/*
 * Decompiled with CFR 0.152.
 */
package net.zemberek.bilgi.araclar;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import net.zemberek.araclar.Kayitci;
import net.zemberek.bilgi.KaynakYukleyici;
import net.zemberek.bilgi.araclar.KokOkuyucu;
import net.zemberek.yapi.Alfabe;
import net.zemberek.yapi.KelimeTipi;
import net.zemberek.yapi.Kisaltma;
import net.zemberek.yapi.Kok;
import net.zemberek.yapi.kok.KokOzelDurumBilgisi;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DuzYaziKokOkuyucu
implements KokOkuyucu {
    private static Logger log = Kayitci.kayitciUret(DuzYaziKokOkuyucu.class);
    private Alfabe alfabe;
    private KokOzelDurumBilgisi ozelDurumlar;
    protected BufferedReader reader;
    private static final Pattern AYIRICI_PATTERN = Pattern.compile("[ ]+");
    private Map<String, KelimeTipi> kokTipAdlari = new HashMap<String, KelimeTipi>();

    public DuzYaziKokOkuyucu(String dosyaAdi, KokOzelDurumBilgisi ozelDurumlar, Alfabe alfabe, Map<String, KelimeTipi> kokTipAdlari) throws IOException {
        this.reader = new KaynakYukleyici("UTF-8").getReader(dosyaAdi);
        this.ozelDurumlar = ozelDurumlar;
        this.alfabe = alfabe;
        this.kokTipAdlari = kokTipAdlari;
    }

    @Override
    public List<Kok> hepsiniOku() throws IOException {
        Kok kok;
        ArrayList<Kok> list = new ArrayList<Kok>();
        while ((kok = this.oku()) != null) {
            list.add(kok);
        }
        if (this.reader != null) {
            this.reader.close();
        }
        return list;
    }

    @Override
    public Kok oku() throws IOException {
        while (this.reader.ready()) {
            String line = this.reader.readLine().trim();
            if (line.startsWith("#") || line.length() == 0) continue;
            String[] tokens = AYIRICI_PATTERN.split(line);
            if (tokens == null || tokens.length < 2) {
                log.warning("Eksik bilgi!" + line);
                continue;
            }
            String asil = tokens[0];
            String icerik = this.alfabe.ayikla(asil);
            if (!this.kokTipAdlari.containsKey(tokens[1])) {
                throw new IllegalArgumentException("Kok tipi bulunamadi!" + line);
            }
            KelimeTipi tip = this.kokTipAdlari.get(tokens[1]);
            Kok kok = tip == KelimeTipi.KISALTMA ? new Kisaltma(icerik) : new Kok(icerik, tip);
            this.ozelDurumlar.kokIcerikIsle(kok, tip, icerik);
            if (!asil.equals(icerik)) {
                kok.setAsil(asil);
            }
            this.ozelDurumlar.duzyaziOzelDurumOku(kok, icerik, tokens);
            this.ozelDurumlar.ozelDurumBelirle(kok);
            return kok;
        }
        return null;
    }
}

