/*
 * Decompiled with CFR 0.152.
 */
package net.zemberek.bilgi;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.Properties;
import java.util.logging.Logger;
import net.zemberek.araclar.Kayitci;
import net.zemberek.bilgi.KaynakYukleyici;

public final class ZemberekAyarlari {
    private static Logger logger = Kayitci.kayitciUret(ZemberekAyarlari.class);
    private Properties konfigurasyon;
    private boolean oneriDeasciifierKullan = true;
    private int oneriMax = 12;
    private boolean oneriKokFrekansKullan = true;
    private boolean disKaynakErisimi = false;
    private boolean oneriBilesikKelimeKullan = true;
    private boolean cepKullan = true;
    private URI bilgiEk;
    private URI bilgiKokler;
    private URI bilgiAlfabe;
    private URI bilgiDizini;
    private URI bilgiCep;

    public ZemberekAyarlari(String dilKisaAdi) {
        try {
            this.konfigurasyon = new KaynakYukleyici().konfigurasyonYukle("zemberek_" + dilKisaAdi + ".properties");
        }
        catch (IOException e) {
            logger.warning("Konfigurasyon dosyasina erisilemiyor! varsayilan degerler kullanilacak");
        }
        this.konfigurasyonOku(this.konfigurasyon);
    }

    public ZemberekAyarlari(Properties ayarlar) {
        this.konfigurasyon = ayarlar;
        this.konfigurasyonOku(ayarlar);
    }

    private void konfigurasyonOku(Properties ayarlar) {
        try {
            this.oneriDeasciifierKullan = this.boolOku(ayarlar, "oneri.deasciifierKullan");
            this.oneriKokFrekansKullan = this.boolOku(ayarlar, "oneri.kokFrekansKullan");
            this.oneriBilesikKelimeKullan = this.boolOku(ayarlar, "oneri.bilesikKelimeKullan");
            this.oneriMax = Integer.parseInt(ayarlar.getProperty("oneri.max"));
            this.disKaynakErisimi = this.boolOku(ayarlar, "bilgi.disKaynakErisimi");
            this.cepKullan = this.boolOku(ayarlar, "denetleme.cepKullan");
            if (this.disKaynakErisimi) {
                File dizin = new File(ayarlar.getProperty("bilgi.dizin"));
                this.bilgiDizini = dizin.toURI();
                this.bilgiEk = new File(dizin, ayarlar.getProperty("bilgi.ekler")).toURI();
                this.bilgiKokler = new File(dizin, ayarlar.getProperty("bilgi.kokler")).toURI();
                this.bilgiAlfabe = new File(dizin, ayarlar.getProperty("bilgi.harf")).toURI();
                this.bilgiCep = new File(dizin, ayarlar.getProperty("bilgi.harf")).toURI();
            }
        }
        catch (NumberFormatException e) {
            logger.severe("property erisim hatasi! Muhtemel tip donusum problemi.. varsayilan parametreler kullanilacak ");
        }
        catch (Exception e) {
            logger.severe("property erisim hatasi! property yer almiyor, ya da adi yanlis yazilmis olabilir. varsayilan konfigurasyon kullanilacak.");
        }
    }

    private boolean boolOku(Properties ayarlar, String anahtar) {
        return Boolean.parseBoolean(ayarlar.getProperty(anahtar));
    }

    public Properties getKonfigurasyon() {
        return this.konfigurasyon;
    }

    public boolean oneriDeasciifierKullan() {
        return this.oneriDeasciifierKullan;
    }

    public boolean oneriBilesikKelimeKullan() {
        return this.oneriBilesikKelimeKullan;
    }

    public int getOneriMax() {
        return this.oneriMax;
    }

    public boolean oneriKokFrekansKullan() {
        return this.oneriKokFrekansKullan;
    }

    public URI getBilgiEk() {
        return this.bilgiEk;
    }

    public URI getBilgiKokler() {
        return this.bilgiKokler;
    }

    public URI getBilgiDizini() {
        return this.bilgiDizini;
    }

    public URI getBilgiAlfabe() {
        return this.bilgiAlfabe;
    }

    public URI getBilgiCep() {
        return this.bilgiCep;
    }

    public boolean disKaynakErisimi() {
        return this.disKaynakErisimi;
    }

    public boolean cepKullan() {
        return this.cepKullan;
    }
}

