/*
 * Decompiled with CFR 0.152.
 */
package net.zemberek.araclar.turkce;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import net.zemberek.bilgi.KaynakYukleyici;
import net.zemberek.istatistik.Istatistikler;

public class TurkishTokenStream {
    BufferedReader bis = null;
    Istatistikler statistics = null;
    char[] buffer = new char[1000];
    int index = 0;
    public static int MAX_KELIME_BOY = 256;
    private char[] kelimeBuffer = new char[MAX_KELIME_BOY];
    public static int MAX_CUMLE_BOY = 4000;
    private char[] cumleBuffer = new char[MAX_CUMLE_BOY];

    public TurkishTokenStream(String fileName, String encoding) {
        try {
            this.bis = new KaynakYukleyici(encoding).getReader(fileName);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public TurkishTokenStream(InputStream is, String encoding) {
        try {
            this.bis = new BufferedReader(new InputStreamReader(is, encoding));
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
    }

    public String nextWord() {
        boolean kelimeBasladi = false;
        int kelimeIndex = 0;
        boolean hypen = false;
        try {
            int readChar;
            while ((readChar = this.bis.read()) != -1) {
                char ch = (char)readChar;
                if (this.statistics != null) {
                    this.statistics.processChar(ch);
                }
                if (ch == '-') {
                    hypen = true;
                    continue;
                }
                if (Character.isLetter(ch) || kelimeBasladi & (ch == '\'' || ch == '-')) {
                    kelimeBasladi = true;
                    hypen = false;
                    if (kelimeIndex < MAX_KELIME_BOY) {
                        this.kelimeBuffer[kelimeIndex++] = ch;
                        continue;
                    }
                    System.out.println("maksimum kelime boyu a\u015f\u0131ld\u0131. " + ch);
                    continue;
                }
                if (!Character.isWhitespace(ch) || hypen) continue;
                if (kelimeBasladi) {
                    return new String(this.kelimeBuffer, 0, kelimeIndex);
                }
                kelimeBasladi = false;
                kelimeIndex = 0;
            }
            if (kelimeBasladi) {
                return new String(this.kelimeBuffer, 0, kelimeIndex);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public String nextSentence() {
        boolean cumleBasladi = false;
        int cumleIndex = 0;
        try {
            int readChar;
            while ((readChar = this.bis.read()) != -1) {
                char ch = (char)readChar;
                if (Character.isLetter(ch) || ch == '\'' || ch == '-') {
                    cumleBasladi = true;
                    if (cumleIndex < MAX_CUMLE_BOY) {
                        this.cumleBuffer[cumleIndex++] = ch;
                        continue;
                    }
                    System.out.println("Lagim tasti " + ch);
                    continue;
                }
                if (this.isSentenceDelimiter(ch)) {
                    if (!cumleBasladi) continue;
                    return new String(this.cumleBuffer, 0, cumleIndex);
                }
                if (cumleIndex < MAX_CUMLE_BOY) {
                    this.cumleBuffer[cumleIndex++] = ch;
                    continue;
                }
                System.out.println("Lagim tasti " + ch);
                return null;
            }
            if (cumleBasladi) {
                return new String(this.kelimeBuffer, 0, cumleIndex);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public char harfIsle(char chIn) {
        char ch;
        switch (chIn) {
            case 'I': {
                ch = '\u0131';
                break;
            }
            default: {
                ch = Character.toLowerCase(chIn);
            }
        }
        return ch;
    }

    public boolean isSentenceDelimiter(char ch) {
        return ch == '.' || ch == ':' || ch == '!' || ch == '?';
    }

    public void setStatistics(Istatistikler statistics) {
        this.statistics = statistics;
    }
}

