/*
 * Decompiled with CFR 0.152.
 */
package net.zemberek.tk.yapi.ek;

import java.util.List;
import java.util.logging.Logger;
import net.zemberek.tk.yapi.TurkmenceSesliUretici;
import net.zemberek.yapi.Alfabe;
import net.zemberek.yapi.HarfDizisi;
import net.zemberek.yapi.TurkceHarf;
import net.zemberek.yapi.ek.EkUretici;
import net.zemberek.yapi.ek.EkUretimBileseni;
import net.zemberek.yapi.ek.TemelEkUretici;
import net.zemberek.yapi.ek.TemelEkUretimKurali;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EkUreticiTm
extends TemelEkUretici
implements EkUretici {
    private static Logger log = Logger.getLogger(EkUreticiTm.class.getName());
    private final TurkceHarf HARF_a;
    private final TurkceHarf HARF_aa;
    private TurkmenceSesliUretici sesliUretici;

    public EkUreticiTm(Alfabe alfabe) {
        this.HARF_a = alfabe.harf('a');
        this.HARF_aa = alfabe.harf('\u00e4');
        this.sesliUretici = new TurkmenceSesliUretici(alfabe);
    }

    public HarfDizisi cozumlemeIcinEkUret(HarfDizisi ulanacak, HarfDizisi giris, List<EkUretimBileseni> bilesenler) {
        HarfDizisi sonuc = new HarfDizisi();
        block9: for (int i = 0; i < bilesenler.size(); ++i) {
            EkUretimBileseni ekUretimBileseni = bilesenler.get(i);
            TurkceHarf harf = ekUretimBileseni.harf;
            TurkceHarf sonSesli = ulanacak.sonSesli();
            switch ((TemelEkUretimKurali)ekUretimBileseni.kural) {
                case HARF: {
                    sonuc.ekle(harf);
                    continue block9;
                }
                case SESSIZ_Y: {
                    if (!ulanacak.sonSesli().inceSesliMi()) {
                        sonuc.ekle(this.HARF_a);
                        continue block9;
                    }
                    sonuc.ekle(this.HARF_aa);
                    continue block9;
                }
                case KAYNASTIR: {
                    if (!ulanacak.sonHarf().sesliMi()) continue block9;
                    sonuc.ekle(harf);
                    continue block9;
                }
                case SERTLESTIR: {
                    if (ulanacak.sonHarf().sertMi()) {
                        sonuc.ekle(harf.sertDonusum());
                        continue block9;
                    }
                    sonuc.ekle(harf);
                    continue block9;
                }
                case SESLI_AA: {
                    if (i == 0 && ulanacak.sonHarf().sesliMi()) continue block9;
                    sonuc.ekle(this.sesliUretici.sesliBelirleAA(sonSesli));
                    continue block9;
                }
                case SESLI_AE: {
                    if (i == 0 && ulanacak.sonHarf().sesliMi()) continue block9;
                    sonuc.ekle(this.sesliUretici.sesliBelirleAE(sonSesli));
                    continue block9;
                }
                case SESLI_IU: {
                    if (i == 0 && ulanacak.sonHarf().sesliMi()) continue block9;
                    if (ulanacak.sesliSayisi() > 1) {
                        sonuc.ekle(this.sesliUretici.sesliBelirleII(sonSesli));
                        continue block9;
                    }
                    if (i == bilesenler.size() - 1) {
                        if (giris == null) {
                            sonuc.ekle(this.sesliUretici.sesliBelirleII(sonSesli));
                            continue block9;
                        }
                        if (giris.sesliSayisi() >= 2 && !giris.sonHarf().sesliMi()) {
                            sonuc.ekle(this.sesliUretici.sesliBelirleIU(sonSesli));
                            continue block9;
                        }
                        sonuc.ekle(this.sesliUretici.sesliBelirleII(sonSesli));
                        continue block9;
                    }
                    sonuc.ekle(this.sesliUretici.sesliBelirleIU(sonSesli));
                }
            }
        }
        return sonuc;
    }
}

