/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.dbus.bin;

import cx.ath.matthew.unix.UnixServerSocket;
import cx.ath.matthew.unix.UnixSocket;
import cx.ath.matthew.unix.UnixSocketAddress;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.freedesktop.DBus;
import org.freedesktop.dbus.BusAddress;
import org.freedesktop.dbus.DBusSignal;
import org.freedesktop.dbus.DirectConnection;
import org.freedesktop.dbus.Error;
import org.freedesktop.dbus.Gettext;
import org.freedesktop.dbus.Marshalling;
import org.freedesktop.dbus.Message;
import org.freedesktop.dbus.MessageReader;
import org.freedesktop.dbus.MessageWriter;
import org.freedesktop.dbus.MethodCall;
import org.freedesktop.dbus.MethodReturn;
import org.freedesktop.dbus.Transport;
import org.freedesktop.dbus.UInt32;
import org.freedesktop.dbus.exceptions.DBusException;
import org.freedesktop.dbus.exceptions.DBusExecutionException;
import org.freedesktop.dbus.exceptions.FatalException;

public class DBusDaemon
extends Thread {
    public static final int QUEUE_POLL_WAIT = 500;
    private Map<Connstruct, Reader> conns = new HashMap<Connstruct, Reader>();
    private HashMap<String, Connstruct> names = new HashMap();
    private MagicMap<Message, WeakReference<Connstruct>> outqueue = new MagicMap("out");
    private MagicMap<Message, WeakReference<Connstruct>> inqueue = new MagicMap("in");
    private MagicMap<Message, WeakReference<Connstruct>> localqueue = new MagicMap("local");
    private List<Connstruct> sigrecips = new Vector<Connstruct>();
    private boolean _run = true;
    private int next_unique = 0;
    private Object unique_lock = new Object();
    DBusServer dbus_server = new DBusServer();
    Sender sender = new Sender();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DBusDaemon() {
        this.setName("Daemon");
        HashMap<String, Connstruct> hashMap = this.names;
        synchronized (hashMap) {
            this.names.put("org.freedesktop.DBus", null);
        }
    }

    private void send(Connstruct connstruct, Message message) {
        this.send(connstruct, message, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void send(Connstruct connstruct, Message message, boolean bl) {
        if (null == connstruct) {
            Map<Connstruct, Reader> map = this.conns;
            synchronized (map) {
                MagicMap<Message, WeakReference<Connstruct>> magicMap = this.outqueue;
                synchronized (magicMap) {
                    for (Connstruct connstruct2 : this.conns.keySet()) {
                        if (bl) {
                            this.outqueue.putFirst(message, new WeakReference<Connstruct>(connstruct2));
                            continue;
                        }
                        this.outqueue.putLast(message, new WeakReference<Connstruct>(connstruct2));
                    }
                    this.outqueue.notifyAll();
                }
            }
        }
        MagicMap<Message, WeakReference<Connstruct>> magicMap = this.outqueue;
        synchronized (magicMap) {
            if (bl) {
                this.outqueue.putFirst(message, new WeakReference<Connstruct>(connstruct));
            } else {
                this.outqueue.putLast(message, new WeakReference<Connstruct>(connstruct));
            }
            this.outqueue.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Connstruct> findSignalMatches(DBusSignal dBusSignal) {
        Vector<Connstruct> vector;
        List<Connstruct> list = this.sigrecips;
        synchronized (list) {
            vector = new Vector<Connstruct>(this.sigrecips);
        }
        return vector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (this._run) {
            try {
                List<WeakReference<Connstruct>> list;
                Message message;
                MagicMap<Message, WeakReference<Connstruct>> magicMap = this.inqueue;
                synchronized (magicMap) {
                    while (0 == this.inqueue.size()) {
                        try {
                            this.inqueue.wait();
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    message = this.inqueue.head();
                    list = this.inqueue.remove(message);
                }
                if (null == list) continue;
                for (WeakReference weakReference : list) {
                    Object dBusException;
                    Connstruct connstruct = (Connstruct)weakReference.get();
                    if (null == connstruct) continue;
                    if (!(null != connstruct.unique || message instanceof MethodCall && "org.freedesktop.DBus".equals(message.getDestination()) && "Hello".equals(message.getName()))) {
                        this.send(connstruct, (Message)new Error("org.freedesktop.DBus", null, "org.freedesktop.DBus.Error.AccessDenied", message.getSerial(), "s", new Object[]{Gettext._((String)"You must send a Hello message")}));
                        continue;
                    }
                    try {
                        if (null != connstruct.unique) {
                            message.setSource(connstruct.unique);
                        }
                    }
                    catch (DBusException dBusException2) {
                        this.send(connstruct, (Message)new Error("org.freedesktop.DBus", null, "org.freedesktop.DBus.Error.GeneralError", message.getSerial(), "s", new Object[]{Gettext._((String)"Sending message failed")}));
                    }
                    if ("org.freedesktop.DBus".equals(message.getDestination())) {
                        dBusException = this.localqueue;
                        synchronized (dBusException) {
                            this.localqueue.putLast(message, weakReference);
                            this.localqueue.notifyAll();
                            continue;
                        }
                    }
                    if (message instanceof DBusSignal) {
                        dBusException = this.findSignalMatches((DBusSignal)message);
                        Iterator iterator = dBusException.iterator();
                        while (iterator.hasNext()) {
                            Connstruct connstruct2 = (Connstruct)iterator.next();
                            this.send(connstruct2, message);
                        }
                        continue;
                    }
                    dBusException = this.names.get(message.getDestination());
                    if (null == dBusException) {
                        this.send(connstruct, (Message)new Error("org.freedesktop.DBus", null, "org.freedesktop.DBus.Error.ServiceUnknown", message.getSerial(), "s", new Object[]{MessageFormat.format(Gettext._((String)"The name `{0}' does not exist"), message.getDestination())}));
                        continue;
                    }
                    this.send((Connstruct)dBusException, message);
                }
            }
            catch (DBusException dBusException) {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeConnection(Connstruct connstruct) {
        Object object;
        boolean bl;
        Map<Connstruct, Reader> map = this.conns;
        synchronized (map) {
            bl = this.conns.containsKey(connstruct);
            if (bl) {
                object = this.conns.get(connstruct);
                ((Reader)object).stopRunning();
                this.conns.remove(connstruct);
            }
        }
        if (bl) {
            try {
                if (null != connstruct.usock) {
                    connstruct.usock.close();
                }
                if (null != connstruct.tsock) {
                    connstruct.tsock.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            map = this.names;
            synchronized (map) {
                object = new Vector();
                for (String string : this.names.keySet()) {
                    if (this.names.get(string) != connstruct) continue;
                    object.add(string);
                    try {
                        this.send(null, (Message)new DBusSignal("org.freedesktop.DBus", "/org/freedesktop/DBus", "org.freedesktop.DBus", "NameOwnerChanged", "sss", new Object[]{string, connstruct.unique, ""}));
                    }
                    catch (DBusException dBusException) {}
                }
                Iterator<String> iterator = object.iterator();
                while (iterator.hasNext()) {
                    String string;
                    string = iterator.next();
                    this.names.remove(string);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSock(UnixSocket unixSocket) {
        Connstruct connstruct = new Connstruct(unixSocket);
        Reader reader = new Reader(connstruct);
        Map<Connstruct, Reader> map = this.conns;
        synchronized (map) {
            this.conns.put(connstruct, reader);
        }
        reader.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSock(Socket socket) throws IOException {
        Connstruct connstruct = new Connstruct(socket);
        Reader reader = new Reader(connstruct);
        Map<Connstruct, Reader> map = this.conns;
        synchronized (map) {
            this.conns.put(connstruct, reader);
        }
        reader.start();
    }

    public static void syntax() {
        System.out.println("Syntax: DBusDaemon [--version] [-v] [--help] [-h] [--listen address] [-l address] [--print-address] [-r] [--pidfile file] [-p file] [--addressfile file] [-a file] [--unix] [-u] [--tcp] [-t] ");
        System.exit(1);
    }

    public static void version() {
        System.out.println("D-Bus Java Version: " + System.getProperty("Version"));
        System.exit(1);
    }

    public static void saveFile(String string, String string2) throws IOException {
        PrintWriter printWriter = new PrintWriter(new FileOutputStream(string2));
        printWriter.println(string);
        printWriter.close();
    }

    public static void main(String[] stringArray) throws Exception {
        String string = null;
        String string2 = null;
        String string3 = null;
        boolean bl = false;
        boolean bl2 = true;
        boolean bl3 = false;
        try {
            for (int i = 0; i < stringArray.length; ++i) {
                if ("--help".equals(stringArray[i]) || "-h".equals(stringArray[i])) {
                    DBusDaemon.syntax();
                    continue;
                }
                if ("--version".equals(stringArray[i]) || "-v".equals(stringArray[i])) {
                    DBusDaemon.version();
                    continue;
                }
                if ("--listen".equals(stringArray[i]) || "-l".equals(stringArray[i])) {
                    string = stringArray[++i];
                    continue;
                }
                if ("--pidfile".equals(stringArray[i]) || "-p".equals(stringArray[i])) {
                    string2 = stringArray[++i];
                    continue;
                }
                if ("--addressfile".equals(stringArray[i]) || "-a".equals(stringArray[i])) {
                    string3 = stringArray[++i];
                    continue;
                }
                if ("--print-address".equals(stringArray[i]) || "-r".equals(stringArray[i])) {
                    bl = true;
                    continue;
                }
                if ("--unix".equals(stringArray[i]) || "-u".equals(stringArray[i])) {
                    bl2 = true;
                    bl3 = false;
                    continue;
                }
                if ("--tcp".equals(stringArray[i]) || "-t".equals(stringArray[i])) {
                    bl3 = true;
                    bl2 = false;
                    continue;
                }
                DBusDaemon.syntax();
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            DBusDaemon.syntax();
        }
        if (null == string && bl2) {
            string = DirectConnection.createDynamicSession();
        } else if (null == string && bl3) {
            string = DirectConnection.createDynamicTCPSession();
        }
        BusAddress busAddress = new BusAddress(string);
        if (null == busAddress.getParameter("guid")) {
            string = string + ",guid=" + Transport.genGUID();
            busAddress = new BusAddress(string);
        }
        if (bl) {
            System.out.println(string);
        }
        if (null != string3) {
            DBusDaemon.saveFile(string, string3);
        }
        if (null != string2) {
            DBusDaemon.saveFile(System.getProperty("Pid"), string2);
        }
        if ("unix".equals(busAddress.getType())) {
            DBusDaemon.doUnix(busAddress);
        } else if ("tcp".equals(busAddress.getType())) {
            DBusDaemon.doTCP(busAddress);
        } else {
            throw new Exception("Unknown address type: " + busAddress.getType());
        }
    }

    private static void doUnix(BusAddress busAddress) throws IOException {
        UnixServerSocket unixServerSocket = null != busAddress.getParameter("abstract") ? new UnixServerSocket(new UnixSocketAddress(busAddress.getParameter("abstract"), true)) : new UnixServerSocket(new UnixSocketAddress(busAddress.getParameter("path"), false));
        DBusDaemon dBusDaemon = new DBusDaemon();
        dBusDaemon.start();
        dBusDaemon.sender.start();
        dBusDaemon.dbus_server.start();
        while (dBusDaemon._run) {
            UnixSocket unixSocket = unixServerSocket.accept();
            if (new Transport.SASL().auth(1, 1, busAddress.getParameter("guid"), unixSocket.getOutputStream(), unixSocket.getInputStream(), unixSocket)) {
                dBusDaemon.addSock(unixSocket);
                continue;
            }
            unixSocket.close();
        }
    }

    private static void doTCP(BusAddress busAddress) throws IOException {
        ServerSocket serverSocket = new ServerSocket(Integer.parseInt(busAddress.getParameter("port")), 10, InetAddress.getByName(busAddress.getParameter("host")));
        DBusDaemon dBusDaemon = new DBusDaemon();
        dBusDaemon.start();
        dBusDaemon.sender.start();
        dBusDaemon.dbus_server.start();
        while (dBusDaemon._run) {
            Socket socket = serverSocket.accept();
            boolean bl = false;
            try {
                bl = new Transport.SASL().auth(1, 1, busAddress.getParameter("guid"), socket.getOutputStream(), socket.getInputStream(), null);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (bl) {
                dBusDaemon.addSock(socket);
                continue;
            }
            socket.close();
        }
    }

    public class Reader
    extends Thread {
        private Connstruct conn;
        private WeakReference<Connstruct> weakconn;
        private boolean _lrun = true;

        public Reader(Connstruct connstruct) {
            this.conn = connstruct;
            this.weakconn = new WeakReference<Connstruct>(connstruct);
            this.setName("Reader");
        }

        public void stopRunning() {
            this._lrun = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (DBusDaemon.this._run && this._lrun) {
                Message message;
                block7: {
                    message = null;
                    try {
                        message = this.conn.min.readMessage();
                    }
                    catch (IOException iOException) {
                        DBusDaemon.this.removeConnection(this.conn);
                    }
                    catch (DBusException dBusException) {
                        if (!(dBusException instanceof FatalException)) break block7;
                        DBusDaemon.this.removeConnection(this.conn);
                    }
                }
                if (null == message) continue;
                MagicMap magicMap = DBusDaemon.this.inqueue;
                synchronized (magicMap) {
                    DBusDaemon.this.inqueue.putLast(message, this.weakconn);
                    DBusDaemon.this.inqueue.notifyAll();
                }
            }
            this.conn = null;
        }
    }

    public class Sender
    extends Thread {
        public Sender() {
            this.setName("Sender");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (DBusDaemon.this._run) {
                Message message = null;
                List list = null;
                MagicMap magicMap = DBusDaemon.this.outqueue;
                synchronized (magicMap) {
                    while (DBusDaemon.this.outqueue.size() == 0) {
                        try {
                            DBusDaemon.this.outqueue.wait();
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    message = (Message)DBusDaemon.this.outqueue.head();
                    list = DBusDaemon.this.outqueue.remove(message);
                }
                if (null == list) continue;
                for (WeakReference weakReference : list) {
                    Connstruct connstruct = (Connstruct)weakReference.get();
                    if (null == connstruct) continue;
                    try {
                        connstruct.mout.writeMessage(message);
                    }
                    catch (IOException iOException) {
                        DBusDaemon.this.removeConnection(connstruct);
                    }
                }
            }
        }
    }

    public class DBusServer
    extends Thread
    implements DBus,
    DBus.Introspectable,
    DBus.Peer {
        public Connstruct c;
        public Message m;

        public DBusServer() {
            this.setName("Server");
        }

        public boolean isRemote() {
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String Hello() {
            Object object = this.c;
            synchronized (object) {
                if (null != this.c.unique) {
                    throw new DBus.Error.AccessDenied(Gettext._((String)"Connection has already sent a Hello message"));
                }
                Object object2 = DBusDaemon.this.unique_lock;
                synchronized (object2) {
                    this.c.unique = ":1." + ++DBusDaemon.this.next_unique;
                }
            }
            object = DBusDaemon.this.names;
            synchronized (object) {
                DBusDaemon.this.names.put(this.c.unique, this.c);
            }
            try {
                DBusDaemon.this.send(this.c, (Message)new DBusSignal("org.freedesktop.DBus", "/org/freedesktop/DBus", "org.freedesktop.DBus", "NameAcquired", "s", new Object[]{this.c.unique}));
                object = new DBusSignal("org.freedesktop.DBus", "/org/freedesktop/DBus", "org.freedesktop.DBus", "NameOwnerChanged", "sss", new Object[]{this.c.unique, "", this.c.unique});
                DBusDaemon.this.send(null, (Message)object);
            }
            catch (DBusException dBusException) {
                // empty catch block
            }
            return this.c.unique;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String[] ListNames() {
            String[] stringArray;
            HashMap hashMap = DBusDaemon.this.names;
            synchronized (hashMap) {
                Set set = DBusDaemon.this.names.keySet();
                stringArray = set.toArray(new String[0]);
            }
            return stringArray;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean NameHasOwner(String string) {
            boolean bl;
            HashMap hashMap = DBusDaemon.this.names;
            synchronized (hashMap) {
                bl = DBusDaemon.this.names.containsKey(string);
            }
            return bl;
        }

        public String GetNameOwner(String string) {
            Connstruct connstruct = (Connstruct)DBusDaemon.this.names.get(string);
            String string2 = null == connstruct ? "" : connstruct.unique;
            return string2;
        }

        public UInt32 GetConnectionUnixUser(String string) {
            return new UInt32(0L);
        }

        public UInt32 StartServiceByName(String string, UInt32 uInt32) {
            return new UInt32(0L);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public UInt32 RequestName(String string, UInt32 uInt32) {
            int n;
            boolean bl = false;
            HashMap hashMap = DBusDaemon.this.names;
            synchronized (hashMap) {
                bl = DBusDaemon.this.names.containsKey(string);
                if (!bl) {
                    DBusDaemon.this.names.put(string, this.c);
                }
            }
            if (bl) {
                n = 3;
            } else {
                n = 1;
                try {
                    DBusDaemon.this.send(this.c, (Message)new DBusSignal("org.freedesktop.DBus", "/org/freedesktop/DBus", "org.freedesktop.DBus", "NameAcquired", "s", new Object[]{string}));
                    DBusDaemon.this.send(null, (Message)new DBusSignal("org.freedesktop.DBus", "/org/freedesktop/DBus", "org.freedesktop.DBus", "NameOwnerChanged", "sss", new Object[]{string, "", this.c.unique}));
                }
                catch (DBusException dBusException) {
                    // empty catch block
                }
            }
            return new UInt32((long)n);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public UInt32 ReleaseName(String string) {
            int n;
            boolean bl = false;
            HashMap hashMap = DBusDaemon.this.names;
            synchronized (hashMap) {
                bl = DBusDaemon.this.names.containsKey(string) && ((Connstruct)DBusDaemon.this.names.get(string)).equals(this.c);
                if (bl) {
                    DBusDaemon.this.names.remove(string);
                }
            }
            if (!bl) {
                n = 2;
            } else {
                n = 1;
                try {
                    DBusDaemon.this.send(this.c, (Message)new DBusSignal("org.freedesktop.DBus", "/org/freedesktop/DBus", "org.freedesktop.DBus", "NameLost", "s", new Object[]{string}));
                    DBusDaemon.this.send(null, (Message)new DBusSignal("org.freedesktop.DBus", "/org/freedesktop/DBus", "org.freedesktop.DBus", "NameOwnerChanged", "sss", new Object[]{string, this.c.unique, ""}));
                }
                catch (DBusException dBusException) {
                    // empty catch block
                }
            }
            return new UInt32((long)n);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void AddMatch(String string) throws DBus.Error.MatchRuleInvalid {
            List list = DBusDaemon.this.sigrecips;
            synchronized (list) {
                if (!DBusDaemon.this.sigrecips.contains(this.c)) {
                    DBusDaemon.this.sigrecips.add(this.c);
                }
            }
        }

        public void RemoveMatch(String string) throws DBus.Error.MatchRuleInvalid {
        }

        public String[] ListQueuedOwners(String string) {
            return new String[0];
        }

        public UInt32 GetConnectionUnixProcessID(String string) {
            return new UInt32(0L);
        }

        public Byte[] GetConnectionSELinuxSecurityContext(String string) {
            return new Byte[0];
        }

        public void ReloadConfig() {
        }

        private void handleMessage(Connstruct connstruct, Message message) throws DBusException {
            block9: {
                if (!(message instanceof MethodCall)) {
                    return;
                }
                Object[] objectArray = message.getParameters();
                Class[] classArray = new Class[objectArray.length];
                for (int i = 0; i < classArray.length; ++i) {
                    classArray[i] = objectArray[i].getClass();
                }
                Method method = null;
                Object object = null;
                try {
                    method = DBusServer.class.getMethod(message.getName(), classArray);
                    try {
                        this.c = connstruct;
                        this.m = message;
                        object = method.invoke((Object)DBusDaemon.this.dbus_server, objectArray);
                        if (null == object) {
                            DBusDaemon.this.send(connstruct, (Message)new MethodReturn("org.freedesktop.DBus", (MethodCall)message, null, new Object[0]), true);
                            break block9;
                        }
                        String string = Marshalling.getDBusType((Type)method.getGenericReturnType())[0];
                        DBusDaemon.this.send(connstruct, (Message)new MethodReturn("org.freedesktop.DBus", (MethodCall)message, string, new Object[]{object}), true);
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        DBusDaemon.this.send(connstruct, (Message)new Error("org.freedesktop.DBus", message, invocationTargetException.getCause()));
                    }
                    catch (DBusExecutionException dBusExecutionException) {
                        DBusDaemon.this.send(connstruct, (Message)new Error("org.freedesktop.DBus", message, (Throwable)dBusExecutionException));
                    }
                    catch (Exception exception) {
                        DBusDaemon.this.send(connstruct, (Message)new Error("org.freedesktop.DBus", connstruct.unique, "org.freedesktop.DBus.Error.GeneralError", message.getSerial(), "s", new Object[]{Gettext._((String)"An error occurred while calling ") + message.getName()}));
                    }
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    DBusDaemon.this.send(connstruct, (Message)new Error("org.freedesktop.DBus", connstruct.unique, "org.freedesktop.DBus.Error.UnknownMethod", message.getSerial(), "s", new Object[]{Gettext._((String)"This service does not support ") + message.getName()}));
                }
            }
        }

        public String Introspect() {
            return "<!DOCTYPE node PUBLIC \"-//freedesktop//DTD D-BUS Object Introspection 1.0//EN\"\n\"http://www.freedesktop.org/standards/dbus/1.0/introspect.dtd\">\n<node>\n  <interface name=\"org.freedesktop.DBus.Introspectable\">\n    <method name=\"Introspect\">\n      <arg name=\"data\" direction=\"out\" type=\"s\"/>\n    </method>\n  </interface>\n  <interface name=\"org.freedesktop.DBus\">\n    <method name=\"RequestName\">\n      <arg direction=\"in\" type=\"s\"/>\n      <arg direction=\"in\" type=\"u\"/>\n      <arg direction=\"out\" type=\"u\"/>\n    </method>\n    <method name=\"ReleaseName\">\n      <arg direction=\"in\" type=\"s\"/>\n      <arg direction=\"out\" type=\"u\"/>\n    </method>\n    <method name=\"StartServiceByName\">\n      <arg direction=\"in\" type=\"s\"/>\n      <arg direction=\"in\" type=\"u\"/>\n      <arg direction=\"out\" type=\"u\"/>\n    </method>\n    <method name=\"Hello\">\n      <arg direction=\"out\" type=\"s\"/>\n    </method>\n    <method name=\"NameHasOwner\">\n      <arg direction=\"in\" type=\"s\"/>\n      <arg direction=\"out\" type=\"b\"/>\n    </method>\n    <method name=\"ListNames\">\n      <arg direction=\"out\" type=\"as\"/>\n    </method>\n    <method name=\"ListActivatableNames\">\n      <arg direction=\"out\" type=\"as\"/>\n    </method>\n    <method name=\"AddMatch\">\n      <arg direction=\"in\" type=\"s\"/>\n    </method>\n    <method name=\"RemoveMatch\">\n      <arg direction=\"in\" type=\"s\"/>\n    </method>\n    <method name=\"GetNameOwner\">\n      <arg direction=\"in\" type=\"s\"/>\n      <arg direction=\"out\" type=\"s\"/>\n    </method>\n    <method name=\"ListQueuedOwners\">\n      <arg direction=\"in\" type=\"s\"/>\n      <arg direction=\"out\" type=\"as\"/>\n    </method>\n    <method name=\"GetConnectionUnixUser\">\n      <arg direction=\"in\" type=\"s\"/>\n      <arg direction=\"out\" type=\"u\"/>\n    </method>\n    <method name=\"GetConnectionUnixProcessID\">\n      <arg direction=\"in\" type=\"s\"/>\n      <arg direction=\"out\" type=\"u\"/>\n    </method>\n    <method name=\"GetConnectionSELinuxSecurityContext\">\n      <arg direction=\"in\" type=\"s\"/>\n      <arg direction=\"out\" type=\"ay\"/>\n    </method>\n    <method name=\"ReloadConfig\">\n    </method>\n    <signal name=\"NameOwnerChanged\">\n      <arg type=\"s\"/>\n      <arg type=\"s\"/>\n      <arg type=\"s\"/>\n    </signal>\n    <signal name=\"NameLost\">\n      <arg type=\"s\"/>\n    </signal>\n    <signal name=\"NameAcquired\">\n      <arg type=\"s\"/>\n    </signal>\n  </interface>\n</node>";
        }

        public void Ping() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (DBusDaemon.this._run) {
                List list;
                Message message;
                MagicMap magicMap = DBusDaemon.this.localqueue;
                synchronized (magicMap) {
                    while (DBusDaemon.this.localqueue.size() == 0) {
                        try {
                            DBusDaemon.this.localqueue.wait();
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    message = (Message)DBusDaemon.this.localqueue.head();
                    list = DBusDaemon.this.localqueue.remove(message);
                }
                if (null == list) continue;
                try {
                    for (WeakReference weakReference : list) {
                        Connstruct connstruct = (Connstruct)weakReference.get();
                        if (null == connstruct) continue;
                        this.handleMessage(connstruct, message);
                    }
                }
                catch (DBusException dBusException) {
                }
            }
        }
    }

    static class MagicMap<A, B> {
        private Map<A, LinkedList<B>> m = new HashMap<A, LinkedList<B>>();
        private LinkedList<A> q = new LinkedList();
        private String name;

        public MagicMap(String string) {
            this.name = string;
        }

        public A head() {
            return this.q.getFirst();
        }

        public void putFirst(A a, B b) {
            if (this.m.containsKey(a)) {
                this.m.get(a).add(b);
            } else {
                LinkedList<B> linkedList = new LinkedList<B>();
                linkedList.add(b);
                this.m.put(a, linkedList);
            }
            this.q.addFirst(a);
        }

        public void putLast(A a, B b) {
            if (this.m.containsKey(a)) {
                this.m.get(a).add(b);
            } else {
                LinkedList<B> linkedList = new LinkedList<B>();
                linkedList.add(b);
                this.m.put(a, linkedList);
            }
            this.q.addLast(a);
        }

        public List<B> remove(A a) {
            this.q.remove(a);
            return this.m.remove(a);
        }

        public int size() {
            return this.q.size();
        }
    }

    static class Connstruct {
        public UnixSocket usock;
        public Socket tsock;
        public MessageReader min;
        public MessageWriter mout;
        public String unique;

        public Connstruct(UnixSocket unixSocket) {
            this.usock = unixSocket;
            this.min = new MessageReader(unixSocket.getInputStream());
            this.mout = new MessageWriter(unixSocket.getOutputStream());
        }

        public Connstruct(Socket socket) throws IOException {
            this.tsock = socket;
            this.min = new MessageReader(socket.getInputStream());
            this.mout = new MessageWriter(socket.getOutputStream());
        }

        public String toString() {
            return null == this.unique ? ":?-?" : this.unique;
        }
    }
}

