/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.dbus.viewer;

import java.util.ArrayList;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import org.freedesktop.dbus.viewer.DBusEntry;

class DBusTableModel
extends AbstractTableModel {
    private static final String INTROSPECTABLE = "introspectable?";
    private static final String OWNER = "owner";
    private static final String USER = "user";
    private static final String NAME = "name";
    private static final String PATH = "path";
    final String[] columns = new String[]{"name", "path", "user", "owner", "introspectable?"};
    private List<DBusEntry> entries = new ArrayList<DBusEntry>();

    DBusTableModel() {
    }

    @Override
    public int getRowCount() {
        return this.entries.size();
    }

    public void add(DBusEntry dBusEntry) {
        this.entries.add(dBusEntry);
    }

    @Override
    public int getColumnCount() {
        return this.columns.length;
    }

    @Override
    public String getColumnName(int n) {
        return this.columns[n];
    }

    public DBusEntry getEntry(int n) {
        return this.entries.get(n);
    }

    @Override
    public Class<?> getColumnClass(int n) {
        String string = this.getColumnName(n);
        if (string.equals(NAME)) {
            return String.class;
        }
        if (string.equals(PATH)) {
            return String.class;
        }
        if (string.equals(USER)) {
            return Object.class;
        }
        if (string.equals(OWNER)) {
            return String.class;
        }
        if (string.equals(INTROSPECTABLE)) {
            return Boolean.class;
        }
        return super.getColumnClass(n);
    }

    @Override
    public Object getValueAt(int n, int n2) {
        DBusEntry dBusEntry = this.getEntry(n);
        String string = this.getColumnName(n2);
        if (string.equals(NAME)) {
            return dBusEntry.getName();
        }
        if (string.equals(PATH)) {
            return dBusEntry.getPath();
        }
        if (string.equals(USER)) {
            return dBusEntry.getUser();
        }
        if (string.equals(OWNER)) {
            return dBusEntry.getOwner();
        }
        if (string.equals(INTROSPECTABLE)) {
            return dBusEntry.getIntrospectable() != null;
        }
        return null;
    }
}

