/*++

Copyright (C) 2015 netfabb GmbH (Original Author)

All rights reserved.

Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

1. Redistributions of source code must retain the above copyright notice, this
list of conditions and the following disclaimer.
2. Redistributions in binary form must reproduce the above copyright notice,
this list of conditions and the following disclaimer in the documentation
and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

Abstract:

NMR_Exception_Windows.h defines the Windows Exception Class.
Each exception is identified via a global ErrorCode, and saves a Win32 HRESULT Error Code
for further information
(ErrorCodes to be looked up in NMR_ErrorConst.h)

--*/

#ifndef __NMR_EXCEPTION_WINDOWS
#define __NMR_EXCEPTION_WINDOWS
      
#include "Common/NMR_Exception.h"

#ifndef __GNUC__
#include <Windows.h>
#else

#include "Common/Platform/NMR_WinTypes.h"

#endif

namespace NMR {

	class CNMRException_Windows : public CNMRException {
	private:
		HRESULT m_hResult;
	public:
		CNMRException_Windows(_In_ nfError errorcode, _In_ HRESULT hResult);
		HRESULT getHResult();
	};

}

#endif // __NMR_EXCEPTION_WINDOWS
