/*
 * Decompiled with CFR 0.152.
 */
package de.zib.tools;

import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;

public class CircularByteArrayOutputStream
extends OutputStream {
    protected byte[] buf;
    protected int pos = 0;
    boolean filled = false;

    public CircularByteArrayOutputStream(int size) {
        if (size < 0) {
            throw new IllegalArgumentException("Negative initial size: " + size);
        }
        this.buf = new byte[size];
    }

    @Override
    public synchronized void write(int b) {
        if (this.pos == this.buf.length) {
            this.filled = true;
            this.pos = 0;
        }
        this.buf[this.pos++] = (byte)b;
    }

    public synchronized void clear() {
        this.pos = 0;
        this.filled = false;
    }

    public synchronized byte[] toByteArray() {
        if (!this.filled) {
            return Arrays.copyOf(this.buf, this.pos);
        }
        byte[] ret = new byte[this.buf.length];
        System.arraycopy(this.buf, this.pos, ret, 0, this.buf.length - this.pos);
        System.arraycopy(this.buf, 0, ret, this.buf.length - this.pos, this.pos);
        return ret;
    }

    public synchronized String toString() {
        return new String(this.toByteArray());
    }

    public synchronized String toString(String charsetName) throws UnsupportedEncodingException {
        return new String(this.toByteArray(), charsetName);
    }
}

