/*
 * Decompiled with CFR 0.152.
 */
package de.zib.scalaris.jmx;

import de.zib.scalaris.ConnectionException;
import de.zib.scalaris.Monitor;
import de.zib.scalaris.UnknownException;
import de.zib.scalaris.jmx.MonitorNodeMBean;
import java.util.Map;

public class MonitorNode
implements MonitorNodeMBean {
    protected final Monitor monitor;

    public MonitorNode(String node) throws ConnectionException {
        this.monitor = new Monitor(node);
    }

    @Override
    public String getScalarisVersion() throws ConnectionException, UnknownException {
        return this.monitor.getNodeInfo().scalarisVersion;
    }

    @Override
    public String getErlangVersion() throws ConnectionException, UnknownException {
        return this.monitor.getNodeInfo().erlangVersion;
    }

    @Override
    public int getDhtNodes() throws ConnectionException, UnknownException {
        return this.monitor.getNodeInfo().dhtNodes;
    }

    @Override
    public Map<Long, Double> getLatencyAvg() throws ConnectionException, UnknownException {
        return this.monitor.getNodePerformance().latencyAvg;
    }

    @Override
    public Map<Long, Double> getLatencyStddev() throws ConnectionException, UnknownException {
        return this.monitor.getNodePerformance().latencyStddev;
    }

    @Override
    public Double getCurLatencyAvg() throws ConnectionException, UnknownException {
        return Monitor.getCurrentPerfValue(this.monitor.getNodePerformance().latencyAvg);
    }

    @Override
    public Double getCurLatencyStddev() throws ConnectionException, UnknownException {
        return Monitor.getCurrentPerfValue(this.monitor.getNodePerformance().latencyStddev);
    }
}

