/*
 * Decompiled with CFR 0.152.
 */
package de.zib.scalaris.executor;

import com.ericsson.otp.erlang.OtpErlangException;
import de.zib.scalaris.ErlangValue;
import de.zib.scalaris.NotFoundException;
import de.zib.scalaris.RequestList;
import de.zib.scalaris.ResultList;
import de.zib.scalaris.UnknownException;
import de.zib.scalaris.executor.ScalarisOp;
import de.zib.scalaris.operations.ReadOp;

public class ScalarisReadOp
implements ScalarisOp {
    protected final String key;
    protected ErlangValue value = null;

    public ScalarisReadOp(String key) {
        this.key = key;
    }

    @Override
    public int workPhases() {
        return 1;
    }

    @Override
    public final int doPhase(int phase, int firstOp, ResultList results, RequestList requests) throws OtpErlangException, UnknownException, IllegalArgumentException {
        switch (phase) {
            case 0: {
                return this.prepareRead(requests);
            }
            case 1: {
                return this.checkRead(firstOp, results);
            }
        }
        throw new IllegalArgumentException("No phase " + phase);
    }

    protected int prepareRead(RequestList requests) throws OtpErlangException, UnknownException {
        requests.addOp(new ReadOp(this.key));
        return 0;
    }

    protected int checkRead(int firstOp, ResultList results) throws OtpErlangException, UnknownException {
        try {
            this.value = results.processReadAt(firstOp);
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        return 1;
    }

    @Override
    public String toString() {
        return "Scalaris.read(" + this.key + ", " + this.value + ")";
    }

    public String getKey() {
        return this.key;
    }

    public ErlangValue getValue() {
        return this.value;
    }
}

