/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.otp.erlang;

import com.ericsson.otp.erlang.OtpErlangDecodeException;
import com.ericsson.otp.erlang.OtpErlangException;
import com.ericsson.otp.erlang.OtpErlangObject;
import com.ericsson.otp.erlang.OtpInputStream;
import com.ericsson.otp.erlang.OtpOutputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OtpErlangTuple
extends OtpErlangObject {
    private static final long serialVersionUID = 9163498658004915935L;
    private static final OtpErlangObject[] NO_ELEMENTS = new OtpErlangObject[0];
    private OtpErlangObject[] elems = NO_ELEMENTS;

    public OtpErlangTuple(OtpErlangObject otpErlangObject) {
        if (otpErlangObject == null) {
            throw new IllegalArgumentException("Tuple element cannot be null");
        }
        this.elems = new OtpErlangObject[]{otpErlangObject};
    }

    public OtpErlangTuple(OtpErlangObject[] otpErlangObjectArray) {
        this(otpErlangObjectArray, 0, otpErlangObjectArray.length);
    }

    public OtpErlangTuple(OtpErlangObject[] otpErlangObjectArray, int n, int n2) {
        if (otpErlangObjectArray == null) {
            throw new IllegalArgumentException("Tuple content can't be null");
        }
        if (n2 < 1) {
            this.elems = NO_ELEMENTS;
        } else {
            this.elems = new OtpErlangObject[n2];
            for (int i = 0; i < n2; ++i) {
                if (otpErlangObjectArray[n + i] == null) {
                    throw new IllegalArgumentException("Tuple element cannot be null (element" + (n + i) + ")");
                }
                this.elems[i] = otpErlangObjectArray[n + i];
            }
        }
    }

    public OtpErlangTuple(OtpInputStream otpInputStream) throws OtpErlangDecodeException {
        int n = otpInputStream.read_tuple_head();
        if (n > 0) {
            this.elems = new OtpErlangObject[n];
            for (int i = 0; i < n; ++i) {
                this.elems[i] = otpInputStream.read_any();
            }
        } else {
            this.elems = NO_ELEMENTS;
        }
    }

    public int arity() {
        return this.elems.length;
    }

    public OtpErlangObject elementAt(int n) {
        if (n >= this.arity() || n < 0) {
            return null;
        }
        return this.elems[n];
    }

    public OtpErlangObject[] elements() {
        OtpErlangObject[] otpErlangObjectArray = new OtpErlangObject[this.arity()];
        System.arraycopy(this.elems, 0, otpErlangObjectArray, 0, otpErlangObjectArray.length);
        return otpErlangObjectArray;
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = this.elems.length;
        stringBuffer.append("{");
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                stringBuffer.append(",");
            }
            stringBuffer.append(this.elems[i].toString());
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    @Override
    public void encode(OtpOutputStream otpOutputStream) {
        int n = this.elems.length;
        otpOutputStream.write_tuple_head(n);
        for (int i = 0; i < n; ++i) {
            otpOutputStream.write_any(this.elems[i]);
        }
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof OtpErlangTuple)) {
            return false;
        }
        OtpErlangTuple otpErlangTuple = (OtpErlangTuple)object;
        int n = this.arity();
        if (n != otpErlangTuple.arity()) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            if (this.elems[i].equals(otpErlangTuple.elems[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public <T> boolean match(OtpErlangObject otpErlangObject, T t) {
        if (!(otpErlangObject instanceof OtpErlangTuple)) {
            return false;
        }
        OtpErlangTuple otpErlangTuple = (OtpErlangTuple)otpErlangObject;
        int n = this.elems.length;
        if (n != otpErlangTuple.elems.length) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            if (this.elems[i].match(otpErlangTuple.elems[i], t)) continue;
            return false;
        }
        return true;
    }

    @Override
    public <T> OtpErlangObject bind(T t) throws OtpErlangException {
        OtpErlangTuple otpErlangTuple = (OtpErlangTuple)this.clone();
        for (OtpErlangObject otpErlangObject : otpErlangTuple.elems) {
            otpErlangTuple.elems[var4_4] = otpErlangObject.bind(t);
        }
        return otpErlangTuple;
    }

    @Override
    protected int doHashCode() {
        OtpErlangObject.Hash hash = new OtpErlangObject.Hash(9);
        int n = this.arity();
        hash.combine(n);
        for (int i = 0; i < n; ++i) {
            hash.combine(this.elems[i].hashCode());
        }
        return hash.valueOf();
    }

    @Override
    public Object clone() {
        OtpErlangTuple otpErlangTuple = (OtpErlangTuple)super.clone();
        otpErlangTuple.elems = (OtpErlangObject[])this.elems.clone();
        return otpErlangTuple;
    }
}

