/*
 * Decompiled with CFR 0.152.
 */
package de.zib.scalaris.operations;

import com.ericsson.otp.erlang.OtpErlangDecodeException;
import com.ericsson.otp.erlang.OtpErlangLong;
import com.ericsson.otp.erlang.OtpErlangObject;
import com.ericsson.otp.erlang.OtpErlangRangeException;
import com.ericsson.otp.erlang.OtpErlangString;
import com.ericsson.otp.erlang.OtpErlangTuple;
import de.zib.scalaris.CommonErlangObjects;
import de.zib.scalaris.EmptyListException;
import de.zib.scalaris.ErlangValue;
import de.zib.scalaris.NotAListException;
import de.zib.scalaris.NotFoundException;
import de.zib.scalaris.UnknownException;
import de.zib.scalaris.operations.PartialReadOp;

public class ReadRandomFromListOp
extends PartialReadOp {
    public ReadRandomFromListOp(OtpErlangString key) {
        super(key);
    }

    public ReadRandomFromListOp(String key) {
        super(key);
    }

    @Override
    public OtpErlangObject getErlang(boolean compressed) {
        return new OtpErlangTuple(new OtpErlangObject[]{CommonErlangObjects.readAtom, this.key, CommonErlangObjects.randomFromListAtom});
    }

    @Override
    public Result processResult() throws NotFoundException, EmptyListException, NotAListException, UnknownException {
        try {
            OtpErlangTuple received = (OtpErlangTuple)this.resultRaw;
            OtpErlangObject state = received.elementAt(0);
            if (received.arity() != 2) {
                throw new UnknownException(this.resultRaw);
            }
            if (state.equals((Object)CommonErlangObjects.okAtom)) {
                return new Result(received.elementAt(1), this.resultCompressed);
            }
            if (state.equals((Object)CommonErlangObjects.failAtom)) {
                OtpErlangObject reason = received.elementAt(1);
                if (reason.equals((Object)CommonErlangObjects.notFoundAtom)) {
                    throw new NotFoundException(this.resultRaw);
                }
                if (reason.equals((Object)CommonErlangObjects.emptyListAtom)) {
                    throw new EmptyListException(this.resultRaw);
                }
                if (reason.equals((Object)CommonErlangObjects.notAListAtom)) {
                    throw new NotAListException(this.resultRaw);
                }
            }
            throw new UnknownException(this.resultRaw);
        }
        catch (ClassCastException e) {
            throw new UnknownException(e, this.resultRaw);
        }
        catch (OtpErlangDecodeException e) {
            throw new UnknownException(e, this.resultRaw);
        }
    }

    @Override
    public Result processResultSingle() throws NotFoundException, EmptyListException, NotAListException, UnknownException {
        return this.processResult();
    }

    public String toString() {
        return "readRandomFromList(" + this.key + ")";
    }

    public static class Result {
        public final ErlangValue randomElement;
        public final int listLength;

        protected Result(OtpErlangObject result0, boolean compressed) throws OtpErlangDecodeException, UnknownException, ClassCastException {
            OtpErlangTuple result = compressed ? (OtpErlangTuple)CommonErlangObjects.decode(result0) : (OtpErlangTuple)result0;
            if (result.arity() != 2) {
                throw new UnknownException((OtpErlangObject)result);
            }
            this.randomElement = new ErlangValue(result.elementAt(0));
            OtpErlangLong listLengthOtp = (OtpErlangLong)result.elementAt(1);
            try {
                this.listLength = listLengthOtp.intValue();
            }
            catch (OtpErlangRangeException e) {
                throw new UnknownException("Unsupported list length (" + listLengthOtp + ")");
            }
        }

        public String toString() {
            return "{randomElement: " + this.randomElement.toString() + ", listLength: " + this.listLength + "}";
        }
    }
}

