/*
 * Decompiled with CFR 0.152.
 */
package de.zib.scalaris;

import com.ericsson.otp.erlang.OtpErlangAtom;
import com.ericsson.otp.erlang.OtpErlangInt;
import com.ericsson.otp.erlang.OtpErlangList;
import com.ericsson.otp.erlang.OtpErlangObject;
import com.ericsson.otp.erlang.OtpErlangTuple;
import de.zib.scalaris.CommonErlangObjects;
import de.zib.scalaris.Connection;
import de.zib.scalaris.ConnectionException;
import de.zib.scalaris.ConnectionFactory;
import de.zib.scalaris.ErlangValue;
import de.zib.scalaris.FixedNodeConnectionPolicy;
import de.zib.scalaris.PeerNode;
import de.zib.scalaris.UnknownException;
import java.net.Inet4Address;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;

public class ScalarisVM {
    private final Connection connection;

    public ScalarisVM(PeerNode node) throws ConnectionException {
        ConnectionFactory cf = ConnectionFactory.getInstance();
        this.connection = cf.createConnection(new FixedNodeConnectionPolicy(node));
    }

    public ScalarisVM(String node) throws ConnectionException {
        ConnectionFactory cf = ConnectionFactory.getInstance();
        this.connection = cf.createConnection(new FixedNodeConnectionPolicy(node));
    }

    public String getVersion() throws ConnectionException, UnknownException {
        OtpErlangObject received_raw = this.connection.doRPC("api_vm", "get_version", new OtpErlangObject[0]);
        try {
            return new ErlangValue(received_raw).stringValue();
        }
        catch (ClassCastException e) {
            throw new UnknownException(e, received_raw);
        }
    }

    public GetInfoResult getInfo() throws ConnectionException, UnknownException {
        OtpErlangObject received_raw = this.connection.doRPC("api_vm", "get_info", new OtpErlangObject[0]);
        try {
            OtpErlangList received = (OtpErlangList)received_raw;
            LinkedHashMap<String, OtpErlangObject> result = new LinkedHashMap<String, OtpErlangObject>(received.arity());
            for (OtpErlangObject iter : received) {
                OtpErlangTuple iter_tpl = (OtpErlangTuple)iter;
                if (iter_tpl.arity() == 2) {
                    String key = ((OtpErlangAtom)iter_tpl.elementAt(0)).atomValue();
                    result.put(key, iter_tpl.elementAt(1));
                    continue;
                }
                throw new UnknownException(received_raw);
            }
            String scalarisVersion = new ErlangValue((OtpErlangObject)result.get("scalaris_version")).stringValue();
            String erlangVersion = new ErlangValue((OtpErlangObject)result.get("erlang_version")).stringValue();
            int memTotal = new ErlangValue((OtpErlangObject)result.get("mem_total")).intValue();
            int uptime = new ErlangValue((OtpErlangObject)result.get("uptime")).intValue();
            String erlangNode = new ErlangValue((OtpErlangObject)result.get("erlang_node")).stringValue();
            OtpErlangTuple erlIP = (OtpErlangTuple)result.get("ip");
            Inet4Address ip = (Inet4Address)Inet4Address.getByName(erlIP.elementAt(0) + "." + erlIP.elementAt(1) + "." + erlIP.elementAt(2) + "." + erlIP.elementAt(3));
            int port = new ErlangValue((OtpErlangObject)result.get("port")).intValue();
            int yawsPort = new ErlangValue((OtpErlangObject)result.get("yaws_port")).intValue();
            return new GetInfoResult(scalarisVersion, erlangVersion, memTotal, uptime, erlangNode, ip, port, yawsPort);
        }
        catch (ClassCastException e) {
            throw new UnknownException(e, received_raw);
        }
        catch (NullPointerException e) {
            throw new UnknownException(e, received_raw);
        }
        catch (UnknownHostException e) {
            throw new UnknownException(e, received_raw);
        }
    }

    public int getNumberOfNodes() throws ConnectionException, UnknownException {
        OtpErlangObject received_raw = this.connection.doRPC("api_vm", "number_of_nodes", new OtpErlangObject[0]);
        try {
            return new ErlangValue(received_raw).intValue();
        }
        catch (ClassCastException e) {
            throw new UnknownException(e, received_raw);
        }
    }

    public List<ErlangValue> getNodes() throws ConnectionException, UnknownException {
        OtpErlangObject received_raw = this.connection.doRPC("api_vm", "get_nodes", new OtpErlangObject[0]);
        try {
            return new ErlangValue(received_raw).listValue();
        }
        catch (ClassCastException e) {
            throw new UnknownException(e, received_raw);
        }
    }

    public AddNodesResult addNodes(int number) throws ConnectionException, UnknownException {
        OtpErlangObject received_raw = this.connection.doRPC("api_vm", "add_nodes", new OtpErlangObject[]{new OtpErlangInt(number)});
        try {
            OtpErlangTuple received = (OtpErlangTuple)received_raw;
            List<ErlangValue> successful = new ErlangValue(received.elementAt(0)).listValue();
            OtpErlangList errors = ErlangValue.otpObjectToOtpList(received.elementAt(1));
            String error_str = errors.arity() == 0 ? "" : errors.toString();
            return new AddNodesResult(successful, error_str);
        }
        catch (ClassCastException e) {
            throw new UnknownException(e, received_raw);
        }
    }

    public boolean shutdownNode(ErlangValue name) throws ConnectionException, UnknownException {
        OtpErlangObject received_raw = this.connection.doRPC("api_vm", "shutdown_node", new OtpErlangObject[]{name.value()});
        if (received_raw.equals((Object)CommonErlangObjects.okAtom)) {
            return true;
        }
        if (received_raw.equals((Object)CommonErlangObjects.notFoundAtom)) {
            return false;
        }
        throw new UnknownException(received_raw);
    }

    public boolean killNode(ErlangValue name) throws ConnectionException, UnknownException {
        OtpErlangObject received_raw = this.connection.doRPC("api_vm", "kill_node", new OtpErlangObject[]{name.value()});
        if (received_raw.equals((Object)CommonErlangObjects.okAtom)) {
            return true;
        }
        if (received_raw.equals((Object)CommonErlangObjects.notFoundAtom)) {
            return false;
        }
        throw new UnknownException(received_raw);
    }

    public List<ErlangValue> shutdownNodes(int number) throws ConnectionException, UnknownException {
        OtpErlangObject received_raw = this.connection.doRPC("api_vm", "shutdown_nodes", new OtpErlangObject[]{new OtpErlangInt(number)});
        return this.makeDeleteResult(received_raw);
    }

    public List<ErlangValue> killNodes(int number) throws ConnectionException, UnknownException {
        OtpErlangObject received_raw = this.connection.doRPC("api_vm", "kill_nodes", new OtpErlangObject[]{new OtpErlangInt(number)});
        return this.makeDeleteResult(received_raw);
    }

    private final List<ErlangValue> makeDeleteResult(OtpErlangObject received_raw) throws UnknownException {
        try {
            return new ErlangValue(received_raw).listValue();
        }
        catch (ClassCastException e) {
            throw new UnknownException(e, received_raw);
        }
    }

    public DeleteNodesByNameResult shutdownNodesByName(List<ErlangValue> names) throws ConnectionException, UnknownException {
        OtpErlangObject received_raw = this.connection.doRPC("api_vm", "shutdown_nodes_by_name", new OtpErlangObject[]{ErlangValue.convertToErlang(names)});
        return this.makeDeleteByNameResult(received_raw);
    }

    public DeleteNodesByNameResult killNodes(List<ErlangValue> names) throws ConnectionException, UnknownException {
        OtpErlangObject received_raw = this.connection.doRPC("api_vm", "kill_nodes_by_name", new OtpErlangObject[]{ErlangValue.convertToErlang(names)});
        return this.makeDeleteByNameResult(received_raw);
    }

    private final DeleteNodesByNameResult makeDeleteByNameResult(OtpErlangObject received_raw) throws UnknownException {
        try {
            OtpErlangTuple received = (OtpErlangTuple)received_raw;
            List<ErlangValue> successful = new ErlangValue(received.elementAt(0)).listValue();
            List<ErlangValue> not_found = new ErlangValue(received.elementAt(1)).listValue();
            return new DeleteNodesByNameResult(successful, not_found);
        }
        catch (ClassCastException e) {
            throw new UnknownException(e, received_raw);
        }
    }

    public List<String> getOtherVMs(int max) throws ConnectionException, UnknownException {
        if (max <= 0) {
            throw new IllegalArgumentException("max must be an integer > 0");
        }
        OtpErlangObject received_raw = this.connection.doRPC("api_vm", "get_other_vms", new OtpErlangObject[]{ErlangValue.convertToErlang(max)});
        try {
            OtpErlangList list = ErlangValue.otpObjectToOtpList(received_raw);
            ArrayList<String> result = new ArrayList<String>(list.arity());
            for (int i = 0; i < list.arity(); ++i) {
                OtpErlangTuple connTuple = (OtpErlangTuple)list.elementAt(i);
                if (connTuple.arity() != 4) {
                    throw new UnknownException(received_raw);
                }
                OtpErlangAtom name_otp = (OtpErlangAtom)connTuple.elementAt(0);
                result.add(name_otp.atomValue());
            }
            return result;
        }
        catch (ClassCastException e) {
            throw new UnknownException(e, received_raw);
        }
    }

    public void shutdownVM() throws ConnectionException {
        this.connection.sendRPC("api_vm", "shutdown_vm", new OtpErlangObject[0]);
    }

    public void killVM() throws ConnectionException {
        this.connection.sendRPC("api_vm", "kill_vm", new OtpErlangObject[0]);
    }

    public void closeConnection() {
        this.connection.close();
    }

    public static class DeleteNodesByNameResult {
        public final List<ErlangValue> successful;
        public final List<ErlangValue> notFound;

        protected DeleteNodesByNameResult(List<ErlangValue> successful, List<ErlangValue> notFound) {
            this.successful = successful;
            this.notFound = notFound;
        }
    }

    public static class AddNodesResult {
        public final List<ErlangValue> successful;
        public final String errors;

        protected AddNodesResult(List<ErlangValue> successful, String errors) {
            this.successful = successful;
            this.errors = errors;
        }
    }

    public static class GetInfoResult {
        public final String scalarisVersion;
        public final String erlangVersion;
        public final int memTotal;
        public final int uptime;
        public final String erlangNode;
        public final Inet4Address ip;
        public final int port;
        public final int yawsPort;

        protected GetInfoResult(String scalarisVersion, String erlangVersion, int memTotal, int uptime, String erlangNode, Inet4Address ip, int port, int yawsPort) {
            this.scalarisVersion = scalarisVersion;
            this.erlangVersion = erlangVersion;
            this.memTotal = memTotal;
            this.uptime = uptime;
            this.erlangNode = erlangNode;
            this.ip = ip;
            this.port = port;
            this.yawsPort = yawsPort;
        }
    }
}

