/*
 * Decompiled with CFR 0.152.
 */
package de.zib.scalaris;

import com.ericsson.otp.erlang.OtpErlangAtom;
import com.ericsson.otp.erlang.OtpErlangList;
import com.ericsson.otp.erlang.OtpErlangObject;
import com.ericsson.otp.erlang.OtpErlangTuple;
import de.zib.scalaris.Connection;
import de.zib.scalaris.ConnectionException;
import de.zib.scalaris.ConnectionFactory;
import de.zib.scalaris.ErlangValue;
import de.zib.scalaris.UnknownException;
import java.util.ArrayList;
import java.util.List;

public class Scalaris {
    private final Connection connection;

    public Scalaris() throws ConnectionException {
        this.connection = ConnectionFactory.getInstance().createConnection();
    }

    public Scalaris(Connection conn) {
        this.connection = conn;
    }

    public List<String> getRandomNodes(int max) throws ConnectionException, UnknownException {
        if (max <= 0) {
            throw new IllegalArgumentException("max must be an integer > 0");
        }
        OtpErlangObject received_raw = this.connection.doRPC("api_vm", "get_other_vms", new OtpErlangObject[]{ErlangValue.convertToErlang(max)});
        try {
            OtpErlangList list = ErlangValue.otpObjectToOtpList(received_raw);
            ArrayList<String> result = new ArrayList<String>(list.arity());
            for (int i = 0; i < list.arity(); ++i) {
                OtpErlangTuple connTuple = (OtpErlangTuple)list.elementAt(i);
                if (connTuple.arity() != 4) {
                    throw new UnknownException(received_raw);
                }
                OtpErlangAtom name_otp = (OtpErlangAtom)connTuple.elementAt(i);
                result.add(name_otp.atomValue());
            }
            if (result.isEmpty()) {
                result.add(this.connection.getRemote().getNode().toString());
            }
            return result;
        }
        catch (ClassCastException e) {
            throw new UnknownException(e, received_raw);
        }
    }

    public void closeConnection() {
        this.connection.close();
    }
}

