/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.otp.erlang;

import com.ericsson.otp.erlang.OtpErlangDecodeException;
import com.ericsson.otp.erlang.OtpErlangObject;
import com.ericsson.otp.erlang.OtpErlangRangeException;
import com.ericsson.otp.erlang.OtpInputStream;
import com.ericsson.otp.erlang.OtpOutputStream;

public class OtpErlangDouble
extends OtpErlangObject {
    private static final long serialVersionUID = 132947104811974021L;
    private final double d;

    public OtpErlangDouble(double d) {
        this.d = d;
    }

    public OtpErlangDouble(OtpInputStream otpInputStream) throws OtpErlangDecodeException {
        this.d = otpInputStream.read_double();
    }

    public double doubleValue() {
        return this.d;
    }

    public float floatValue() throws OtpErlangRangeException {
        float f = (float)this.d;
        if ((double)f != this.d) {
            throw new OtpErlangRangeException("Value too large for float: " + this.d);
        }
        return f;
    }

    public String toString() {
        return "" + this.d;
    }

    public void encode(OtpOutputStream otpOutputStream) {
        otpOutputStream.write_double(this.d);
    }

    public boolean equals(Object object) {
        if (!(object instanceof OtpErlangDouble)) {
            return false;
        }
        OtpErlangDouble otpErlangDouble = (OtpErlangDouble)object;
        return this.d == otpErlangDouble.d;
    }

    protected int doHashCode() {
        Double d = new Double(this.d);
        return d.hashCode();
    }
}

