/*
 * Decompiled with CFR 0.152.
 */
package de.zib.scalaris.operations;

import com.ericsson.otp.erlang.OtpErlangObject;
import com.ericsson.otp.erlang.OtpErlangString;
import com.ericsson.otp.erlang.OtpErlangTuple;
import de.zib.scalaris.AbortException;
import de.zib.scalaris.CommonErlangObjects;
import de.zib.scalaris.ErlangValue;
import de.zib.scalaris.UnknownException;
import de.zib.scalaris.operations.TransactionOperation;
import de.zib.scalaris.operations.TransactionSingleOpOperation;

public class WriteOp
implements TransactionOperation,
TransactionSingleOpOperation {
    protected final OtpErlangString key;
    protected final OtpErlangObject value;
    protected OtpErlangObject resultRaw = null;
    protected boolean resultCompressed = false;

    public WriteOp(OtpErlangString key, OtpErlangObject value) {
        this.key = key;
        this.value = value;
    }

    public <T> WriteOp(String key, T value) {
        this.key = new OtpErlangString(key);
        this.value = ErlangValue.convertToErlang(value);
    }

    @Override
    public OtpErlangObject getErlang(boolean compressed) {
        return new OtpErlangTuple(new OtpErlangObject[]{CommonErlangObjects.writeAtom, this.key, compressed ? CommonErlangObjects.encode(this.value) : this.value});
    }

    @Override
    public OtpErlangString getKey() {
        return this.key;
    }

    @Override
    public void setResult(OtpErlangObject resultRaw, boolean compressed) {
        this.resultRaw = resultRaw;
        this.resultCompressed = compressed;
    }

    @Override
    public OtpErlangObject getResult() {
        return this.resultRaw;
    }

    @Override
    public boolean getResultCompressed() {
        return this.resultCompressed;
    }

    @Override
    public Object processResult() throws UnknownException {
        try {
            OtpErlangTuple received = (OtpErlangTuple)this.resultRaw;
            if (received.equals((Object)CommonErlangObjects.okTupleAtom)) {
                return null;
            }
            throw new UnknownException(this.resultRaw);
        }
        catch (ClassCastException e) {
            throw new UnknownException(e, this.resultRaw);
        }
    }

    @Override
    public Object processResultSingle() throws AbortException, UnknownException {
        CommonErlangObjects.checkResult_failAbort(this.resultRaw, this.resultCompressed);
        return this.processResult();
    }

    public String toString() {
        return "write(" + this.key + ", " + this.value + ")";
    }
}

