/*
 * Decompiled with CFR 0.152.
 */
package de.zib.scalaris.operations;

import com.ericsson.otp.erlang.OtpErlangDecodeException;
import com.ericsson.otp.erlang.OtpErlangObject;
import com.ericsson.otp.erlang.OtpErlangString;
import com.ericsson.otp.erlang.OtpErlangTuple;
import de.zib.scalaris.AbortException;
import de.zib.scalaris.CommonErlangObjects;
import de.zib.scalaris.ErlangValue;
import de.zib.scalaris.KeyChangedException;
import de.zib.scalaris.NotFoundException;
import de.zib.scalaris.UnknownException;
import de.zib.scalaris.operations.TransactionOperation;
import de.zib.scalaris.operations.TransactionSingleOpOperation;

public class TestAndSetOp
implements TransactionOperation,
TransactionSingleOpOperation {
    protected final OtpErlangString key;
    protected final OtpErlangObject oldValue;
    protected final OtpErlangObject newValue;
    protected OtpErlangObject resultRaw = null;
    protected boolean resultCompressed = false;

    public TestAndSetOp(OtpErlangString key, OtpErlangObject oldValue, OtpErlangObject newValue) {
        this.key = key;
        this.oldValue = oldValue;
        this.newValue = newValue;
    }

    public <OldT, NewT> TestAndSetOp(String key, OldT oldValue, NewT newValue) {
        this.key = new OtpErlangString(key);
        this.oldValue = ErlangValue.convertToErlang(oldValue);
        this.newValue = ErlangValue.convertToErlang(newValue);
    }

    @Override
    public OtpErlangObject getErlang(boolean compressed) {
        return new OtpErlangTuple(new OtpErlangObject[]{CommonErlangObjects.testAndSetAtom, this.key, compressed ? CommonErlangObjects.encode(this.oldValue) : this.oldValue, compressed ? CommonErlangObjects.encode(this.newValue) : this.newValue});
    }

    @Override
    public OtpErlangString getKey() {
        return this.key;
    }

    @Override
    public void setResult(OtpErlangObject resultRaw, boolean compressed) {
        this.resultRaw = resultRaw;
        this.resultCompressed = compressed;
    }

    @Override
    public OtpErlangObject getResult() {
        return this.resultRaw;
    }

    @Override
    public boolean getResultCompressed() {
        return this.resultCompressed;
    }

    @Override
    public Object processResult() throws NotFoundException, KeyChangedException, UnknownException {
        try {
            OtpErlangTuple received = (OtpErlangTuple)this.resultRaw;
            if (received.equals((Object)CommonErlangObjects.okTupleAtom)) {
                return null;
            }
            if (received.elementAt(0).equals((Object)CommonErlangObjects.failAtom) && received.arity() == 2) {
                OtpErlangObject reason = received.elementAt(1);
                if (reason.equals((Object)CommonErlangObjects.notFoundAtom)) {
                    throw new NotFoundException(this.resultRaw);
                }
                OtpErlangTuple reason_tpl = (OtpErlangTuple)reason;
                if (reason_tpl.elementAt(0).equals((Object)CommonErlangObjects.keyChangedAtom) && reason_tpl.arity() == 2) {
                    OtpErlangObject result = reason_tpl.elementAt(1);
                    if (this.resultCompressed) {
                        result = CommonErlangObjects.decode(result);
                    }
                    throw new KeyChangedException(new ErlangValue(result));
                }
            }
            throw new UnknownException(this.resultRaw);
        }
        catch (ClassCastException e) {
            throw new UnknownException(e, this.resultRaw);
        }
        catch (OtpErlangDecodeException e) {
            throw new UnknownException(e, this.resultRaw);
        }
    }

    @Override
    public Object processResultSingle() throws AbortException, NotFoundException, KeyChangedException, UnknownException {
        CommonErlangObjects.checkResult_failAbort(this.resultRaw, this.resultCompressed);
        return this.processResult();
    }

    public String toString() {
        return "test_and_set(" + this.key + ", " + this.oldValue + ", " + this.newValue + ")";
    }
}

