/*
 * Decompiled with CFR 0.152.
 */
package de.zib.scalaris.operations;

import com.ericsson.otp.erlang.OtpErlangDecodeException;
import com.ericsson.otp.erlang.OtpErlangInt;
import com.ericsson.otp.erlang.OtpErlangLong;
import com.ericsson.otp.erlang.OtpErlangObject;
import com.ericsson.otp.erlang.OtpErlangRangeException;
import com.ericsson.otp.erlang.OtpErlangString;
import com.ericsson.otp.erlang.OtpErlangTuple;
import de.zib.scalaris.CommonErlangObjects;
import de.zib.scalaris.ErlangValue;
import de.zib.scalaris.NotAListException;
import de.zib.scalaris.NotFoundException;
import de.zib.scalaris.UnknownException;
import de.zib.scalaris.operations.PartialReadOp;
import java.math.BigInteger;

public class ReadSublistOp
extends PartialReadOp {
    protected final OtpErlangInt start;
    protected final OtpErlangInt length;

    public ReadSublistOp(OtpErlangString key, OtpErlangInt start, OtpErlangInt length) {
        super(key);
        assert (!start.bigIntegerValue().equals(BigInteger.ZERO));
        this.start = start;
        this.length = length;
    }

    public ReadSublistOp(String key, int start, int length) {
        super(key);
        assert (start != 0);
        this.start = new OtpErlangInt(start);
        this.length = new OtpErlangInt(length);
    }

    @Override
    public OtpErlangObject getErlang(boolean compressed) {
        return new OtpErlangTuple(new OtpErlangObject[]{CommonErlangObjects.readAtom, this.key, new OtpErlangTuple(new OtpErlangObject[]{CommonErlangObjects.sublistAtom, this.start, this.length})});
    }

    @Override
    public Result processResult() throws NotFoundException, NotAListException, UnknownException {
        try {
            OtpErlangTuple received = (OtpErlangTuple)this.resultRaw;
            OtpErlangObject state = received.elementAt(0);
            if (received.arity() != 2) {
                throw new UnknownException(this.resultRaw);
            }
            if (state.equals((Object)CommonErlangObjects.okAtom)) {
                return new Result(received.elementAt(1), this.resultCompressed);
            }
            if (state.equals((Object)CommonErlangObjects.failAtom)) {
                OtpErlangObject reason = received.elementAt(1);
                if (reason.equals((Object)CommonErlangObjects.notFoundAtom)) {
                    throw new NotFoundException(this.resultRaw);
                }
                if (reason.equals((Object)CommonErlangObjects.notAListAtom)) {
                    throw new NotAListException(this.resultRaw);
                }
            }
            throw new UnknownException(this.resultRaw);
        }
        catch (ClassCastException e) {
            throw new UnknownException(e, this.resultRaw);
        }
        catch (OtpErlangDecodeException e) {
            throw new UnknownException(e, this.resultRaw);
        }
    }

    @Override
    public Result processResultSingle() throws NotFoundException, NotAListException, UnknownException {
        return this.processResult();
    }

    public String toString() {
        return "readSublist(" + this.key + "," + this.start + "," + this.length + ")";
    }

    public static class Result {
        public final ErlangValue subList;
        public final int listLength;

        protected Result(OtpErlangObject result0, boolean compressed) throws OtpErlangDecodeException, UnknownException {
            OtpErlangTuple result = compressed ? (OtpErlangTuple)CommonErlangObjects.decode(result0) : (OtpErlangTuple)result0;
            if (result.arity() != 2) {
                throw new UnknownException((OtpErlangObject)result);
            }
            this.subList = new ErlangValue((OtpErlangObject)ErlangValue.otpObjectToOtpList(result.elementAt(0)));
            OtpErlangLong listLengthOtp = (OtpErlangLong)result.elementAt(1);
            try {
                this.listLength = listLengthOtp.intValue();
            }
            catch (OtpErlangRangeException e) {
                throw new UnknownException("Unsupported list length (" + listLengthOtp + ")");
            }
        }

        public String toString() {
            return "{subList: " + this.subList.toString() + ", listLength: " + this.listLength + "}";
        }
    }
}

