/*
 * Decompiled with CFR 0.152.
 */
package de.zib.scalaris.operations;

import com.ericsson.otp.erlang.OtpErlangDecodeException;
import com.ericsson.otp.erlang.OtpErlangObject;
import com.ericsson.otp.erlang.OtpErlangString;
import com.ericsson.otp.erlang.OtpErlangTuple;
import de.zib.scalaris.AbortException;
import de.zib.scalaris.CommonErlangObjects;
import de.zib.scalaris.ErlangValue;
import de.zib.scalaris.KeyChangedException;
import de.zib.scalaris.NotAListException;
import de.zib.scalaris.NotANumberException;
import de.zib.scalaris.NotFoundException;
import de.zib.scalaris.UnknownException;
import de.zib.scalaris.operations.TransactionOperation;
import de.zib.scalaris.operations.TransactionSingleOpOperation;

public class ReadOp
implements TransactionOperation,
TransactionSingleOpOperation {
    protected final OtpErlangString key;
    protected OtpErlangObject resultRaw = null;
    protected boolean resultCompressed = false;

    public ReadOp(OtpErlangString key) {
        this.key = key;
    }

    public ReadOp(String key) {
        this.key = new OtpErlangString(key);
    }

    @Override
    public OtpErlangObject getErlang(boolean compressed) {
        return new OtpErlangTuple(new OtpErlangObject[]{CommonErlangObjects.readAtom, this.key});
    }

    @Override
    public OtpErlangString getKey() {
        return this.key;
    }

    @Override
    public void setResult(OtpErlangObject resultRaw, boolean compressed) {
        this.resultRaw = resultRaw;
        this.resultCompressed = compressed;
    }

    @Override
    public OtpErlangObject getResult() {
        return this.resultRaw;
    }

    @Override
    public boolean getResultCompressed() {
        return this.resultCompressed;
    }

    @Override
    public ErlangValue processResult() throws NotFoundException, UnknownException {
        try {
            OtpErlangObject reason;
            OtpErlangTuple received = (OtpErlangTuple)this.resultRaw;
            OtpErlangObject state = received.elementAt(0);
            if (received.arity() != 2) {
                throw new UnknownException(this.resultRaw);
            }
            if (state.equals((Object)CommonErlangObjects.okAtom)) {
                OtpErlangObject result = received.elementAt(1);
                if (this.resultCompressed) {
                    result = CommonErlangObjects.decode(result);
                }
                return new ErlangValue(result);
            }
            if (state.equals((Object)CommonErlangObjects.failAtom) && (reason = received.elementAt(1)).equals((Object)CommonErlangObjects.notFoundAtom)) {
                throw new NotFoundException(this.resultRaw);
            }
            throw new UnknownException(this.resultRaw);
        }
        catch (ClassCastException e) {
            throw new UnknownException(e, this.resultRaw);
        }
        catch (OtpErlangDecodeException e) {
            throw new UnknownException(e, this.resultRaw);
        }
    }

    @Override
    public ErlangValue processResultSingle() throws NotFoundException, KeyChangedException, NotANumberException, NotAListException, AbortException, UnknownException {
        return this.processResult();
    }

    public String toString() {
        return "read(" + this.key + ")";
    }
}

