/*
 * Decompiled with CFR 0.152.
 */
package de.zib.scalaris;

import com.ericsson.otp.erlang.OtpErlangAtom;
import com.ericsson.otp.erlang.OtpErlangInt;
import com.ericsson.otp.erlang.OtpErlangList;
import com.ericsson.otp.erlang.OtpErlangLong;
import com.ericsson.otp.erlang.OtpErlangObject;
import com.ericsson.otp.erlang.OtpErlangRangeException;
import com.ericsson.otp.erlang.OtpErlangString;
import com.ericsson.otp.erlang.OtpErlangTuple;
import de.zib.scalaris.CommonErlangObjects;
import de.zib.scalaris.Connection;
import de.zib.scalaris.ConnectionException;
import de.zib.scalaris.ConnectionFactory;
import de.zib.scalaris.DeleteResult;
import de.zib.scalaris.TimeoutException;
import de.zib.scalaris.UnknownException;

public class ReplicatedDHT {
    private DeleteResult lastDeleteResult = null;
    private final Connection connection;

    public ReplicatedDHT() throws ConnectionException {
        this.connection = ConnectionFactory.getInstance().createConnection();
    }

    public ReplicatedDHT(Connection conn) {
        this.connection = conn;
    }

    public DeleteResult delete(OtpErlangString key) throws ConnectionException, TimeoutException, UnknownException {
        return this.delete(key, 2000);
    }

    public DeleteResult delete(OtpErlangString key, int timeout) throws ConnectionException, TimeoutException, UnknownException {
        this.lastDeleteResult = null;
        OtpErlangObject received_raw = this.connection.doRPC("api_rdht", "delete", new OtpErlangObject[]{key, new OtpErlangInt(timeout)});
        try {
            OtpErlangObject reason;
            OtpErlangTuple received = (OtpErlangTuple)received_raw;
            OtpErlangAtom state = (OtpErlangAtom)received.elementAt(0);
            if (state.equals((Object)CommonErlangObjects.okAtom) && received.arity() == 3) {
                this.lastDeleteResult = new DeleteResult((OtpErlangList)received.elementAt(2));
                int succeeded = ((OtpErlangLong)received.elementAt(1)).intValue();
                if (succeeded != this.lastDeleteResult.ok) {
                    throw new UnknownException(received_raw);
                }
                return this.lastDeleteResult;
            }
            if (state.equals((Object)CommonErlangObjects.failAtom) && received.arity() == 4 && (reason = received.elementAt(1)).equals((Object)CommonErlangObjects.timeoutAtom)) {
                this.lastDeleteResult = new DeleteResult((OtpErlangList)received.elementAt(3));
                int succeeded = ((OtpErlangLong)received.elementAt(2)).intValue();
                if (succeeded != this.lastDeleteResult.ok) {
                    throw new UnknownException(received_raw);
                }
                throw new TimeoutException(received_raw);
            }
            throw new UnknownException(received_raw);
        }
        catch (ClassCastException e) {
            throw new UnknownException(e, received_raw);
        }
        catch (OtpErlangRangeException e) {
            throw new UnknownException(e, received_raw);
        }
    }

    public DeleteResult delete(String key) throws ConnectionException, TimeoutException, UnknownException {
        return this.delete(key, 2000);
    }

    public DeleteResult delete(String key, int timeout) throws ConnectionException, TimeoutException, UnknownException {
        return this.delete(new OtpErlangString(key), timeout);
    }

    public DeleteResult getLastDeleteResult() {
        return this.lastDeleteResult;
    }

    public void closeConnection() {
        this.connection.close();
    }
}

