/*
 * Decompiled with CFR 0.152.
 */
package de.zib.scalaris;

import com.ericsson.otp.erlang.OtpErlangAtom;
import com.ericsson.otp.erlang.OtpErlangBinary;
import com.ericsson.otp.erlang.OtpErlangBoolean;
import com.ericsson.otp.erlang.OtpErlangDouble;
import com.ericsson.otp.erlang.OtpErlangException;
import com.ericsson.otp.erlang.OtpErlangList;
import com.ericsson.otp.erlang.OtpErlangLong;
import com.ericsson.otp.erlang.OtpErlangObject;
import com.ericsson.otp.erlang.OtpErlangRangeException;
import com.ericsson.otp.erlang.OtpErlangString;
import com.ericsson.otp.erlang.OtpErlangTuple;
import de.zib.scalaris.CommonErlangObjects;
import de.zib.scalaris.ErlangValueJSONToBean;
import de.zib.scalaris.ErlangValueJSONToMap;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class ErlangValue
implements Comparable<ErlangValue> {
    private final OtpErlangObject value;

    public ErlangValue(OtpErlangObject value) {
        this.value = value;
    }

    public <T> ErlangValue(T value) throws ClassCastException {
        this.value = ErlangValue.convertToErlang(value);
    }

    public static <T> OtpErlangObject convertToErlang(T value) throws ClassCastException {
        if (value instanceof Boolean) {
            return new OtpErlangBoolean(((Boolean)value).booleanValue());
        }
        if (value instanceof Integer) {
            return new OtpErlangLong((long)((Integer)value).intValue());
        }
        if (value instanceof Long) {
            return new OtpErlangLong(((Long)value).longValue());
        }
        if (value instanceof BigInteger) {
            return new OtpErlangLong((BigInteger)value);
        }
        if (value instanceof Double) {
            return new OtpErlangDouble(((Double)value).doubleValue());
        }
        if (value instanceof String) {
            return new OtpErlangString((String)value);
        }
        if (value instanceof byte[]) {
            return new OtpErlangBinary((byte[])value);
        }
        if (value instanceof Collection) {
            Collection list = (Collection)value;
            int listSize = list.size();
            OtpErlangObject[] erlValue = new OtpErlangObject[listSize];
            int i = 0;
            for (Object iter : list) {
                erlValue[i] = ErlangValue.convertToErlang(iter);
                ++i;
            }
            return new OtpErlangList(erlValue);
        }
        if (value instanceof Map) {
            Map map = (Map)value;
            ErlangValueJSONToMap json_converter = new ErlangValueJSONToMap();
            return json_converter.toScalarisJSON(map);
        }
        if (value instanceof ErlangValue) {
            return ((ErlangValue)value).value();
        }
        if (value instanceof OtpErlangObject) {
            return (OtpErlangObject)value;
        }
        ErlangValueJSONToBean json_converter = new ErlangValueJSONToBean(value.getClass());
        return json_converter.toScalarisJSON(value);
    }

    public boolean boolValue() throws ClassCastException {
        if (this.value.equals((Object)CommonErlangObjects.falseAtom)) {
            return false;
        }
        if (this.value.equals((Object)CommonErlangObjects.trueAtom)) {
            return true;
        }
        throw new ClassCastException("No boolean.");
    }

    public int intValue() throws ClassCastException {
        try {
            return ((OtpErlangLong)this.value).intValue();
        }
        catch (OtpErlangRangeException e) {
            throw new ClassCastException("Cannot cast to int - value is too big (use longValue() or bigIntValue() instead).");
        }
    }

    public long longValue() throws ClassCastException {
        OtpErlangLong longValue = (OtpErlangLong)this.value;
        if (longValue.isLong()) {
            return longValue.longValue();
        }
        throw new ClassCastException("Cannot cast to long - value is too big (use bigIntValue() instead).");
    }

    public BigInteger bigIntValue() throws ClassCastException {
        return ((OtpErlangLong)this.value).bigIntegerValue();
    }

    public double doubleValue() throws ClassCastException {
        return ((OtpErlangDouble)this.value).doubleValue();
    }

    static String otpObjectToString(OtpErlangObject value) throws ClassCastException {
        if (value instanceof OtpErlangList) {
            try {
                return ((OtpErlangList)value).stringValue();
            }
            catch (OtpErlangException e) {
                throw new ClassCastException("com.ericsson.otp.erlang.OtpErlangList cannot be cast to com.ericsson.otp.erlang.OtpErlangString: " + e.getMessage());
            }
        }
        if (value instanceof OtpErlangAtom) {
            return ((OtpErlangAtom)value).atomValue();
        }
        return ((OtpErlangString)value).stringValue();
    }

    static OtpErlangString otpObjectToOtpString(OtpErlangObject value) throws ClassCastException {
        if (value instanceof OtpErlangList) {
            try {
                return new OtpErlangString((OtpErlangList)value);
            }
            catch (OtpErlangException e) {
                throw new ClassCastException("com.ericsson.otp.erlang.OtpErlangList cannot be cast to com.ericsson.otp.erlang.OtpErlangString: " + e.getMessage());
            }
        }
        if (value instanceof OtpErlangAtom) {
            return new OtpErlangString(((OtpErlangAtom)value).atomValue());
        }
        return (OtpErlangString)value;
    }

    public String stringValue() throws ClassCastException {
        return ErlangValue.otpObjectToString(this.value);
    }

    public byte[] binaryValue() throws ClassCastException {
        return ((OtpErlangBinary)this.value).binaryValue();
    }

    public Map<String, Object> jsonValue() throws ClassCastException {
        OtpErlangTuple value_tpl = (OtpErlangTuple)this.value;
        if (value_tpl.arity() == 2 && value_tpl.elementAt(0).equals((Object)CommonErlangObjects.structAtom)) {
            ErlangValueJSONToMap json_converter = new ErlangValueJSONToMap();
            return json_converter.toJava((OtpErlangList)value_tpl.elementAt(1));
        }
        throw new ClassCastException("wrong tuple arity");
    }

    public <T> T jsonValue(Class<T> c) throws ClassCastException {
        OtpErlangTuple value_tpl = (OtpErlangTuple)this.value;
        if (value_tpl.arity() == 2 && value_tpl.elementAt(0).equals((Object)CommonErlangObjects.structAtom)) {
            ErlangValueJSONToBean<T> json_converter = new ErlangValueJSONToBean<T>(c);
            return json_converter.toJava((OtpErlangList)value_tpl.elementAt(1));
        }
        throw new ClassCastException("wrong tuple arity");
    }

    public static OtpErlangList otpObjectToOtpList(OtpErlangObject value) throws ClassCastException {
        if (value instanceof OtpErlangString) {
            OtpErlangString value_string = (OtpErlangString)value;
            return new OtpErlangList(value_string.stringValue());
        }
        return (OtpErlangList)value;
    }

    public <T> List<T> listValue(ListElementConverter<T> converter) throws ClassCastException {
        OtpErlangList list = ErlangValue.otpObjectToOtpList(this.value);
        ArrayList<T> result = new ArrayList<T>(list.arity());
        for (int i = 0; i < list.arity(); ++i) {
            result.add(converter.convert(i, new ErlangValue(list.elementAt(i))));
        }
        return result;
    }

    public <T> Collection<T> listCollectionValue(Class<? extends Collection<T>> clazz, ListElementConverter<T> converter) throws ClassCastException {
        OtpErlangList list = ErlangValue.otpObjectToOtpList(this.value);
        try {
            Collection<T> result = clazz.newInstance();
            for (int i = 0; i < list.arity(); ++i) {
                result.add(converter.convert(i, new ErlangValue(list.elementAt(i))));
            }
            return result;
        }
        catch (Exception e) {
            throw new ClassCastException("Error creating collection: " + e.getMessage());
        }
    }

    public List<ErlangValue> listValue() throws ClassCastException {
        return this.listValue(new ListElementConverter<ErlangValue>(){

            @Override
            public ErlangValue convert(int i, ErlangValue v) {
                return v;
            }
        });
    }

    public Collection<ErlangValue> listCollectionValue(Class<? extends Collection<ErlangValue>> clazz) throws ClassCastException {
        return this.listCollectionValue(clazz, new ListElementConverter<ErlangValue>(){

            @Override
            public ErlangValue convert(int i, ErlangValue v) {
                return v;
            }
        });
    }

    public List<Long> longListValue() throws ClassCastException {
        return this.listValue(new ListElementConverter<Long>(){

            @Override
            public Long convert(int i, ErlangValue v) {
                return v.longValue();
            }
        });
    }

    public List<Double> doubleListValue() throws ClassCastException {
        return this.listValue(new ListElementConverter<Double>(){

            @Override
            public Double convert(int i, ErlangValue v) {
                return v.doubleValue();
            }
        });
    }

    public List<String> stringListValue() throws ClassCastException {
        return this.listValue(new StringListElementConverter());
    }

    public List<byte[]> binaryListValue() throws ClassCastException {
        return this.listValue(new ListElementConverter<byte[]>(){

            @Override
            public byte[] convert(int i, ErlangValue v) {
                return v.binaryValue();
            }
        });
    }

    public <T> List<T> jsonListValue(final Class<T> c) throws ClassCastException {
        return this.listValue(new ListElementConverter<T>(){

            @Override
            public T convert(int i, ErlangValue v) {
                return v.jsonValue(c);
            }
        });
    }

    public OtpErlangObject value() {
        return this.value;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ErlangValue)) {
            return false;
        }
        ErlangValue erlValue = (ErlangValue)obj;
        return this.value.equals((Object)erlValue.value);
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public String toString() {
        return this.value.toString();
    }

    @Override
    public int compareTo(ErlangValue o) {
        return this.value.toString().compareTo(o.toString());
    }

    public static class StringListElementConverter
    implements ListElementConverter<String> {
        @Override
        public String convert(int i, ErlangValue v) {
            return v.stringValue();
        }
    }

    public static interface ListElementConverter<T> {
        public T convert(int var1, ErlangValue var2);
    }
}

