/*
 * Decompiled with CFR 0.152.
 */
package de.zib.scalaris;

import com.ericsson.otp.erlang.OtpErlangDouble;
import com.ericsson.otp.erlang.OtpErlangList;
import com.ericsson.otp.erlang.OtpErlangLong;
import com.ericsson.otp.erlang.OtpErlangObject;
import com.ericsson.otp.erlang.OtpErlangString;
import de.zib.scalaris.operations.AddDelOnListOp;
import de.zib.scalaris.operations.AddOnNrOp;
import de.zib.scalaris.operations.CommitOp;
import de.zib.scalaris.operations.Operation;
import de.zib.scalaris.operations.ReadOp;
import de.zib.scalaris.operations.TestAndSetOp;
import de.zib.scalaris.operations.WriteOp;
import java.util.ArrayList;
import java.util.List;

public abstract class RequestList {
    protected final List<Operation> requests = new ArrayList<Operation>(5);
    private CommitOp commitOp = null;

    protected RequestList() {
    }

    protected RequestList(Operation op) {
        this.addOp(op);
    }

    protected RequestList(RequestList other) {
        this.addAll_(other);
    }

    public RequestList addOp(Operation op) throws UnsupportedOperationException {
        if (this.isCommit()) {
            throw new UnsupportedOperationException("No further request supported after a commit!");
        }
        this.requests.add(op);
        return this;
    }

    @Deprecated
    public RequestList addRead(OtpErlangString key) throws UnsupportedOperationException {
        return this.addOp(new ReadOp(key));
    }

    @Deprecated
    public RequestList addRead(String key) throws UnsupportedOperationException {
        return this.addOp(new ReadOp(key));
    }

    @Deprecated
    public RequestList addWrite(OtpErlangString key, OtpErlangObject value) throws UnsupportedOperationException {
        return this.addOp(new WriteOp(key, value));
    }

    @Deprecated
    public <T> RequestList addWrite(String key, T value) throws UnsupportedOperationException {
        return this.addOp(new WriteOp(key, value));
    }

    @Deprecated
    public RequestList addAddDelOnList(OtpErlangString key, OtpErlangList toAdd, OtpErlangList toRemove) throws UnsupportedOperationException {
        return this.addOp(new AddDelOnListOp(key, toAdd, toRemove));
    }

    @Deprecated
    public <T> RequestList addAddDelOnList(String key, List<T> toAdd, List<T> toRemove) throws UnsupportedOperationException {
        return this.addOp(new AddDelOnListOp(key, toAdd, toRemove));
    }

    @Deprecated
    public RequestList addAddOnNr(OtpErlangString key, OtpErlangLong toAdd) throws UnsupportedOperationException {
        return this.addOp(new AddOnNrOp(key, toAdd));
    }

    @Deprecated
    public RequestList addAddOnNr(OtpErlangString key, OtpErlangDouble toAdd) throws UnsupportedOperationException {
        return this.addOp(new AddOnNrOp(key, toAdd));
    }

    @Deprecated
    public <T extends Number> RequestList addAddOnNr(String key, T toAdd) throws UnsupportedOperationException {
        return this.addOp(new AddOnNrOp(key, toAdd));
    }

    @Deprecated
    public RequestList addAddOnNr(String key, Double toAdd) throws UnsupportedOperationException {
        return this.addOp(new AddOnNrOp(key, toAdd));
    }

    @Deprecated
    public RequestList addTestAndSet(OtpErlangString key, OtpErlangObject oldValue, OtpErlangObject newValue) throws UnsupportedOperationException {
        return this.addOp(new TestAndSetOp(key, oldValue, newValue));
    }

    @Deprecated
    public <OldT, NewT> RequestList addTestAndSet(String key, OldT oldValue, NewT newValue) throws UnsupportedOperationException {
        return this.addOp(new TestAndSetOp(key, oldValue, newValue));
    }

    public RequestList addCommit() throws UnsupportedOperationException {
        CommitOp op = new CommitOp();
        this.addOp(op);
        this.commitOp = op;
        return this;
    }

    OtpErlangList getErlangReqList(boolean compressed) {
        OtpErlangObject[] result = new OtpErlangObject[this.requests.size()];
        int i = 0;
        for (Operation op : this.requests) {
            result[i++] = op.getErlang(compressed);
        }
        return new OtpErlangList(result);
    }

    public boolean isCommit() {
        return this.commitOp != null;
    }

    public CommitOp getCommit() {
        return this.commitOp;
    }

    public boolean isEmpty() {
        return this.requests.isEmpty();
    }

    public int size() {
        return this.requests.size();
    }

    protected RequestList addAll_(RequestList other) {
        this.requests.addAll(other.requests);
        return this;
    }

    public List<Operation> getRequests() {
        return this.requests;
    }

    public String toString() {
        return this.requests.toString();
    }
}

