/*
 * Decompiled with CFR 0.152.
 */
package de.zib.scalaris;

import de.zib.scalaris.ConnectionException;
import de.zib.scalaris.ConnectionFactory;
import de.zib.scalaris.ConnectionPool;
import de.zib.scalaris.LeastFailedNodesComparator;
import de.zib.scalaris.PeerNode;
import de.zib.scalaris.ScalarisVM;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class NodeDiscovery
implements Runnable {
    protected final ConnectionFactory cf;
    protected final ConnectionPool cPool;
    protected int maxNodes = 10;
    protected int minAgeToRemove = 60;

    public NodeDiscovery(ConnectionFactory cf) {
        this.cf = cf;
        this.cPool = null;
    }

    public NodeDiscovery(ConnectionPool cPool) {
        this.cf = cPool.getConnectionFactory();
        this.cPool = cPool;
    }

    public void startWithFixedDelay(long delay) {
        this.startWithFixedDelay(0L, delay, TimeUnit.SECONDS);
    }

    public void startWithFixedDelay(long initialDelay, long delay, TimeUnit unit) {
        ScheduledExecutorService ses = Executors.newScheduledThreadPool(1);
        ses.scheduleWithFixedDelay(this, initialDelay, delay, unit);
    }

    @Override
    public void run() {
        try {
            ScalarisVM vm = new ScalarisVM(this.cf.getConnectionPolicy().selectNode());
            List<String> otherVms = vm.getOtherVMs(this.maxNodes);
            List<PeerNode> existingNodes = this.cf.getNodes();
            HashMap<String, PeerNode> existingNodesMap = new HashMap<String, PeerNode>(existingNodes.size());
            for (PeerNode node : existingNodes) {
                existingNodesMap.put(node.toString(), node);
            }
            Iterator<String> iterator = otherVms.iterator();
            while (iterator.hasNext()) {
                String otherVm = iterator.next();
                if (!existingNodesMap.containsKey(otherVm)) continue;
                iterator.remove();
            }
            if (otherVms.isEmpty()) {
                return;
            }
            int remainingNodes = this.removeFailedNodes(existingNodes, otherVms);
            this.addNewNodes(existingNodes, otherVms, remainingNodes);
            if (this.cPool != null) {
                this.cPool.closeAllBut(new HashSet<PeerNode>(existingNodes));
            }
        }
        catch (ConnectionException e) {
            e.printStackTrace();
        }
    }

    protected int removeFailedNodes(List<PeerNode> existingNodes, List<String> otherVms) {
        PeerNode node;
        int lastNodeIdx;
        Collections.sort(existingNodes, new LeastFailedNodesComparator());
        int existingNodesCount = existingNodes.size();
        int failedNodesToRemove = otherVms.size() > this.maxNodes ? existingNodesCount : (existingNodesCount + otherVms.size() <= this.maxNodes ? 0 : existingNodesCount + otherVms.size() - this.maxNodes);
        assert (failedNodesToRemove >= 0);
        assert (failedNodesToRemove <= existingNodesCount);
        for (lastNodeIdx = existingNodesCount - 1; lastNodeIdx >= existingNodesCount - failedNodesToRemove && ((node = existingNodes.get(lastNodeIdx)).getFailureCount() > 0 || node.getLastConnectSuccess() == null || node.getLastConnectSuccess().getTime() < System.currentTimeMillis() - (long)(this.minAgeToRemove * 1000)); --lastNodeIdx) {
            this.cf.removeNode(node);
            existingNodes.remove(lastNodeIdx);
        }
        return lastNodeIdx + 1;
    }

    protected void addNewNodes(List<PeerNode> existingNodes, List<String> otherVms, int remainingNodes) {
        for (int i = 0; i < this.maxNodes - remainingNodes && i < otherVms.size(); ++i) {
            PeerNode p = new PeerNode(otherVms.get(i));
            this.cf.addNode(p);
            existingNodes.add(p);
        }
    }

    public final int getMaxNodes() {
        return this.maxNodes;
    }

    public final void setMaxNodes(int maxNodes) {
        this.maxNodes = maxNodes;
    }

    public final int getMinAgeToRemove() {
        return this.minAgeToRemove;
    }

    public final void setMinAgeToRemove(int minAgeToRemove) {
        this.minAgeToRemove = minAgeToRemove;
    }

    public final ConnectionFactory getCf() {
        return this.cf;
    }

    public static interface NewNodeHandler {
        public void newNodeFound(String var1);
    }
}

