/*
 * Decompiled with CFR 0.152.
 */
package de.zib.scalaris;

import com.ericsson.otp.erlang.OtpAuthException;
import de.zib.scalaris.ConnectionPolicy;
import de.zib.scalaris.LeastRecentlyFailedNodesComparator;
import de.zib.scalaris.PeerNode;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.SortedSet;
import java.util.TreeSet;

public class DefaultConnectionPolicy
extends ConnectionPolicy {
    protected List<PeerNode> goodNodes = new ArrayList<PeerNode>();
    protected SortedSet<PeerNode> badNodes = new TreeSet<PeerNode>(new LeastRecentlyFailedNodesComparator());
    private final Random random = new Random();
    private int maxRetries = 3;

    public DefaultConnectionPolicy(PeerNode remoteNode) {
        super(remoteNode);
        this.availableNodeAdded(remoteNode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DefaultConnectionPolicy(List<PeerNode> availableRemoteNodes) {
        super(availableRemoteNodes);
        List<PeerNode> list = availableRemoteNodes;
        synchronized (list) {
            for (PeerNode remoteNode : availableRemoteNodes) {
                this.availableNodeAdded(remoteNode);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void availableNodeAdded(PeerNode newNode) {
        PeerNode peerNode = newNode;
        synchronized (peerNode) {
            if (newNode.getFailureCount() == 0) {
                this.goodNodes.add(newNode);
            } else {
                this.badNodes.add(newNode);
            }
        }
    }

    @Override
    public synchronized void availableNodeRemoved(PeerNode removedNode) {
        this.goodNodes.remove(removedNode);
        this.badNodes.remove(removedNode);
    }

    @Override
    public synchronized void availableNodesReset() {
        this.goodNodes.clear();
        this.badNodes.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void nodeFailed(PeerNode node) {
        PeerNode peerNode = node;
        synchronized (peerNode) {
            this.badNodes.remove(node);
            node.setLastFailedConnect();
            if (node.getFailureCount() == 1) {
                this.goodNodes.remove(node);
            }
            this.badNodes.add(node);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void nodeFailReset(PeerNode node) {
        PeerNode peerNode = node;
        synchronized (peerNode) {
            if (node.getFailureCount() > 0) {
                this.badNodes.remove(node);
                node.resetFailureCount();
                this.goodNodes.add(node);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void nodeConnectSuccess(PeerNode node) {
        PeerNode peerNode = node;
        synchronized (peerNode) {
            node.setLastConnectSuccess();
            if (node.getFailureCount() > 0) {
                this.badNodes.remove(node);
                node.resetFailureCount();
                this.goodNodes.add(node);
            }
        }
    }

    protected synchronized PeerNode getGoodNode() {
        if (this.goodNodes.size() == 1) {
            return this.goodNodes.get(0);
        }
        return this.goodNodes.get(this.random.nextInt(this.goodNodes.size()));
    }

    @Override
    public synchronized <E extends Exception> PeerNode selectNode(int retry, PeerNode failedNode, E e) throws E {
        assert (this.maxRetries >= 0);
        if (retry <= this.maxRetries) {
            if (this.goodNodes.size() + this.badNodes.size() < 1) {
                throw new UnsupportedOperationException("Can not choose a node from an empty list.");
            }
            if (this.goodNodes.size() > 0) {
                return this.getGoodNode();
            }
            return this.badNodes.first();
        }
        String newMessage = e.getMessage() + ", bad nodes: " + this.badNodes.toString() + ", good nodes: " + this.goodNodes.toString() + ", retries: " + (retry - 1);
        if (e instanceof OtpAuthException) {
            OtpAuthException e1 = new OtpAuthException(newMessage);
            e1.setStackTrace(e.getStackTrace());
            throw e1;
        }
        if (e instanceof IOException) {
            IOException e1 = new IOException(newMessage);
            e1.setStackTrace(e.getStackTrace());
            throw e1;
        }
        throw e;
    }

    public int getMaxRetries() {
        return this.maxRetries;
    }

    public void setMaxRetries(int maxRetries) {
        if (maxRetries < 0) {
            throw new IllegalArgumentException("maxRetries must be >= 0");
        }
        this.maxRetries = maxRetries;
    }

    public synchronized List<PeerNode> getGoodNodes() {
        return new ArrayList<PeerNode>(this.goodNodes);
    }

    public synchronized List<PeerNode> getBadNodes() {
        ArrayList<PeerNode> result = new ArrayList<PeerNode>(this.badNodes.size());
        for (PeerNode p : this.badNodes) {
            result.add(p);
        }
        return result;
    }
}

