/*
 * Decompiled with CFR 0.152.
 */
package de.zib.scalaris;

import de.zib.scalaris.PeerNode;
import java.util.ArrayList;
import java.util.List;

public abstract class ConnectionPolicy {
    protected List<PeerNode> availableRemoteNodes;

    public ConnectionPolicy(PeerNode remoteNode) {
        this.availableRemoteNodes = new ArrayList<PeerNode>(1);
        this.availableRemoteNodes.add(remoteNode);
    }

    public ConnectionPolicy(List<PeerNode> availableRemoteNodes) {
        this.availableRemoteNodes = availableRemoteNodes;
    }

    public void availableNodeAdded(PeerNode newNode) {
    }

    public void availableNodeRemoved(PeerNode removedNode) {
    }

    public void availableNodesReset() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void nodeFailed(PeerNode node) {
        PeerNode peerNode = node;
        synchronized (peerNode) {
            node.setLastFailedConnect();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void nodeFailReset(PeerNode node) {
        PeerNode peerNode = node;
        synchronized (peerNode) {
            node.resetFailureCount();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void nodeConnectSuccess(PeerNode node) {
        PeerNode peerNode = node;
        synchronized (peerNode) {
            node.resetFailureCount();
            node.setLastConnectSuccess();
        }
    }

    public PeerNode selectNode() throws UnsupportedOperationException {
        try {
            return this.selectNode(0, null, null);
        }
        catch (UnsupportedOperationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new InternalError();
        }
    }

    public abstract <E extends Exception> PeerNode selectNode(int var1, PeerNode var2, E var3) throws E, UnsupportedOperationException;
}

