/*
 * Decompiled with CFR 0.152.
 */
package de.zib.scalaris;

import com.ericsson.otp.erlang.OtpErlangAtom;
import com.ericsson.otp.erlang.OtpErlangBinary;
import com.ericsson.otp.erlang.OtpErlangBoolean;
import com.ericsson.otp.erlang.OtpErlangDecodeException;
import com.ericsson.otp.erlang.OtpErlangDouble;
import com.ericsson.otp.erlang.OtpErlangLong;
import com.ericsson.otp.erlang.OtpErlangObject;
import com.ericsson.otp.erlang.OtpErlangTuple;
import com.ericsson.otp.erlang.OtpInputStream;
import com.ericsson.otp.erlang.OtpOutputStream;
import de.zib.scalaris.AbortException;
import de.zib.scalaris.ErlangValue;
import de.zib.scalaris.UnknownException;
import java.io.IOException;
import java.util.List;

public final class CommonErlangObjects {
    public static final OtpErlangAtom readAtom = new OtpErlangAtom("read");
    public static final OtpErlangAtom writeAtom = new OtpErlangAtom("write");
    public static final OtpErlangAtom addDelOnListAtom = new OtpErlangAtom("add_del_on_list");
    public static final OtpErlangAtom testAndSetAtom = new OtpErlangAtom("test_and_set");
    public static final OtpErlangAtom addOnNrAtom = new OtpErlangAtom("add_on_nr");
    public static final OtpErlangAtom okAtom = new OtpErlangAtom("ok");
    public static final OtpErlangAtom failAtom = new OtpErlangAtom("fail");
    public static final OtpErlangAtom abortAtom = new OtpErlangAtom("abort");
    public static final OtpErlangAtom timeoutAtom = new OtpErlangAtom("timeout");
    public static final OtpErlangAtom notFoundAtom = new OtpErlangAtom("not_found");
    public static final OtpErlangAtom keyChangedAtom = new OtpErlangAtom("key_changed");
    public static final OtpErlangAtom notAListAtom = new OtpErlangAtom("not_a_list");
    public static final OtpErlangAtom notANumberAtom = new OtpErlangAtom("not_a_number");
    public static final OtpErlangAtom emptyListAtom = new OtpErlangAtom("empty_list");
    public static final OtpErlangTuple okTupleAtom = new OtpErlangTuple((OtpErlangObject)okAtom);
    public static final OtpErlangTuple commitTupleAtom = new OtpErlangTuple((OtpErlangObject)new OtpErlangAtom("commit"));
    public static final OtpErlangAtom sublistAtom = new OtpErlangAtom("sublist");
    public static final OtpErlangAtom randomFromListAtom = new OtpErlangAtom("random_from_list");
    public static final OtpErlangAtom structAtom = new OtpErlangAtom("struct");
    public static final OtpErlangAtom arrayAtom = new OtpErlangAtom("array");
    public static final OtpErlangAtom trueAtom = new OtpErlangAtom("true");
    public static final OtpErlangAtom falseAtom = new OtpErlangAtom("false");
    public static final OtpErlangAtom nullAtom = new OtpErlangAtom("null");

    public static OtpErlangObject encode(OtpErlangObject value) {
        if (value instanceof OtpErlangAtom) {
            return value;
        }
        if (value instanceof OtpErlangBoolean) {
            return value;
        }
        if (value instanceof OtpErlangLong) {
            return value;
        }
        if (value instanceof OtpErlangDouble) {
            return value;
        }
        if (value instanceof OtpErlangBinary) {
            OtpOutputStream oos = new OtpOutputStream();
            oos.write1(131L);
            oos.write_any(value);
            byte[] encoded = oos.toByteArray();
            OtpErlangBinary result = new OtpErlangBinary(encoded);
            try {
                oos.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return result;
        }
        OtpOutputStream oos = new OtpOutputStream();
        oos.write1(131L);
        oos.write_compressed(value);
        byte[] encoded = oos.toByteArray();
        OtpErlangBinary result = new OtpErlangBinary(encoded);
        try {
            oos.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static OtpErlangObject decode(OtpErlangObject value) throws OtpErlangDecodeException {
        if (value instanceof OtpErlangBinary) {
            OtpErlangBinary valueBin = (OtpErlangBinary)value;
            OtpInputStream ois = new OtpInputStream(valueBin.binaryValue());
            try {
                OtpErlangObject otpErlangObject = ois.read_any();
                return otpErlangObject;
            }
            finally {
                try {
                    ois.close();
                }
                catch (IOException iOException) {}
            }
        }
        return value;
    }

    public static final void checkResult_failAbort(OtpErlangObject received_raw, boolean compressed) throws AbortException, UnknownException {
        try {
            OtpErlangTuple received = (OtpErlangTuple)received_raw;
            CommonErlangObjects.checkResult_failAbort(received, compressed);
        }
        catch (ClassCastException e) {
            throw new UnknownException(e, received_raw);
        }
    }

    public static final void checkResult_failAbort(OtpErlangTuple received, boolean compressed) throws AbortException, UnknownException {
        try {
            if (received.elementAt(0).equals((Object)failAtom) && received.arity() == 3 && received.elementAt(1).equals((Object)abortAtom)) {
                List<String> responsibleKeys = new ErlangValue(received.elementAt(2)).stringListValue();
                throw new AbortException(responsibleKeys);
            }
        }
        catch (ClassCastException e) {
            throw new UnknownException(e, (OtpErlangObject)received);
        }
    }
}

