/*
 * Decompiled with CFR 0.152.
 */
package de.zib.scalaris.executor;

import com.ericsson.otp.erlang.OtpErlangException;
import de.zib.scalaris.RequestList;
import de.zib.scalaris.ResultList;
import de.zib.scalaris.UnknownException;
import de.zib.scalaris.executor.ScalarisOp;
import de.zib.scalaris.operations.AddOnNrOp;

public class ScalarisIncrementOp2<T extends Number>
implements ScalarisOp {
    protected final String key;
    protected final T value;

    public ScalarisIncrementOp2(String key, T value) {
        this.key = key;
        this.value = value;
    }

    @Override
    public int workPhases() {
        return 1;
    }

    @Override
    public final int doPhase(int phase, int firstOp, ResultList results, RequestList requests) throws OtpErlangException, UnknownException, IllegalArgumentException {
        switch (phase) {
            case 0: {
                return this.prepareIncrement(requests);
            }
            case 1: {
                return this.checkIncrement(firstOp, results);
            }
        }
        throw new IllegalArgumentException("No phase " + phase);
    }

    protected int prepareIncrement(RequestList requests) throws OtpErlangException, UnknownException {
        requests.addOp(new AddOnNrOp(this.key, this.value));
        return 0;
    }

    protected int checkIncrement(int firstOp, ResultList results) throws OtpErlangException, UnknownException {
        assert (results != null);
        results.processAddOnNrAt(firstOp);
        return 1;
    }

    @Override
    public String toString() {
        return "Scalaris.increment(" + this.key + ", " + this.value + ")";
    }

    public String getKey() {
        return this.key;
    }

    public T getIncValue() {
        return this.value;
    }
}

