/*
 * Decompiled with CFR 0.152.
 */
package de.zib.scalaris;

import com.ericsson.otp.erlang.OtpErlangDouble;
import com.ericsson.otp.erlang.OtpErlangList;
import com.ericsson.otp.erlang.OtpErlangLong;
import com.ericsson.otp.erlang.OtpErlangObject;
import com.ericsson.otp.erlang.OtpErlangString;
import com.ericsson.otp.erlang.OtpErlangTuple;
import de.zib.scalaris.AbortException;
import de.zib.scalaris.AbstractTransaction;
import de.zib.scalaris.Connection;
import de.zib.scalaris.ConnectionException;
import de.zib.scalaris.ErlangValue;
import de.zib.scalaris.KeyChangedException;
import de.zib.scalaris.NotAListException;
import de.zib.scalaris.NotANumberException;
import de.zib.scalaris.NotFoundException;
import de.zib.scalaris.UnknownException;
import de.zib.scalaris.operations.AddDelOnListOp;
import de.zib.scalaris.operations.AddOnNrOp;
import de.zib.scalaris.operations.CommitOp;
import de.zib.scalaris.operations.Operation;
import de.zib.scalaris.operations.TestAndSetOp;
import de.zib.scalaris.operations.TransactionOperation;
import de.zib.scalaris.operations.WriteOp;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;

public class Transaction
extends AbstractTransaction<RequestList, ResultList> {
    protected final Translog transLog = this.getTranslogImpl();

    protected Translog getTranslogImpl() {
        return new FilteringTransLog();
    }

    public Transaction() throws ConnectionException {
    }

    public Transaction(Connection conn) {
        super(conn);
    }

    @Override
    public ResultList req_list(TransactionOperation op) throws ConnectionException, AbortException, UnknownException {
        return (ResultList)super.req_list(op);
    }

    @Override
    public ResultList req_list(RequestList req) throws ConnectionException, AbortException, UnknownException {
        if (req.isEmpty()) {
            return new ResultList(new OtpErlangList(), this.compressed, req);
        }
        OtpErlangObject received_raw = null;
        OtpErlangList erlangReqList = req.getErlangReqList(this.compressed);
        received_raw = this.transLog.isEmpty() ? this.connection.doRPC(this.module(), "req_list", new OtpErlangObject[]{erlangReqList}) : this.connection.doRPC(this.module(), "req_list", new OtpErlangObject[]{this.transLog.filter(req), erlangReqList});
        try {
            OtpErlangTuple received = (OtpErlangTuple)received_raw;
            this.transLog.merge(received.elementAt(0));
            if (received.arity() == 2) {
                ResultList result = new ResultList((OtpErlangList)received.elementAt(1), this.compressed, req);
                if (req.isCommit()) {
                    req.getCommit().processResult();
                    this.transLog.reset();
                }
                return result;
            }
            throw new UnknownException(received_raw);
        }
        catch (ClassCastException e) {
            throw new UnknownException(e, received_raw);
        }
    }

    public void commit() throws ConnectionException, AbortException, UnknownException {
        this.req_list((RequestList)new RequestList().addCommit());
    }

    public void abort() {
        this.transLog.reset();
    }

    @Override
    protected RequestList newReqList() {
        return new RequestList();
    }

    @Override
    public void write(OtpErlangString key, OtpErlangObject value) throws ConnectionException, UnknownException {
        try {
            super.write(key, value);
        }
        catch (AbortException e) {
            throw new UnknownException((Throwable)((Object)e));
        }
    }

    @Override
    public <T> void write(String key, T value) throws ConnectionException, UnknownException {
        try {
            super.write(key, value);
        }
        catch (AbortException e) {
            throw new UnknownException((Throwable)((Object)e));
        }
    }

    @Override
    public void addDelOnList(OtpErlangString key, OtpErlangList toAdd, OtpErlangList toRemove) throws ConnectionException, NotAListException, UnknownException {
        try {
            super.addDelOnList(key, toAdd, toRemove);
        }
        catch (AbortException e) {
            throw new UnknownException((Throwable)((Object)e));
        }
    }

    @Override
    public <T> void addDelOnList(String key, List<T> toAdd, List<T> toRemove) throws ConnectionException, NotAListException, UnknownException {
        try {
            super.addDelOnList(key, toAdd, toRemove);
        }
        catch (AbortException e) {
            throw new UnknownException((Throwable)((Object)e));
        }
    }

    @Override
    public void addOnNr(OtpErlangString key, OtpErlangLong toAdd) throws ConnectionException, NotANumberException, UnknownException {
        try {
            super.addOnNr(key, toAdd);
        }
        catch (AbortException e) {
            throw new UnknownException((Throwable)((Object)e));
        }
    }

    @Override
    public void addOnNr(OtpErlangString key, OtpErlangDouble toAdd) throws ConnectionException, NotANumberException, UnknownException {
        try {
            super.addOnNr(key, toAdd);
        }
        catch (AbortException e) {
            throw new UnknownException((Throwable)((Object)e));
        }
    }

    @Override
    public <T> void addOnNr(String key, T toAdd) throws ConnectionException, NotANumberException, UnknownException {
        try {
            super.addOnNr(key, toAdd);
        }
        catch (AbortException e) {
            throw new UnknownException((Throwable)((Object)e));
        }
    }

    @Override
    public void testAndSet(OtpErlangString key, OtpErlangObject oldValue, OtpErlangObject newValue) throws ConnectionException, NotFoundException, KeyChangedException, UnknownException {
        try {
            super.testAndSet(key, oldValue, newValue);
        }
        catch (AbortException e) {
            throw new UnknownException((Throwable)((Object)e));
        }
    }

    @Override
    public <OldT, NewT> void testAndSet(String key, OldT oldValue, NewT newValue) throws ConnectionException, NotFoundException, KeyChangedException, UnknownException {
        try {
            super.testAndSet(key, oldValue, newValue);
        }
        catch (AbortException e) {
            throw new UnknownException((Throwable)((Object)e));
        }
    }

    protected static class FilteringTransLog
    implements Translog {
        protected LinkedHashMap<OtpErlangString, OtpErlangTuple> entries = new LinkedHashMap();

        protected FilteringTransLog() {
        }

        @Override
        public Translog merge(OtpErlangObject newTLog) {
            try {
                OtpErlangList newTLogL = (OtpErlangList)newTLog;
                for (int i = 0; i < newTLogL.arity(); ++i) {
                    OtpErlangTuple entry = (OtpErlangTuple)newTLogL.elementAt(i);
                    OtpErlangString key = ErlangValue.otpObjectToOtpString(entry.elementAt(1));
                    this.entries.put(key, entry);
                }
            }
            catch (ClassCastException e) {
                throw new UnknownException(newTLog);
            }
            return this;
        }

        @Override
        public boolean isEmpty() {
            return this.entries.isEmpty();
        }

        @Override
        public void reset() {
            this.entries.clear();
        }

        @Override
        public OtpErlangObject filter(RequestList req) {
            OtpErlangList result;
            if (req.isCommit()) {
                result = new OtpErlangList((OtpErlangObject[])this.entries.values().toArray(new OtpErlangTuple[0]));
            } else {
                HashSet<OtpErlangTuple> resultJ = new HashSet<OtpErlangTuple>(req.size());
                for (Operation op : req.getRequests()) {
                    OtpErlangTuple entry = this.entries.get(op.getKey());
                    if (entry == null) continue;
                    resultJ.add(entry);
                }
                result = new OtpErlangList((OtpErlangObject[])resultJ.toArray(new OtpErlangTuple[0]));
            }
            return result;
        }
    }

    protected static class FullTransLog
    implements Translog {
        protected OtpErlangObject tlog = null;

        protected FullTransLog() {
        }

        @Override
        public Translog merge(OtpErlangObject newTLog) {
            this.tlog = newTLog;
            return this;
        }

        @Override
        public boolean isEmpty() {
            return this.tlog == null;
        }

        @Override
        public void reset() {
            this.tlog = null;
        }

        @Override
        public OtpErlangObject filter(RequestList req) {
            return this.tlog;
        }
    }

    protected static interface Translog {
        public Translog merge(OtpErlangObject var1);

        public boolean isEmpty();

        public void reset();

        public OtpErlangObject filter(RequestList var1);
    }

    public static class ResultList
    extends de.zib.scalaris.ResultList {
        ResultList(OtpErlangList results, boolean compressed, RequestList requests) {
            super(results, compressed, requests);
        }

        @Override
        public void processWriteAt(int pos) throws UnknownException {
            ((WriteOp)this.get(pos)).processResult();
        }

        @Override
        public void processAddDelOnListAt(int pos) throws NotAListException, UnknownException {
            ((AddDelOnListOp)this.get(pos)).processResult();
        }

        @Override
        public void processAddOnNrAt(int pos) throws NotANumberException, UnknownException {
            ((AddOnNrOp)this.get(pos)).processResult();
        }

        @Override
        public void processTestAndSetAt(int pos) throws NotFoundException, KeyChangedException, UnknownException {
            ((TestAndSetOp)this.get(pos)).processResult();
        }

        public void processCommitAt(int pos) throws AbortException, UnknownException {
            ((CommitOp)this.get(pos)).processResult();
        }
    }

    public static class RequestList
    extends de.zib.scalaris.RequestList {
        public RequestList() {
        }

        protected RequestList(TransactionOperation op) {
            super(op);
        }

        public RequestList(RequestList other) {
            super(other);
        }

        @Override
        public RequestList addOp(Operation op) throws UnsupportedOperationException {
            if (!(op instanceof TransactionOperation)) {
                throw new UnsupportedOperationException();
            }
            return (RequestList)super.addOp(op);
        }

        public RequestList addAll(RequestList other) {
            return (RequestList)super.addAll_(other);
        }
    }
}

