/*
 * Decompiled with CFR 0.152.
 */
package de.zib.scalaris;

import com.ericsson.otp.erlang.OtpErlangAtom;
import com.ericsson.otp.erlang.OtpErlangList;
import com.ericsson.otp.erlang.OtpErlangObject;
import com.ericsson.otp.erlang.OtpErlangString;
import com.ericsson.otp.erlang.OtpErlangTuple;
import de.zib.scalaris.CommonErlangObjects;
import de.zib.scalaris.ErlangValue;
import de.zib.scalaris.ErlangValueJSONBase;
import de.zib.scalaris.ErlangValueJSONInterface;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

class ErlangValueJSONToBean<T>
extends ErlangValueJSONBase
implements ErlangValueJSONInterface<T> {
    private final Class<T> c;
    private final Pattern getMatcher = Pattern.compile("^get|is");

    public ErlangValueJSONToBean(Class<T> c) {
        this.c = c;
    }

    public static <U> ErlangValueJSONToBean<U> getInstance(Class<U> c) {
        return new ErlangValueJSONToBean<U>(c);
    }

    public static ErlangValueJSONToBean<?> getInstance(Type t) {
        ErlangValueJSONToBean<?> json_converter = ErlangValueJSONToBean.getInstance(ErlangValueJSONToBean.getRawType(t));
        return json_converter;
    }

    @Override
    public OtpErlangTuple toScalarisJSON(T value) throws ClassCastException {
        return this.convertJavaToScalarisJSON_object2(value);
    }

    @Override
    public T toJava(OtpErlangList value) throws ClassCastException {
        return (T)this.convertScalarisJSONtoJava_object2(value, null);
    }

    private static String capFirst(String key) {
        if (key.length() > 0) {
            String keyCap = key.substring(0, 1).toUpperCase() + key.substring(1);
            return keyCap;
        }
        return "";
    }

    private static String decapFirst(String key) {
        if (key.length() > 0) {
            String keyCap = key.substring(0, 1).toLowerCase() + key.substring(1);
            return keyCap;
        }
        return "";
    }

    private static Class<?> getRawType(Type type) {
        if (type instanceof ParameterizedType) {
            return (Class)((ParameterizedType)type).getRawType();
        }
        return (Class)type;
    }

    private Method getSetterFor(String key, Type type) {
        String keyCap1st = ErlangValueJSONToBean.capFirst(key);
        String setMethod = "set" + keyCap1st;
        Class<?> class_ = ErlangValueJSONToBean.getRawType(type);
        try {
            return this.c.getMethod(setMethod, class_);
        }
        catch (Exception e) {
            throw new ClassCastException("no setter " + setMethod + "(" + class_.getSimpleName() + "): " + e.getMessage());
        }
    }

    private Type getTypeOf(String key) throws ClassCastException {
        String keyCap1st = ErlangValueJSONToBean.capFirst(key);
        try {
            try {
                return this.c.getMethod("get" + keyCap1st, new Class[0]).getGenericReturnType();
            }
            catch (NoSuchMethodException e) {
                return this.c.getMethod("is" + keyCap1st, new Class[0]).getGenericReturnType();
            }
        }
        catch (Exception e) {
            throw new ClassCastException("no getter [get|is]" + keyCap1st + ": " + e.getMessage());
        }
    }

    @Override
    protected OtpErlangTuple convertJavaToScalarisJSON_object(Object value) throws ClassCastException {
        ErlangValueJSONToBean<?> json_converter = ErlangValueJSONToBean.getInstance(value.getClass());
        return json_converter.convertJavaToScalarisJSON_object2(value);
    }

    protected OtpErlangTuple convertJavaToScalarisJSON_object2(Object value_) throws ClassCastException {
        try {
            if (value_ instanceof Map) {
                Map value = (Map)value_;
                OtpErlangTuple[] resultList = new OtpErlangTuple[value.size()];
                int i = 0;
                for (Map.Entry entry : value.entrySet()) {
                    resultList[i] = new OtpErlangTuple(new OtpErlangObject[]{new OtpErlangString((String)entry.getKey()), this.convertJavaToScalarisJSON_value(entry.getValue())});
                    ++i;
                }
                OtpErlangTuple resultTpl = new OtpErlangTuple(new OtpErlangObject[]{CommonErlangObjects.structAtom, new OtpErlangList((OtpErlangObject[])resultList)});
                return resultTpl;
            }
            Object value = value_;
            Method[] methods = this.c.getDeclaredMethods();
            LinkedList<OtpErlangTuple> resultList = new LinkedList<OtpErlangTuple>();
            for (int j = 0; j < methods.length; ++j) {
                String methodName = methods[j].getName();
                if (!this.getMatcher.matcher(methodName).lookingAt()) continue;
                String key_j = ErlangValueJSONToBean.decapFirst(this.getMatcher.matcher(methodName).replaceFirst(""));
                try {
                    OtpErlangObject value_j = this.convertJavaToScalarisJSON_value(methods[j].invoke(value, new Object[0]));
                    resultList.add(new OtpErlangTuple(new OtpErlangObject[]{new OtpErlangString(key_j), value_j}));
                    continue;
                }
                catch (IllegalArgumentException e) {
                    e.printStackTrace();
                    throw new ClassCastException("cannot access getter " + methodName + "() of class " + this.c.getSimpleName() + ": " + e.getMessage());
                }
                catch (IllegalAccessException e) {
                    throw new ClassCastException("cannot access getter " + methodName + "() of class " + this.c.getSimpleName() + ": " + e.getMessage());
                }
                catch (InvocationTargetException e) {
                    throw new ClassCastException("cannot access getter " + methodName + "() of class " + this.c.getSimpleName() + ": " + e.getMessage());
                }
            }
            OtpErlangTuple resultTpl = new OtpErlangTuple(new OtpErlangObject[]{CommonErlangObjects.structAtom, new OtpErlangList(resultList.toArray(new OtpErlangObject[0]))});
            return resultTpl;
        }
        catch (ClassCastException e) {
            e.printStackTrace();
            throw new ClassCastException("Unsupported JSON type (value: " + value_ + ")");
        }
    }

    protected Object convertScalarisJSONtoJava_object2(OtpErlangList value, Type type_) throws ClassCastException {
        T result;
        if (this.c.equals(Map.class) || Arrays.asList(this.c.getInterfaces()).contains(Map.class)) {
            ParameterizedType type;
            Type[] typeArguments;
            Object elementType = Object.class;
            if (type_ != null && type_ instanceof ParameterizedType && (typeArguments = (type = (ParameterizedType)type_).getActualTypeArguments()).length == 2) {
                elementType = typeArguments[1];
            }
            LinkedHashMap<String, Object> result2 = new LinkedHashMap<String, Object>(value.arity());
            for (OtpErlangObject iter : value) {
                OtpErlangTuple iter_tpl = (OtpErlangTuple)iter;
                if (iter_tpl.arity() == 2) {
                    String key = this.convertScalarisJSONtoJava_key(iter_tpl.elementAt(0));
                    result2.put(key, this.convertScalarisJSONtoJava_value2(iter_tpl.elementAt(1), (Type)elementType));
                    continue;
                }
                throw new ClassCastException("Unsupported JSON type (value: " + value.toString() + ")");
            }
            return result2;
        }
        try {
            result = this.c.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new ClassCastException("Cannot store value to JSON object (value: " + value.toString() + "): " + e.getMessage());
        }
        for (OtpErlangObject iter : value) {
            OtpErlangTuple iter_tpl = (OtpErlangTuple)iter;
            if (iter_tpl.arity() == 2) {
                String key;
                OtpErlangObject key_erl = iter_tpl.elementAt(0);
                if (key_erl instanceof OtpErlangAtom) {
                    key = ((OtpErlangAtom)key_erl).atomValue();
                } else {
                    try {
                        key = ErlangValue.otpObjectToString(key_erl);
                    }
                    catch (ClassCastException e) {
                        throw new ClassCastException("Unsupported JSON type (value: " + value.toString() + ")");
                    }
                }
                Type elementType = this.getTypeOf(key);
                Method setter = this.getSetterFor(key, elementType);
                Object myValue = this.convertScalarisJSONtoJava_value2(iter_tpl.elementAt(1), elementType);
                try {
                    setter.invoke(result, myValue);
                    continue;
                }
                catch (Exception e) {
                    throw new ClassCastException("Cannot store value to JSON object (key: " + key + ", value: " + myValue + ", complete object: " + value.toString() + "): " + e.getMessage());
                }
            }
            throw new ClassCastException("Unsupported JSON type (value: " + value.toString() + ")");
        }
        return result;
    }

    protected List<Object> convertScalarisJSONtoJava_array2(OtpErlangList value, Type type_) throws ClassCastException {
        ArrayList<Object> result = new ArrayList<Object>(value.arity());
        for (OtpErlangObject iter : value) {
            if (type_ instanceof ParameterizedType) {
                ParameterizedType type = (ParameterizedType)type_;
                Type[] typeArguments = type.getActualTypeArguments();
                if (typeArguments.length != 1) continue;
                result.add(this.convertScalarisJSONtoJava_value2(iter, typeArguments[0]));
                continue;
            }
            result.add(this.convertScalarisJSONtoJava_value2(iter, (Type)((Object)Object.class)));
        }
        return result;
    }

    protected Object convertScalarisJSONtoJava_value2(OtpErlangObject value, Type type) throws ClassCastException {
        if (value instanceof OtpErlangTuple) {
            OtpErlangTuple value_tpl = (OtpErlangTuple)value;
            if (value_tpl.arity() == 2) {
                OtpErlangObject tag = value_tpl.elementAt(0);
                if (tag.equals((Object)CommonErlangObjects.structAtom)) {
                    OtpErlangList value_obj = (OtpErlangList)value_tpl.elementAt(1);
                    Object type1 = type.equals(Object.class) ? Map.class : type;
                    ErlangValueJSONToBean<?> json_converter = ErlangValueJSONToBean.getInstance((Type)type1);
                    return json_converter.convertScalarisJSONtoJava_object2(value_obj, (Type)type1);
                }
                if (tag.equals((Object)CommonErlangObjects.arrayAtom)) {
                    OtpErlangList value_list = ErlangValue.otpObjectToOtpList(value_tpl.elementAt(1));
                    return this.convertScalarisJSONtoJava_array2(value_list, type);
                }
                throw new ClassCastException("unknown JSON tag");
            }
            throw new ClassCastException("wrong tuple arity");
        }
        return super.convertScalarisJSONtoJava_value_simple(value);
    }
}

