/* libcmime - A C mime library
 * Copyright (C) 2013 SpaceNet AG and Axel Steiner <ast@treibsand.com>
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, sublicense, and/or sell copies of the Software, and to
 * permit persons to whom the Software is furnished to do so, subject to
 * the following conditions:
 *
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
 * LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
 * OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
 * WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

/*!
 * @file cmime.h
 * @brief Convenience header, which includes the rest of the CMime library. 
 *
 */

#ifndef _CMIME_H
#define _CMIME_H

#ifdef __cplusplus
extern "C" {
#endif

#include <cmime/cmime_address.h>
#include <cmime/cmime_config.h>
#include <cmime/cmime_base64.h>
#include <cmime/cmime_qp.h>
#include <cmime/cmime_header.h>
#include <cmime/cmime_list.h>
#include <cmime/cmime_message.h>
#include <cmime/cmime_part.h>
#include <cmime/cmime_string.h>
#include <cmime/cmime_util.h>

#ifdef __cplusplus
}
#endif

#endif /* _CMIME_H */
