/*
 * Decompiled with CFR 0.152.
 */
package jdk.nashorn.internal.runtime;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import jdk.nashorn.internal.lookup.Lookup;
import jdk.nashorn.internal.runtime.CompiledFunction;
import jdk.nashorn.internal.runtime.CompiledFunctions;
import jdk.nashorn.internal.runtime.ConsString;
import jdk.nashorn.internal.runtime.Context;
import jdk.nashorn.internal.runtime.DebuggerSupport;
import jdk.nashorn.internal.runtime.ECMAErrors;
import jdk.nashorn.internal.runtime.FinalScriptFunctionData;
import jdk.nashorn.internal.runtime.JSType;
import jdk.nashorn.internal.runtime.PropertyMap;
import jdk.nashorn.internal.runtime.ScriptFunction;
import jdk.nashorn.internal.runtime.ScriptObject;
import jdk.nashorn.internal.runtime.ScriptRuntime;

public abstract class ScriptFunctionData
implements Serializable {
    protected final String name;
    protected final CompiledFunctions code;
    protected int flags;
    private int arity;
    private static final MethodHandle NEWFILTER = ScriptFunctionData.findOwnMH("newFilter", Object.class, Object.class, Object.class);
    private static final MethodHandle BIND_VAR_ARGS = ScriptFunctionData.findOwnMH("bindVarArgs", Object[].class, Object[].class, Object[].class);
    public static final int IS_STRICT = 1;
    public static final int IS_BUILTIN = 2;
    public static final int IS_CONSTRUCTOR = 4;
    public static final int NEEDS_CALLEE = 8;
    public static final int USES_THIS = 16;
    public static final int IS_STRICT_OR_BUILTIN = 3;
    public static final int IS_BUILTIN_CONSTRUCTOR = 6;
    public static final int IS_STRICT_CONSTRUCTOR = 5;
    private static final long serialVersionUID = 4252901245508769114L;

    ScriptFunctionData(String name, int arity, int flags) {
        this.name = name;
        this.arity = arity;
        this.code = new CompiledFunctions();
        this.flags = flags;
    }

    final int getArity() {
        return this.arity;
    }

    void setArity(int arity) {
        this.arity = arity;
    }

    CompiledFunction bind(CompiledFunction originalInv, ScriptFunction fn, Object self, Object[] args) {
        MethodHandle boundInvoker = this.bindInvokeHandle(originalInv.getInvoker(), fn, self, args);
        if (this.isConstructor()) {
            this.ensureConstructor(originalInv);
            return new CompiledFunction(boundInvoker.type(), boundInvoker, ScriptFunctionData.bindConstructHandle(originalInv.getConstructor(), fn, args));
        }
        return new CompiledFunction(boundInvoker.type(), boundInvoker);
    }

    public boolean isStrict() {
        return (this.flags & 1) != 0;
    }

    boolean isBuiltin() {
        return (this.flags & 2) != 0;
    }

    boolean isConstructor() {
        return (this.flags & 4) != 0;
    }

    boolean needsCallee() {
        this.ensureCompiled();
        return (this.flags & 8) != 0;
    }

    boolean needsWrappedThis() {
        return (this.flags & 0x10) != 0 && (this.flags & 3) == 0;
    }

    String toSource() {
        return "function " + (this.name == null ? "" : this.name) + "() { [native code] }";
    }

    String getName() {
        return this.name;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("name='").append(this.name.isEmpty() ? "<anonymous>" : this.name).append("' ").append(this.code.size()).append(" invokers=").append(this.code);
        return sb.toString();
    }

    MethodHandle getBestInvoker(MethodType callSiteType, Object[] args) {
        return this.getBest(callSiteType).getInvoker();
    }

    MethodHandle getBestInvoker(MethodType callSiteType) {
        return this.getBestInvoker(callSiteType, null);
    }

    MethodHandle getBestConstructor(MethodType callSiteType, Object[] args) {
        if (!this.isConstructor()) {
            throw ECMAErrors.typeError("not.a.constructor", this.toSource());
        }
        this.ensureCodeGenerated();
        CompiledFunction best = this.getBest(callSiteType);
        this.ensureConstructor(best);
        return best.getConstructor();
    }

    MethodHandle getBestConstructor(MethodType callSiteType) {
        return this.getBestConstructor(callSiteType, null);
    }

    protected void ensureCodeGenerated() {
    }

    protected void ensureCompiled() {
    }

    public final MethodHandle getGenericInvoker() {
        this.ensureCodeGenerated();
        return this.code.generic().getInvoker();
    }

    final MethodHandle getGenericConstructor() {
        this.ensureCodeGenerated();
        this.ensureConstructor(this.code.generic());
        return this.code.generic().getConstructor();
    }

    private CompiledFunction getBest(MethodType callSiteType) {
        this.ensureCodeGenerated();
        return this.code.best(callSiteType);
    }

    ScriptObject allocate(PropertyMap map) {
        return null;
    }

    PropertyMap getAllocatorMap() {
        return null;
    }

    ScriptFunctionData makeBoundFunctionData(ScriptFunction fn, Object self, Object[] args) {
        this.ensureCodeGenerated();
        Object[] allArgs = args == null ? ScriptRuntime.EMPTY_ARRAY : args;
        int length = args == null ? 0 : args.length;
        int boundFlags = this.flags & 0xFFFFFFF7 & 0xFFFFFFEF;
        CompiledFunctions boundList = new CompiledFunctions();
        if (this.code.size() == 1) {
            boundList.add(this.bind((CompiledFunction)this.code.first(), fn, self, allArgs));
        } else {
            MethodHandle genInvoker = this.getGenericInvoker();
            CompiledFunction inv = new CompiledFunction(genInvoker.type(), genInvoker, this.getGenericConstructor());
            boundList.add(this.bind(inv, fn, self, allArgs));
        }
        return new FinalScriptFunctionData(this.name, this.arity == -1 ? -1 : Math.max(0, this.arity - length), boundList, boundFlags);
    }

    protected MethodHandle composeConstructor(MethodHandle ctor) {
        boolean needsCallee = ScriptFunctionData.needsCallee(ctor);
        MethodHandle composedCtor = needsCallee ? ScriptFunctionData.swapCalleeAndThis(ctor) : ctor;
        composedCtor = ScriptFunctionData.changeReturnTypeToObject(composedCtor);
        MethodType ctorType = composedCtor.type();
        Class<?>[] ctorArgs = ctorType.dropParameterTypes(0, 1).parameterArray();
        composedCtor = Lookup.MH.foldArguments(Lookup.MH.dropArguments(NEWFILTER, 2, ctorArgs), composedCtor);
        if (needsCallee) {
            return Lookup.MH.foldArguments(composedCtor, ScriptFunction.ALLOCATE);
        }
        return Lookup.MH.filterArguments(composedCtor, 0, ScriptFunction.ALLOCATE);
    }

    private static MethodHandle swapCalleeAndThis(MethodHandle mh) {
        MethodType type = mh.type();
        assert (type.parameterType(0) == ScriptFunction.class) : type;
        assert (type.parameterType(1) == Object.class) : type;
        MethodType newType = type.changeParameterType(0, Object.class).changeParameterType(1, ScriptFunction.class);
        int[] reorder = new int[type.parameterCount()];
        reorder[0] = 1;
        assert (reorder[1] == 0);
        for (int i = 2; i < reorder.length; ++i) {
            reorder[i] = i;
        }
        return MethodHandles.permuteArguments(mh, newType, reorder);
    }

    private Object convertThisObject(Object thiz) {
        if (!(thiz instanceof ScriptObject) && this.needsWrappedThis()) {
            if (JSType.nullOrUndefined(thiz)) {
                return Context.getGlobal();
            }
            if (ScriptFunctionData.isPrimitiveThis(thiz)) {
                return Context.getGlobal().wrapAsObject(thiz);
            }
        }
        return thiz;
    }

    static boolean isPrimitiveThis(Object obj) {
        return obj instanceof String || obj instanceof ConsString || obj instanceof Number || obj instanceof Boolean;
    }

    private MethodHandle bindInvokeHandle(MethodHandle originalInvoker, ScriptFunction targetFn, Object self, Object[] args) {
        MethodHandle boundInvoker;
        Object boundSelf;
        boolean isTargetBound = targetFn.isBoundFunction();
        boolean needsCallee = ScriptFunctionData.needsCallee(originalInvoker);
        assert (needsCallee == this.needsCallee()) : "callee contract violation 2";
        assert (!isTargetBound || !needsCallee);
        Object object = boundSelf = isTargetBound ? null : this.convertThisObject(self);
        if (ScriptFunctionData.isVarArg(originalInvoker)) {
            MethodHandle noArgBoundInvoker = isTargetBound ? originalInvoker : (needsCallee ? Lookup.MH.insertArguments(originalInvoker, 0, targetFn, boundSelf) : Lookup.MH.bindTo(originalInvoker, boundSelf));
            boundInvoker = args.length > 0 ? ScriptFunctionData.varArgBinder(noArgBoundInvoker, args) : noArgBoundInvoker;
        } else {
            int argInsertPos = isTargetBound ? 1 : 0;
            Object[] boundArgs = new Object[Math.min(originalInvoker.type().parameterCount() - argInsertPos, args.length + (isTargetBound ? 0 : (needsCallee ? 2 : 1)))];
            int next = 0;
            if (!isTargetBound) {
                if (needsCallee) {
                    boundArgs[next++] = targetFn;
                }
                boundArgs[next++] = boundSelf;
            }
            System.arraycopy(args, 0, boundArgs, next, boundArgs.length - next);
            boundInvoker = Lookup.MH.insertArguments(originalInvoker, argInsertPos, boundArgs);
        }
        if (isTargetBound) {
            return boundInvoker;
        }
        return Lookup.MH.dropArguments(boundInvoker, 0, Object.class);
    }

    private static MethodHandle bindConstructHandle(MethodHandle originalConstructor, ScriptFunction fn, Object[] args) {
        Object[] boundArgs;
        MethodHandle calleeBoundConstructor;
        assert (originalConstructor != null);
        MethodHandle methodHandle = calleeBoundConstructor = fn.isBoundFunction() ? originalConstructor : Lookup.MH.dropArguments(Lookup.MH.bindTo(originalConstructor, fn), 0, ScriptFunction.class);
        if (args.length == 0) {
            return calleeBoundConstructor;
        }
        if (ScriptFunctionData.isVarArg(calleeBoundConstructor)) {
            return ScriptFunctionData.varArgBinder(calleeBoundConstructor, args);
        }
        int maxArgCount = calleeBoundConstructor.type().parameterCount() - 1;
        if (args.length <= maxArgCount) {
            boundArgs = args;
        } else {
            boundArgs = new Object[maxArgCount];
            System.arraycopy(args, 0, boundArgs, 0, maxArgCount);
        }
        return Lookup.MH.insertArguments(calleeBoundConstructor, 1, boundArgs);
    }

    Object invoke(ScriptFunction fn, Object self, Object ... arguments) throws Throwable {
        MethodHandle mh = this.getGenericInvoker();
        Object selfObj = this.convertThisObject(self);
        Object[] args = arguments == null ? ScriptRuntime.EMPTY_ARRAY : arguments;
        DebuggerSupport.notifyInvoke(mh);
        if (ScriptFunctionData.isVarArg(mh)) {
            if (ScriptFunctionData.needsCallee(mh)) {
                return mh.invokeExact(fn, selfObj, args);
            }
            return mh.invokeExact(selfObj, args);
        }
        int paramCount = mh.type().parameterCount();
        if (ScriptFunctionData.needsCallee(mh)) {
            switch (paramCount) {
                case 2: {
                    return mh.invokeExact(fn, selfObj);
                }
                case 3: {
                    return mh.invokeExact(fn, selfObj, ScriptFunctionData.getArg(args, 0));
                }
                case 4: {
                    return mh.invokeExact(fn, selfObj, ScriptFunctionData.getArg(args, 0), ScriptFunctionData.getArg(args, 1));
                }
                case 5: {
                    return mh.invokeExact(fn, selfObj, ScriptFunctionData.getArg(args, 0), ScriptFunctionData.getArg(args, 1), ScriptFunctionData.getArg(args, 2));
                }
                case 6: {
                    return mh.invokeExact(fn, selfObj, ScriptFunctionData.getArg(args, 0), ScriptFunctionData.getArg(args, 1), ScriptFunctionData.getArg(args, 2), ScriptFunctionData.getArg(args, 3));
                }
                case 7: {
                    return mh.invokeExact(fn, selfObj, ScriptFunctionData.getArg(args, 0), ScriptFunctionData.getArg(args, 1), ScriptFunctionData.getArg(args, 2), ScriptFunctionData.getArg(args, 3), ScriptFunctionData.getArg(args, 4));
                }
                case 8: {
                    return mh.invokeExact(fn, selfObj, ScriptFunctionData.getArg(args, 0), ScriptFunctionData.getArg(args, 1), ScriptFunctionData.getArg(args, 2), ScriptFunctionData.getArg(args, 3), ScriptFunctionData.getArg(args, 4), ScriptFunctionData.getArg(args, 5));
                }
            }
            return mh.invokeWithArguments(ScriptFunctionData.withArguments(fn, selfObj, paramCount, args));
        }
        switch (paramCount) {
            case 1: {
                return mh.invokeExact(selfObj);
            }
            case 2: {
                return mh.invokeExact(selfObj, ScriptFunctionData.getArg(args, 0));
            }
            case 3: {
                return mh.invokeExact(selfObj, ScriptFunctionData.getArg(args, 0), ScriptFunctionData.getArg(args, 1));
            }
            case 4: {
                return mh.invokeExact(selfObj, ScriptFunctionData.getArg(args, 0), ScriptFunctionData.getArg(args, 1), ScriptFunctionData.getArg(args, 2));
            }
            case 5: {
                return mh.invokeExact(selfObj, ScriptFunctionData.getArg(args, 0), ScriptFunctionData.getArg(args, 1), ScriptFunctionData.getArg(args, 2), ScriptFunctionData.getArg(args, 3));
            }
            case 6: {
                return mh.invokeExact(selfObj, ScriptFunctionData.getArg(args, 0), ScriptFunctionData.getArg(args, 1), ScriptFunctionData.getArg(args, 2), ScriptFunctionData.getArg(args, 3), ScriptFunctionData.getArg(args, 4));
            }
            case 7: {
                return mh.invokeExact(selfObj, ScriptFunctionData.getArg(args, 0), ScriptFunctionData.getArg(args, 1), ScriptFunctionData.getArg(args, 2), ScriptFunctionData.getArg(args, 3), ScriptFunctionData.getArg(args, 4), ScriptFunctionData.getArg(args, 5));
            }
        }
        return mh.invokeWithArguments(ScriptFunctionData.withArguments(null, selfObj, paramCount, args));
    }

    Object construct(ScriptFunction fn, Object ... arguments) throws Throwable {
        MethodHandle mh = this.getGenericConstructor();
        Object[] args = arguments == null ? ScriptRuntime.EMPTY_ARRAY : arguments;
        DebuggerSupport.notifyInvoke(mh);
        if (ScriptFunctionData.isVarArg(mh)) {
            if (ScriptFunctionData.needsCallee(mh)) {
                return mh.invokeExact(fn, args);
            }
            return mh.invokeExact(args);
        }
        int paramCount = mh.type().parameterCount();
        if (ScriptFunctionData.needsCallee(mh)) {
            switch (paramCount) {
                case 1: {
                    return mh.invokeExact(fn);
                }
                case 2: {
                    return mh.invokeExact(fn, ScriptFunctionData.getArg(args, 0));
                }
                case 3: {
                    return mh.invokeExact(fn, ScriptFunctionData.getArg(args, 0), ScriptFunctionData.getArg(args, 1));
                }
                case 4: {
                    return mh.invokeExact(fn, ScriptFunctionData.getArg(args, 0), ScriptFunctionData.getArg(args, 1), ScriptFunctionData.getArg(args, 2));
                }
                case 5: {
                    return mh.invokeExact(fn, ScriptFunctionData.getArg(args, 0), ScriptFunctionData.getArg(args, 1), ScriptFunctionData.getArg(args, 2), ScriptFunctionData.getArg(args, 3));
                }
                case 6: {
                    return mh.invokeExact(fn, ScriptFunctionData.getArg(args, 0), ScriptFunctionData.getArg(args, 1), ScriptFunctionData.getArg(args, 2), ScriptFunctionData.getArg(args, 3), ScriptFunctionData.getArg(args, 4));
                }
                case 7: {
                    return mh.invokeExact(fn, ScriptFunctionData.getArg(args, 0), ScriptFunctionData.getArg(args, 1), ScriptFunctionData.getArg(args, 2), ScriptFunctionData.getArg(args, 3), ScriptFunctionData.getArg(args, 4), ScriptFunctionData.getArg(args, 5));
                }
            }
            return mh.invokeWithArguments(ScriptFunctionData.withArguments(fn, paramCount, args));
        }
        switch (paramCount) {
            case 0: {
                return mh.invokeExact();
            }
            case 1: {
                return mh.invokeExact(ScriptFunctionData.getArg(args, 0));
            }
            case 2: {
                return mh.invokeExact(ScriptFunctionData.getArg(args, 0), ScriptFunctionData.getArg(args, 1));
            }
            case 3: {
                return mh.invokeExact(ScriptFunctionData.getArg(args, 0), ScriptFunctionData.getArg(args, 1), ScriptFunctionData.getArg(args, 2));
            }
            case 4: {
                return mh.invokeExact(ScriptFunctionData.getArg(args, 0), ScriptFunctionData.getArg(args, 1), ScriptFunctionData.getArg(args, 2), ScriptFunctionData.getArg(args, 3));
            }
            case 5: {
                return mh.invokeExact(ScriptFunctionData.getArg(args, 0), ScriptFunctionData.getArg(args, 1), ScriptFunctionData.getArg(args, 2), ScriptFunctionData.getArg(args, 3), ScriptFunctionData.getArg(args, 4));
            }
            case 6: {
                return mh.invokeExact(ScriptFunctionData.getArg(args, 0), ScriptFunctionData.getArg(args, 1), ScriptFunctionData.getArg(args, 2), ScriptFunctionData.getArg(args, 3), ScriptFunctionData.getArg(args, 4), ScriptFunctionData.getArg(args, 5));
            }
        }
        return mh.invokeWithArguments(ScriptFunctionData.withArguments(null, paramCount, args));
    }

    private static Object getArg(Object[] args, int i) {
        return i < args.length ? args[i] : ScriptRuntime.UNDEFINED;
    }

    private static Object[] withArguments(ScriptFunction fn, int argCount, Object[] args) {
        Object[] finalArgs = new Object[argCount];
        int nextArg = 0;
        if (fn != null) {
            finalArgs[nextArg++] = fn;
        }
        int i = 0;
        while (i < args.length && nextArg < argCount) {
            finalArgs[nextArg++] = args[i++];
        }
        while (nextArg < argCount) {
            finalArgs[nextArg++] = ScriptRuntime.UNDEFINED;
        }
        return finalArgs;
    }

    private static Object[] withArguments(ScriptFunction fn, Object self, int argCount, Object[] args) {
        Object[] finalArgs = new Object[argCount];
        int nextArg = 0;
        if (fn != null) {
            finalArgs[nextArg++] = fn;
        }
        finalArgs[nextArg++] = self;
        int i = 0;
        while (i < args.length && nextArg < argCount) {
            finalArgs[nextArg++] = args[i++];
        }
        while (nextArg < argCount) {
            finalArgs[nextArg++] = ScriptRuntime.UNDEFINED;
        }
        return finalArgs;
    }

    private static MethodHandle varArgBinder(MethodHandle mh, Object[] args) {
        assert (args != null);
        assert (args.length > 0);
        return Lookup.MH.filterArguments(mh, mh.type().parameterCount() - 1, Lookup.MH.bindTo(BIND_VAR_ARGS, args));
    }

    private static MethodHandle changeReturnTypeToObject(MethodHandle mh) {
        MethodType type = mh.type();
        return type.returnType() == Object.class ? mh : Lookup.MH.asType(mh, type.changeReturnType(Object.class));
    }

    private void ensureConstructor(CompiledFunction inv) {
        if (!inv.hasConstructor()) {
            inv.setConstructor(this.composeConstructor(inv.getInvoker()));
        }
    }

    protected static boolean needsCallee(MethodHandle mh) {
        MethodType type = mh.type();
        return type.parameterCount() > 0 && type.parameterType(0) == ScriptFunction.class;
    }

    protected static boolean isVarArg(MethodHandle mh) {
        MethodType type = mh.type();
        return ((Class)type.parameterType(type.parameterCount() - 1)).isArray();
    }

    private static Object[] bindVarArgs(Object[] array1, Object[] array2) {
        if (array2 == null) {
            return (Object[])array1.clone();
        }
        int l2 = array2.length;
        if (l2 == 0) {
            return (Object[])array1.clone();
        }
        int l1 = array1.length;
        Object[] concat = new Object[l1 + l2];
        System.arraycopy(array1, 0, concat, 0, l1);
        System.arraycopy(array2, 0, concat, l1, l2);
        return concat;
    }

    private static Object newFilter(Object result, Object allocation) {
        return result instanceof ScriptObject || !JSType.isPrimitive(result) ? result : allocation;
    }

    private static MethodHandle findOwnMH(String name, Class<?> rtype, Class<?> ... types) {
        return Lookup.MH.findStatic(MethodHandles.lookup(), ScriptFunctionData.class, name, Lookup.MH.type(rtype, types));
    }
}

