/*
 * Decompiled with CFR 0.152.
 */
package jdk.nashorn.internal.runtime;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Base64;
import java.util.Map;
import jdk.nashorn.internal.runtime.CompiledScript;
import jdk.nashorn.internal.runtime.Source;

final class CodeStore {
    private final File dir;
    private final int minSize;
    private static final Base64.Encoder BASE64 = Base64.getUrlEncoder().withoutPadding();
    private static final int DEFAULT_MIN_SIZE = 1000;

    public CodeStore(String path) throws IOException {
        this(path, 1000);
    }

    public CodeStore(String path, int minSize) throws IOException {
        this.dir = CodeStore.checkDirectory(path);
        this.minSize = minSize;
    }

    private static File checkDirectory(final String path) throws IOException {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<File>(){

                @Override
                public File run() throws IOException {
                    File dir = new File(path).getAbsoluteFile();
                    if (!dir.exists() && !dir.mkdirs()) {
                        throw new IOException("Could not create directory: " + dir);
                    }
                    if (!dir.isDirectory()) {
                        throw new IOException("Not a directory: " + dir);
                    }
                    if (!dir.canRead() || !dir.canWrite()) {
                        throw new IOException("Directory not readable or writable: " + dir);
                    }
                    return dir;
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (IOException)e.getException();
        }
    }

    public CompiledScript getScript(final Source source) throws IOException, ClassNotFoundException {
        if (source.getLength() < this.minSize) {
            return null;
        }
        String digest = BASE64.encodeToString(source.getDigest());
        final File file = new File(this.dir, digest);
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<CompiledScript>(){

                @Override
                public CompiledScript run() throws IOException, ClassNotFoundException {
                    if (!file.exists()) {
                        return null;
                    }
                    try (ObjectInputStream in = new ObjectInputStream(new BufferedInputStream(new FileInputStream(file)));){
                        CompiledScript compiledScript = (CompiledScript)in.readObject();
                        compiledScript.setSource(source);
                        CompiledScript compiledScript2 = compiledScript;
                        return compiledScript2;
                    }
                }
            });
        }
        catch (PrivilegedActionException e) {
            Exception ex = e.getException();
            if (ex instanceof IOException) {
                throw (IOException)ex;
            }
            if (ex instanceof ClassNotFoundException) {
                throw (ClassNotFoundException)ex;
            }
            throw new RuntimeException(ex);
        }
    }

    public void putScript(Source source, String mainClassName, Map<String, byte[]> classBytes, Object[] constants) throws IOException {
        if (source.getLength() < this.minSize) {
            return;
        }
        for (Object constant : constants) {
            if (constant instanceof Serializable) continue;
            return;
        }
        String digest = BASE64.encodeToString(source.getDigest());
        final File file = new File(this.dir, digest);
        final CompiledScript script = new CompiledScript(source, mainClassName, classBytes, constants);
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws IOException {
                    try (ObjectOutputStream out = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(file)));){
                        out.writeObject(script);
                    }
                    return null;
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (IOException)e.getException();
        }
    }
}

