/*
 * Decompiled with CFR 0.152.
 */
package jdk.nashorn.internal.ir;

import jdk.nashorn.internal.codegen.types.Type;
import jdk.nashorn.internal.ir.Assignment;
import jdk.nashorn.internal.ir.Expression;
import jdk.nashorn.internal.ir.IdentNode;
import jdk.nashorn.internal.ir.LexicalContext;
import jdk.nashorn.internal.ir.Node;
import jdk.nashorn.internal.ir.annotations.Immutable;
import jdk.nashorn.internal.ir.visitor.NodeVisitor;
import jdk.nashorn.internal.parser.TokenType;

@Immutable
public final class BinaryNode
extends Expression
implements Assignment<Expression> {
    private final Expression lhs;
    private final Expression rhs;

    public BinaryNode(long token, Expression lhs, Expression rhs) {
        super(token, lhs.getStart(), rhs.getFinish());
        this.lhs = lhs;
        this.rhs = rhs;
    }

    private BinaryNode(BinaryNode binaryNode, Expression lhs, Expression rhs) {
        super(binaryNode);
        this.lhs = lhs;
        this.rhs = rhs;
    }

    @Override
    public boolean isComparison() {
        switch (this.tokenType()) {
            case EQ: 
            case EQ_STRICT: 
            case NE: 
            case NE_STRICT: 
            case LE: 
            case LT: 
            case GE: 
            case GT: {
                return true;
            }
        }
        return false;
    }

    @Override
    public Type getWidestOperationType() {
        switch (this.tokenType()) {
            case SHR: 
            case ASSIGN_SHR: {
                return Type.LONG;
            }
            case ASSIGN_SAR: 
            case ASSIGN_SHL: 
            case BIT_AND: 
            case BIT_OR: 
            case BIT_XOR: 
            case ASSIGN_BIT_AND: 
            case ASSIGN_BIT_OR: 
            case ASSIGN_BIT_XOR: 
            case SAR: 
            case SHL: {
                return Type.INT;
            }
            case DIV: 
            case MOD: 
            case MUL: 
            case SUB: 
            case ASSIGN_DIV: 
            case ASSIGN_MOD: 
            case ASSIGN_MUL: 
            case ASSIGN_SUB: {
                return Type.NUMBER;
            }
        }
        return Type.OBJECT;
    }

    @Override
    public boolean isAssignment() {
        switch (this.tokenType()) {
            case ASSIGN_SHR: 
            case ASSIGN_SAR: 
            case ASSIGN_SHL: 
            case ASSIGN_BIT_AND: 
            case ASSIGN_BIT_OR: 
            case ASSIGN_BIT_XOR: 
            case ASSIGN_DIV: 
            case ASSIGN_MOD: 
            case ASSIGN_MUL: 
            case ASSIGN_SUB: 
            case ASSIGN: 
            case ASSIGN_ADD: {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isSelfModifying() {
        return this.isAssignment() && this.tokenType() != TokenType.ASSIGN;
    }

    @Override
    public Expression getAssignmentDest() {
        return this.isAssignment() ? this.lhs() : null;
    }

    public BinaryNode setAssignmentDest(Expression n) {
        return this.setLHS(n);
    }

    @Override
    public Expression getAssignmentSource() {
        return this.rhs();
    }

    @Override
    public Node accept(NodeVisitor<? extends LexicalContext> visitor) {
        if (visitor.enterBinaryNode(this)) {
            return visitor.leaveBinaryNode(this.setLHS((Expression)this.lhs.accept(visitor)).setRHS((Expression)this.rhs.accept(visitor)));
        }
        return this;
    }

    @Override
    public boolean isLocal() {
        switch (this.tokenType()) {
            case SHR: 
            case BIT_AND: 
            case BIT_OR: 
            case BIT_XOR: 
            case SAR: 
            case SHL: 
            case DIV: 
            case MOD: 
            case MUL: 
            case SUB: 
            case ADD: {
                return this.lhs.isLocal() && this.lhs.getType().isJSPrimitive() && this.rhs.isLocal() && this.rhs.getType().isJSPrimitive();
            }
            case ASSIGN_SHR: 
            case ASSIGN_SAR: 
            case ASSIGN_SHL: 
            case ASSIGN_BIT_AND: 
            case ASSIGN_BIT_OR: 
            case ASSIGN_BIT_XOR: 
            case ASSIGN_DIV: 
            case ASSIGN_MOD: 
            case ASSIGN_MUL: 
            case ASSIGN_SUB: 
            case ASSIGN_ADD: {
                return this.lhs instanceof IdentNode && this.lhs.isLocal() && this.lhs.getType().isJSPrimitive() && this.rhs.isLocal() && this.rhs.getType().isJSPrimitive();
            }
            case ASSIGN: {
                return this.lhs instanceof IdentNode && this.lhs.isLocal() && this.rhs.isLocal();
            }
        }
        return false;
    }

    @Override
    public void toString(StringBuilder sb) {
        TokenType type = this.tokenType();
        boolean lhsParen = type.needsParens(this.lhs().tokenType(), true);
        boolean rhsParen = type.needsParens(this.rhs().tokenType(), false);
        if (lhsParen) {
            sb.append('(');
        }
        this.lhs().toString(sb);
        if (lhsParen) {
            sb.append(')');
        }
        sb.append(' ');
        switch (type) {
            case COMMALEFT: {
                sb.append(",<");
                break;
            }
            case COMMARIGHT: {
                sb.append(",>");
                break;
            }
            case INCPREFIX: 
            case DECPREFIX: {
                sb.append("++");
                break;
            }
            default: {
                sb.append(type.getName());
            }
        }
        sb.append(' ');
        if (rhsParen) {
            sb.append('(');
        }
        this.rhs().toString(sb);
        if (rhsParen) {
            sb.append(')');
        }
    }

    public Expression lhs() {
        return this.lhs;
    }

    public Expression rhs() {
        return this.rhs;
    }

    public BinaryNode setLHS(Expression lhs) {
        if (this.lhs == lhs) {
            return this;
        }
        return new BinaryNode(this, lhs, this.rhs);
    }

    public BinaryNode setRHS(Expression rhs) {
        if (this.rhs == rhs) {
            return this;
        }
        return new BinaryNode(this, this.lhs, rhs);
    }
}

