/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferInt;
import java.awt.image.SinglePixelPackedSampleModel;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.security.AccessController;
import java.security.PrivilegedAction;
import sun.awt.image.SunWritableRaster;
import sun.util.logging.PlatformLogger;

public final class SplashScreen {
    private BufferedImage image;
    private final long splashPtr;
    private static boolean wasClosed = false;
    private URL imageURL;
    private static SplashScreen theInstance = null;
    private static final PlatformLogger log = PlatformLogger.getLogger("java.awt.SplashScreen");

    SplashScreen(long l) {
        this.splashPtr = l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SplashScreen getSplashScreen() {
        Class<SplashScreen> clazz = SplashScreen.class;
        synchronized (SplashScreen.class) {
            if (GraphicsEnvironment.isHeadless()) {
                throw new HeadlessException();
            }
            if (!wasClosed && theInstance == null) {
                AccessController.doPrivileged(new PrivilegedAction<Void>(){

                    @Override
                    public Void run() {
                        System.loadLibrary("splashscreen");
                        return null;
                    }
                });
                long l = SplashScreen._getInstance();
                if (l != 0L && SplashScreen._isVisible(l)) {
                    theInstance = new SplashScreen(l);
                }
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return theInstance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setImageURL(URL uRL) throws NullPointerException, IOException, IllegalStateException {
        this.checkVisible();
        URLConnection uRLConnection = uRL.openConnection();
        uRLConnection.connect();
        int n = uRLConnection.getContentLength();
        InputStream inputStream = uRLConnection.getInputStream();
        byte[] byArray = new byte[n];
        int n2 = 0;
        while (true) {
            int n3;
            int n4;
            if ((n4 = inputStream.available()) <= 0) {
                n4 = 1;
            }
            if (n2 + n4 > n) {
                n = n2 * 2;
                if (n2 + n4 > n) {
                    n = n4 + n2;
                }
                byte[] byArray2 = byArray;
                byArray = new byte[n];
                System.arraycopy(byArray2, 0, byArray, 0, n2);
            }
            if ((n3 = inputStream.read(byArray, n2, n4)) < 0) break;
            n2 += n3;
        }
        Class<SplashScreen> clazz = SplashScreen.class;
        synchronized (SplashScreen.class) {
            this.checkVisible();
            if (!SplashScreen._setImageData(this.splashPtr, byArray)) {
                throw new IOException("Bad image format or i/o error when loading image");
            }
            this.imageURL = uRL;
            // ** MonitorExit[var7_8] (shouldn't be in output)
            return;
        }
    }

    private void checkVisible() {
        if (!this.isVisible()) {
            throw new IllegalStateException("no splash screen available");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public URL getImageURL() throws IllegalStateException {
        Class<SplashScreen> clazz = SplashScreen.class;
        synchronized (SplashScreen.class) {
            block7: {
                this.checkVisible();
                if (this.imageURL == null) {
                    try {
                        String string = SplashScreen._getImageFileName(this.splashPtr);
                        String string2 = SplashScreen._getImageJarName(this.splashPtr);
                        if (string != null) {
                            this.imageURL = string2 != null ? new URL("jar:" + new File(string2).toURL().toString() + "!/" + string) : new File(string).toURL();
                        }
                    }
                    catch (MalformedURLException malformedURLException) {
                        if (!log.isLoggable(PlatformLogger.Level.FINE)) break block7;
                        log.fine("MalformedURLException caught in the getImageURL() method", malformedURLException);
                    }
                }
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.imageURL;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Rectangle getBounds() throws IllegalStateException {
        Class<SplashScreen> clazz = SplashScreen.class;
        synchronized (SplashScreen.class) {
            this.checkVisible();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return SplashScreen._getBounds(this.splashPtr);
        }
    }

    public Dimension getSize() throws IllegalStateException {
        return this.getBounds().getSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Graphics2D createGraphics() throws IllegalStateException {
        Class<SplashScreen> clazz = SplashScreen.class;
        synchronized (SplashScreen.class) {
            if (this.image == null) {
                Dimension dimension = this.getSize();
                this.image = new BufferedImage(dimension.width, dimension.height, 2);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.image.createGraphics();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update() throws IllegalStateException {
        Object object = SplashScreen.class;
        synchronized (SplashScreen.class) {
            this.checkVisible();
            BufferedImage bufferedImage = this.image;
            // ** MonitorExit[var2_1] (shouldn't be in output)
            if (bufferedImage == null) {
                throw new IllegalStateException("no overlay image available");
            }
            object = bufferedImage.getRaster().getDataBuffer();
            if (!(object instanceof DataBufferInt)) {
                throw new AssertionError((Object)("Overlay image DataBuffer is of invalid type == " + object.getClass().getName()));
            }
            int n = ((DataBuffer)object).getNumBanks();
            if (n != 1) {
                throw new AssertionError((Object)("Invalid number of banks ==" + n + " in overlay image DataBuffer"));
            }
            if (!(bufferedImage.getSampleModel() instanceof SinglePixelPackedSampleModel)) {
                throw new AssertionError((Object)("Overlay image has invalid sample model == " + bufferedImage.getSampleModel().getClass().getName()));
            }
            SinglePixelPackedSampleModel singlePixelPackedSampleModel = (SinglePixelPackedSampleModel)bufferedImage.getSampleModel();
            int n2 = singlePixelPackedSampleModel.getScanlineStride();
            Rectangle rectangle = bufferedImage.getRaster().getBounds();
            int[] nArray = SunWritableRaster.stealData((DataBufferInt)object, 0);
            Class<SplashScreen> clazz = SplashScreen.class;
            synchronized (SplashScreen.class) {
                this.checkVisible();
                SplashScreen._update(this.splashPtr, nArray, rectangle.x, rectangle.y, rectangle.width, rectangle.height, n2);
                // ** MonitorExit[var8_9] (shouldn't be in output)
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IllegalStateException {
        Class<SplashScreen> clazz = SplashScreen.class;
        synchronized (SplashScreen.class) {
            this.checkVisible();
            SplashScreen._close(this.splashPtr);
            this.image = null;
            SplashScreen.markClosed();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void markClosed() {
        Class<SplashScreen> clazz = SplashScreen.class;
        synchronized (SplashScreen.class) {
            wasClosed = true;
            theInstance = null;
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isVisible() {
        Class<SplashScreen> clazz = SplashScreen.class;
        synchronized (SplashScreen.class) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return !wasClosed && SplashScreen._isVisible(this.splashPtr);
        }
    }

    private static native void _update(long var0, int[] var2, int var3, int var4, int var5, int var6, int var7);

    private static native boolean _isVisible(long var0);

    private static native Rectangle _getBounds(long var0);

    private static native long _getInstance();

    private static native void _close(long var0);

    private static native String _getImageFileName(long var0);

    private static native String _getImageJarName(long var0);

    private static native boolean _setImageData(long var0, byte[] var2);
}

