/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.code;

import java.util.Observable;
import java.util.Observer;
import sun.jvm.hotspot.code.Stub;
import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.runtime.VM;
import sun.jvm.hotspot.runtime.VMObject;
import sun.jvm.hotspot.runtime.VMObjectFactory;
import sun.jvm.hotspot.types.AddressField;
import sun.jvm.hotspot.types.CIntegerField;
import sun.jvm.hotspot.types.Type;
import sun.jvm.hotspot.types.TypeDataBase;
import sun.jvm.hotspot.utilities.Assert;

public class StubQueue
extends VMObject {
    private static AddressField stubBufferField;
    private static CIntegerField bufferLimitField;
    private static CIntegerField queueBeginField;
    private static CIntegerField queueEndField;
    private static CIntegerField numberOfStubsField;
    private Class stubType;

    private static synchronized void initialize(TypeDataBase db) {
        Type type = db.lookupType("StubQueue");
        stubBufferField = type.getAddressField("_stub_buffer");
        bufferLimitField = type.getCIntegerField("_buffer_limit");
        queueBeginField = type.getCIntegerField("_queue_begin");
        queueEndField = type.getCIntegerField("_queue_end");
        numberOfStubsField = type.getCIntegerField("_number_of_stubs");
    }

    public StubQueue(Address addr, Class stubType) {
        super(addr);
        this.stubType = stubType;
    }

    public boolean contains(Address pc) {
        if (pc == null) {
            return false;
        }
        long offset = pc.minus(this.getStubBuffer());
        return 0L <= offset && offset < this.getBufferLimit();
    }

    public Stub getStubContaining(Address pc) {
        if (this.contains(pc)) {
            boolean i = false;
            Stub s = this.getFirst();
            while (s != null) {
                if (this.stubContains(s, pc)) {
                    return s;
                }
                s = this.getNext(s);
            }
        }
        return null;
    }

    public boolean stubContains(Stub s, Address pc) {
        return s.codeBegin().lessThanOrEqual(pc) && s.codeEnd().greaterThan(pc);
    }

    public int getNumberOfStubs() {
        return (int)numberOfStubsField.getValue(this.addr);
    }

    public Stub getFirst() {
        return this.getNumberOfStubs() > 0 ? this.getStubAt(this.getQueueBegin()) : null;
    }

    public Stub getNext(Stub s) {
        long i = this.getIndexOf(s) + this.getStubSize(s);
        if (i == this.getBufferLimit()) {
            i = 0L;
        }
        return i == this.getQueueEnd() ? null : this.getStubAt(i);
    }

    public Stub getPrev(Stub s) {
        if (this.getIndexOf(s) == this.getQueueBegin()) {
            return null;
        }
        Stub temp = this.getFirst();
        Stub prev = null;
        while (temp != null && this.getIndexOf(temp) != this.getIndexOf(s)) {
            prev = temp;
            temp = this.getNext(temp);
        }
        return prev;
    }

    private long getQueueBegin() {
        return queueBeginField.getValue(this.addr);
    }

    private long getQueueEnd() {
        return queueEndField.getValue(this.addr);
    }

    private long getBufferLimit() {
        return bufferLimitField.getValue(this.addr);
    }

    private Address getStubBuffer() {
        return stubBufferField.getValue(this.addr);
    }

    private Stub getStubAt(long offset) {
        this.checkIndex(offset);
        return (Stub)VMObjectFactory.newObject(this.stubType, this.getStubBuffer().addOffsetTo(offset));
    }

    private long getIndexOf(Stub s) {
        long i = s.getAddress().minus(this.getStubBuffer());
        this.checkIndex(i);
        return i;
    }

    private long getStubSize(Stub s) {
        return s.getSize();
    }

    private void checkIndex(long i) {
        if (Assert.ASSERTS_ENABLED) {
            Assert.that(0L <= i && i < this.getBufferLimit() && i % VM.getVM().getAddressSize() == 0L, "illegal index");
        }
    }

    static {
        VM.registerVMInitializedObserver(new Observer(){

            @Override
            public void update(Observable o, Object data) {
                StubQueue.initialize(VM.getVM().getTypeDataBase());
            }
        });
    }
}

