/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.jconsole;

import com.sun.tools.attach.AgentInitializationException;
import com.sun.tools.attach.AgentLoadException;
import com.sun.tools.attach.AttachNotSupportedException;
import com.sun.tools.attach.VirtualMachine;
import com.sun.tools.attach.VirtualMachineDescriptor;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import sun.jvmstat.monitor.HostIdentifier;
import sun.jvmstat.monitor.MonitorException;
import sun.jvmstat.monitor.MonitoredHost;
import sun.jvmstat.monitor.MonitoredVm;
import sun.jvmstat.monitor.MonitoredVmUtil;
import sun.jvmstat.monitor.VmIdentifier;
import sun.management.ConnectorAddressLink;
import sun.tools.jconsole.JConsole;

public class LocalVirtualMachine {
    private String address;
    private String commandLine;
    private String displayName;
    private int vmid;
    private boolean isAttachSupported;
    private static final String LOCAL_CONNECTOR_ADDRESS_PROP = "com.sun.management.jmxremote.localConnectorAddress";

    public LocalVirtualMachine(int n, String string, boolean bl, String string2) {
        this.vmid = n;
        this.commandLine = string;
        this.address = string2;
        this.isAttachSupported = bl;
        this.displayName = LocalVirtualMachine.getDisplayName(string);
    }

    private static String getDisplayName(String string) {
        String[] stringArray = string.split(" ", 2);
        if (stringArray[0].endsWith(".jar")) {
            File file = new File(stringArray[0]);
            String string2 = file.getName();
            if (stringArray.length == 2) {
                string2 = string2 + " " + stringArray[1];
            }
            return string2;
        }
        return string;
    }

    public int vmid() {
        return this.vmid;
    }

    public boolean isManageable() {
        return this.address != null;
    }

    public boolean isAttachable() {
        return this.isAttachSupported;
    }

    public void startManagementAgent() throws IOException {
        if (this.address != null) {
            return;
        }
        if (!this.isAttachable()) {
            throw new IOException("This virtual machine \"" + this.vmid + "\" does not support dynamic attach.");
        }
        this.loadManagementAgent();
        if (this.address == null) {
            throw new IOException("Fails to find connector address");
        }
    }

    public String connectorAddress() {
        return this.address;
    }

    public String displayName() {
        return this.displayName;
    }

    public String toString() {
        return this.commandLine;
    }

    public static Map<Integer, LocalVirtualMachine> getAllVirtualMachines() {
        HashMap<Integer, LocalVirtualMachine> hashMap = new HashMap<Integer, LocalVirtualMachine>();
        LocalVirtualMachine.getMonitoredVMs(hashMap);
        LocalVirtualMachine.getAttachableVMs(hashMap);
        return hashMap;
    }

    private static void getMonitoredVMs(Map<Integer, LocalVirtualMachine> map) {
        Set<Integer> set;
        MonitoredHost monitoredHost;
        try {
            monitoredHost = MonitoredHost.getMonitoredHost(new HostIdentifier((String)null));
            set = monitoredHost.activeVms();
        }
        catch (URISyntaxException | MonitorException exception) {
            throw new InternalError(exception.getMessage(), exception);
        }
        for (Integer n : set) {
            if (!(n instanceof Integer)) continue;
            int n2 = n;
            String string = ((Object)n).toString();
            boolean bl = false;
            String string2 = null;
            try {
                MonitoredVm monitoredVm = monitoredHost.getMonitoredVm(new VmIdentifier(string));
                string = MonitoredVmUtil.commandLine(monitoredVm);
                bl = MonitoredVmUtil.isAttachable(monitoredVm);
                string2 = ConnectorAddressLink.importFrom((int)n2);
                monitoredVm.detach();
            }
            catch (Exception exception) {
                // empty catch block
            }
            map.put(n, new LocalVirtualMachine(n2, string, bl, string2));
        }
    }

    private static void getAttachableVMs(Map<Integer, LocalVirtualMachine> map) {
        List<VirtualMachineDescriptor> list = VirtualMachine.list();
        for (VirtualMachineDescriptor virtualMachineDescriptor : list) {
            try {
                Integer n = Integer.valueOf(virtualMachineDescriptor.id());
                if (map.containsKey(n)) continue;
                boolean bl = false;
                String string = null;
                try {
                    VirtualMachine virtualMachine = VirtualMachine.attach(virtualMachineDescriptor);
                    bl = true;
                    Properties properties = virtualMachine.getAgentProperties();
                    string = (String)properties.get(LOCAL_CONNECTOR_ADDRESS_PROP);
                    virtualMachine.detach();
                }
                catch (AttachNotSupportedException attachNotSupportedException) {
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                map.put(n, new LocalVirtualMachine(n, virtualMachineDescriptor.displayName(), bl, string));
            }
            catch (NumberFormatException numberFormatException) {}
        }
    }

    public static LocalVirtualMachine getLocalVirtualMachine(int n) {
        LocalVirtualMachine localVirtualMachine;
        block5: {
            Map<Integer, LocalVirtualMachine> map = LocalVirtualMachine.getAllVirtualMachines();
            localVirtualMachine = map.get(n);
            if (localVirtualMachine == null) {
                boolean bl = false;
                String string = null;
                String string2 = String.valueOf(n);
                try {
                    VirtualMachine virtualMachine = VirtualMachine.attach(string2);
                    bl = true;
                    Properties properties = virtualMachine.getAgentProperties();
                    string = (String)properties.get(LOCAL_CONNECTOR_ADDRESS_PROP);
                    virtualMachine.detach();
                    localVirtualMachine = new LocalVirtualMachine(n, string2, bl, string);
                }
                catch (AttachNotSupportedException attachNotSupportedException) {
                    if (JConsole.isDebug()) {
                        attachNotSupportedException.printStackTrace();
                    }
                }
                catch (IOException iOException) {
                    if (!JConsole.isDebug()) break block5;
                    iOException.printStackTrace();
                }
            }
        }
        return localVirtualMachine;
    }

    private void loadManagementAgent() throws IOException {
        VirtualMachine virtualMachine = null;
        String string = String.valueOf(this.vmid);
        try {
            virtualMachine = VirtualMachine.attach(string);
        }
        catch (AttachNotSupportedException attachNotSupportedException) {
            IOException iOException = new IOException(attachNotSupportedException.getMessage());
            iOException.initCause(attachNotSupportedException);
            throw iOException;
        }
        String string2 = virtualMachine.getSystemProperties().getProperty("java.home");
        String string3 = string2 + File.separator + "jre" + File.separator + "lib" + File.separator + "management-agent.jar";
        File file = new File(string3);
        if (!file.exists() && !(file = new File(string3 = string2 + File.separator + "lib" + File.separator + "management-agent.jar")).exists()) {
            throw new IOException("Management agent not found");
        }
        string3 = file.getCanonicalPath();
        try {
            virtualMachine.loadAgent(string3, "com.sun.management.jmxremote");
        }
        catch (AgentLoadException agentLoadException) {
            IOException iOException = new IOException(agentLoadException.getMessage());
            iOException.initCause(agentLoadException);
            throw iOException;
        }
        catch (AgentInitializationException agentInitializationException) {
            IOException iOException = new IOException(agentInitializationException.getMessage());
            iOException.initCause(agentInitializationException);
            throw iOException;
        }
        Properties properties = virtualMachine.getAgentProperties();
        this.address = (String)properties.get(LOCAL_CONNECTOR_ADDRESS_PROP);
        virtualMachine.detach();
    }
}

