/*
 * Decompiled with CFR 0.152.
 */
package sun.util.locale.provider;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.text.spi.DateFormatProvider;
import java.util.Locale;

public class HostLocaleProviderAdapterImpl {
    static Locale[] supported = new Locale[]{Locale.getDefault(Locale.Category.FORMAT)};

    public static DateFormatProvider getDateFormatProvider() {
        return new DateFormatProvider(){
            String posixPattern;

            @Override
            public Locale[] getAvailableLocales() {
                return new Locale[0];
            }

            @Override
            public DateFormat getDateInstance(int n, Locale locale) {
                this.posixPattern = HostLocaleProviderAdapterImpl.getPattern(n, -1, locale.toLanguageTag());
                return new SimpleDateFormat(HostLocaleProviderAdapterImpl.convertPosixToJava(this.posixPattern), locale);
            }

            @Override
            public DateFormat getTimeInstance(int n, Locale locale) {
                this.posixPattern = HostLocaleProviderAdapterImpl.getPattern(-1, n, locale.toLanguageTag());
                return new SimpleDateFormat(HostLocaleProviderAdapterImpl.convertPosixToJava(this.posixPattern), locale);
            }

            @Override
            public DateFormat getDateTimeInstance(int n, int n2, Locale locale) {
                this.posixPattern = HostLocaleProviderAdapterImpl.getPattern(n, n2, locale.toLanguageTag());
                return new SimpleDateFormat(HostLocaleProviderAdapterImpl.convertPosixToJava(this.posixPattern), locale);
            }
        };
    }

    private static String convertPosixToJava(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = false;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (bl) {
                switch (c) {
                    case 'a': {
                        stringBuilder.append("EEE");
                        break;
                    }
                    case 'b': {
                        stringBuilder.append("MMM");
                        break;
                    }
                    case 'e': {
                        stringBuilder.append("dd");
                        break;
                    }
                    case 'H': {
                        stringBuilder.append("kk");
                        break;
                    }
                    case 'M': {
                        stringBuilder.append("mm");
                        break;
                    }
                    case 'S': {
                        stringBuilder.append("ss");
                        break;
                    }
                    case 'Y': {
                        stringBuilder.append("yyyy");
                        break;
                    }
                    case 'm': {
                        stringBuilder.append("MM");
                        break;
                    }
                    case 'd': {
                        stringBuilder.append("dd");
                        break;
                    }
                    case 'r': {
                        stringBuilder.append("hh:mm:ss aa");
                        break;
                    }
                    case 'Z': {
                        stringBuilder.append("zzz");
                    }
                }
                bl = false;
                continue;
            }
            if (c == '%') {
                bl = true;
                continue;
            }
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    private static native String getPattern(int var0, int var1, String var2);
}

