/*
 * Decompiled with CFR 0.152.
 */
package jdk.nashorn.internal.ir;

import jdk.nashorn.internal.ir.Block;
import jdk.nashorn.internal.ir.Expression;
import jdk.nashorn.internal.ir.LexicalContext;
import jdk.nashorn.internal.ir.LoopNode;
import jdk.nashorn.internal.ir.Node;
import jdk.nashorn.internal.ir.annotations.Immutable;
import jdk.nashorn.internal.ir.visitor.NodeVisitor;

@Immutable
public final class WhileNode
extends LoopNode {
    private final boolean isDoWhile;

    public WhileNode(int lineNumber, long token, int finish, boolean isDoWhile) {
        super(lineNumber, token, finish, null, null, false);
        this.isDoWhile = isDoWhile;
    }

    protected WhileNode(WhileNode whileNode, Expression test, Block body, boolean controlFlowEscapes) {
        super(whileNode, test, body, controlFlowEscapes);
        this.isDoWhile = whileNode.isDoWhile;
    }

    @Override
    public Node ensureUniqueLabels(LexicalContext lc) {
        return Node.replaceInLexicalContext(lc, this, new WhileNode(this, this.test, this.body, this.controlFlowEscapes));
    }

    @Override
    public boolean hasGoto() {
        return this.test == null;
    }

    @Override
    public Node accept(LexicalContext lc, NodeVisitor<? extends LexicalContext> visitor) {
        if (visitor.enterWhileNode(this)) {
            if (this.isDoWhile()) {
                return visitor.leaveWhileNode(this.setBody(lc, (Block)this.body.accept(visitor)).setTest(lc, (Expression)this.test.accept(visitor)));
            }
            return visitor.leaveWhileNode(this.setTest(lc, (Expression)this.test.accept(visitor)).setBody(lc, (Block)this.body.accept(visitor)));
        }
        return this;
    }

    @Override
    public Expression getTest() {
        return this.test;
    }

    @Override
    public WhileNode setTest(LexicalContext lc, Expression test) {
        if (this.test == test) {
            return this;
        }
        return Node.replaceInLexicalContext(lc, this, new WhileNode(this, test, this.body, this.controlFlowEscapes));
    }

    @Override
    public Block getBody() {
        return this.body;
    }

    @Override
    public WhileNode setBody(LexicalContext lc, Block body) {
        if (this.body == body) {
            return this;
        }
        return Node.replaceInLexicalContext(lc, this, new WhileNode(this, this.test, body, this.controlFlowEscapes));
    }

    @Override
    public WhileNode setControlFlowEscapes(LexicalContext lc, boolean controlFlowEscapes) {
        if (this.controlFlowEscapes == controlFlowEscapes) {
            return this;
        }
        return Node.replaceInLexicalContext(lc, this, new WhileNode(this, this.test, this.body, controlFlowEscapes));
    }

    public boolean isDoWhile() {
        return this.isDoWhile;
    }

    @Override
    public void toString(StringBuilder sb) {
        sb.append("while (");
        this.test.toString(sb);
        sb.append(')');
    }

    @Override
    public boolean mustEnter() {
        if (this.isDoWhile()) {
            return true;
        }
        return this.test == null;
    }
}

