/*
 * Decompiled with CFR 0.152.
 */
package jdk.nashorn.internal.ir;

import java.util.Arrays;
import java.util.List;
import jdk.nashorn.internal.codegen.Label;
import jdk.nashorn.internal.ir.Block;
import jdk.nashorn.internal.ir.BreakableStatement;
import jdk.nashorn.internal.ir.Expression;
import jdk.nashorn.internal.ir.LexicalContext;
import jdk.nashorn.internal.ir.Node;

public abstract class LoopNode
extends BreakableStatement {
    protected final Label continueLabel;
    protected final Expression test;
    protected final Block body;
    protected final boolean controlFlowEscapes;

    protected LoopNode(int lineNumber, long token, int finish, Expression test, Block body, boolean controlFlowEscapes) {
        super(lineNumber, token, finish, new Label("while_break"));
        this.continueLabel = new Label("while_continue");
        this.test = test;
        this.body = body;
        this.controlFlowEscapes = controlFlowEscapes;
    }

    protected LoopNode(LoopNode loopNode, Expression test, Block body, boolean controlFlowEscapes) {
        super(loopNode);
        this.continueLabel = new Label(loopNode.continueLabel);
        this.test = test;
        this.body = body;
        this.controlFlowEscapes = controlFlowEscapes;
    }

    @Override
    public abstract Node ensureUniqueLabels(LexicalContext var1);

    public boolean controlFlowEscapes() {
        return this.controlFlowEscapes;
    }

    @Override
    public boolean isTerminal() {
        if (!this.mustEnter()) {
            return false;
        }
        if (this.controlFlowEscapes) {
            return false;
        }
        if (this.body.isTerminal()) {
            return true;
        }
        return this.test == null;
    }

    public abstract boolean mustEnter();

    public Label getContinueLabel() {
        return this.continueLabel;
    }

    @Override
    public List<Label> getLabels() {
        return Arrays.asList(this.breakLabel, this.continueLabel);
    }

    @Override
    public boolean isLoop() {
        return true;
    }

    public abstract Block getBody();

    public abstract LoopNode setBody(LexicalContext var1, Block var2);

    public abstract Expression getTest();

    public abstract LoopNode setTest(LexicalContext var1, Expression var2);

    public abstract LoopNode setControlFlowEscapes(LexicalContext var1, boolean var2);
}

