/*
 * Decompiled with CFR 0.152.
 */
package jdk.nashorn.internal.codegen;

import java.io.PrintStream;
import java.lang.reflect.Array;
import java.util.EnumSet;
import java.util.List;
import jdk.internal.dynalink.support.NameCodec;
import jdk.internal.org.objectweb.asm.Handle;
import jdk.internal.org.objectweb.asm.MethodVisitor;
import jdk.nashorn.internal.codegen.ClassEmitter;
import jdk.nashorn.internal.codegen.CompilerConstants;
import jdk.nashorn.internal.codegen.Condition;
import jdk.nashorn.internal.codegen.Emitter;
import jdk.nashorn.internal.codegen.Label;
import jdk.nashorn.internal.codegen.RuntimeCallSite;
import jdk.nashorn.internal.codegen.types.ArrayType;
import jdk.nashorn.internal.codegen.types.BitwiseType;
import jdk.nashorn.internal.codegen.types.NumericType;
import jdk.nashorn.internal.codegen.types.Type;
import jdk.nashorn.internal.ir.FunctionNode;
import jdk.nashorn.internal.ir.IdentNode;
import jdk.nashorn.internal.ir.LexicalContext;
import jdk.nashorn.internal.ir.LiteralNode;
import jdk.nashorn.internal.ir.RuntimeNode;
import jdk.nashorn.internal.ir.Symbol;
import jdk.nashorn.internal.runtime.ArgumentSetter;
import jdk.nashorn.internal.runtime.Debug;
import jdk.nashorn.internal.runtime.DebugLogger;
import jdk.nashorn.internal.runtime.JSType;
import jdk.nashorn.internal.runtime.ScriptEnvironment;
import jdk.nashorn.internal.runtime.ScriptObject;
import jdk.nashorn.internal.runtime.linker.Bootstrap;
import jdk.nashorn.internal.runtime.options.Options;

public class MethodEmitter
implements Emitter {
    private final MethodVisitor method;
    private Label.Stack stack;
    private final ClassEmitter classEmitter;
    protected FunctionNode functionNode;
    private boolean hasReturn;
    private final ScriptEnvironment env;
    static final int LARGE_STRING_THRESHOLD = 32768;
    private static final DebugLogger LOG = new DebugLogger("codegen", "nashorn.codegen.debug");
    private static final boolean DEBUG = LOG.isEnabled();
    private static final int DEBUG_TRACE_LINE;
    private static final Handle LINKERBOOTSTRAP;
    private static final Handle RUNTIMEBOOTSTRAP;
    private final CompilerConstants.FieldAccess ERR_STREAM = CompilerConstants.staticField(System.class, "err", PrintStream.class);
    private final CompilerConstants.Call PRINT = CompilerConstants.virtualCallNoLookup(PrintStream.class, "print", Void.TYPE, Object.class);
    private final CompilerConstants.Call PRINTLN = CompilerConstants.virtualCallNoLookup(PrintStream.class, "println", Void.TYPE, Object.class);
    private final CompilerConstants.Call PRINT_STACKTRACE = CompilerConstants.virtualCallNoLookup(Throwable.class, "printStackTrace", Void.TYPE, new Class[0]);
    private static int linePrefix;

    MethodEmitter(ClassEmitter classEmitter, MethodVisitor method) {
        this(classEmitter, method, null);
    }

    MethodEmitter(ClassEmitter classEmitter, MethodVisitor method, FunctionNode functionNode) {
        this.env = classEmitter.getEnv();
        this.classEmitter = classEmitter;
        this.method = method;
        this.functionNode = functionNode;
        this.stack = null;
    }

    @Override
    public void begin() {
        this.classEmitter.beginMethod(this);
        this.newStack();
        this.method.visitCode();
    }

    @Override
    public void end() {
        this.method.visitMaxs(0, 0);
        this.method.visitEnd();
        this.classEmitter.endMethod(this);
    }

    private void newStack() {
        this.stack = new Label.Stack();
    }

    public String toString() {
        return "methodEmitter: " + (this.functionNode == null ? this.method : this.functionNode.getName()).toString() + ' ' + Debug.id(this);
    }

    private void pushType(Type type) {
        if (type != null) {
            this.stack.push(type);
        }
    }

    private Type popType(Type expected) {
        Type type = this.stack.pop();
        assert (type.isObject() && expected.isObject() || type.isEquivalentTo(expected)) : type + " is not compatible with " + expected;
        return type;
    }

    private Type popType() {
        return this.stack.pop();
    }

    private NumericType popNumeric() {
        Type type = this.stack.pop();
        assert (type.isNumeric()) : type + " is not numeric";
        return (NumericType)type;
    }

    private BitwiseType popInteger() {
        Type type = this.stack.pop();
        assert (type.isInteger() || type.isLong()) : type + " is not an integer or long";
        return (BitwiseType)type;
    }

    private ArrayType popArray() {
        Type type = this.stack.pop();
        assert (type.isArray()) : type;
        return (ArrayType)type;
    }

    final Type peekType(int pos) {
        return this.stack.peek(pos);
    }

    final Type peekType() {
        return this.stack.peek();
    }

    MethodEmitter _new(String classDescriptor) {
        this.debug("new", classDescriptor);
        this.method.visitTypeInsn(187, classDescriptor);
        this.pushType(Type.OBJECT);
        return this;
    }

    MethodEmitter _new(Class<?> clazz) {
        return this._new(CompilerConstants.className(clazz));
    }

    MethodEmitter newInstance(Class<?> clazz) {
        return this.invoke(CompilerConstants.constructorNoLookup(clazz));
    }

    MethodEmitter dup(int depth) {
        if (this.peekType().dup(this.method, depth) == null) {
            return null;
        }
        this.debug("dup", depth);
        switch (depth) {
            case 0: {
                this.pushType(this.peekType());
                break;
            }
            case 1: {
                Type p0 = this.popType();
                Type p1 = this.popType();
                this.pushType(p0);
                this.pushType(p1);
                this.pushType(p0);
                break;
            }
            case 2: {
                Type p0 = this.popType();
                Type p1 = this.popType();
                Type p2 = this.popType();
                this.pushType(p0);
                this.pushType(p2);
                this.pushType(p1);
                this.pushType(p0);
                break;
            }
            default: {
                assert (false) : "illegal dup depth = " + depth;
                return null;
            }
        }
        return this;
    }

    MethodEmitter dup2() {
        this.debug("dup2");
        if (this.peekType().isCategory2()) {
            this.pushType(this.peekType());
        } else {
            Type type = this.get2();
            this.pushType(type);
            this.pushType(type);
            this.pushType(type);
            this.pushType(type);
        }
        this.method.visitInsn(92);
        return this;
    }

    MethodEmitter dup() {
        return this.dup(0);
    }

    MethodEmitter pop() {
        this.debug("pop", this.peekType());
        this.popType().pop(this.method);
        return this;
    }

    MethodEmitter pop2() {
        if (this.peekType().isCategory2()) {
            this.popType();
        } else {
            this.get2n();
        }
        return this;
    }

    MethodEmitter swap() {
        this.debug("swap");
        Type p0 = this.popType();
        Type p1 = this.popType();
        p0.swap(this.method, p1);
        this.pushType(p0);
        this.pushType(p1);
        this.debug("after ", p0, p1);
        return this;
    }

    void localVariable(Symbol symbol, Label start, Label end) {
        if (!symbol.hasSlot()) {
            return;
        }
        String name = symbol.getName();
        if (name.equals(CompilerConstants.THIS.symbolName())) {
            name = CompilerConstants.THIS_DEBUGGER.symbolName();
        }
        this.method.visitLocalVariable(name, symbol.getSymbolType().getDescriptor(), null, start.getLabel(), end.getLabel(), symbol.getSlot());
    }

    MethodEmitter newStringBuilder() {
        return this.invoke(CompilerConstants.constructorNoLookup(StringBuilder.class)).dup();
    }

    MethodEmitter stringBuilderAppend() {
        this.convert(Type.STRING);
        return this.invoke(CompilerConstants.virtualCallNoLookup(StringBuilder.class, "append", StringBuilder.class, String.class));
    }

    MethodEmitter and() {
        this.debug("and");
        this.pushType(this.get2i().and(this.method));
        return this;
    }

    MethodEmitter or() {
        this.debug("or");
        this.pushType(this.get2i().or(this.method));
        return this;
    }

    MethodEmitter xor() {
        this.debug("xor");
        this.pushType(this.get2i().xor(this.method));
        return this;
    }

    MethodEmitter shr() {
        this.debug("shr");
        this.popType(Type.INT);
        this.pushType(this.popInteger().shr(this.method));
        return this;
    }

    MethodEmitter shl() {
        this.debug("shl");
        this.popType(Type.INT);
        this.pushType(this.popInteger().shl(this.method));
        return this;
    }

    MethodEmitter sar() {
        this.debug("sar");
        this.popType(Type.INT);
        this.pushType(this.popInteger().sar(this.method));
        return this;
    }

    MethodEmitter neg() {
        this.debug("neg");
        this.pushType(this.popNumeric().neg(this.method));
        return this;
    }

    void _catch(Label recovery) {
        this.stack.clear();
        this.stack.push(Type.OBJECT);
        this.label(recovery);
    }

    void _try(Label entry, Label exit, Label recovery, String typeDescriptor) {
        this.method.visitTryCatchBlock(entry.getLabel(), exit.getLabel(), recovery.getLabel(), typeDescriptor);
    }

    void _try(Label entry, Label exit, Label recovery, Class<?> clazz) {
        this.method.visitTryCatchBlock(entry.getLabel(), exit.getLabel(), recovery.getLabel(), CompilerConstants.className(clazz));
    }

    void _try(Label entry, Label exit, Label recovery) {
        this._try(entry, exit, recovery, (String)null);
    }

    MethodEmitter loadConstants() {
        this.getStatic(this.classEmitter.getUnitClassName(), CompilerConstants.CONSTANTS.symbolName(), CompilerConstants.CONSTANTS.descriptor());
        assert (this.peekType().isArray()) : this.peekType();
        return this;
    }

    MethodEmitter loadUndefined(Type type) {
        this.debug("load undefined ", type);
        this.pushType(type.loadUndefined(this.method));
        return this;
    }

    MethodEmitter loadEmpty(Type type) {
        this.debug("load empty ", type);
        this.pushType(type.loadEmpty(this.method));
        return this;
    }

    MethodEmitter loadNull() {
        this.debug("aconst_null");
        this.pushType(Type.OBJECT.ldc(this.method, null));
        return this;
    }

    MethodEmitter loadType(String className) {
        this.debug("load type", className);
        this.method.visitLdcInsn(jdk.internal.org.objectweb.asm.Type.getObjectType(className));
        this.pushType(Type.OBJECT);
        return this;
    }

    MethodEmitter load(boolean b) {
        this.debug("load boolean", b);
        this.pushType(Type.BOOLEAN.ldc(this.method, b));
        return this;
    }

    MethodEmitter load(int i) {
        this.debug("load int", i);
        this.pushType(Type.INT.ldc(this.method, i));
        return this;
    }

    MethodEmitter load(double d) {
        this.debug("load double", d);
        this.pushType(Type.NUMBER.ldc(this.method, d));
        return this;
    }

    MethodEmitter load(long l) {
        this.debug("load long", l);
        this.pushType(Type.LONG.ldc(this.method, l));
        return this;
    }

    MethodEmitter arraylength() {
        this.debug("arraylength");
        this.popType(Type.OBJECT);
        this.pushType(Type.OBJECT_ARRAY.arraylength(this.method));
        return this;
    }

    MethodEmitter load(String s) {
        this.debug("load string", s);
        if (s == null) {
            this.loadNull();
            return this;
        }
        int length = s.length();
        if (length > 32768) {
            this._new(StringBuilder.class);
            this.dup();
            this.load(length);
            this.invoke(CompilerConstants.constructorNoLookup(StringBuilder.class, Integer.TYPE));
            for (int n = 0; n < length; n += 32768) {
                String part = s.substring(n, Math.min(n + 32768, length));
                this.load(part);
                this.stringBuilderAppend();
            }
            this.invoke(CompilerConstants.virtualCallNoLookup(StringBuilder.class, "toString", String.class, new Class[0]));
            return this;
        }
        this.pushType(Type.OBJECT.ldc(this.method, s));
        return this;
    }

    MethodEmitter load(Symbol symbol) {
        assert (symbol != null);
        if (symbol.hasSlot()) {
            int slot = symbol.getSlot();
            this.debug("load symbol", symbol.getName(), " slot=", slot);
            Type type = symbol.getSymbolType().load(this.method, slot);
            this.pushType(type == Type.OBJECT && symbol.isThis() ? Type.THIS : type);
        } else if (symbol.isParam()) {
            assert (!symbol.isScope());
            assert (this.functionNode.isVarArg()) : "Non-vararg functions have slotted parameters";
            int index = symbol.getFieldIndex();
            if (this.functionNode.needsArguments()) {
                this.debug("load symbol", symbol.getName(), " arguments index=", index);
                this.loadCompilerConstant(CompilerConstants.ARGUMENTS);
                this.load(index);
                ScriptObject.GET_ARGUMENT.invoke(this);
            } else {
                this.debug("load symbol", symbol.getName(), " array index=", index);
                this.loadCompilerConstant(CompilerConstants.VARARGS);
                this.load(symbol.getFieldIndex());
                this.arrayload();
            }
        }
        return this;
    }

    MethodEmitter load(Type type, int slot) {
        this.debug("explicit load", type, slot);
        Type loadType = type.load(this.method, slot);
        this.pushType(loadType == Type.OBJECT && this.isThisSlot(slot) ? Type.THIS : loadType);
        return this;
    }

    private boolean isThisSlot(int slot) {
        if (this.functionNode == null) {
            return slot == CompilerConstants.JAVA_THIS.slot();
        }
        int thisSlot = this.compilerConstant(CompilerConstants.THIS).getSlot();
        assert (!this.functionNode.needsCallee() || thisSlot == 1);
        assert (this.functionNode.needsCallee() || thisSlot == 0);
        return slot == thisSlot;
    }

    MethodEmitter loadHandle(String className, String methodName, String descName, EnumSet<ClassEmitter.Flag> flags) {
        this.debug("load handle ");
        this.pushType(Type.OBJECT.ldc(this.method, new Handle(ClassEmitter.Flag.getValue(flags), className, methodName, descName)));
        return this;
    }

    private Symbol compilerConstant(CompilerConstants cc) {
        return this.functionNode.getBody().getExistingSymbol(cc.symbolName());
    }

    boolean hasScope() {
        return this.compilerConstant(CompilerConstants.SCOPE).hasSlot();
    }

    MethodEmitter loadCompilerConstant(CompilerConstants cc) {
        Symbol symbol = this.compilerConstant(cc);
        if (cc == CompilerConstants.SCOPE && this.peekType() == Type.SCOPE) {
            this.dup();
            return this;
        }
        return this.load(symbol);
    }

    void storeCompilerConstant(CompilerConstants cc) {
        Symbol symbol = this.compilerConstant(cc);
        this.debug("store compiler constant ", symbol);
        this.store(symbol);
    }

    MethodEmitter arrayload() {
        this.debug("Xaload");
        this.popType(Type.INT);
        this.pushType(this.popArray().aload(this.method));
        return this;
    }

    void arraystore() {
        this.debug("Xastore");
        Type value = this.popType();
        Type index = this.popType(Type.INT);
        assert (index.isInteger()) : "array index is not integer, but " + index;
        ArrayType array = this.popArray();
        assert (value.isEquivalentTo(array.getElementType())) : "Storing " + value + " into " + array;
        assert (array.isObject());
        array.astore(this.method);
    }

    void store(Symbol symbol) {
        assert (symbol != null) : "No symbol to store";
        if (symbol.hasSlot()) {
            int slot = symbol.getSlot();
            this.debug("store symbol", symbol.getName(), " slot=", slot);
            this.popType(symbol.getSymbolType()).store(this.method, slot);
        } else if (symbol.isParam()) {
            assert (!symbol.isScope());
            assert (this.functionNode.isVarArg()) : "Non-vararg functions have slotted parameters";
            int index = symbol.getFieldIndex();
            if (this.functionNode.needsArguments()) {
                this.debug("store symbol", symbol.getName(), " arguments index=", index);
                this.loadCompilerConstant(CompilerConstants.ARGUMENTS);
                this.load(index);
                ArgumentSetter.SET_ARGUMENT.invoke(this);
            } else {
                this.debug("store symbol", symbol.getName(), " array index=", index);
                this.loadCompilerConstant(CompilerConstants.VARARGS);
                this.load(index);
                ArgumentSetter.SET_ARRAY_ELEMENT.invoke(this);
            }
        }
    }

    void store(Type type, int slot) {
        this.popType(type);
        type.store(this.method, slot);
    }

    void iinc(int slot, int increment) {
        this.debug("iinc");
        this.method.visitIincInsn(slot, increment);
    }

    public void athrow() {
        this.debug("athrow");
        Type receiver = this.popType(Type.OBJECT);
        assert (receiver.isObject());
        this.method.visitInsn(191);
        this.stack = null;
    }

    MethodEmitter _instanceof(String classDescriptor) {
        this.debug("instanceof", classDescriptor);
        this.popType(Type.OBJECT);
        this.method.visitTypeInsn(193, classDescriptor);
        this.pushType(Type.INT);
        return this;
    }

    MethodEmitter _instanceof(Class<?> clazz) {
        return this._instanceof(CompilerConstants.className(clazz));
    }

    MethodEmitter checkcast(String classDescriptor) {
        this.debug("checkcast", classDescriptor);
        assert (this.peekType().isObject());
        this.method.visitTypeInsn(192, classDescriptor);
        return this;
    }

    MethodEmitter checkcast(Class<?> clazz) {
        return this.checkcast(CompilerConstants.className(clazz));
    }

    MethodEmitter newarray(ArrayType arrayType) {
        this.debug("newarray ", "arrayType=", arrayType);
        this.popType(Type.INT);
        this.pushType(arrayType.newarray(this.method));
        return this;
    }

    MethodEmitter multinewarray(ArrayType arrayType, int dims) {
        this.debug("multianewarray ", arrayType, dims);
        for (int i = 0; i < dims; ++i) {
            this.popType(Type.INT);
        }
        this.pushType(arrayType.newarray(this.method, dims));
        return this;
    }

    private Type fixParamStack(String signature) {
        Type[] params = Type.getMethodArguments(signature);
        for (int i = params.length - 1; i >= 0; --i) {
            this.popType(params[i]);
        }
        Type returnType = Type.getMethodReturnType(signature);
        return returnType;
    }

    MethodEmitter invoke(CompilerConstants.Call call) {
        return call.invoke(this);
    }

    private MethodEmitter invoke(int opcode, String className, String methodName, String methodDescriptor, boolean hasReceiver) {
        Type returnType = this.fixParamStack(methodDescriptor);
        if (hasReceiver) {
            this.popType(Type.OBJECT);
        }
        if (opcode == 185) {
            this.method.visitMethodInsn(opcode, className, methodName, methodDescriptor, true);
        } else {
            this.method.visitMethodInsn(opcode, className, methodName, methodDescriptor, false);
        }
        if (returnType != null) {
            this.pushType(returnType);
        }
        return this;
    }

    MethodEmitter invokespecial(String className, String methodName, String methodDescriptor) {
        this.debug("invokespecial", className, ".", methodName, methodDescriptor);
        return this.invoke(183, className, methodName, methodDescriptor, true);
    }

    MethodEmitter invokevirtual(String className, String methodName, String methodDescriptor) {
        this.debug("invokevirtual", className, ".", methodName, methodDescriptor, " ", this.stack);
        return this.invoke(182, className, methodName, methodDescriptor, true);
    }

    MethodEmitter invokestatic(String className, String methodName, String methodDescriptor) {
        this.debug("invokestatic", className, ".", methodName, methodDescriptor);
        this.invoke(184, className, methodName, methodDescriptor, false);
        return this;
    }

    MethodEmitter invokeStatic(String className, String methodName, String methodDescriptor, Type returnType) {
        this.invokestatic(className, methodName, methodDescriptor);
        this.popType();
        this.pushType(returnType);
        return this;
    }

    MethodEmitter invokeinterface(String className, String methodName, String methodDescriptor) {
        this.debug("invokeinterface", className, ".", methodName, methodDescriptor);
        return this.invoke(185, className, methodName, methodDescriptor, true);
    }

    static jdk.internal.org.objectweb.asm.Label[] getLabels(Label ... table) {
        jdk.internal.org.objectweb.asm.Label[] internalLabels = new jdk.internal.org.objectweb.asm.Label[table.length];
        for (int i = 0; i < table.length; ++i) {
            internalLabels[i] = table[i].getLabel();
        }
        return internalLabels;
    }

    void lookupswitch(Label defaultLabel, int[] values, Label ... table) {
        this.debug("lookupswitch", this.peekType());
        this.popType(Type.INT);
        this.method.visitLookupSwitchInsn(defaultLabel.getLabel(), values, MethodEmitter.getLabels(table));
    }

    void tableswitch(int lo, int hi, Label defaultLabel, Label ... table) {
        this.debug("tableswitch", this.peekType());
        this.popType(Type.INT);
        this.method.visitTableSwitchInsn(lo, hi, defaultLabel.getLabel(), MethodEmitter.getLabels(table));
    }

    void conditionalJump(Condition cond, Label trueLabel) {
        this.conditionalJump(cond, cond != Condition.GT && cond != Condition.GE, trueLabel);
    }

    void conditionalJump(Condition cond, boolean isCmpG, Label trueLabel) {
        if (this.peekType().isCategory2()) {
            this.debug("[ld]cmp isCmpG=", isCmpG);
            this.pushType(this.get2n().cmp(this.method, isCmpG));
            this.jump(Condition.toUnary(cond), trueLabel, 1);
        } else {
            this.debug(new Object[]{"if", cond});
            this.jump(Condition.toBinary(cond, this.peekType().isObject()), trueLabel, 2);
        }
    }

    MethodEmitter registerReturn() {
        this.setHasReturn();
        return this;
    }

    void setHasReturn() {
        this.hasReturn = true;
    }

    void _return(Type type) {
        this.debug("return", type);
        assert (this.stack.size() == 1) : "Only return value on stack allowed at return point - depth=" + this.stack.size() + " stack = " + this.stack;
        Type stackType = this.peekType();
        if (!Type.areEquivalent(type, stackType)) {
            this.convert(type);
        }
        this.popType(type)._return(this.method);
        this.stack = null;
    }

    void _return() {
        this._return(this.peekType());
    }

    void returnVoid() {
        this.debug("return [void]");
        assert (this.stack.isEmpty()) : this.stack;
        this.method.visitInsn(177);
        this.stack = null;
    }

    void splitAwareGoto(LexicalContext lc, Label label) {
        this._goto(label);
    }

    MethodEmitter cmp(boolean isCmpG) {
        this.pushType(this.get2n().cmp(this.method, isCmpG));
        return this;
    }

    private void jump(int opcode, Label label, int n) {
        for (int i = 0; i < n; ++i) {
            assert (this.peekType().isInteger() || this.peekType().isBoolean() || this.peekType().isObject()) : "expecting integer type or object for jump, but found " + this.peekType();
            this.popType();
        }
        this.mergeStackTo(label);
        this.method.visitJumpInsn(opcode, label.getLabel());
    }

    void if_acmpeq(Label label) {
        this.debug("if_acmpeq", label);
        this.jump(165, label, 2);
    }

    void if_acmpne(Label label) {
        this.debug("if_acmpne", label);
        this.jump(166, label, 2);
    }

    void ifnull(Label label) {
        this.debug("ifnull", label);
        this.jump(198, label, 1);
    }

    void ifnonnull(Label label) {
        this.debug("ifnonnull", label);
        this.jump(199, label, 1);
    }

    void ifeq(Label label) {
        this.debug("ifeq ", label);
        this.jump(153, label, 1);
    }

    void if_icmpeq(Label label) {
        this.debug("if_icmpeq", label);
        this.jump(159, label, 2);
    }

    void ifne(Label label) {
        this.debug("ifne", label);
        this.jump(154, label, 1);
    }

    void if_icmpne(Label label) {
        this.debug("if_icmpne", label);
        this.jump(160, label, 2);
    }

    void iflt(Label label) {
        this.debug("iflt", label);
        this.jump(155, label, 1);
    }

    void ifle(Label label) {
        this.debug("ifle", label);
        this.jump(158, label, 1);
    }

    void ifgt(Label label) {
        this.debug("ifgt", label);
        this.jump(157, label, 1);
    }

    void ifge(Label label) {
        this.debug("ifge", label);
        this.jump(156, label, 1);
    }

    void _goto(Label label) {
        this.jump(167, label, 0);
        this.stack = null;
    }

    private void mergeStackTo(Label label) {
        assert (this.stack != null) : label + " entered with no stack. deadcode that remains?";
        Label.Stack labelStack = label.getStack();
        if (labelStack == null) {
            label.setStack(this.stack.copy());
            return;
        }
        assert (this.stack.isEquivalentTo(labelStack)) : "stacks " + this.stack + " is not equivalent with " + labelStack + " at join point";
    }

    void label(Label label) {
        if (this.stack == null) {
            this.stack = label.getStack();
            if (this.stack == null) {
                this.newStack();
            }
        }
        this.debug_label(label);
        this.mergeStackTo(label);
        this.method.visitLabel(label.getLabel());
    }

    MethodEmitter convert(Type to) {
        Type type = this.peekType().convert(this.method, to);
        if (type != null) {
            if (!this.peekType().isEquivalentTo(to)) {
                this.debug("convert", this.peekType(), "->", to);
            }
            this.popType();
            this.pushType(type);
        }
        return this;
    }

    private Type get2() {
        Type p0 = this.popType();
        Type p1 = this.popType();
        assert (p0.isEquivalentTo(p1)) : "expecting equivalent types on stack but got " + p0 + " and " + p1;
        return p0;
    }

    private BitwiseType get2i() {
        BitwiseType p0 = this.popInteger();
        BitwiseType p1 = this.popInteger();
        assert (p0.isEquivalentTo(p1)) : "expecting equivalent types on stack but got " + p0 + " and " + p1;
        return p0;
    }

    private NumericType get2n() {
        NumericType p0 = this.popNumeric();
        NumericType p1 = this.popNumeric();
        assert (p0.isEquivalentTo(p1)) : "expecting equivalent types on stack but got " + p0 + " and " + p1;
        return p0;
    }

    MethodEmitter add() {
        this.debug("add");
        this.pushType(this.get2().add(this.method));
        return this;
    }

    MethodEmitter sub() {
        this.debug("sub");
        this.pushType(this.get2n().sub(this.method));
        return this;
    }

    MethodEmitter mul() {
        this.debug("mul ");
        this.pushType(this.get2n().mul(this.method));
        return this;
    }

    MethodEmitter div() {
        this.debug("div");
        this.pushType(this.get2n().div(this.method));
        return this;
    }

    MethodEmitter rem() {
        this.debug("rem");
        this.pushType(this.get2n().rem(this.method));
        return this;
    }

    protected Type[] getTypesFromStack(int count) {
        Type[] types = new Type[count];
        int pos = 0;
        for (int i = count - 1; i >= 0; --i) {
            types[i] = this.stack.peek(pos++);
        }
        return types;
    }

    private String getDynamicSignature(Type returnType, int argCount) {
        Type[] paramTypes = new Type[argCount];
        int pos = 0;
        for (int i = argCount - 1; i >= 0; --i) {
            paramTypes[i] = this.stack.peek(pos++);
        }
        String descriptor = Type.getMethodDescriptor(returnType, paramTypes);
        for (int i = 0; i < argCount; ++i) {
            this.popType(paramTypes[argCount - i - 1]);
        }
        return descriptor;
    }

    MethodEmitter dynamicNew(int argCount, int flags) {
        this.debug("dynamic_new", "argcount=", argCount);
        String signature = this.getDynamicSignature(Type.OBJECT, argCount);
        this.method.visitInvokeDynamicInsn("dyn:new", signature, LINKERBOOTSTRAP, flags);
        this.pushType(Type.OBJECT);
        return this;
    }

    MethodEmitter dynamicCall(Type returnType, int argCount, int flags) {
        this.debug("dynamic_call", "args=", argCount, "returnType=", returnType);
        String signature = this.getDynamicSignature(returnType, argCount);
        this.debug("   signature", signature);
        this.method.visitInvokeDynamicInsn("dyn:call", signature, LINKERBOOTSTRAP, flags);
        this.pushType(returnType);
        return this;
    }

    MethodEmitter dynamicRuntimeCall(String name, Type returnType, RuntimeNode.Request request) {
        this.debug("dynamic_runtime_call", name, "args=", request.getArity(), "returnType=", returnType);
        String signature = this.getDynamicSignature(returnType, request.getArity());
        this.debug("   signature", signature);
        this.method.visitInvokeDynamicInsn(name, signature, RUNTIMEBOOTSTRAP, new Object[0]);
        this.pushType(returnType);
        return this;
    }

    MethodEmitter dynamicGet(Type valueType, String name, int flags, boolean isMethod) {
        this.debug("dynamic_get", name, valueType);
        Type type = valueType;
        if (type.isObject() || type.isBoolean()) {
            type = Type.OBJECT;
        }
        this.popType(Type.SCOPE);
        this.method.visitInvokeDynamicInsn((isMethod ? "dyn:getMethod|getProp|getElem:" : "dyn:getProp|getElem|getMethod:") + NameCodec.encode(name), Type.getMethodDescriptor(type, Type.OBJECT), LINKERBOOTSTRAP, flags);
        this.pushType(type);
        this.convert(valueType);
        return this;
    }

    void dynamicSet(String name, int flags) {
        this.debug("dynamic_set", name, this.peekType());
        Type type = this.peekType();
        if (type.isObject() || type.isBoolean()) {
            type = Type.OBJECT;
            this.convert(Type.OBJECT);
        }
        this.popType(type);
        this.popType(Type.SCOPE);
        this.method.visitInvokeDynamicInsn("dyn:setProp|setElem:" + NameCodec.encode(name), CompilerConstants.methodDescriptor(Void.TYPE, Object.class, type.getTypeClass()), LINKERBOOTSTRAP, flags);
    }

    MethodEmitter dynamicGetIndex(Type result, int flags, boolean isMethod) {
        Type index;
        this.debug("dynamic_get_index", this.peekType(1), "[", this.peekType(), "]");
        Type resultType = result;
        if (result.isBoolean()) {
            resultType = Type.OBJECT;
        }
        if ((index = this.peekType()).isObject() || index.isBoolean()) {
            index = Type.OBJECT;
            this.convert(Type.OBJECT);
        }
        this.popType();
        this.popType(Type.OBJECT);
        String signature = Type.getMethodDescriptor(resultType, Type.OBJECT, index);
        this.method.visitInvokeDynamicInsn(isMethod ? "dyn:getMethod|getElem|getProp" : "dyn:getElem|getProp|getMethod", signature, LINKERBOOTSTRAP, flags);
        this.pushType(resultType);
        if (result.isBoolean()) {
            this.convert(Type.BOOLEAN);
        }
        return this;
    }

    void dynamicSetIndex(int flags) {
        this.debug("dynamic_set_index", this.peekType(2), "[", this.peekType(1), "] =", this.peekType());
        Type value = this.peekType();
        if (value.isObject() || value.isBoolean()) {
            value = Type.OBJECT;
            this.convert(Type.OBJECT);
        }
        this.popType();
        Type index = this.peekType();
        if (index.isObject() || index.isBoolean()) {
            index = Type.OBJECT;
            this.convert(Type.OBJECT);
        }
        this.popType(index);
        Type receiver = this.popType(Type.OBJECT);
        assert (receiver.isObject());
        this.method.visitInvokeDynamicInsn("dyn:setElem|setProp", CompilerConstants.methodDescriptor(Void.TYPE, receiver.getTypeClass(), index.getTypeClass(), value.getTypeClass()), LINKERBOOTSTRAP, flags);
    }

    MethodEmitter loadKey(Object key) {
        if (key instanceof IdentNode) {
            this.method.visitLdcInsn(((IdentNode)key).getName());
        } else if (key instanceof LiteralNode) {
            this.method.visitLdcInsn(((LiteralNode)key).getString());
        } else {
            this.method.visitLdcInsn(JSType.toString(key));
        }
        this.pushType(Type.OBJECT);
        return this;
    }

    private static Type fieldType(String desc) {
        switch (desc) {
            case "Z": 
            case "B": 
            case "C": 
            case "S": 
            case "I": {
                return Type.INT;
            }
            case "F": {
                assert (false);
            }
            case "D": {
                return Type.NUMBER;
            }
            case "J": {
                return Type.LONG;
            }
        }
        assert (desc.startsWith("[") || desc.startsWith("L")) : desc + " is not an object type";
        switch (desc.charAt(0)) {
            case 'L': {
                return Type.OBJECT;
            }
            case '[': {
                return Type.typeFor(Array.newInstance(MethodEmitter.fieldType(desc.substring(1)).getTypeClass(), 0).getClass());
            }
        }
        assert (false);
        return Type.OBJECT;
    }

    MethodEmitter getField(CompilerConstants.FieldAccess fa) {
        return fa.get(this);
    }

    void putField(CompilerConstants.FieldAccess fa) {
        fa.put(this);
    }

    MethodEmitter getField(String className, String fieldName, String fieldDescriptor) {
        this.debug("getfield", "receiver=", this.peekType(), className, ".", fieldName, fieldDescriptor);
        Type receiver = this.popType();
        assert (receiver.isObject());
        this.method.visitFieldInsn(180, className, fieldName, fieldDescriptor);
        this.pushType(MethodEmitter.fieldType(fieldDescriptor));
        return this;
    }

    MethodEmitter getStatic(String className, String fieldName, String fieldDescriptor) {
        this.debug("getstatic", className, ".", fieldName, ".", fieldDescriptor);
        this.method.visitFieldInsn(178, className, fieldName, fieldDescriptor);
        this.pushType(MethodEmitter.fieldType(fieldDescriptor));
        return this;
    }

    void putField(String className, String fieldName, String fieldDescriptor) {
        this.debug("putfield", "receiver=", this.peekType(1), "value=", this.peekType());
        this.popType(MethodEmitter.fieldType(fieldDescriptor));
        this.popType(Type.OBJECT);
        this.method.visitFieldInsn(181, className, fieldName, fieldDescriptor);
    }

    void putStatic(String className, String fieldName, String fieldDescriptor) {
        this.debug("putfield", "value=", this.peekType());
        this.popType(MethodEmitter.fieldType(fieldDescriptor));
        this.method.visitFieldInsn(179, className, fieldName, fieldDescriptor);
    }

    void lineNumber(int line) {
        if (this.env._debug_lines) {
            this.debug_label("[LINE]", line);
            jdk.internal.org.objectweb.asm.Label l = new jdk.internal.org.objectweb.asm.Label();
            this.method.visitLabel(l);
            this.method.visitLineNumber(line, l);
        }
    }

    void print() {
        this.getField(this.ERR_STREAM);
        this.swap();
        this.convert(Type.OBJECT);
        this.invoke(this.PRINT);
    }

    void println() {
        this.getField(this.ERR_STREAM);
        this.swap();
        this.convert(Type.OBJECT);
        this.invoke(this.PRINTLN);
    }

    void print(String string) {
        this.getField(this.ERR_STREAM);
        this.load(string);
        this.invoke(this.PRINT);
    }

    void println(String string) {
        this.getField(this.ERR_STREAM);
        this.load(string);
        this.invoke(this.PRINTLN);
    }

    void stacktrace() {
        this._new(Throwable.class);
        this.dup();
        this.invoke(CompilerConstants.constructorNoLookup(Throwable.class));
        this.invoke(this.PRINT_STACKTRACE);
    }

    private void debug(Object ... args) {
        if (DEBUG) {
            this.debug(30, args);
        }
    }

    private void debug_label(Object ... args) {
        if (DEBUG) {
            this.debug(22, args);
        }
    }

    private void debug(int padConstant, Object ... args) {
        if (DEBUG) {
            int pad;
            StringBuilder sb = new StringBuilder();
            sb.append('#');
            sb.append(++linePrefix);
            for (pad = 5 - sb.length(); pad > 0; --pad) {
                sb.append(' ');
            }
            if (this.stack != null && !this.stack.isEmpty()) {
                sb.append("{");
                sb.append(this.stack.size());
                sb.append(":");
                for (int pos = 0; pos < this.stack.size(); ++pos) {
                    Type t = this.stack.peek(pos);
                    if (t == Type.SCOPE) {
                        sb.append("scope");
                    } else if (t == Type.THIS) {
                        sb.append("this");
                    } else if (t.isObject()) {
                        int i;
                        String desc = t.getDescriptor();
                        for (i = 0; desc.charAt(i) == '[' && i < desc.length(); ++i) {
                            sb.append('[');
                        }
                        int slash = (desc = desc.substring(i)).lastIndexOf(47);
                        if (slash != -1) {
                            desc = desc.substring(slash + 1, desc.length() - 1);
                        }
                        if ("Object".equals(desc)) {
                            sb.append('O');
                        } else {
                            sb.append(desc);
                        }
                    } else {
                        sb.append(t.getDescriptor());
                    }
                    if (pos + 1 >= this.stack.size()) continue;
                    sb.append(' ');
                }
                sb.append('}');
                sb.append(' ');
            }
            for (pad = padConstant - sb.length(); pad > 0; --pad) {
                sb.append(' ');
            }
            for (Object arg : args) {
                sb.append(arg);
                sb.append(' ');
            }
            if (this.env != null) {
                LOG.info(sb);
                if (DEBUG_TRACE_LINE == linePrefix) {
                    new Throwable().printStackTrace(LOG.getOutputStream());
                }
            }
        }
    }

    void setFunctionNode(FunctionNode functionNode) {
        this.functionNode = functionNode;
    }

    boolean hasReturn() {
        return this.hasReturn;
    }

    List<Label> getExternalTargets() {
        return null;
    }

    static {
        String tl = Options.getStringProperty("nashorn.codegen.debug.trace", "-1");
        int line = -1;
        try {
            line = Integer.parseInt(tl);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        DEBUG_TRACE_LINE = line;
        LINKERBOOTSTRAP = new Handle(6, Bootstrap.BOOTSTRAP.className(), Bootstrap.BOOTSTRAP.name(), Bootstrap.BOOTSTRAP.descriptor());
        RUNTIMEBOOTSTRAP = new Handle(6, RuntimeCallSite.BOOTSTRAP.className(), RuntimeCallSite.BOOTSTRAP.name(), RuntimeCallSite.BOOTSTRAP.descriptor());
        linePrefix = 0;
    }
}

