/*
 * Decompiled with CFR 0.152.
 */
package jdk.internal.dynalink.linker;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.invoke.SwitchPoint;
import java.lang.invoke.WrongMethodTypeException;
import java.util.List;
import jdk.internal.dynalink.CallSiteDescriptor;
import jdk.internal.dynalink.linker.LinkerServices;
import jdk.internal.dynalink.support.Guards;

public class GuardedInvocation {
    private final MethodHandle invocation;
    private final MethodHandle guard;
    private final SwitchPoint switchPoint;

    public GuardedInvocation(MethodHandle invocation, MethodHandle guard) {
        this(invocation, guard, null);
    }

    public GuardedInvocation(MethodHandle invocation, MethodHandle guard, SwitchPoint switchPoint) {
        invocation.getClass();
        this.invocation = invocation;
        this.guard = guard;
        this.switchPoint = switchPoint;
    }

    public GuardedInvocation(MethodHandle invocation, SwitchPoint switchPoint, MethodHandle guard) {
        this(invocation, guard, switchPoint);
    }

    public MethodHandle getInvocation() {
        return this.invocation;
    }

    public MethodHandle getGuard() {
        return this.guard;
    }

    public SwitchPoint getSwitchPoint() {
        return this.switchPoint;
    }

    public boolean hasBeenInvalidated() {
        return this.switchPoint != null && this.switchPoint.hasBeenInvalidated();
    }

    public void assertType(MethodType type) {
        GuardedInvocation.assertType(this.invocation, type);
        if (this.guard != null) {
            GuardedInvocation.assertType(this.guard, type.changeReturnType(Boolean.TYPE));
        }
    }

    public GuardedInvocation replaceMethods(MethodHandle newInvocation, MethodHandle newGuard) {
        return new GuardedInvocation(newInvocation, newGuard, this.switchPoint);
    }

    private GuardedInvocation replaceMethodsOrThis(MethodHandle newInvocation, MethodHandle newGuard) {
        if (newInvocation == this.invocation && newGuard == this.guard) {
            return this;
        }
        return this.replaceMethods(newInvocation, newGuard);
    }

    public GuardedInvocation asType(MethodType newType) {
        return this.replaceMethodsOrThis(this.invocation.asType(newType), this.guard == null ? null : Guards.asType(this.guard, newType));
    }

    public GuardedInvocation asType(LinkerServices linkerServices, MethodType newType) {
        return this.replaceMethodsOrThis(linkerServices.asType(this.invocation, newType), this.guard == null ? null : Guards.asType(linkerServices, this.guard, newType));
    }

    public GuardedInvocation asType(CallSiteDescriptor desc) {
        return this.asType(desc.getMethodType());
    }

    public GuardedInvocation filterArguments(int pos, MethodHandle ... filters) {
        return this.replaceMethods(MethodHandles.filterArguments(this.invocation, pos, filters), this.guard == null ? null : MethodHandles.filterArguments(this.guard, pos, filters));
    }

    public GuardedInvocation dropArguments(int pos, List<Class<?>> valueTypes) {
        return this.replaceMethods(MethodHandles.dropArguments(this.invocation, pos, valueTypes), this.guard == null ? null : MethodHandles.dropArguments(this.guard, pos, valueTypes));
    }

    public GuardedInvocation dropArguments(int pos, Class<?> ... valueTypes) {
        return this.replaceMethods(MethodHandles.dropArguments(this.invocation, pos, valueTypes), this.guard == null ? null : MethodHandles.dropArguments(this.guard, pos, valueTypes));
    }

    public MethodHandle compose(MethodHandle fallback) {
        return this.compose(fallback, fallback);
    }

    public MethodHandle compose(MethodHandle switchpointFallback, MethodHandle guardFallback) {
        MethodHandle guarded = this.guard == null ? this.invocation : MethodHandles.guardWithTest(this.guard, this.invocation, guardFallback);
        return this.switchPoint == null ? guarded : this.switchPoint.guardWithTest(guarded, switchpointFallback);
    }

    private static void assertType(MethodHandle mh, MethodType type) {
        if (!mh.type().equals((Object)type)) {
            throw new WrongMethodTypeException("Expected type: " + type + " actual type: " + mh.type());
        }
    }
}

