/*
 * Decompiled with CFR 0.152.
 */
package javax.crypto;

import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.ProviderException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Iterator;
import java.util.List;
import javax.crypto.JceSecurity;
import javax.crypto.KeyAgreementSpi;
import javax.crypto.SecretKey;
import javax.crypto.ShortBufferException;
import sun.security.jca.GetInstance;
import sun.security.util.Debug;

public class KeyAgreement {
    private static final Debug debug = Debug.getInstance("jca", "KeyAgreement");
    private Provider provider;
    private KeyAgreementSpi spi;
    private final String algorithm;
    private Provider.Service firstService;
    private Iterator<Provider.Service> serviceIterator;
    private final Object lock;
    private static int warnCount = 10;
    private static final int I_NO_PARAMS = 1;
    private static final int I_PARAMS = 2;

    protected KeyAgreement(KeyAgreementSpi keyAgreementSpi, Provider provider, String string) {
        this.spi = keyAgreementSpi;
        this.provider = provider;
        this.algorithm = string;
        this.lock = null;
    }

    private KeyAgreement(Provider.Service service, Iterator<Provider.Service> iterator, String string) {
        this.firstService = service;
        this.serviceIterator = iterator;
        this.algorithm = string;
        this.lock = new Object();
    }

    public final String getAlgorithm() {
        return this.algorithm;
    }

    public static final KeyAgreement getInstance(String string) throws NoSuchAlgorithmException {
        List<Provider.Service> list = GetInstance.getServices("KeyAgreement", string);
        Iterator<Provider.Service> iterator = list.iterator();
        while (iterator.hasNext()) {
            Provider.Service service = iterator.next();
            if (!JceSecurity.canUseProvider(service.getProvider())) continue;
            return new KeyAgreement(service, iterator, string);
        }
        throw new NoSuchAlgorithmException("Algorithm " + string + " not available");
    }

    public static final KeyAgreement getInstance(String string, String string2) throws NoSuchAlgorithmException, NoSuchProviderException {
        GetInstance.Instance instance = JceSecurity.getInstance("KeyAgreement", KeyAgreementSpi.class, string, string2);
        return new KeyAgreement((KeyAgreementSpi)instance.impl, instance.provider, string);
    }

    public static final KeyAgreement getInstance(String string, Provider provider) throws NoSuchAlgorithmException {
        GetInstance.Instance instance = JceSecurity.getInstance("KeyAgreement", KeyAgreementSpi.class, string, provider);
        return new KeyAgreement((KeyAgreementSpi)instance.impl, instance.provider, string);
    }

    void chooseFirstProvider() {
        if (this.spi != null) {
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            Object object2;
            int n;
            if (this.spi != null) {
                return;
            }
            if (debug != null && (n = --warnCount) >= 0) {
                debug.println("KeyAgreement.init() not first method called, disabling delayed provider selection");
                if (n == 0) {
                    debug.println("Further warnings of this type will be suppressed");
                }
                new Exception("Call trace").printStackTrace();
            }
            Exception exception = null;
            while (this.firstService != null || this.serviceIterator.hasNext()) {
                if (this.firstService != null) {
                    object2 = this.firstService;
                    this.firstService = null;
                } else {
                    object2 = this.serviceIterator.next();
                }
                if (!JceSecurity.canUseProvider(((Provider.Service)object2).getProvider())) continue;
                try {
                    Object object3 = ((Provider.Service)object2).newInstance(null);
                    if (!(object3 instanceof KeyAgreementSpi)) continue;
                    this.spi = (KeyAgreementSpi)object3;
                    this.provider = ((Provider.Service)object2).getProvider();
                    this.firstService = null;
                    this.serviceIterator = null;
                    return;
                }
                catch (Exception exception2) {
                    exception = exception2;
                }
            }
            object2 = new ProviderException("Could not construct KeyAgreementSpi instance");
            if (exception != null) {
                ((Throwable)object2).initCause(exception);
            }
            throw object2;
        }
    }

    private void implInit(KeyAgreementSpi keyAgreementSpi, int n, Key key, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (n == 1) {
            keyAgreementSpi.engineInit(key, secureRandom);
        } else {
            keyAgreementSpi.engineInit(key, algorithmParameterSpec, secureRandom);
        }
    }

    private void chooseProvider(int n, Key key, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        Object object = this.lock;
        synchronized (object) {
            Object object2;
            if (this.spi != null) {
                this.implInit(this.spi, n, key, algorithmParameterSpec, secureRandom);
                return;
            }
            Exception exception = null;
            while (this.firstService != null || this.serviceIterator.hasNext()) {
                if (this.firstService != null) {
                    object2 = this.firstService;
                    this.firstService = null;
                } else {
                    object2 = this.serviceIterator.next();
                }
                if (!((Provider.Service)object2).supportsParameter(key) || !JceSecurity.canUseProvider(((Provider.Service)object2).getProvider())) continue;
                try {
                    KeyAgreementSpi keyAgreementSpi = (KeyAgreementSpi)((Provider.Service)object2).newInstance(null);
                    this.implInit(keyAgreementSpi, n, key, algorithmParameterSpec, secureRandom);
                    this.provider = ((Provider.Service)object2).getProvider();
                    this.spi = keyAgreementSpi;
                    this.firstService = null;
                    this.serviceIterator = null;
                    return;
                }
                catch (Exception exception2) {
                    if (exception != null) continue;
                    exception = exception2;
                }
            }
            if (exception instanceof InvalidKeyException) {
                throw (InvalidKeyException)exception;
            }
            if (exception instanceof InvalidAlgorithmParameterException) {
                throw (InvalidAlgorithmParameterException)exception;
            }
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            object2 = key != null ? key.getClass().getName() : "(null)";
            throw new InvalidKeyException("No installed provider supports this key: " + (String)object2, exception);
        }
    }

    public final Provider getProvider() {
        this.chooseFirstProvider();
        return this.provider;
    }

    public final void init(Key key) throws InvalidKeyException {
        this.init(key, JceSecurity.RANDOM);
    }

    public final void init(Key key, SecureRandom secureRandom) throws InvalidKeyException {
        if (this.spi != null) {
            this.spi.engineInit(key, secureRandom);
        } else {
            try {
                this.chooseProvider(1, key, null, secureRandom);
            }
            catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
                throw new InvalidKeyException(invalidAlgorithmParameterException);
            }
        }
    }

    public final void init(Key key, AlgorithmParameterSpec algorithmParameterSpec) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.init(key, algorithmParameterSpec, JceSecurity.RANDOM);
    }

    public final void init(Key key, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (this.spi != null) {
            this.spi.engineInit(key, algorithmParameterSpec, secureRandom);
        } else {
            this.chooseProvider(2, key, algorithmParameterSpec, secureRandom);
        }
    }

    public final Key doPhase(Key key, boolean bl) throws InvalidKeyException, IllegalStateException {
        this.chooseFirstProvider();
        return this.spi.engineDoPhase(key, bl);
    }

    public final byte[] generateSecret() throws IllegalStateException {
        this.chooseFirstProvider();
        return this.spi.engineGenerateSecret();
    }

    public final int generateSecret(byte[] byArray, int n) throws IllegalStateException, ShortBufferException {
        this.chooseFirstProvider();
        return this.spi.engineGenerateSecret(byArray, n);
    }

    public final SecretKey generateSecret(String string) throws IllegalStateException, NoSuchAlgorithmException, InvalidKeyException {
        this.chooseFirstProvider();
        return this.spi.engineGenerateSecret(string);
    }
}

