#! /usr/bin/python2
# -*- python -*-

# @HEADER
# ***********************************************************************
#
#          PyTrilinos: Python Interfaces to Trilinos Packages
#                 Copyright (2014) Sandia Corporation
#
# Under the terms of Contract DE-AC04-94AL85000 with Sandia
# Corporation, the U.S. Government retains certain rights in this
# software.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are
# met:
#
# 1. Redistributions of source code must retain the above copyright
# notice, this list of conditions and the following disclaimer.
#
# 2. Redistributions in binary form must reproduce the above copyright
# notice, this list of conditions and the following disclaimer in the
# documentation and/or other materials provided with the distribution.
#
# 3. Neither the name of the Corporation nor the names of the
# contributors may be used to endorse or promote products derived from
# this software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY SANDIA CORPORATION "AS IS" AND ANY
# EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
# PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL SANDIA CORPORATION OR THE
# CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
# EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
# PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
# PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
# LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
# NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
# SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#
# Questions? Contact William F. Spotz (wfspotz@sandia.gov)
#
# ***********************************************************************
# @HEADER

"""

PyTrilinos: A python interface to selected Trilinos packages.  This installation
  of PyTrilinos was built with the following python-wrapped packages enabled:

    Teuchos
    Epetra
    TriUtils
    Tpetra
    EpetraExt
    Isorropia
    Pliris
    AztecOO
    Galeri
    Amesos
    IFPACK
    Komplex
    Anasazi
    ML
    NOX
    LOCA

"""

# We need symbol names to be recognized across PyTrilinos extension modules.  On
# some systems, this requires that the dynamic library opener be given certain
# flags: runtime load now and runtime load global.  This has to be set before
# any PyTrilinos extension modules are loaded.  Unfortunately, the python module
# we want that contains the named values of these flags is called "dl" on some
# systems, "DLFCN" on others, and does not even exist on some.  The following
# logic loads the module into name "dl" if it exists and extracts the needed
# flags.  If the module we need does not exist, we use our best guess at what
# the flags values are.  After all this, the sys module setdlopenflags()
# function is called.
dl = None
try:
    import dl
except (SystemError, ImportError):
    try:
        import DLFCN as dl
    except (SystemError, ImportError):
        pass
if dl:
    dlopenflags = dl.RTLD_NOW | dl.RTLD_GLOBAL
    del dl
else:
    dlopenflags = 258
import sys
sys.setdlopenflags(dlopenflags)

# Set the __all__ special variable, a list of strings which define all of the
# PyTrilinos public names, namely the Trilinos packages that are enabled.
__all__ = ['Teuchos',
          'Epetra',
          'TriUtils',
          'Tpetra',
          'EpetraExt',
          'Isorropia',
          'Pliris',
          'AztecOO',
          'Galeri',
          'Amesos',
          'IFPACK',
          'Komplex',
          'Anasazi',
          'ML',
          'NOX',
          'LOCA',
          ]

# Versioning.  Set the __version__ special variable and define a version()
# function.
__version__ = '12.3;(;Dev;)'
def version():
    return 'Trilinos version: 12.6.2\nPyTrilinos version: ' + __version__

#
# Import utility class
from PropertyBase import PropertyBase
#
# Import the typed tuple factory and classes
from typed_tuple import *
#
# Import the typed dict factory
from typed_dict import *
