# This file was automatically generated by SWIG (http://www.swig.org).
# Version 3.0.12
#
# Do not make changes to this file unless you know what you are doing--modify
# the SWIG interface file instead.

"""

PyTrilinos.Teuchos is the python interface to the Trilinos tools and
utilities package Teuchos:

    http://trilinos.sandia.gov/packages/teuchos

The purpose of Teuchos is to provide a number of utilities often
needed by numerical applications, but that are not necessarily
numerical by nature.  The python version of the Teuchos package
supports the following classes:

    * SerialComm              - Serial communicator
    * MpiComm                 - MPI communicator
    * DefaultComm             - Default communicator facility
    * ParameterList           - List of arbitrarily-typed values,
                                keyed by strings
    * XMLObject               - Object-oriented interface to XML
                                objects
    * XMLParameterListReader  - ParameterList input from XML
    * XMLParameterListWriter  - ParameterList output to XML
    * XMLInputSource          - Base class for converting a stream
                                to XML
    * FileInputSource         - Class for converting file contents
                                to XML
    * StringInputSource       - Class for converting string contents
                                to XML
    * ScalarTraits            - Function factory for ScalarTraits<...>
                                classes
    * Time                    - Wall-clock timer class

The ParameterList class matches string keys to arbitrarily-typed
values.  In python, the Teuchos.ParameterList is tightly integrated
with python dictionaries -- PyTrilinos methods that expect a
ParameterList will accept a python dictionary.

"""


from sys import version_info as _swig_python_version_info
if _swig_python_version_info >= (2, 7, 0):
    def swig_import_helper():
        import importlib
        pkg = __name__.rpartition('.')[0]
        mname = '.'.join((pkg, '_Teuchos')).lstrip('.')
        try:
            return importlib.import_module(mname)
        except ImportError:
            return importlib.import_module('_Teuchos')
    _Teuchos = swig_import_helper()
    del swig_import_helper
elif _swig_python_version_info >= (2, 6, 0):
    def swig_import_helper():
        from os.path import dirname
        import imp
        fp = None
        try:
            fp, pathname, description = imp.find_module('_Teuchos', [dirname(__file__)])
        except ImportError:
            import _Teuchos
            return _Teuchos
        try:
            _mod = imp.load_module('_Teuchos', fp, pathname, description)
        finally:
            if fp is not None:
                fp.close()
        return _mod
    _Teuchos = swig_import_helper()
    del swig_import_helper
else:
    import _Teuchos
del _swig_python_version_info

try:
    _swig_property = property
except NameError:
    pass  # Python < 2.2 doesn't have 'property'.

try:
    import builtins as __builtin__
except ImportError:
    import __builtin__

def _swig_setattr_nondynamic(self, class_type, name, value, static=1):
    if (name == "thisown"):
        return self.this.own(value)
    if (name == "this"):
        if type(value).__name__ == 'SwigPyObject':
            self.__dict__[name] = value
            return
    method = class_type.__swig_setmethods__.get(name, None)
    if method:
        return method(self, value)
    if (not static):
        if _newclass:
            object.__setattr__(self, name, value)
        else:
            self.__dict__[name] = value
    else:
        raise AttributeError("You cannot add attributes to %s" % self)


def _swig_setattr(self, class_type, name, value):
    return _swig_setattr_nondynamic(self, class_type, name, value, 0)


def _swig_getattr(self, class_type, name):
    if (name == "thisown"):
        return self.this.own()
    method = class_type.__swig_getmethods__.get(name, None)
    if method:
        return method(self)
    raise AttributeError("'%s' object has no attribute '%s'" % (class_type.__name__, name))


def _swig_repr(self):
    try:
        strthis = "proxy of " + self.this.__repr__()
    except __builtin__.Exception:
        strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)

try:
    _object = object
    _newclass = 1
except __builtin__.Exception:
    class _object:
        pass
    _newclass = 0

try:
    import weakref
    weakref_proxy = weakref.proxy
except __builtin__.Exception:
    weakref_proxy = lambda x: x


class SwigPyIterator(_object):
    """Proxy of C++ swig::SwigPyIterator class."""

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, SwigPyIterator, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, SwigPyIterator, name)

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _Teuchos.delete_SwigPyIterator

    def value(self, *args):
        """value(SwigPyIterator self) -> PyObject *"""
        return _Teuchos.SwigPyIterator_value(self, *args)


    def incr(self, *args):
        """incr(SwigPyIterator self, size_t n=1) -> SwigPyIterator"""
        return _Teuchos.SwigPyIterator_incr(self, *args)


    def decr(self, *args):
        """decr(SwigPyIterator self, size_t n=1) -> SwigPyIterator"""
        return _Teuchos.SwigPyIterator_decr(self, *args)


    def distance(self, *args):
        """distance(SwigPyIterator self, SwigPyIterator x) -> ptrdiff_t"""
        return _Teuchos.SwigPyIterator_distance(self, *args)


    def equal(self, *args):
        """equal(SwigPyIterator self, SwigPyIterator x) -> bool"""
        return _Teuchos.SwigPyIterator_equal(self, *args)


    def copy(self, *args):
        """copy(SwigPyIterator self) -> SwigPyIterator"""
        return _Teuchos.SwigPyIterator_copy(self, *args)


    def next(self, *args):
        """next(SwigPyIterator self) -> PyObject *"""
        return _Teuchos.SwigPyIterator_next(self, *args)


    def __next__(self, *args):
        """__next__(SwigPyIterator self) -> PyObject *"""
        return _Teuchos.SwigPyIterator___next__(self, *args)


    def previous(self, *args):
        """previous(SwigPyIterator self) -> PyObject *"""
        return _Teuchos.SwigPyIterator_previous(self, *args)


    def advance(self, *args):
        """advance(SwigPyIterator self, ptrdiff_t n) -> SwigPyIterator"""
        return _Teuchos.SwigPyIterator_advance(self, *args)


    def __eq__(self, *args):
        """__eq__(SwigPyIterator self, SwigPyIterator x) -> bool"""
        return _Teuchos.SwigPyIterator___eq__(self, *args)


    def __ne__(self, *args):
        """__ne__(SwigPyIterator self, SwigPyIterator x) -> bool"""
        return _Teuchos.SwigPyIterator___ne__(self, *args)


    def __iadd__(self, *args):
        """__iadd__(SwigPyIterator self, ptrdiff_t n) -> SwigPyIterator"""
        return _Teuchos.SwigPyIterator___iadd__(self, *args)


    def __isub__(self, *args):
        """__isub__(SwigPyIterator self, ptrdiff_t n) -> SwigPyIterator"""
        return _Teuchos.SwigPyIterator___isub__(self, *args)


    def __add__(self, *args):
        """__add__(SwigPyIterator self, ptrdiff_t n) -> SwigPyIterator"""
        return _Teuchos.SwigPyIterator___add__(self, *args)


    def __sub__(self, *args):
        """
        __sub__(SwigPyIterator self, ptrdiff_t n) -> SwigPyIterator
        __sub__(SwigPyIterator self, SwigPyIterator x) -> ptrdiff_t
        """
        return _Teuchos.SwigPyIterator___sub__(self, *args)

    def __iter__(self):
        return self
SwigPyIterator_swigregister = _Teuchos.SwigPyIterator_swigregister
SwigPyIterator_swigregister(SwigPyIterator)
cvar = _Teuchos.cvar
Teuchos_MinDouble = cvar.Teuchos_MinDouble
Teuchos_MaxDouble = cvar.Teuchos_MaxDouble
Teuchos_Overflow = cvar.Teuchos_Overflow
Teuchos_Underflow = cvar.Teuchos_Underflow
Teuchos_DefaultTracebackMode = cvar.Teuchos_DefaultTracebackMode

SHARED_PTR_DISOWN = _Teuchos.SHARED_PTR_DISOWN
class ScalarTraitsByte(_object):
    """Proxy of C++ Teuchos::ScalarTraits<(char)> class."""

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, ScalarTraitsByte, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, ScalarTraitsByte, name)
    __repr__ = _swig_repr
    isComplex = _Teuchos.ScalarTraitsByte_isComplex
    isOrdinal = _Teuchos.ScalarTraitsByte_isOrdinal
    isComparable = _Teuchos.ScalarTraitsByte_isComparable
    hasMachineParameters = _Teuchos.ScalarTraitsByte_hasMachineParameters

    def magnitude(*args):
        """magnitude(char a) -> Teuchos::ScalarTraits< char >::magnitudeType"""
        return _Teuchos.ScalarTraitsByte_magnitude(*args)

    magnitude = staticmethod(magnitude)

    def zero(*args):
        """zero() -> char"""
        return _Teuchos.ScalarTraitsByte_zero(*args)

    zero = staticmethod(zero)

    def one(*args):
        """one() -> char"""
        return _Teuchos.ScalarTraitsByte_one(*args)

    one = staticmethod(one)

    def real(*args):
        """real(char a) -> Teuchos::ScalarTraits< char >::magnitudeType"""
        return _Teuchos.ScalarTraitsByte_real(*args)

    real = staticmethod(real)

    def imag(*args):
        """imag(char a) -> Teuchos::ScalarTraits< char >::magnitudeType"""
        return _Teuchos.ScalarTraitsByte_imag(*args)

    imag = staticmethod(imag)

    def conjugate(*args):
        """conjugate(char a) -> char"""
        return _Teuchos.ScalarTraitsByte_conjugate(*args)

    conjugate = staticmethod(conjugate)

    def isnaninf(*args):
        """isnaninf(char const & x) -> bool"""
        return _Teuchos.ScalarTraitsByte_isnaninf(*args)

    isnaninf = staticmethod(isnaninf)

    def seedrandom(*args):
        """seedrandom(unsigned int s)"""
        return _Teuchos.ScalarTraitsByte_seedrandom(*args)

    seedrandom = staticmethod(seedrandom)

    def random(*args):
        """random() -> char"""
        return _Teuchos.ScalarTraitsByte_random(*args)

    random = staticmethod(random)

    def name(*args):
        """name() -> std::string"""
        return _Teuchos.ScalarTraitsByte_name(*args)

    name = staticmethod(name)

    def squareroot(*args):
        """squareroot(char x) -> char"""
        return _Teuchos.ScalarTraitsByte_squareroot(*args)

    squareroot = staticmethod(squareroot)

    def pow(*args):
        """pow(char x, char y) -> char"""
        return _Teuchos.ScalarTraitsByte_pow(*args)

    pow = staticmethod(pow)

    def __init__(self, *args):
        """__init__(Teuchos::ScalarTraits<(char)> self) -> ScalarTraitsByte"""
        this = _Teuchos.new_ScalarTraitsByte(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _Teuchos.delete_ScalarTraitsByte
ScalarTraitsByte_swigregister = _Teuchos.ScalarTraitsByte_swigregister
ScalarTraitsByte_swigregister(ScalarTraitsByte)

def ScalarTraitsByte_magnitude(*args):
    """ScalarTraitsByte_magnitude(char a) -> Teuchos::ScalarTraits< char >::magnitudeType"""
    return _Teuchos.ScalarTraitsByte_magnitude(*args)

def ScalarTraitsByte_zero(*args):
    """ScalarTraitsByte_zero() -> char"""
    return _Teuchos.ScalarTraitsByte_zero(*args)

def ScalarTraitsByte_one(*args):
    """ScalarTraitsByte_one() -> char"""
    return _Teuchos.ScalarTraitsByte_one(*args)

def ScalarTraitsByte_real(*args):
    """ScalarTraitsByte_real(char a) -> Teuchos::ScalarTraits< char >::magnitudeType"""
    return _Teuchos.ScalarTraitsByte_real(*args)

def ScalarTraitsByte_imag(*args):
    """ScalarTraitsByte_imag(char a) -> Teuchos::ScalarTraits< char >::magnitudeType"""
    return _Teuchos.ScalarTraitsByte_imag(*args)

def ScalarTraitsByte_conjugate(*args):
    """ScalarTraitsByte_conjugate(char a) -> char"""
    return _Teuchos.ScalarTraitsByte_conjugate(*args)

def ScalarTraitsByte_isnaninf(*args):
    """ScalarTraitsByte_isnaninf(char const & x) -> bool"""
    return _Teuchos.ScalarTraitsByte_isnaninf(*args)

def ScalarTraitsByte_seedrandom(*args):
    """ScalarTraitsByte_seedrandom(unsigned int s)"""
    return _Teuchos.ScalarTraitsByte_seedrandom(*args)

def ScalarTraitsByte_random(*args):
    """ScalarTraitsByte_random() -> char"""
    return _Teuchos.ScalarTraitsByte_random(*args)

def ScalarTraitsByte_name(*args):
    """ScalarTraitsByte_name() -> std::string"""
    return _Teuchos.ScalarTraitsByte_name(*args)

def ScalarTraitsByte_squareroot(*args):
    """ScalarTraitsByte_squareroot(char x) -> char"""
    return _Teuchos.ScalarTraitsByte_squareroot(*args)

def ScalarTraitsByte_pow(*args):
    """ScalarTraitsByte_pow(char x, char y) -> char"""
    return _Teuchos.ScalarTraitsByte_pow(*args)

class ScalarTraitsUbyte(_object):
    """Proxy of C++ Teuchos::ScalarTraits<(unsigned char)> class."""

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, ScalarTraitsUbyte, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, ScalarTraitsUbyte, name)
    __repr__ = _swig_repr
    isComplex = _Teuchos.ScalarTraitsUbyte_isComplex
    isComparable = _Teuchos.ScalarTraitsUbyte_isComparable
    hasMachineParameters = _Teuchos.ScalarTraitsUbyte_hasMachineParameters

    def magnitude(*args):
        """magnitude(unsigned char a) -> Teuchos::ScalarTraits< unsigned char >::magnitudeType"""
        return _Teuchos.ScalarTraitsUbyte_magnitude(*args)

    magnitude = staticmethod(magnitude)

    def zero(*args):
        """zero() -> unsigned char"""
        return _Teuchos.ScalarTraitsUbyte_zero(*args)

    zero = staticmethod(zero)

    def one(*args):
        """one() -> unsigned char"""
        return _Teuchos.ScalarTraitsUbyte_one(*args)

    one = staticmethod(one)

    def conjugate(*args):
        """conjugate(unsigned char x) -> unsigned char"""
        return _Teuchos.ScalarTraitsUbyte_conjugate(*args)

    conjugate = staticmethod(conjugate)

    def real(*args):
        """real(unsigned char x) -> unsigned char"""
        return _Teuchos.ScalarTraitsUbyte_real(*args)

    real = staticmethod(real)

    def imag(*args):
        """imag(unsigned char x) -> unsigned char"""
        return _Teuchos.ScalarTraitsUbyte_imag(*args)

    imag = staticmethod(imag)

    def seedrandom(*args):
        """seedrandom(unsigned int s)"""
        return _Teuchos.ScalarTraitsUbyte_seedrandom(*args)

    seedrandom = staticmethod(seedrandom)

    def random(*args):
        """random() -> unsigned char"""
        return _Teuchos.ScalarTraitsUbyte_random(*args)

    random = staticmethod(random)

    def name(*args):
        """name() -> std::string"""
        return _Teuchos.ScalarTraitsUbyte_name(*args)

    name = staticmethod(name)

    def squareroot(*args):
        """squareroot(unsigned char x) -> unsigned char"""
        return _Teuchos.ScalarTraitsUbyte_squareroot(*args)

    squareroot = staticmethod(squareroot)

    def pow(*args):
        """pow(unsigned char x, unsigned char y) -> unsigned char"""
        return _Teuchos.ScalarTraitsUbyte_pow(*args)

    pow = staticmethod(pow)

    def __init__(self, *args):
        """__init__(Teuchos::ScalarTraits<(unsigned char)> self) -> ScalarTraitsUbyte"""
        this = _Teuchos.new_ScalarTraitsUbyte(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _Teuchos.delete_ScalarTraitsUbyte
ScalarTraitsUbyte_swigregister = _Teuchos.ScalarTraitsUbyte_swigregister
ScalarTraitsUbyte_swigregister(ScalarTraitsUbyte)

def ScalarTraitsUbyte_magnitude(*args):
    """ScalarTraitsUbyte_magnitude(unsigned char a) -> Teuchos::ScalarTraits< unsigned char >::magnitudeType"""
    return _Teuchos.ScalarTraitsUbyte_magnitude(*args)

def ScalarTraitsUbyte_zero(*args):
    """ScalarTraitsUbyte_zero() -> unsigned char"""
    return _Teuchos.ScalarTraitsUbyte_zero(*args)

def ScalarTraitsUbyte_one(*args):
    """ScalarTraitsUbyte_one() -> unsigned char"""
    return _Teuchos.ScalarTraitsUbyte_one(*args)

def ScalarTraitsUbyte_conjugate(*args):
    """ScalarTraitsUbyte_conjugate(unsigned char x) -> unsigned char"""
    return _Teuchos.ScalarTraitsUbyte_conjugate(*args)

def ScalarTraitsUbyte_real(*args):
    """ScalarTraitsUbyte_real(unsigned char x) -> unsigned char"""
    return _Teuchos.ScalarTraitsUbyte_real(*args)

def ScalarTraitsUbyte_imag(*args):
    """ScalarTraitsUbyte_imag(unsigned char x) -> unsigned char"""
    return _Teuchos.ScalarTraitsUbyte_imag(*args)

def ScalarTraitsUbyte_seedrandom(*args):
    """ScalarTraitsUbyte_seedrandom(unsigned int s)"""
    return _Teuchos.ScalarTraitsUbyte_seedrandom(*args)

def ScalarTraitsUbyte_random(*args):
    """ScalarTraitsUbyte_random() -> unsigned char"""
    return _Teuchos.ScalarTraitsUbyte_random(*args)

def ScalarTraitsUbyte_name(*args):
    """ScalarTraitsUbyte_name() -> std::string"""
    return _Teuchos.ScalarTraitsUbyte_name(*args)

def ScalarTraitsUbyte_squareroot(*args):
    """ScalarTraitsUbyte_squareroot(unsigned char x) -> unsigned char"""
    return _Teuchos.ScalarTraitsUbyte_squareroot(*args)

def ScalarTraitsUbyte_pow(*args):
    """ScalarTraitsUbyte_pow(unsigned char x, unsigned char y) -> unsigned char"""
    return _Teuchos.ScalarTraitsUbyte_pow(*args)

class ScalarTraitsShort(_object):
    """Proxy of C++ Teuchos::ScalarTraits<(short)> class."""

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, ScalarTraitsShort, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, ScalarTraitsShort, name)
    __repr__ = _swig_repr
    isComplex = _Teuchos.ScalarTraitsShort_isComplex
    isOrdinal = _Teuchos.ScalarTraitsShort_isOrdinal
    isComparable = _Teuchos.ScalarTraitsShort_isComparable
    hasMachineParameters = _Teuchos.ScalarTraitsShort_hasMachineParameters

    def magnitude(*args):
        """magnitude(short a) -> Teuchos::ScalarTraits< short >::magnitudeType"""
        return _Teuchos.ScalarTraitsShort_magnitude(*args)

    magnitude = staticmethod(magnitude)

    def zero(*args):
        """zero() -> short"""
        return _Teuchos.ScalarTraitsShort_zero(*args)

    zero = staticmethod(zero)

    def one(*args):
        """one() -> short"""
        return _Teuchos.ScalarTraitsShort_one(*args)

    one = staticmethod(one)

    def real(*args):
        """real(short a) -> Teuchos::ScalarTraits< short >::magnitudeType"""
        return _Teuchos.ScalarTraitsShort_real(*args)

    real = staticmethod(real)

    def imag(*args):
        """imag(short a) -> Teuchos::ScalarTraits< short >::magnitudeType"""
        return _Teuchos.ScalarTraitsShort_imag(*args)

    imag = staticmethod(imag)

    def conjugate(*args):
        """conjugate(short a) -> short"""
        return _Teuchos.ScalarTraitsShort_conjugate(*args)

    conjugate = staticmethod(conjugate)

    def seedrandom(*args):
        """seedrandom(unsigned int s)"""
        return _Teuchos.ScalarTraitsShort_seedrandom(*args)

    seedrandom = staticmethod(seedrandom)

    def random(*args):
        """random() -> short"""
        return _Teuchos.ScalarTraitsShort_random(*args)

    random = staticmethod(random)

    def name(*args):
        """name() -> std::string"""
        return _Teuchos.ScalarTraitsShort_name(*args)

    name = staticmethod(name)

    def squareroot(*args):
        """squareroot(short x) -> short"""
        return _Teuchos.ScalarTraitsShort_squareroot(*args)

    squareroot = staticmethod(squareroot)

    def pow(*args):
        """pow(short x, short y) -> short"""
        return _Teuchos.ScalarTraitsShort_pow(*args)

    pow = staticmethod(pow)

    def __init__(self, *args):
        """__init__(Teuchos::ScalarTraits<(short)> self) -> ScalarTraitsShort"""
        this = _Teuchos.new_ScalarTraitsShort(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _Teuchos.delete_ScalarTraitsShort
ScalarTraitsShort_swigregister = _Teuchos.ScalarTraitsShort_swigregister
ScalarTraitsShort_swigregister(ScalarTraitsShort)

def ScalarTraitsShort_magnitude(*args):
    """ScalarTraitsShort_magnitude(short a) -> Teuchos::ScalarTraits< short >::magnitudeType"""
    return _Teuchos.ScalarTraitsShort_magnitude(*args)

def ScalarTraitsShort_zero(*args):
    """ScalarTraitsShort_zero() -> short"""
    return _Teuchos.ScalarTraitsShort_zero(*args)

def ScalarTraitsShort_one(*args):
    """ScalarTraitsShort_one() -> short"""
    return _Teuchos.ScalarTraitsShort_one(*args)

def ScalarTraitsShort_real(*args):
    """ScalarTraitsShort_real(short a) -> Teuchos::ScalarTraits< short >::magnitudeType"""
    return _Teuchos.ScalarTraitsShort_real(*args)

def ScalarTraitsShort_imag(*args):
    """ScalarTraitsShort_imag(short a) -> Teuchos::ScalarTraits< short >::magnitudeType"""
    return _Teuchos.ScalarTraitsShort_imag(*args)

def ScalarTraitsShort_conjugate(*args):
    """ScalarTraitsShort_conjugate(short a) -> short"""
    return _Teuchos.ScalarTraitsShort_conjugate(*args)

def ScalarTraitsShort_seedrandom(*args):
    """ScalarTraitsShort_seedrandom(unsigned int s)"""
    return _Teuchos.ScalarTraitsShort_seedrandom(*args)

def ScalarTraitsShort_random(*args):
    """ScalarTraitsShort_random() -> short"""
    return _Teuchos.ScalarTraitsShort_random(*args)

def ScalarTraitsShort_name(*args):
    """ScalarTraitsShort_name() -> std::string"""
    return _Teuchos.ScalarTraitsShort_name(*args)

def ScalarTraitsShort_squareroot(*args):
    """ScalarTraitsShort_squareroot(short x) -> short"""
    return _Teuchos.ScalarTraitsShort_squareroot(*args)

def ScalarTraitsShort_pow(*args):
    """ScalarTraitsShort_pow(short x, short y) -> short"""
    return _Teuchos.ScalarTraitsShort_pow(*args)

class ScalarTraitsUshort(_object):
    """Proxy of C++ Teuchos::ScalarTraits<(unsigned short)> class."""

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, ScalarTraitsUshort, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, ScalarTraitsUshort, name)
    __repr__ = _swig_repr
    isComplex = _Teuchos.ScalarTraitsUshort_isComplex
    isOrdinal = _Teuchos.ScalarTraitsUshort_isOrdinal
    isComparable = _Teuchos.ScalarTraitsUshort_isComparable
    hasMachineParameters = _Teuchos.ScalarTraitsUshort_hasMachineParameters

    def magnitude(*args):
        """magnitude(unsigned short a) -> Teuchos::ScalarTraits< unsigned short >::magnitudeType"""
        return _Teuchos.ScalarTraitsUshort_magnitude(*args)

    magnitude = staticmethod(magnitude)

    def zero(*args):
        """zero() -> unsigned short"""
        return _Teuchos.ScalarTraitsUshort_zero(*args)

    zero = staticmethod(zero)

    def one(*args):
        """one() -> unsigned short"""
        return _Teuchos.ScalarTraitsUshort_one(*args)

    one = staticmethod(one)

    def real(*args):
        """real(unsigned short a) -> Teuchos::ScalarTraits< unsigned short >::magnitudeType"""
        return _Teuchos.ScalarTraitsUshort_real(*args)

    real = staticmethod(real)

    def imag(*args):
        """imag(unsigned short a) -> Teuchos::ScalarTraits< unsigned short >::magnitudeType"""
        return _Teuchos.ScalarTraitsUshort_imag(*args)

    imag = staticmethod(imag)

    def conjugate(*args):
        """conjugate(unsigned short a) -> unsigned short"""
        return _Teuchos.ScalarTraitsUshort_conjugate(*args)

    conjugate = staticmethod(conjugate)

    def seedrandom(*args):
        """seedrandom(unsigned int s)"""
        return _Teuchos.ScalarTraitsUshort_seedrandom(*args)

    seedrandom = staticmethod(seedrandom)

    def random(*args):
        """random() -> unsigned short"""
        return _Teuchos.ScalarTraitsUshort_random(*args)

    random = staticmethod(random)

    def name(*args):
        """name() -> std::string"""
        return _Teuchos.ScalarTraitsUshort_name(*args)

    name = staticmethod(name)

    def squareroot(*args):
        """squareroot(unsigned short x) -> unsigned short"""
        return _Teuchos.ScalarTraitsUshort_squareroot(*args)

    squareroot = staticmethod(squareroot)

    def pow(*args):
        """pow(unsigned short x, unsigned short y) -> unsigned short"""
        return _Teuchos.ScalarTraitsUshort_pow(*args)

    pow = staticmethod(pow)

    def __init__(self, *args):
        """__init__(Teuchos::ScalarTraits<(unsigned short)> self) -> ScalarTraitsUshort"""
        this = _Teuchos.new_ScalarTraitsUshort(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _Teuchos.delete_ScalarTraitsUshort
ScalarTraitsUshort_swigregister = _Teuchos.ScalarTraitsUshort_swigregister
ScalarTraitsUshort_swigregister(ScalarTraitsUshort)

def ScalarTraitsUshort_magnitude(*args):
    """ScalarTraitsUshort_magnitude(unsigned short a) -> Teuchos::ScalarTraits< unsigned short >::magnitudeType"""
    return _Teuchos.ScalarTraitsUshort_magnitude(*args)

def ScalarTraitsUshort_zero(*args):
    """ScalarTraitsUshort_zero() -> unsigned short"""
    return _Teuchos.ScalarTraitsUshort_zero(*args)

def ScalarTraitsUshort_one(*args):
    """ScalarTraitsUshort_one() -> unsigned short"""
    return _Teuchos.ScalarTraitsUshort_one(*args)

def ScalarTraitsUshort_real(*args):
    """ScalarTraitsUshort_real(unsigned short a) -> Teuchos::ScalarTraits< unsigned short >::magnitudeType"""
    return _Teuchos.ScalarTraitsUshort_real(*args)

def ScalarTraitsUshort_imag(*args):
    """ScalarTraitsUshort_imag(unsigned short a) -> Teuchos::ScalarTraits< unsigned short >::magnitudeType"""
    return _Teuchos.ScalarTraitsUshort_imag(*args)

def ScalarTraitsUshort_conjugate(*args):
    """ScalarTraitsUshort_conjugate(unsigned short a) -> unsigned short"""
    return _Teuchos.ScalarTraitsUshort_conjugate(*args)

def ScalarTraitsUshort_seedrandom(*args):
    """ScalarTraitsUshort_seedrandom(unsigned int s)"""
    return _Teuchos.ScalarTraitsUshort_seedrandom(*args)

def ScalarTraitsUshort_random(*args):
    """ScalarTraitsUshort_random() -> unsigned short"""
    return _Teuchos.ScalarTraitsUshort_random(*args)

def ScalarTraitsUshort_name(*args):
    """ScalarTraitsUshort_name() -> std::string"""
    return _Teuchos.ScalarTraitsUshort_name(*args)

def ScalarTraitsUshort_squareroot(*args):
    """ScalarTraitsUshort_squareroot(unsigned short x) -> unsigned short"""
    return _Teuchos.ScalarTraitsUshort_squareroot(*args)

def ScalarTraitsUshort_pow(*args):
    """ScalarTraitsUshort_pow(unsigned short x, unsigned short y) -> unsigned short"""
    return _Teuchos.ScalarTraitsUshort_pow(*args)

class ScalarTraitsInt(_object):
    """Proxy of C++ Teuchos::ScalarTraits<(int)> class."""

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, ScalarTraitsInt, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, ScalarTraitsInt, name)
    __repr__ = _swig_repr
    isComplex = _Teuchos.ScalarTraitsInt_isComplex
    isOrdinal = _Teuchos.ScalarTraitsInt_isOrdinal
    isComparable = _Teuchos.ScalarTraitsInt_isComparable
    hasMachineParameters = _Teuchos.ScalarTraitsInt_hasMachineParameters

    def magnitude(*args):
        """magnitude(int a) -> Teuchos::ScalarTraits< int >::magnitudeType"""
        return _Teuchos.ScalarTraitsInt_magnitude(*args)

    magnitude = staticmethod(magnitude)

    def zero(*args):
        """zero() -> int"""
        return _Teuchos.ScalarTraitsInt_zero(*args)

    zero = staticmethod(zero)

    def one(*args):
        """one() -> int"""
        return _Teuchos.ScalarTraitsInt_one(*args)

    one = staticmethod(one)

    def real(*args):
        """real(int a) -> Teuchos::ScalarTraits< int >::magnitudeType"""
        return _Teuchos.ScalarTraitsInt_real(*args)

    real = staticmethod(real)

    def imag(*args):
        """imag(int a) -> Teuchos::ScalarTraits< int >::magnitudeType"""
        return _Teuchos.ScalarTraitsInt_imag(*args)

    imag = staticmethod(imag)

    def conjugate(*args):
        """conjugate(int a) -> int"""
        return _Teuchos.ScalarTraitsInt_conjugate(*args)

    conjugate = staticmethod(conjugate)

    def isnaninf(*args):
        """isnaninf(int const & x) -> bool"""
        return _Teuchos.ScalarTraitsInt_isnaninf(*args)

    isnaninf = staticmethod(isnaninf)

    def seedrandom(*args):
        """seedrandom(unsigned int s)"""
        return _Teuchos.ScalarTraitsInt_seedrandom(*args)

    seedrandom = staticmethod(seedrandom)

    def random(*args):
        """random() -> int"""
        return _Teuchos.ScalarTraitsInt_random(*args)

    random = staticmethod(random)

    def name(*args):
        """name() -> std::string"""
        return _Teuchos.ScalarTraitsInt_name(*args)

    name = staticmethod(name)

    def squareroot(*args):
        """squareroot(int x) -> int"""
        return _Teuchos.ScalarTraitsInt_squareroot(*args)

    squareroot = staticmethod(squareroot)

    def pow(*args):
        """pow(int x, int y) -> int"""
        return _Teuchos.ScalarTraitsInt_pow(*args)

    pow = staticmethod(pow)

    def __init__(self, *args):
        """__init__(Teuchos::ScalarTraits<(int)> self) -> ScalarTraitsInt"""
        this = _Teuchos.new_ScalarTraitsInt(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _Teuchos.delete_ScalarTraitsInt
ScalarTraitsInt_swigregister = _Teuchos.ScalarTraitsInt_swigregister
ScalarTraitsInt_swigregister(ScalarTraitsInt)

def ScalarTraitsInt_magnitude(*args):
    """ScalarTraitsInt_magnitude(int a) -> Teuchos::ScalarTraits< int >::magnitudeType"""
    return _Teuchos.ScalarTraitsInt_magnitude(*args)

def ScalarTraitsInt_zero(*args):
    """ScalarTraitsInt_zero() -> int"""
    return _Teuchos.ScalarTraitsInt_zero(*args)

def ScalarTraitsInt_one(*args):
    """ScalarTraitsInt_one() -> int"""
    return _Teuchos.ScalarTraitsInt_one(*args)

def ScalarTraitsInt_real(*args):
    """ScalarTraitsInt_real(int a) -> Teuchos::ScalarTraits< int >::magnitudeType"""
    return _Teuchos.ScalarTraitsInt_real(*args)

def ScalarTraitsInt_imag(*args):
    """ScalarTraitsInt_imag(int a) -> Teuchos::ScalarTraits< int >::magnitudeType"""
    return _Teuchos.ScalarTraitsInt_imag(*args)

def ScalarTraitsInt_conjugate(*args):
    """ScalarTraitsInt_conjugate(int a) -> int"""
    return _Teuchos.ScalarTraitsInt_conjugate(*args)

def ScalarTraitsInt_isnaninf(*args):
    """ScalarTraitsInt_isnaninf(int const & x) -> bool"""
    return _Teuchos.ScalarTraitsInt_isnaninf(*args)

def ScalarTraitsInt_seedrandom(*args):
    """ScalarTraitsInt_seedrandom(unsigned int s)"""
    return _Teuchos.ScalarTraitsInt_seedrandom(*args)

def ScalarTraitsInt_random(*args):
    """ScalarTraitsInt_random() -> int"""
    return _Teuchos.ScalarTraitsInt_random(*args)

def ScalarTraitsInt_name(*args):
    """ScalarTraitsInt_name() -> std::string"""
    return _Teuchos.ScalarTraitsInt_name(*args)

def ScalarTraitsInt_squareroot(*args):
    """ScalarTraitsInt_squareroot(int x) -> int"""
    return _Teuchos.ScalarTraitsInt_squareroot(*args)

def ScalarTraitsInt_pow(*args):
    """ScalarTraitsInt_pow(int x, int y) -> int"""
    return _Teuchos.ScalarTraitsInt_pow(*args)

class ScalarTraitsUint(_object):
    """Proxy of C++ Teuchos::ScalarTraits<(unsigned int)> class."""

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, ScalarTraitsUint, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, ScalarTraitsUint, name)
    __repr__ = _swig_repr
    isComplex = _Teuchos.ScalarTraitsUint_isComplex
    isOrdinal = _Teuchos.ScalarTraitsUint_isOrdinal
    isComparable = _Teuchos.ScalarTraitsUint_isComparable
    hasMachineParameters = _Teuchos.ScalarTraitsUint_hasMachineParameters

    def magnitude(*args):
        """magnitude(unsigned int a) -> Teuchos::ScalarTraits< unsigned int >::magnitudeType"""
        return _Teuchos.ScalarTraitsUint_magnitude(*args)

    magnitude = staticmethod(magnitude)

    def zero(*args):
        """zero() -> unsigned int"""
        return _Teuchos.ScalarTraitsUint_zero(*args)

    zero = staticmethod(zero)

    def one(*args):
        """one() -> unsigned int"""
        return _Teuchos.ScalarTraitsUint_one(*args)

    one = staticmethod(one)

    def real(*args):
        """real(unsigned int a) -> Teuchos::ScalarTraits< unsigned int >::magnitudeType"""
        return _Teuchos.ScalarTraitsUint_real(*args)

    real = staticmethod(real)

    def imag(*args):
        """imag(unsigned int a) -> Teuchos::ScalarTraits< unsigned int >::magnitudeType"""
        return _Teuchos.ScalarTraitsUint_imag(*args)

    imag = staticmethod(imag)

    def conjugate(*args):
        """conjugate(unsigned int a) -> unsigned int"""
        return _Teuchos.ScalarTraitsUint_conjugate(*args)

    conjugate = staticmethod(conjugate)

    def seedrandom(*args):
        """seedrandom(unsigned int s)"""
        return _Teuchos.ScalarTraitsUint_seedrandom(*args)

    seedrandom = staticmethod(seedrandom)

    def random(*args):
        """random() -> unsigned int"""
        return _Teuchos.ScalarTraitsUint_random(*args)

    random = staticmethod(random)

    def name(*args):
        """name() -> std::string"""
        return _Teuchos.ScalarTraitsUint_name(*args)

    name = staticmethod(name)

    def squareroot(*args):
        """squareroot(unsigned int x) -> unsigned int"""
        return _Teuchos.ScalarTraitsUint_squareroot(*args)

    squareroot = staticmethod(squareroot)

    def pow(*args):
        """pow(unsigned int x, unsigned int y) -> unsigned int"""
        return _Teuchos.ScalarTraitsUint_pow(*args)

    pow = staticmethod(pow)

    def __init__(self, *args):
        """__init__(Teuchos::ScalarTraits<(unsigned int)> self) -> ScalarTraitsUint"""
        this = _Teuchos.new_ScalarTraitsUint(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _Teuchos.delete_ScalarTraitsUint
ScalarTraitsUint_swigregister = _Teuchos.ScalarTraitsUint_swigregister
ScalarTraitsUint_swigregister(ScalarTraitsUint)

def ScalarTraitsUint_magnitude(*args):
    """ScalarTraitsUint_magnitude(unsigned int a) -> Teuchos::ScalarTraits< unsigned int >::magnitudeType"""
    return _Teuchos.ScalarTraitsUint_magnitude(*args)

def ScalarTraitsUint_zero(*args):
    """ScalarTraitsUint_zero() -> unsigned int"""
    return _Teuchos.ScalarTraitsUint_zero(*args)

def ScalarTraitsUint_one(*args):
    """ScalarTraitsUint_one() -> unsigned int"""
    return _Teuchos.ScalarTraitsUint_one(*args)

def ScalarTraitsUint_real(*args):
    """ScalarTraitsUint_real(unsigned int a) -> Teuchos::ScalarTraits< unsigned int >::magnitudeType"""
    return _Teuchos.ScalarTraitsUint_real(*args)

def ScalarTraitsUint_imag(*args):
    """ScalarTraitsUint_imag(unsigned int a) -> Teuchos::ScalarTraits< unsigned int >::magnitudeType"""
    return _Teuchos.ScalarTraitsUint_imag(*args)

def ScalarTraitsUint_conjugate(*args):
    """ScalarTraitsUint_conjugate(unsigned int a) -> unsigned int"""
    return _Teuchos.ScalarTraitsUint_conjugate(*args)

def ScalarTraitsUint_seedrandom(*args):
    """ScalarTraitsUint_seedrandom(unsigned int s)"""
    return _Teuchos.ScalarTraitsUint_seedrandom(*args)

def ScalarTraitsUint_random(*args):
    """ScalarTraitsUint_random() -> unsigned int"""
    return _Teuchos.ScalarTraitsUint_random(*args)

def ScalarTraitsUint_name(*args):
    """ScalarTraitsUint_name() -> std::string"""
    return _Teuchos.ScalarTraitsUint_name(*args)

def ScalarTraitsUint_squareroot(*args):
    """ScalarTraitsUint_squareroot(unsigned int x) -> unsigned int"""
    return _Teuchos.ScalarTraitsUint_squareroot(*args)

def ScalarTraitsUint_pow(*args):
    """ScalarTraitsUint_pow(unsigned int x, unsigned int y) -> unsigned int"""
    return _Teuchos.ScalarTraitsUint_pow(*args)

class ScalarTraitsLong(_object):
    """Proxy of C++ Teuchos::ScalarTraits<(long)> class."""

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, ScalarTraitsLong, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, ScalarTraitsLong, name)
    __repr__ = _swig_repr
    isComplex = _Teuchos.ScalarTraitsLong_isComplex
    isOrdinal = _Teuchos.ScalarTraitsLong_isOrdinal
    isComparable = _Teuchos.ScalarTraitsLong_isComparable
    hasMachineParameters = _Teuchos.ScalarTraitsLong_hasMachineParameters

    def magnitude(*args):
        """magnitude(long a) -> Teuchos::ScalarTraits< long >::magnitudeType"""
        return _Teuchos.ScalarTraitsLong_magnitude(*args)

    magnitude = staticmethod(magnitude)

    def zero(*args):
        """zero() -> long"""
        return _Teuchos.ScalarTraitsLong_zero(*args)

    zero = staticmethod(zero)

    def one(*args):
        """one() -> long"""
        return _Teuchos.ScalarTraitsLong_one(*args)

    one = staticmethod(one)

    def real(*args):
        """real(long a) -> Teuchos::ScalarTraits< long >::magnitudeType"""
        return _Teuchos.ScalarTraitsLong_real(*args)

    real = staticmethod(real)

    def imag(*args):
        """imag(long a) -> Teuchos::ScalarTraits< long >::magnitudeType"""
        return _Teuchos.ScalarTraitsLong_imag(*args)

    imag = staticmethod(imag)

    def conjugate(*args):
        """conjugate(long a) -> long"""
        return _Teuchos.ScalarTraitsLong_conjugate(*args)

    conjugate = staticmethod(conjugate)

    def seedrandom(*args):
        """seedrandom(unsigned int s)"""
        return _Teuchos.ScalarTraitsLong_seedrandom(*args)

    seedrandom = staticmethod(seedrandom)

    def random(*args):
        """random() -> long"""
        return _Teuchos.ScalarTraitsLong_random(*args)

    random = staticmethod(random)

    def name(*args):
        """name() -> std::string"""
        return _Teuchos.ScalarTraitsLong_name(*args)

    name = staticmethod(name)

    def squareroot(*args):
        """squareroot(long x) -> long"""
        return _Teuchos.ScalarTraitsLong_squareroot(*args)

    squareroot = staticmethod(squareroot)

    def pow(*args):
        """pow(long x, long y) -> long"""
        return _Teuchos.ScalarTraitsLong_pow(*args)

    pow = staticmethod(pow)

    def __init__(self, *args):
        """__init__(Teuchos::ScalarTraits<(long)> self) -> ScalarTraitsLong"""
        this = _Teuchos.new_ScalarTraitsLong(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _Teuchos.delete_ScalarTraitsLong
ScalarTraitsLong_swigregister = _Teuchos.ScalarTraitsLong_swigregister
ScalarTraitsLong_swigregister(ScalarTraitsLong)

def ScalarTraitsLong_magnitude(*args):
    """ScalarTraitsLong_magnitude(long a) -> Teuchos::ScalarTraits< long >::magnitudeType"""
    return _Teuchos.ScalarTraitsLong_magnitude(*args)

def ScalarTraitsLong_zero(*args):
    """ScalarTraitsLong_zero() -> long"""
    return _Teuchos.ScalarTraitsLong_zero(*args)

def ScalarTraitsLong_one(*args):
    """ScalarTraitsLong_one() -> long"""
    return _Teuchos.ScalarTraitsLong_one(*args)

def ScalarTraitsLong_real(*args):
    """ScalarTraitsLong_real(long a) -> Teuchos::ScalarTraits< long >::magnitudeType"""
    return _Teuchos.ScalarTraitsLong_real(*args)

def ScalarTraitsLong_imag(*args):
    """ScalarTraitsLong_imag(long a) -> Teuchos::ScalarTraits< long >::magnitudeType"""
    return _Teuchos.ScalarTraitsLong_imag(*args)

def ScalarTraitsLong_conjugate(*args):
    """ScalarTraitsLong_conjugate(long a) -> long"""
    return _Teuchos.ScalarTraitsLong_conjugate(*args)

def ScalarTraitsLong_seedrandom(*args):
    """ScalarTraitsLong_seedrandom(unsigned int s)"""
    return _Teuchos.ScalarTraitsLong_seedrandom(*args)

def ScalarTraitsLong_random(*args):
    """ScalarTraitsLong_random() -> long"""
    return _Teuchos.ScalarTraitsLong_random(*args)

def ScalarTraitsLong_name(*args):
    """ScalarTraitsLong_name() -> std::string"""
    return _Teuchos.ScalarTraitsLong_name(*args)

def ScalarTraitsLong_squareroot(*args):
    """ScalarTraitsLong_squareroot(long x) -> long"""
    return _Teuchos.ScalarTraitsLong_squareroot(*args)

def ScalarTraitsLong_pow(*args):
    """ScalarTraitsLong_pow(long x, long y) -> long"""
    return _Teuchos.ScalarTraitsLong_pow(*args)

class ScalarTraitsUlong(_object):
    """Proxy of C++ Teuchos::ScalarTraits<(unsigned long)> class."""

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, ScalarTraitsUlong, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, ScalarTraitsUlong, name)
    __repr__ = _swig_repr
    isComplex = _Teuchos.ScalarTraitsUlong_isComplex
    isOrdinal = _Teuchos.ScalarTraitsUlong_isOrdinal
    isComparable = _Teuchos.ScalarTraitsUlong_isComparable
    hasMachineParameters = _Teuchos.ScalarTraitsUlong_hasMachineParameters

    def magnitude(*args):
        """magnitude(unsigned long a) -> Teuchos::ScalarTraits< unsigned long >::magnitudeType"""
        return _Teuchos.ScalarTraitsUlong_magnitude(*args)

    magnitude = staticmethod(magnitude)

    def zero(*args):
        """zero() -> unsigned long"""
        return _Teuchos.ScalarTraitsUlong_zero(*args)

    zero = staticmethod(zero)

    def one(*args):
        """one() -> unsigned long"""
        return _Teuchos.ScalarTraitsUlong_one(*args)

    one = staticmethod(one)

    def real(*args):
        """real(unsigned long a) -> Teuchos::ScalarTraits< unsigned long >::magnitudeType"""
        return _Teuchos.ScalarTraitsUlong_real(*args)

    real = staticmethod(real)

    def imag(*args):
        """imag(unsigned long a) -> Teuchos::ScalarTraits< unsigned long >::magnitudeType"""
        return _Teuchos.ScalarTraitsUlong_imag(*args)

    imag = staticmethod(imag)

    def conjugate(*args):
        """conjugate(unsigned long a) -> unsigned long"""
        return _Teuchos.ScalarTraitsUlong_conjugate(*args)

    conjugate = staticmethod(conjugate)

    def seedrandom(*args):
        """seedrandom(unsigned int s)"""
        return _Teuchos.ScalarTraitsUlong_seedrandom(*args)

    seedrandom = staticmethod(seedrandom)

    def random(*args):
        """random() -> unsigned long"""
        return _Teuchos.ScalarTraitsUlong_random(*args)

    random = staticmethod(random)

    def name(*args):
        """name() -> std::string"""
        return _Teuchos.ScalarTraitsUlong_name(*args)

    name = staticmethod(name)

    def squareroot(*args):
        """squareroot(unsigned long x) -> unsigned long"""
        return _Teuchos.ScalarTraitsUlong_squareroot(*args)

    squareroot = staticmethod(squareroot)

    def pow(*args):
        """pow(unsigned long x, unsigned long y) -> unsigned long"""
        return _Teuchos.ScalarTraitsUlong_pow(*args)

    pow = staticmethod(pow)

    def __init__(self, *args):
        """__init__(Teuchos::ScalarTraits<(unsigned long)> self) -> ScalarTraitsUlong"""
        this = _Teuchos.new_ScalarTraitsUlong(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _Teuchos.delete_ScalarTraitsUlong
ScalarTraitsUlong_swigregister = _Teuchos.ScalarTraitsUlong_swigregister
ScalarTraitsUlong_swigregister(ScalarTraitsUlong)

def ScalarTraitsUlong_magnitude(*args):
    """ScalarTraitsUlong_magnitude(unsigned long a) -> Teuchos::ScalarTraits< unsigned long >::magnitudeType"""
    return _Teuchos.ScalarTraitsUlong_magnitude(*args)

def ScalarTraitsUlong_zero(*args):
    """ScalarTraitsUlong_zero() -> unsigned long"""
    return _Teuchos.ScalarTraitsUlong_zero(*args)

def ScalarTraitsUlong_one(*args):
    """ScalarTraitsUlong_one() -> unsigned long"""
    return _Teuchos.ScalarTraitsUlong_one(*args)

def ScalarTraitsUlong_real(*args):
    """ScalarTraitsUlong_real(unsigned long a) -> Teuchos::ScalarTraits< unsigned long >::magnitudeType"""
    return _Teuchos.ScalarTraitsUlong_real(*args)

def ScalarTraitsUlong_imag(*args):
    """ScalarTraitsUlong_imag(unsigned long a) -> Teuchos::ScalarTraits< unsigned long >::magnitudeType"""
    return _Teuchos.ScalarTraitsUlong_imag(*args)

def ScalarTraitsUlong_conjugate(*args):
    """ScalarTraitsUlong_conjugate(unsigned long a) -> unsigned long"""
    return _Teuchos.ScalarTraitsUlong_conjugate(*args)

def ScalarTraitsUlong_seedrandom(*args):
    """ScalarTraitsUlong_seedrandom(unsigned int s)"""
    return _Teuchos.ScalarTraitsUlong_seedrandom(*args)

def ScalarTraitsUlong_random(*args):
    """ScalarTraitsUlong_random() -> unsigned long"""
    return _Teuchos.ScalarTraitsUlong_random(*args)

def ScalarTraitsUlong_name(*args):
    """ScalarTraitsUlong_name() -> std::string"""
    return _Teuchos.ScalarTraitsUlong_name(*args)

def ScalarTraitsUlong_squareroot(*args):
    """ScalarTraitsUlong_squareroot(unsigned long x) -> unsigned long"""
    return _Teuchos.ScalarTraitsUlong_squareroot(*args)

def ScalarTraitsUlong_pow(*args):
    """ScalarTraitsUlong_pow(unsigned long x, unsigned long y) -> unsigned long"""
    return _Teuchos.ScalarTraitsUlong_pow(*args)

class ScalarTraitsLongLong(_object):
    """Proxy of C++ Teuchos::ScalarTraits<(long long)> class."""

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, ScalarTraitsLongLong, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, ScalarTraitsLongLong, name)
    __repr__ = _swig_repr
    isComplex = _Teuchos.ScalarTraitsLongLong_isComplex
    isOrdinal = _Teuchos.ScalarTraitsLongLong_isOrdinal
    isComparable = _Teuchos.ScalarTraitsLongLong_isComparable
    hasMachineParameters = _Teuchos.ScalarTraitsLongLong_hasMachineParameters

    def magnitude(*args):
        """magnitude(long long a) -> Teuchos::ScalarTraits< long long >::magnitudeType"""
        return _Teuchos.ScalarTraitsLongLong_magnitude(*args)

    magnitude = staticmethod(magnitude)

    def zero(*args):
        """zero() -> long long"""
        return _Teuchos.ScalarTraitsLongLong_zero(*args)

    zero = staticmethod(zero)

    def one(*args):
        """one() -> long long"""
        return _Teuchos.ScalarTraitsLongLong_one(*args)

    one = staticmethod(one)

    def real(*args):
        """real(long long a) -> Teuchos::ScalarTraits< long long >::magnitudeType"""
        return _Teuchos.ScalarTraitsLongLong_real(*args)

    real = staticmethod(real)

    def imag(*args):
        """imag(long long a) -> Teuchos::ScalarTraits< long long >::magnitudeType"""
        return _Teuchos.ScalarTraitsLongLong_imag(*args)

    imag = staticmethod(imag)

    def conjugate(*args):
        """conjugate(long long a) -> long long"""
        return _Teuchos.ScalarTraitsLongLong_conjugate(*args)

    conjugate = staticmethod(conjugate)

    def seedrandom(*args):
        """seedrandom(unsigned int s)"""
        return _Teuchos.ScalarTraitsLongLong_seedrandom(*args)

    seedrandom = staticmethod(seedrandom)

    def random(*args):
        """random() -> long long"""
        return _Teuchos.ScalarTraitsLongLong_random(*args)

    random = staticmethod(random)

    def name(*args):
        """name() -> std::string"""
        return _Teuchos.ScalarTraitsLongLong_name(*args)

    name = staticmethod(name)

    def squareroot(*args):
        """squareroot(long long x) -> long long"""
        return _Teuchos.ScalarTraitsLongLong_squareroot(*args)

    squareroot = staticmethod(squareroot)

    def pow(*args):
        """pow(long long x, long long y) -> long long"""
        return _Teuchos.ScalarTraitsLongLong_pow(*args)

    pow = staticmethod(pow)

    def __init__(self, *args):
        """__init__(Teuchos::ScalarTraits<(long long)> self) -> ScalarTraitsLongLong"""
        this = _Teuchos.new_ScalarTraitsLongLong(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _Teuchos.delete_ScalarTraitsLongLong
ScalarTraitsLongLong_swigregister = _Teuchos.ScalarTraitsLongLong_swigregister
ScalarTraitsLongLong_swigregister(ScalarTraitsLongLong)

def ScalarTraitsLongLong_magnitude(*args):
    """ScalarTraitsLongLong_magnitude(long long a) -> Teuchos::ScalarTraits< long long >::magnitudeType"""
    return _Teuchos.ScalarTraitsLongLong_magnitude(*args)

def ScalarTraitsLongLong_zero(*args):
    """ScalarTraitsLongLong_zero() -> long long"""
    return _Teuchos.ScalarTraitsLongLong_zero(*args)

def ScalarTraitsLongLong_one(*args):
    """ScalarTraitsLongLong_one() -> long long"""
    return _Teuchos.ScalarTraitsLongLong_one(*args)

def ScalarTraitsLongLong_real(*args):
    """ScalarTraitsLongLong_real(long long a) -> Teuchos::ScalarTraits< long long >::magnitudeType"""
    return _Teuchos.ScalarTraitsLongLong_real(*args)

def ScalarTraitsLongLong_imag(*args):
    """ScalarTraitsLongLong_imag(long long a) -> Teuchos::ScalarTraits< long long >::magnitudeType"""
    return _Teuchos.ScalarTraitsLongLong_imag(*args)

def ScalarTraitsLongLong_conjugate(*args):
    """ScalarTraitsLongLong_conjugate(long long a) -> long long"""
    return _Teuchos.ScalarTraitsLongLong_conjugate(*args)

def ScalarTraitsLongLong_seedrandom(*args):
    """ScalarTraitsLongLong_seedrandom(unsigned int s)"""
    return _Teuchos.ScalarTraitsLongLong_seedrandom(*args)

def ScalarTraitsLongLong_random(*args):
    """ScalarTraitsLongLong_random() -> long long"""
    return _Teuchos.ScalarTraitsLongLong_random(*args)

def ScalarTraitsLongLong_name(*args):
    """ScalarTraitsLongLong_name() -> std::string"""
    return _Teuchos.ScalarTraitsLongLong_name(*args)

def ScalarTraitsLongLong_squareroot(*args):
    """ScalarTraitsLongLong_squareroot(long long x) -> long long"""
    return _Teuchos.ScalarTraitsLongLong_squareroot(*args)

def ScalarTraitsLongLong_pow(*args):
    """ScalarTraitsLongLong_pow(long long x, long long y) -> long long"""
    return _Teuchos.ScalarTraitsLongLong_pow(*args)

class ScalarTraitsUlongLong(_object):
    """Proxy of C++ Teuchos::ScalarTraits<(unsigned long long)> class."""

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, ScalarTraitsUlongLong, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, ScalarTraitsUlongLong, name)
    __repr__ = _swig_repr
    isComplex = _Teuchos.ScalarTraitsUlongLong_isComplex
    isOrdinal = _Teuchos.ScalarTraitsUlongLong_isOrdinal
    isComparable = _Teuchos.ScalarTraitsUlongLong_isComparable
    hasMachineParameters = _Teuchos.ScalarTraitsUlongLong_hasMachineParameters

    def magnitude(*args):
        """magnitude(unsigned long long a) -> Teuchos::ScalarTraits< unsigned long long >::magnitudeType"""
        return _Teuchos.ScalarTraitsUlongLong_magnitude(*args)

    magnitude = staticmethod(magnitude)

    def zero(*args):
        """zero() -> unsigned long long"""
        return _Teuchos.ScalarTraitsUlongLong_zero(*args)

    zero = staticmethod(zero)

    def one(*args):
        """one() -> unsigned long long"""
        return _Teuchos.ScalarTraitsUlongLong_one(*args)

    one = staticmethod(one)

    def real(*args):
        """real(unsigned long long a) -> Teuchos::ScalarTraits< unsigned long long >::magnitudeType"""
        return _Teuchos.ScalarTraitsUlongLong_real(*args)

    real = staticmethod(real)

    def imag(*args):
        """imag(unsigned long long a) -> Teuchos::ScalarTraits< unsigned long long >::magnitudeType"""
        return _Teuchos.ScalarTraitsUlongLong_imag(*args)

    imag = staticmethod(imag)

    def conjugate(*args):
        """conjugate(unsigned long long a) -> unsigned long long"""
        return _Teuchos.ScalarTraitsUlongLong_conjugate(*args)

    conjugate = staticmethod(conjugate)

    def seedrandom(*args):
        """seedrandom(unsigned int s)"""
        return _Teuchos.ScalarTraitsUlongLong_seedrandom(*args)

    seedrandom = staticmethod(seedrandom)

    def random(*args):
        """random() -> unsigned long long"""
        return _Teuchos.ScalarTraitsUlongLong_random(*args)

    random = staticmethod(random)

    def name(*args):
        """name() -> std::string"""
        return _Teuchos.ScalarTraitsUlongLong_name(*args)

    name = staticmethod(name)

    def squareroot(*args):
        """squareroot(unsigned long long x) -> unsigned long long"""
        return _Teuchos.ScalarTraitsUlongLong_squareroot(*args)

    squareroot = staticmethod(squareroot)

    def pow(*args):
        """pow(unsigned long long x, unsigned long long y) -> unsigned long long"""
        return _Teuchos.ScalarTraitsUlongLong_pow(*args)

    pow = staticmethod(pow)

    def __init__(self, *args):
        """__init__(Teuchos::ScalarTraits<(unsigned long long)> self) -> ScalarTraitsUlongLong"""
        this = _Teuchos.new_ScalarTraitsUlongLong(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _Teuchos.delete_ScalarTraitsUlongLong
ScalarTraitsUlongLong_swigregister = _Teuchos.ScalarTraitsUlongLong_swigregister
ScalarTraitsUlongLong_swigregister(ScalarTraitsUlongLong)

def ScalarTraitsUlongLong_magnitude(*args):
    """ScalarTraitsUlongLong_magnitude(unsigned long long a) -> Teuchos::ScalarTraits< unsigned long long >::magnitudeType"""
    return _Teuchos.ScalarTraitsUlongLong_magnitude(*args)

def ScalarTraitsUlongLong_zero(*args):
    """ScalarTraitsUlongLong_zero() -> unsigned long long"""
    return _Teuchos.ScalarTraitsUlongLong_zero(*args)

def ScalarTraitsUlongLong_one(*args):
    """ScalarTraitsUlongLong_one() -> unsigned long long"""
    return _Teuchos.ScalarTraitsUlongLong_one(*args)

def ScalarTraitsUlongLong_real(*args):
    """ScalarTraitsUlongLong_real(unsigned long long a) -> Teuchos::ScalarTraits< unsigned long long >::magnitudeType"""
    return _Teuchos.ScalarTraitsUlongLong_real(*args)

def ScalarTraitsUlongLong_imag(*args):
    """ScalarTraitsUlongLong_imag(unsigned long long a) -> Teuchos::ScalarTraits< unsigned long long >::magnitudeType"""
    return _Teuchos.ScalarTraitsUlongLong_imag(*args)

def ScalarTraitsUlongLong_conjugate(*args):
    """ScalarTraitsUlongLong_conjugate(unsigned long long a) -> unsigned long long"""
    return _Teuchos.ScalarTraitsUlongLong_conjugate(*args)

def ScalarTraitsUlongLong_seedrandom(*args):
    """ScalarTraitsUlongLong_seedrandom(unsigned int s)"""
    return _Teuchos.ScalarTraitsUlongLong_seedrandom(*args)

def ScalarTraitsUlongLong_random(*args):
    """ScalarTraitsUlongLong_random() -> unsigned long long"""
    return _Teuchos.ScalarTraitsUlongLong_random(*args)

def ScalarTraitsUlongLong_name(*args):
    """ScalarTraitsUlongLong_name() -> std::string"""
    return _Teuchos.ScalarTraitsUlongLong_name(*args)

def ScalarTraitsUlongLong_squareroot(*args):
    """ScalarTraitsUlongLong_squareroot(unsigned long long x) -> unsigned long long"""
    return _Teuchos.ScalarTraitsUlongLong_squareroot(*args)

def ScalarTraitsUlongLong_pow(*args):
    """ScalarTraitsUlongLong_pow(unsigned long long x, unsigned long long y) -> unsigned long long"""
    return _Teuchos.ScalarTraitsUlongLong_pow(*args)

class ScalarTraitsFloat(_object):
    """Proxy of C++ Teuchos::ScalarTraits<(float)> class."""

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, ScalarTraitsFloat, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, ScalarTraitsFloat, name)
    __repr__ = _swig_repr
    isComplex = _Teuchos.ScalarTraitsFloat_isComplex
    isOrdinal = _Teuchos.ScalarTraitsFloat_isOrdinal
    isComparable = _Teuchos.ScalarTraitsFloat_isComparable
    hasMachineParameters = _Teuchos.ScalarTraitsFloat_hasMachineParameters

    def eps(*args):
        """eps() -> Teuchos::ScalarTraits< float >::magnitudeType"""
        return _Teuchos.ScalarTraitsFloat_eps(*args)

    eps = staticmethod(eps)

    def sfmin(*args):
        """sfmin() -> Teuchos::ScalarTraits< float >::magnitudeType"""
        return _Teuchos.ScalarTraitsFloat_sfmin(*args)

    sfmin = staticmethod(sfmin)

    def base(*args):
        """base() -> Teuchos::ScalarTraits< float >::magnitudeType"""
        return _Teuchos.ScalarTraitsFloat_base(*args)

    base = staticmethod(base)

    def prec(*args):
        """prec() -> Teuchos::ScalarTraits< float >::magnitudeType"""
        return _Teuchos.ScalarTraitsFloat_prec(*args)

    prec = staticmethod(prec)

    def t(*args):
        """t() -> Teuchos::ScalarTraits< float >::magnitudeType"""
        return _Teuchos.ScalarTraitsFloat_t(*args)

    t = staticmethod(t)

    def rnd(*args):
        """rnd() -> Teuchos::ScalarTraits< float >::magnitudeType"""
        return _Teuchos.ScalarTraitsFloat_rnd(*args)

    rnd = staticmethod(rnd)

    def emin(*args):
        """emin() -> Teuchos::ScalarTraits< float >::magnitudeType"""
        return _Teuchos.ScalarTraitsFloat_emin(*args)

    emin = staticmethod(emin)

    def rmin(*args):
        """rmin() -> Teuchos::ScalarTraits< float >::magnitudeType"""
        return _Teuchos.ScalarTraitsFloat_rmin(*args)

    rmin = staticmethod(rmin)

    def emax(*args):
        """emax() -> Teuchos::ScalarTraits< float >::magnitudeType"""
        return _Teuchos.ScalarTraitsFloat_emax(*args)

    emax = staticmethod(emax)

    def rmax(*args):
        """rmax() -> Teuchos::ScalarTraits< float >::magnitudeType"""
        return _Teuchos.ScalarTraitsFloat_rmax(*args)

    rmax = staticmethod(rmax)

    def magnitude(*args):
        """magnitude(float a) -> Teuchos::ScalarTraits< float >::magnitudeType"""
        return _Teuchos.ScalarTraitsFloat_magnitude(*args)

    magnitude = staticmethod(magnitude)

    def zero(*args):
        """zero() -> float"""
        return _Teuchos.ScalarTraitsFloat_zero(*args)

    zero = staticmethod(zero)

    def one(*args):
        """one() -> float"""
        return _Teuchos.ScalarTraitsFloat_one(*args)

    one = staticmethod(one)

    def real(*args):
        """real(float a) -> Teuchos::ScalarTraits< float >::magnitudeType"""
        return _Teuchos.ScalarTraitsFloat_real(*args)

    real = staticmethod(real)

    def imag(*args):
        """imag(float a) -> Teuchos::ScalarTraits< float >::magnitudeType"""
        return _Teuchos.ScalarTraitsFloat_imag(*args)

    imag = staticmethod(imag)

    def conjugate(*args):
        """conjugate(float a) -> float"""
        return _Teuchos.ScalarTraitsFloat_conjugate(*args)

    conjugate = staticmethod(conjugate)

    def nan(*args):
        """nan() -> float"""
        return _Teuchos.ScalarTraitsFloat_nan(*args)

    nan = staticmethod(nan)

    def isnaninf(*args):
        """isnaninf(float const & x) -> bool"""
        return _Teuchos.ScalarTraitsFloat_isnaninf(*args)

    isnaninf = staticmethod(isnaninf)

    def seedrandom(*args):
        """seedrandom(unsigned int s)"""
        return _Teuchos.ScalarTraitsFloat_seedrandom(*args)

    seedrandom = staticmethod(seedrandom)

    def random(*args):
        """random() -> float"""
        return _Teuchos.ScalarTraitsFloat_random(*args)

    random = staticmethod(random)

    def name(*args):
        """name() -> std::string"""
        return _Teuchos.ScalarTraitsFloat_name(*args)

    name = staticmethod(name)

    def squareroot(*args):
        """squareroot(float x) -> float"""
        return _Teuchos.ScalarTraitsFloat_squareroot(*args)

    squareroot = staticmethod(squareroot)

    def pow(*args):
        """pow(float x, float y) -> float"""
        return _Teuchos.ScalarTraitsFloat_pow(*args)

    pow = staticmethod(pow)

    def __init__(self, *args):
        """__init__(Teuchos::ScalarTraits<(float)> self) -> ScalarTraitsFloat"""
        this = _Teuchos.new_ScalarTraitsFloat(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _Teuchos.delete_ScalarTraitsFloat
ScalarTraitsFloat_swigregister = _Teuchos.ScalarTraitsFloat_swigregister
ScalarTraitsFloat_swigregister(ScalarTraitsFloat)

def ScalarTraitsFloat_eps(*args):
    """ScalarTraitsFloat_eps() -> Teuchos::ScalarTraits< float >::magnitudeType"""
    return _Teuchos.ScalarTraitsFloat_eps(*args)

def ScalarTraitsFloat_sfmin(*args):
    """ScalarTraitsFloat_sfmin() -> Teuchos::ScalarTraits< float >::magnitudeType"""
    return _Teuchos.ScalarTraitsFloat_sfmin(*args)

def ScalarTraitsFloat_base(*args):
    """ScalarTraitsFloat_base() -> Teuchos::ScalarTraits< float >::magnitudeType"""
    return _Teuchos.ScalarTraitsFloat_base(*args)

def ScalarTraitsFloat_prec(*args):
    """ScalarTraitsFloat_prec() -> Teuchos::ScalarTraits< float >::magnitudeType"""
    return _Teuchos.ScalarTraitsFloat_prec(*args)

def ScalarTraitsFloat_t(*args):
    """ScalarTraitsFloat_t() -> Teuchos::ScalarTraits< float >::magnitudeType"""
    return _Teuchos.ScalarTraitsFloat_t(*args)

def ScalarTraitsFloat_rnd(*args):
    """ScalarTraitsFloat_rnd() -> Teuchos::ScalarTraits< float >::magnitudeType"""
    return _Teuchos.ScalarTraitsFloat_rnd(*args)

def ScalarTraitsFloat_emin(*args):
    """ScalarTraitsFloat_emin() -> Teuchos::ScalarTraits< float >::magnitudeType"""
    return _Teuchos.ScalarTraitsFloat_emin(*args)

def ScalarTraitsFloat_rmin(*args):
    """ScalarTraitsFloat_rmin() -> Teuchos::ScalarTraits< float >::magnitudeType"""
    return _Teuchos.ScalarTraitsFloat_rmin(*args)

def ScalarTraitsFloat_emax(*args):
    """ScalarTraitsFloat_emax() -> Teuchos::ScalarTraits< float >::magnitudeType"""
    return _Teuchos.ScalarTraitsFloat_emax(*args)

def ScalarTraitsFloat_rmax(*args):
    """ScalarTraitsFloat_rmax() -> Teuchos::ScalarTraits< float >::magnitudeType"""
    return _Teuchos.ScalarTraitsFloat_rmax(*args)

def ScalarTraitsFloat_magnitude(*args):
    """ScalarTraitsFloat_magnitude(float a) -> Teuchos::ScalarTraits< float >::magnitudeType"""
    return _Teuchos.ScalarTraitsFloat_magnitude(*args)

def ScalarTraitsFloat_zero(*args):
    """ScalarTraitsFloat_zero() -> float"""
    return _Teuchos.ScalarTraitsFloat_zero(*args)

def ScalarTraitsFloat_one(*args):
    """ScalarTraitsFloat_one() -> float"""
    return _Teuchos.ScalarTraitsFloat_one(*args)

def ScalarTraitsFloat_real(*args):
    """ScalarTraitsFloat_real(float a) -> Teuchos::ScalarTraits< float >::magnitudeType"""
    return _Teuchos.ScalarTraitsFloat_real(*args)

def ScalarTraitsFloat_imag(*args):
    """ScalarTraitsFloat_imag(float a) -> Teuchos::ScalarTraits< float >::magnitudeType"""
    return _Teuchos.ScalarTraitsFloat_imag(*args)

def ScalarTraitsFloat_conjugate(*args):
    """ScalarTraitsFloat_conjugate(float a) -> float"""
    return _Teuchos.ScalarTraitsFloat_conjugate(*args)

def ScalarTraitsFloat_nan(*args):
    """ScalarTraitsFloat_nan() -> float"""
    return _Teuchos.ScalarTraitsFloat_nan(*args)

def ScalarTraitsFloat_isnaninf(*args):
    """ScalarTraitsFloat_isnaninf(float const & x) -> bool"""
    return _Teuchos.ScalarTraitsFloat_isnaninf(*args)

def ScalarTraitsFloat_seedrandom(*args):
    """ScalarTraitsFloat_seedrandom(unsigned int s)"""
    return _Teuchos.ScalarTraitsFloat_seedrandom(*args)

def ScalarTraitsFloat_random(*args):
    """ScalarTraitsFloat_random() -> float"""
    return _Teuchos.ScalarTraitsFloat_random(*args)

def ScalarTraitsFloat_name(*args):
    """ScalarTraitsFloat_name() -> std::string"""
    return _Teuchos.ScalarTraitsFloat_name(*args)

def ScalarTraitsFloat_squareroot(*args):
    """ScalarTraitsFloat_squareroot(float x) -> float"""
    return _Teuchos.ScalarTraitsFloat_squareroot(*args)

def ScalarTraitsFloat_pow(*args):
    """ScalarTraitsFloat_pow(float x, float y) -> float"""
    return _Teuchos.ScalarTraitsFloat_pow(*args)

class ScalarTraitsDouble(_object):
    """Proxy of C++ Teuchos::ScalarTraits<(double)> class."""

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, ScalarTraitsDouble, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, ScalarTraitsDouble, name)
    __repr__ = _swig_repr
    isComplex = _Teuchos.ScalarTraitsDouble_isComplex
    isOrdinal = _Teuchos.ScalarTraitsDouble_isOrdinal
    isComparable = _Teuchos.ScalarTraitsDouble_isComparable
    hasMachineParameters = _Teuchos.ScalarTraitsDouble_hasMachineParameters

    def eps(*args):
        """eps() -> Teuchos::ScalarTraits< double >::magnitudeType"""
        return _Teuchos.ScalarTraitsDouble_eps(*args)

    eps = staticmethod(eps)

    def sfmin(*args):
        """sfmin() -> Teuchos::ScalarTraits< double >::magnitudeType"""
        return _Teuchos.ScalarTraitsDouble_sfmin(*args)

    sfmin = staticmethod(sfmin)

    def base(*args):
        """base() -> Teuchos::ScalarTraits< double >::magnitudeType"""
        return _Teuchos.ScalarTraitsDouble_base(*args)

    base = staticmethod(base)

    def prec(*args):
        """prec() -> Teuchos::ScalarTraits< double >::magnitudeType"""
        return _Teuchos.ScalarTraitsDouble_prec(*args)

    prec = staticmethod(prec)

    def t(*args):
        """t() -> Teuchos::ScalarTraits< double >::magnitudeType"""
        return _Teuchos.ScalarTraitsDouble_t(*args)

    t = staticmethod(t)

    def rnd(*args):
        """rnd() -> Teuchos::ScalarTraits< double >::magnitudeType"""
        return _Teuchos.ScalarTraitsDouble_rnd(*args)

    rnd = staticmethod(rnd)

    def emin(*args):
        """emin() -> Teuchos::ScalarTraits< double >::magnitudeType"""
        return _Teuchos.ScalarTraitsDouble_emin(*args)

    emin = staticmethod(emin)

    def rmin(*args):
        """rmin() -> Teuchos::ScalarTraits< double >::magnitudeType"""
        return _Teuchos.ScalarTraitsDouble_rmin(*args)

    rmin = staticmethod(rmin)

    def emax(*args):
        """emax() -> Teuchos::ScalarTraits< double >::magnitudeType"""
        return _Teuchos.ScalarTraitsDouble_emax(*args)

    emax = staticmethod(emax)

    def rmax(*args):
        """rmax() -> Teuchos::ScalarTraits< double >::magnitudeType"""
        return _Teuchos.ScalarTraitsDouble_rmax(*args)

    rmax = staticmethod(rmax)

    def magnitude(*args):
        """magnitude(double a) -> Teuchos::ScalarTraits< double >::magnitudeType"""
        return _Teuchos.ScalarTraitsDouble_magnitude(*args)

    magnitude = staticmethod(magnitude)

    def zero(*args):
        """zero() -> double"""
        return _Teuchos.ScalarTraitsDouble_zero(*args)

    zero = staticmethod(zero)

    def one(*args):
        """one() -> double"""
        return _Teuchos.ScalarTraitsDouble_one(*args)

    one = staticmethod(one)

    def real(*args):
        """real(double a) -> Teuchos::ScalarTraits< double >::magnitudeType"""
        return _Teuchos.ScalarTraitsDouble_real(*args)

    real = staticmethod(real)

    def imag(*args):
        """imag(double a) -> Teuchos::ScalarTraits< double >::magnitudeType"""
        return _Teuchos.ScalarTraitsDouble_imag(*args)

    imag = staticmethod(imag)

    def conjugate(*args):
        """conjugate(double a) -> double"""
        return _Teuchos.ScalarTraitsDouble_conjugate(*args)

    conjugate = staticmethod(conjugate)

    def nan(*args):
        """nan() -> double"""
        return _Teuchos.ScalarTraitsDouble_nan(*args)

    nan = staticmethod(nan)

    def isnaninf(*args):
        """isnaninf(double const & x) -> bool"""
        return _Teuchos.ScalarTraitsDouble_isnaninf(*args)

    isnaninf = staticmethod(isnaninf)

    def seedrandom(*args):
        """seedrandom(unsigned int s)"""
        return _Teuchos.ScalarTraitsDouble_seedrandom(*args)

    seedrandom = staticmethod(seedrandom)

    def random(*args):
        """random() -> double"""
        return _Teuchos.ScalarTraitsDouble_random(*args)

    random = staticmethod(random)

    def name(*args):
        """name() -> std::string"""
        return _Teuchos.ScalarTraitsDouble_name(*args)

    name = staticmethod(name)

    def squareroot(*args):
        """squareroot(double x) -> double"""
        return _Teuchos.ScalarTraitsDouble_squareroot(*args)

    squareroot = staticmethod(squareroot)

    def pow(*args):
        """pow(double x, double y) -> double"""
        return _Teuchos.ScalarTraitsDouble_pow(*args)

    pow = staticmethod(pow)

    def __init__(self, *args):
        """__init__(Teuchos::ScalarTraits<(double)> self) -> ScalarTraitsDouble"""
        this = _Teuchos.new_ScalarTraitsDouble(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _Teuchos.delete_ScalarTraitsDouble
ScalarTraitsDouble_swigregister = _Teuchos.ScalarTraitsDouble_swigregister
ScalarTraitsDouble_swigregister(ScalarTraitsDouble)

def ScalarTraitsDouble_eps(*args):
    """ScalarTraitsDouble_eps() -> Teuchos::ScalarTraits< double >::magnitudeType"""
    return _Teuchos.ScalarTraitsDouble_eps(*args)

def ScalarTraitsDouble_sfmin(*args):
    """ScalarTraitsDouble_sfmin() -> Teuchos::ScalarTraits< double >::magnitudeType"""
    return _Teuchos.ScalarTraitsDouble_sfmin(*args)

def ScalarTraitsDouble_base(*args):
    """ScalarTraitsDouble_base() -> Teuchos::ScalarTraits< double >::magnitudeType"""
    return _Teuchos.ScalarTraitsDouble_base(*args)

def ScalarTraitsDouble_prec(*args):
    """ScalarTraitsDouble_prec() -> Teuchos::ScalarTraits< double >::magnitudeType"""
    return _Teuchos.ScalarTraitsDouble_prec(*args)

def ScalarTraitsDouble_t(*args):
    """ScalarTraitsDouble_t() -> Teuchos::ScalarTraits< double >::magnitudeType"""
    return _Teuchos.ScalarTraitsDouble_t(*args)

def ScalarTraitsDouble_rnd(*args):
    """ScalarTraitsDouble_rnd() -> Teuchos::ScalarTraits< double >::magnitudeType"""
    return _Teuchos.ScalarTraitsDouble_rnd(*args)

def ScalarTraitsDouble_emin(*args):
    """ScalarTraitsDouble_emin() -> Teuchos::ScalarTraits< double >::magnitudeType"""
    return _Teuchos.ScalarTraitsDouble_emin(*args)

def ScalarTraitsDouble_rmin(*args):
    """ScalarTraitsDouble_rmin() -> Teuchos::ScalarTraits< double >::magnitudeType"""
    return _Teuchos.ScalarTraitsDouble_rmin(*args)

def ScalarTraitsDouble_emax(*args):
    """ScalarTraitsDouble_emax() -> Teuchos::ScalarTraits< double >::magnitudeType"""
    return _Teuchos.ScalarTraitsDouble_emax(*args)

def ScalarTraitsDouble_rmax(*args):
    """ScalarTraitsDouble_rmax() -> Teuchos::ScalarTraits< double >::magnitudeType"""
    return _Teuchos.ScalarTraitsDouble_rmax(*args)

def ScalarTraitsDouble_magnitude(*args):
    """ScalarTraitsDouble_magnitude(double a) -> Teuchos::ScalarTraits< double >::magnitudeType"""
    return _Teuchos.ScalarTraitsDouble_magnitude(*args)

def ScalarTraitsDouble_zero(*args):
    """ScalarTraitsDouble_zero() -> double"""
    return _Teuchos.ScalarTraitsDouble_zero(*args)

def ScalarTraitsDouble_one(*args):
    """ScalarTraitsDouble_one() -> double"""
    return _Teuchos.ScalarTraitsDouble_one(*args)

def ScalarTraitsDouble_real(*args):
    """ScalarTraitsDouble_real(double a) -> Teuchos::ScalarTraits< double >::magnitudeType"""
    return _Teuchos.ScalarTraitsDouble_real(*args)

def ScalarTraitsDouble_imag(*args):
    """ScalarTraitsDouble_imag(double a) -> Teuchos::ScalarTraits< double >::magnitudeType"""
    return _Teuchos.ScalarTraitsDouble_imag(*args)

def ScalarTraitsDouble_conjugate(*args):
    """ScalarTraitsDouble_conjugate(double a) -> double"""
    return _Teuchos.ScalarTraitsDouble_conjugate(*args)

def ScalarTraitsDouble_nan(*args):
    """ScalarTraitsDouble_nan() -> double"""
    return _Teuchos.ScalarTraitsDouble_nan(*args)

def ScalarTraitsDouble_isnaninf(*args):
    """ScalarTraitsDouble_isnaninf(double const & x) -> bool"""
    return _Teuchos.ScalarTraitsDouble_isnaninf(*args)

def ScalarTraitsDouble_seedrandom(*args):
    """ScalarTraitsDouble_seedrandom(unsigned int s)"""
    return _Teuchos.ScalarTraitsDouble_seedrandom(*args)

def ScalarTraitsDouble_random(*args):
    """ScalarTraitsDouble_random() -> double"""
    return _Teuchos.ScalarTraitsDouble_random(*args)

def ScalarTraitsDouble_name(*args):
    """ScalarTraitsDouble_name() -> std::string"""
    return _Teuchos.ScalarTraitsDouble_name(*args)

def ScalarTraitsDouble_squareroot(*args):
    """ScalarTraitsDouble_squareroot(double x) -> double"""
    return _Teuchos.ScalarTraitsDouble_squareroot(*args)

def ScalarTraitsDouble_pow(*args):
    """ScalarTraitsDouble_pow(double x, double y) -> double"""
    return _Teuchos.ScalarTraitsDouble_pow(*args)


def ScalarTraits(scalarType):
    """
    ScalarTraits(str scalarType) -> ScalarTraits<...>

    The scalarType argument is for specifying the type of scalar for
    which traits are requested.  Limited NumPy-style type
    specification is supported:

        'b'  byte
        'B'  unsigned byte
        'h'  short
        'H'  unsigned short
        'i'  int
        'I'  unsigned int
        'l'  long
        'L'  unsigned long
        'q'  long long
        'Q'  unsigned long long
        'f'  float
        'd'  double
    """
    if   scalarType == 'b': return ScalarTraitsByte()
    elif scalarType == 'B': return ScalarTraitsUbyte()
    elif scalarType == 'h': return ScalarTraitsShort()
    elif scalarType == 'H': return ScalarTraitsUshort()
    elif scalarType == 'i': return ScalarTraitsInt()
    elif scalarType == 'I': return ScalarTraitsUint()
    elif scalarType == 'l': return ScalarTraitsLong()
    elif scalarType == 'L': return ScalarTraitsUlong()
    elif scalarType == 'q': return ScalarTraitsLongLong()
    elif scalarType == 'Q': return ScalarTraitsUlongLong()
    elif scalarType == 'f': return ScalarTraitsFloat()
    elif scalarType == 'd': return ScalarTraitsDouble()
    raise NotImplementedError, "ScalarTraits for " + repr(scalarType) + " not supported"

class DirectSerializationTraitsByte(_object):
    """Proxy of C++ Teuchos::DirectSerializationTraits<(long,char)> class."""

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, DirectSerializationTraitsByte, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, DirectSerializationTraitsByte, name)
    __repr__ = _swig_repr
    supportsDirectSerialization = _Teuchos.DirectSerializationTraitsByte_supportsDirectSerialization

    def fromCountToDirectBytes(*args):
        """fromCountToDirectBytes(long const count) -> long"""
        return _Teuchos.DirectSerializationTraitsByte_fromCountToDirectBytes(*args)

    fromCountToDirectBytes = staticmethod(fromCountToDirectBytes)

    def convertToCharPtr(*args):
        """convertToCharPtr(char * ptr) -> char *"""
        return _Teuchos.DirectSerializationTraitsByte_convertToCharPtr(*args)

    convertToCharPtr = staticmethod(convertToCharPtr)

    def fromDirectBytesToCount(*args):
        """fromDirectBytesToCount(long const count) -> long"""
        return _Teuchos.DirectSerializationTraitsByte_fromDirectBytesToCount(*args)

    fromDirectBytesToCount = staticmethod(fromDirectBytesToCount)

    def convertFromCharPtr(*args):
        """convertFromCharPtr(char * ptr) -> char *"""
        return _Teuchos.DirectSerializationTraitsByte_convertFromCharPtr(*args)

    convertFromCharPtr = staticmethod(convertFromCharPtr)

    def fromCountToIndirectBytes(*args):
        """fromCountToIndirectBytes(long const count, char const [] buffer) -> long"""
        return _Teuchos.DirectSerializationTraitsByte_fromCountToIndirectBytes(*args)

    fromCountToIndirectBytes = staticmethod(fromCountToIndirectBytes)

    def serialize(*args):
        """serialize(long const count, char const [] buffer, long const bytes, char [] charBuffer)"""
        return _Teuchos.DirectSerializationTraitsByte_serialize(*args)

    serialize = staticmethod(serialize)

    def fromIndirectBytesToCount(*args):
        """fromIndirectBytesToCount(long const bytes, char const [] charBuffer) -> long"""
        return _Teuchos.DirectSerializationTraitsByte_fromIndirectBytesToCount(*args)

    fromIndirectBytesToCount = staticmethod(fromIndirectBytesToCount)

    def deserialize(*args):
        """deserialize(long const bytes, char const [] charBuffer, long const count, char [] buffer)"""
        return _Teuchos.DirectSerializationTraitsByte_deserialize(*args)

    deserialize = staticmethod(deserialize)

    def __init__(self, *args):
        """__init__(Teuchos::DirectSerializationTraits<(long,char)> self) -> DirectSerializationTraitsByte"""
        this = _Teuchos.new_DirectSerializationTraitsByte(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _Teuchos.delete_DirectSerializationTraitsByte
DirectSerializationTraitsByte_swigregister = _Teuchos.DirectSerializationTraitsByte_swigregister
DirectSerializationTraitsByte_swigregister(DirectSerializationTraitsByte)

def DirectSerializationTraitsByte_fromCountToDirectBytes(*args):
    """DirectSerializationTraitsByte_fromCountToDirectBytes(long const count) -> long"""
    return _Teuchos.DirectSerializationTraitsByte_fromCountToDirectBytes(*args)

def DirectSerializationTraitsByte_convertToCharPtr(*args):
    """DirectSerializationTraitsByte_convertToCharPtr(char * ptr) -> char *"""
    return _Teuchos.DirectSerializationTraitsByte_convertToCharPtr(*args)

def DirectSerializationTraitsByte_fromDirectBytesToCount(*args):
    """DirectSerializationTraitsByte_fromDirectBytesToCount(long const count) -> long"""
    return _Teuchos.DirectSerializationTraitsByte_fromDirectBytesToCount(*args)

def DirectSerializationTraitsByte_convertFromCharPtr(*args):
    """DirectSerializationTraitsByte_convertFromCharPtr(char * ptr) -> char *"""
    return _Teuchos.DirectSerializationTraitsByte_convertFromCharPtr(*args)

def DirectSerializationTraitsByte_fromCountToIndirectBytes(*args):
    """DirectSerializationTraitsByte_fromCountToIndirectBytes(long const count, char const [] buffer) -> long"""
    return _Teuchos.DirectSerializationTraitsByte_fromCountToIndirectBytes(*args)

def DirectSerializationTraitsByte_serialize(*args):
    """DirectSerializationTraitsByte_serialize(long const count, char const [] buffer, long const bytes, char [] charBuffer)"""
    return _Teuchos.DirectSerializationTraitsByte_serialize(*args)

def DirectSerializationTraitsByte_fromIndirectBytesToCount(*args):
    """DirectSerializationTraitsByte_fromIndirectBytesToCount(long const bytes, char const [] charBuffer) -> long"""
    return _Teuchos.DirectSerializationTraitsByte_fromIndirectBytesToCount(*args)

def DirectSerializationTraitsByte_deserialize(*args):
    """DirectSerializationTraitsByte_deserialize(long const bytes, char const [] charBuffer, long const count, char [] buffer)"""
    return _Teuchos.DirectSerializationTraitsByte_deserialize(*args)

class SerializationTraitsByte(DirectSerializationTraitsByte):
    """Proxy of C++ Teuchos::SerializationTraits<(long,char)> class."""

    __swig_setmethods__ = {}
    for _s in [DirectSerializationTraitsByte]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, SerializationTraitsByte, name, value)
    __swig_getmethods__ = {}
    for _s in [DirectSerializationTraitsByte]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, SerializationTraitsByte, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """__init__(Teuchos::SerializationTraits<(long,char)> self) -> SerializationTraitsByte"""
        this = _Teuchos.new_SerializationTraitsByte(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _Teuchos.delete_SerializationTraitsByte
SerializationTraitsByte_swigregister = _Teuchos.SerializationTraitsByte_swigregister
SerializationTraitsByte_swigregister(SerializationTraitsByte)

class DirectSerializationTraitsUbyte(_object):
    """Proxy of C++ Teuchos::DirectSerializationTraits<(long,unsigned char)> class."""

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, DirectSerializationTraitsUbyte, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, DirectSerializationTraitsUbyte, name)
    __repr__ = _swig_repr
    supportsDirectSerialization = _Teuchos.DirectSerializationTraitsUbyte_supportsDirectSerialization

    def fromCountToDirectBytes(*args):
        """fromCountToDirectBytes(long const count) -> long"""
        return _Teuchos.DirectSerializationTraitsUbyte_fromCountToDirectBytes(*args)

    fromCountToDirectBytes = staticmethod(fromCountToDirectBytes)

    def convertToCharPtr(*args):
        """convertToCharPtr(unsigned char * ptr) -> char *"""
        return _Teuchos.DirectSerializationTraitsUbyte_convertToCharPtr(*args)

    convertToCharPtr = staticmethod(convertToCharPtr)

    def fromDirectBytesToCount(*args):
        """fromDirectBytesToCount(long const count) -> long"""
        return _Teuchos.DirectSerializationTraitsUbyte_fromDirectBytesToCount(*args)

    fromDirectBytesToCount = staticmethod(fromDirectBytesToCount)

    def convertFromCharPtr(*args):
        """convertFromCharPtr(char * ptr) -> unsigned char *"""
        return _Teuchos.DirectSerializationTraitsUbyte_convertFromCharPtr(*args)

    convertFromCharPtr = staticmethod(convertFromCharPtr)

    def fromCountToIndirectBytes(*args):
        """fromCountToIndirectBytes(long const count, unsigned char const [] buffer) -> long"""
        return _Teuchos.DirectSerializationTraitsUbyte_fromCountToIndirectBytes(*args)

    fromCountToIndirectBytes = staticmethod(fromCountToIndirectBytes)

    def serialize(*args):
        """serialize(long const count, unsigned char const [] buffer, long const bytes, char [] charBuffer)"""
        return _Teuchos.DirectSerializationTraitsUbyte_serialize(*args)

    serialize = staticmethod(serialize)

    def fromIndirectBytesToCount(*args):
        """fromIndirectBytesToCount(long const bytes, char const [] charBuffer) -> long"""
        return _Teuchos.DirectSerializationTraitsUbyte_fromIndirectBytesToCount(*args)

    fromIndirectBytesToCount = staticmethod(fromIndirectBytesToCount)

    def deserialize(*args):
        """deserialize(long const bytes, char const [] charBuffer, long const count, unsigned char [] buffer)"""
        return _Teuchos.DirectSerializationTraitsUbyte_deserialize(*args)

    deserialize = staticmethod(deserialize)

    def __init__(self, *args):
        """__init__(Teuchos::DirectSerializationTraits<(long,unsigned char)> self) -> DirectSerializationTraitsUbyte"""
        this = _Teuchos.new_DirectSerializationTraitsUbyte(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _Teuchos.delete_DirectSerializationTraitsUbyte
DirectSerializationTraitsUbyte_swigregister = _Teuchos.DirectSerializationTraitsUbyte_swigregister
DirectSerializationTraitsUbyte_swigregister(DirectSerializationTraitsUbyte)

def DirectSerializationTraitsUbyte_fromCountToDirectBytes(*args):
    """DirectSerializationTraitsUbyte_fromCountToDirectBytes(long const count) -> long"""
    return _Teuchos.DirectSerializationTraitsUbyte_fromCountToDirectBytes(*args)

def DirectSerializationTraitsUbyte_convertToCharPtr(*args):
    """DirectSerializationTraitsUbyte_convertToCharPtr(unsigned char * ptr) -> char *"""
    return _Teuchos.DirectSerializationTraitsUbyte_convertToCharPtr(*args)

def DirectSerializationTraitsUbyte_fromDirectBytesToCount(*args):
    """DirectSerializationTraitsUbyte_fromDirectBytesToCount(long const count) -> long"""
    return _Teuchos.DirectSerializationTraitsUbyte_fromDirectBytesToCount(*args)

def DirectSerializationTraitsUbyte_convertFromCharPtr(*args):
    """DirectSerializationTraitsUbyte_convertFromCharPtr(char * ptr) -> unsigned char *"""
    return _Teuchos.DirectSerializationTraitsUbyte_convertFromCharPtr(*args)

def DirectSerializationTraitsUbyte_fromCountToIndirectBytes(*args):
    """DirectSerializationTraitsUbyte_fromCountToIndirectBytes(long const count, unsigned char const [] buffer) -> long"""
    return _Teuchos.DirectSerializationTraitsUbyte_fromCountToIndirectBytes(*args)

def DirectSerializationTraitsUbyte_serialize(*args):
    """DirectSerializationTraitsUbyte_serialize(long const count, unsigned char const [] buffer, long const bytes, char [] charBuffer)"""
    return _Teuchos.DirectSerializationTraitsUbyte_serialize(*args)

def DirectSerializationTraitsUbyte_fromIndirectBytesToCount(*args):
    """DirectSerializationTraitsUbyte_fromIndirectBytesToCount(long const bytes, char const [] charBuffer) -> long"""
    return _Teuchos.DirectSerializationTraitsUbyte_fromIndirectBytesToCount(*args)

def DirectSerializationTraitsUbyte_deserialize(*args):
    """DirectSerializationTraitsUbyte_deserialize(long const bytes, char const [] charBuffer, long const count, unsigned char [] buffer)"""
    return _Teuchos.DirectSerializationTraitsUbyte_deserialize(*args)

class SerializationTraitsUbyte(DirectSerializationTraitsUbyte):
    """Proxy of C++ Teuchos::SerializationTraits<(long,unsigned char)> class."""

    __swig_setmethods__ = {}
    for _s in [DirectSerializationTraitsUbyte]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, SerializationTraitsUbyte, name, value)
    __swig_getmethods__ = {}
    for _s in [DirectSerializationTraitsUbyte]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, SerializationTraitsUbyte, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """__init__(Teuchos::SerializationTraits<(long,unsigned char)> self) -> SerializationTraitsUbyte"""
        this = _Teuchos.new_SerializationTraitsUbyte(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _Teuchos.delete_SerializationTraitsUbyte
SerializationTraitsUbyte_swigregister = _Teuchos.SerializationTraitsUbyte_swigregister
SerializationTraitsUbyte_swigregister(SerializationTraitsUbyte)

class DirectSerializationTraitsShort(_object):
    """Proxy of C++ Teuchos::DirectSerializationTraits<(long,short)> class."""

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, DirectSerializationTraitsShort, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, DirectSerializationTraitsShort, name)
    __repr__ = _swig_repr
    supportsDirectSerialization = _Teuchos.DirectSerializationTraitsShort_supportsDirectSerialization

    def fromCountToDirectBytes(*args):
        """fromCountToDirectBytes(long const count) -> long"""
        return _Teuchos.DirectSerializationTraitsShort_fromCountToDirectBytes(*args)

    fromCountToDirectBytes = staticmethod(fromCountToDirectBytes)

    def convertToCharPtr(*args):
        """convertToCharPtr(short * ptr) -> char *"""
        return _Teuchos.DirectSerializationTraitsShort_convertToCharPtr(*args)

    convertToCharPtr = staticmethod(convertToCharPtr)

    def fromDirectBytesToCount(*args):
        """fromDirectBytesToCount(long const count) -> long"""
        return _Teuchos.DirectSerializationTraitsShort_fromDirectBytesToCount(*args)

    fromDirectBytesToCount = staticmethod(fromDirectBytesToCount)

    def convertFromCharPtr(*args):
        """convertFromCharPtr(char * ptr) -> short *"""
        return _Teuchos.DirectSerializationTraitsShort_convertFromCharPtr(*args)

    convertFromCharPtr = staticmethod(convertFromCharPtr)

    def fromCountToIndirectBytes(*args):
        """fromCountToIndirectBytes(long const count, short const [] buffer) -> long"""
        return _Teuchos.DirectSerializationTraitsShort_fromCountToIndirectBytes(*args)

    fromCountToIndirectBytes = staticmethod(fromCountToIndirectBytes)

    def serialize(*args):
        """serialize(long const count, short const [] buffer, long const bytes, char [] charBuffer)"""
        return _Teuchos.DirectSerializationTraitsShort_serialize(*args)

    serialize = staticmethod(serialize)

    def fromIndirectBytesToCount(*args):
        """fromIndirectBytesToCount(long const bytes, char const [] charBuffer) -> long"""
        return _Teuchos.DirectSerializationTraitsShort_fromIndirectBytesToCount(*args)

    fromIndirectBytesToCount = staticmethod(fromIndirectBytesToCount)

    def deserialize(*args):
        """deserialize(long const bytes, char const [] charBuffer, long const count, short [] buffer)"""
        return _Teuchos.DirectSerializationTraitsShort_deserialize(*args)

    deserialize = staticmethod(deserialize)

    def __init__(self, *args):
        """__init__(Teuchos::DirectSerializationTraits<(long,short)> self) -> DirectSerializationTraitsShort"""
        this = _Teuchos.new_DirectSerializationTraitsShort(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _Teuchos.delete_DirectSerializationTraitsShort
DirectSerializationTraitsShort_swigregister = _Teuchos.DirectSerializationTraitsShort_swigregister
DirectSerializationTraitsShort_swigregister(DirectSerializationTraitsShort)

def DirectSerializationTraitsShort_fromCountToDirectBytes(*args):
    """DirectSerializationTraitsShort_fromCountToDirectBytes(long const count) -> long"""
    return _Teuchos.DirectSerializationTraitsShort_fromCountToDirectBytes(*args)

def DirectSerializationTraitsShort_convertToCharPtr(*args):
    """DirectSerializationTraitsShort_convertToCharPtr(short * ptr) -> char *"""
    return _Teuchos.DirectSerializationTraitsShort_convertToCharPtr(*args)

def DirectSerializationTraitsShort_fromDirectBytesToCount(*args):
    """DirectSerializationTraitsShort_fromDirectBytesToCount(long const count) -> long"""
    return _Teuchos.DirectSerializationTraitsShort_fromDirectBytesToCount(*args)

def DirectSerializationTraitsShort_convertFromCharPtr(*args):
    """DirectSerializationTraitsShort_convertFromCharPtr(char * ptr) -> short *"""
    return _Teuchos.DirectSerializationTraitsShort_convertFromCharPtr(*args)

def DirectSerializationTraitsShort_fromCountToIndirectBytes(*args):
    """DirectSerializationTraitsShort_fromCountToIndirectBytes(long const count, short const [] buffer) -> long"""
    return _Teuchos.DirectSerializationTraitsShort_fromCountToIndirectBytes(*args)

def DirectSerializationTraitsShort_serialize(*args):
    """DirectSerializationTraitsShort_serialize(long const count, short const [] buffer, long const bytes, char [] charBuffer)"""
    return _Teuchos.DirectSerializationTraitsShort_serialize(*args)

def DirectSerializationTraitsShort_fromIndirectBytesToCount(*args):
    """DirectSerializationTraitsShort_fromIndirectBytesToCount(long const bytes, char const [] charBuffer) -> long"""
    return _Teuchos.DirectSerializationTraitsShort_fromIndirectBytesToCount(*args)

def DirectSerializationTraitsShort_deserialize(*args):
    """DirectSerializationTraitsShort_deserialize(long const bytes, char const [] charBuffer, long const count, short [] buffer)"""
    return _Teuchos.DirectSerializationTraitsShort_deserialize(*args)

class SerializationTraitsShort(DirectSerializationTraitsShort):
    """Proxy of C++ Teuchos::SerializationTraits<(long,short)> class."""

    __swig_setmethods__ = {}
    for _s in [DirectSerializationTraitsShort]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, SerializationTraitsShort, name, value)
    __swig_getmethods__ = {}
    for _s in [DirectSerializationTraitsShort]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, SerializationTraitsShort, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """__init__(Teuchos::SerializationTraits<(long,short)> self) -> SerializationTraitsShort"""
        this = _Teuchos.new_SerializationTraitsShort(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _Teuchos.delete_SerializationTraitsShort
SerializationTraitsShort_swigregister = _Teuchos.SerializationTraitsShort_swigregister
SerializationTraitsShort_swigregister(SerializationTraitsShort)

class DirectSerializationTraitsUshort(_object):
    """Proxy of C++ Teuchos::DirectSerializationTraits<(long,unsigned short)> class."""

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, DirectSerializationTraitsUshort, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, DirectSerializationTraitsUshort, name)
    __repr__ = _swig_repr
    supportsDirectSerialization = _Teuchos.DirectSerializationTraitsUshort_supportsDirectSerialization

    def fromCountToDirectBytes(*args):
        """fromCountToDirectBytes(long const count) -> long"""
        return _Teuchos.DirectSerializationTraitsUshort_fromCountToDirectBytes(*args)

    fromCountToDirectBytes = staticmethod(fromCountToDirectBytes)

    def convertToCharPtr(*args):
        """convertToCharPtr(unsigned short * ptr) -> char *"""
        return _Teuchos.DirectSerializationTraitsUshort_convertToCharPtr(*args)

    convertToCharPtr = staticmethod(convertToCharPtr)

    def fromDirectBytesToCount(*args):
        """fromDirectBytesToCount(long const count) -> long"""
        return _Teuchos.DirectSerializationTraitsUshort_fromDirectBytesToCount(*args)

    fromDirectBytesToCount = staticmethod(fromDirectBytesToCount)

    def convertFromCharPtr(*args):
        """convertFromCharPtr(char * ptr) -> unsigned short *"""
        return _Teuchos.DirectSerializationTraitsUshort_convertFromCharPtr(*args)

    convertFromCharPtr = staticmethod(convertFromCharPtr)

    def fromCountToIndirectBytes(*args):
        """fromCountToIndirectBytes(long const count, unsigned short const [] buffer) -> long"""
        return _Teuchos.DirectSerializationTraitsUshort_fromCountToIndirectBytes(*args)

    fromCountToIndirectBytes = staticmethod(fromCountToIndirectBytes)

    def serialize(*args):
        """serialize(long const count, unsigned short const [] buffer, long const bytes, char [] charBuffer)"""
        return _Teuchos.DirectSerializationTraitsUshort_serialize(*args)

    serialize = staticmethod(serialize)

    def fromIndirectBytesToCount(*args):
        """fromIndirectBytesToCount(long const bytes, char const [] charBuffer) -> long"""
        return _Teuchos.DirectSerializationTraitsUshort_fromIndirectBytesToCount(*args)

    fromIndirectBytesToCount = staticmethod(fromIndirectBytesToCount)

    def deserialize(*args):
        """deserialize(long const bytes, char const [] charBuffer, long const count, unsigned short [] buffer)"""
        return _Teuchos.DirectSerializationTraitsUshort_deserialize(*args)

    deserialize = staticmethod(deserialize)

    def __init__(self, *args):
        """__init__(Teuchos::DirectSerializationTraits<(long,unsigned short)> self) -> DirectSerializationTraitsUshort"""
        this = _Teuchos.new_DirectSerializationTraitsUshort(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _Teuchos.delete_DirectSerializationTraitsUshort
DirectSerializationTraitsUshort_swigregister = _Teuchos.DirectSerializationTraitsUshort_swigregister
DirectSerializationTraitsUshort_swigregister(DirectSerializationTraitsUshort)

def DirectSerializationTraitsUshort_fromCountToDirectBytes(*args):
    """DirectSerializationTraitsUshort_fromCountToDirectBytes(long const count) -> long"""
    return _Teuchos.DirectSerializationTraitsUshort_fromCountToDirectBytes(*args)

def DirectSerializationTraitsUshort_convertToCharPtr(*args):
    """DirectSerializationTraitsUshort_convertToCharPtr(unsigned short * ptr) -> char *"""
    return _Teuchos.DirectSerializationTraitsUshort_convertToCharPtr(*args)

def DirectSerializationTraitsUshort_fromDirectBytesToCount(*args):
    """DirectSerializationTraitsUshort_fromDirectBytesToCount(long const count) -> long"""
    return _Teuchos.DirectSerializationTraitsUshort_fromDirectBytesToCount(*args)

def DirectSerializationTraitsUshort_convertFromCharPtr(*args):
    """DirectSerializationTraitsUshort_convertFromCharPtr(char * ptr) -> unsigned short *"""
    return _Teuchos.DirectSerializationTraitsUshort_convertFromCharPtr(*args)

def DirectSerializationTraitsUshort_fromCountToIndirectBytes(*args):
    """DirectSerializationTraitsUshort_fromCountToIndirectBytes(long const count, unsigned short const [] buffer) -> long"""
    return _Teuchos.DirectSerializationTraitsUshort_fromCountToIndirectBytes(*args)

def DirectSerializationTraitsUshort_serialize(*args):
    """DirectSerializationTraitsUshort_serialize(long const count, unsigned short const [] buffer, long const bytes, char [] charBuffer)"""
    return _Teuchos.DirectSerializationTraitsUshort_serialize(*args)

def DirectSerializationTraitsUshort_fromIndirectBytesToCount(*args):
    """DirectSerializationTraitsUshort_fromIndirectBytesToCount(long const bytes, char const [] charBuffer) -> long"""
    return _Teuchos.DirectSerializationTraitsUshort_fromIndirectBytesToCount(*args)

def DirectSerializationTraitsUshort_deserialize(*args):
    """DirectSerializationTraitsUshort_deserialize(long const bytes, char const [] charBuffer, long const count, unsigned short [] buffer)"""
    return _Teuchos.DirectSerializationTraitsUshort_deserialize(*args)

class SerializationTraitsUshort(DirectSerializationTraitsUshort):
    """Proxy of C++ Teuchos::SerializationTraits<(long,unsigned short)> class."""

    __swig_setmethods__ = {}
    for _s in [DirectSerializationTraitsUshort]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, SerializationTraitsUshort, name, value)
    __swig_getmethods__ = {}
    for _s in [DirectSerializationTraitsUshort]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, SerializationTraitsUshort, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """__init__(Teuchos::SerializationTraits<(long,unsigned short)> self) -> SerializationTraitsUshort"""
        this = _Teuchos.new_SerializationTraitsUshort(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _Teuchos.delete_SerializationTraitsUshort
SerializationTraitsUshort_swigregister = _Teuchos.SerializationTraitsUshort_swigregister
SerializationTraitsUshort_swigregister(SerializationTraitsUshort)

class DirectSerializationTraitsInt(_object):
    """Proxy of C++ Teuchos::DirectSerializationTraits<(long,int)> class."""

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, DirectSerializationTraitsInt, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, DirectSerializationTraitsInt, name)
    __repr__ = _swig_repr
    supportsDirectSerialization = _Teuchos.DirectSerializationTraitsInt_supportsDirectSerialization

    def fromCountToDirectBytes(*args):
        """fromCountToDirectBytes(long const count) -> long"""
        return _Teuchos.DirectSerializationTraitsInt_fromCountToDirectBytes(*args)

    fromCountToDirectBytes = staticmethod(fromCountToDirectBytes)

    def convertToCharPtr(*args):
        """convertToCharPtr(int * ptr) -> char *"""
        return _Teuchos.DirectSerializationTraitsInt_convertToCharPtr(*args)

    convertToCharPtr = staticmethod(convertToCharPtr)

    def fromDirectBytesToCount(*args):
        """fromDirectBytesToCount(long const count) -> long"""
        return _Teuchos.DirectSerializationTraitsInt_fromDirectBytesToCount(*args)

    fromDirectBytesToCount = staticmethod(fromDirectBytesToCount)

    def convertFromCharPtr(*args):
        """convertFromCharPtr(char * ptr) -> int *"""
        return _Teuchos.DirectSerializationTraitsInt_convertFromCharPtr(*args)

    convertFromCharPtr = staticmethod(convertFromCharPtr)

    def fromCountToIndirectBytes(*args):
        """fromCountToIndirectBytes(long const count, int const [] buffer) -> long"""
        return _Teuchos.DirectSerializationTraitsInt_fromCountToIndirectBytes(*args)

    fromCountToIndirectBytes = staticmethod(fromCountToIndirectBytes)

    def serialize(*args):
        """serialize(long const count, int const [] buffer, long const bytes, char [] charBuffer)"""
        return _Teuchos.DirectSerializationTraitsInt_serialize(*args)

    serialize = staticmethod(serialize)

    def fromIndirectBytesToCount(*args):
        """fromIndirectBytesToCount(long const bytes, char const [] charBuffer) -> long"""
        return _Teuchos.DirectSerializationTraitsInt_fromIndirectBytesToCount(*args)

    fromIndirectBytesToCount = staticmethod(fromIndirectBytesToCount)

    def deserialize(*args):
        """deserialize(long const bytes, char const [] charBuffer, long const count, int [] buffer)"""
        return _Teuchos.DirectSerializationTraitsInt_deserialize(*args)

    deserialize = staticmethod(deserialize)

    def __init__(self, *args):
        """__init__(Teuchos::DirectSerializationTraits<(long,int)> self) -> DirectSerializationTraitsInt"""
        this = _Teuchos.new_DirectSerializationTraitsInt(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _Teuchos.delete_DirectSerializationTraitsInt
DirectSerializationTraitsInt_swigregister = _Teuchos.DirectSerializationTraitsInt_swigregister
DirectSerializationTraitsInt_swigregister(DirectSerializationTraitsInt)

def DirectSerializationTraitsInt_fromCountToDirectBytes(*args):
    """DirectSerializationTraitsInt_fromCountToDirectBytes(long const count) -> long"""
    return _Teuchos.DirectSerializationTraitsInt_fromCountToDirectBytes(*args)

def DirectSerializationTraitsInt_convertToCharPtr(*args):
    """DirectSerializationTraitsInt_convertToCharPtr(int * ptr) -> char *"""
    return _Teuchos.DirectSerializationTraitsInt_convertToCharPtr(*args)

def DirectSerializationTraitsInt_fromDirectBytesToCount(*args):
    """DirectSerializationTraitsInt_fromDirectBytesToCount(long const count) -> long"""
    return _Teuchos.DirectSerializationTraitsInt_fromDirectBytesToCount(*args)

def DirectSerializationTraitsInt_convertFromCharPtr(*args):
    """DirectSerializationTraitsInt_convertFromCharPtr(char * ptr) -> int *"""
    return _Teuchos.DirectSerializationTraitsInt_convertFromCharPtr(*args)

def DirectSerializationTraitsInt_fromCountToIndirectBytes(*args):
    """DirectSerializationTraitsInt_fromCountToIndirectBytes(long const count, int const [] buffer) -> long"""
    return _Teuchos.DirectSerializationTraitsInt_fromCountToIndirectBytes(*args)

def DirectSerializationTraitsInt_serialize(*args):
    """DirectSerializationTraitsInt_serialize(long const count, int const [] buffer, long const bytes, char [] charBuffer)"""
    return _Teuchos.DirectSerializationTraitsInt_serialize(*args)

def DirectSerializationTraitsInt_fromIndirectBytesToCount(*args):
    """DirectSerializationTraitsInt_fromIndirectBytesToCount(long const bytes, char const [] charBuffer) -> long"""
    return _Teuchos.DirectSerializationTraitsInt_fromIndirectBytesToCount(*args)

def DirectSerializationTraitsInt_deserialize(*args):
    """DirectSerializationTraitsInt_deserialize(long const bytes, char const [] charBuffer, long const count, int [] buffer)"""
    return _Teuchos.DirectSerializationTraitsInt_deserialize(*args)

class SerializationTraitsInt(DirectSerializationTraitsInt):
    """Proxy of C++ Teuchos::SerializationTraits<(long,int)> class."""

    __swig_setmethods__ = {}
    for _s in [DirectSerializationTraitsInt]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, SerializationTraitsInt, name, value)
    __swig_getmethods__ = {}
    for _s in [DirectSerializationTraitsInt]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, SerializationTraitsInt, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """__init__(Teuchos::SerializationTraits<(long,int)> self) -> SerializationTraitsInt"""
        this = _Teuchos.new_SerializationTraitsInt(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _Teuchos.delete_SerializationTraitsInt
SerializationTraitsInt_swigregister = _Teuchos.SerializationTraitsInt_swigregister
SerializationTraitsInt_swigregister(SerializationTraitsInt)

class DirectSerializationTraitsUint(_object):
    """Proxy of C++ Teuchos::DirectSerializationTraits<(long,unsigned int)> class."""

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, DirectSerializationTraitsUint, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, DirectSerializationTraitsUint, name)
    __repr__ = _swig_repr
    supportsDirectSerialization = _Teuchos.DirectSerializationTraitsUint_supportsDirectSerialization

    def fromCountToDirectBytes(*args):
        """fromCountToDirectBytes(long const count) -> long"""
        return _Teuchos.DirectSerializationTraitsUint_fromCountToDirectBytes(*args)

    fromCountToDirectBytes = staticmethod(fromCountToDirectBytes)

    def convertToCharPtr(*args):
        """convertToCharPtr(unsigned int * ptr) -> char *"""
        return _Teuchos.DirectSerializationTraitsUint_convertToCharPtr(*args)

    convertToCharPtr = staticmethod(convertToCharPtr)

    def fromDirectBytesToCount(*args):
        """fromDirectBytesToCount(long const count) -> long"""
        return _Teuchos.DirectSerializationTraitsUint_fromDirectBytesToCount(*args)

    fromDirectBytesToCount = staticmethod(fromDirectBytesToCount)

    def convertFromCharPtr(*args):
        """convertFromCharPtr(char * ptr) -> unsigned int *"""
        return _Teuchos.DirectSerializationTraitsUint_convertFromCharPtr(*args)

    convertFromCharPtr = staticmethod(convertFromCharPtr)

    def fromCountToIndirectBytes(*args):
        """fromCountToIndirectBytes(long const count, unsigned int const [] buffer) -> long"""
        return _Teuchos.DirectSerializationTraitsUint_fromCountToIndirectBytes(*args)

    fromCountToIndirectBytes = staticmethod(fromCountToIndirectBytes)

    def serialize(*args):
        """serialize(long const count, unsigned int const [] buffer, long const bytes, char [] charBuffer)"""
        return _Teuchos.DirectSerializationTraitsUint_serialize(*args)

    serialize = staticmethod(serialize)

    def fromIndirectBytesToCount(*args):
        """fromIndirectBytesToCount(long const bytes, char const [] charBuffer) -> long"""
        return _Teuchos.DirectSerializationTraitsUint_fromIndirectBytesToCount(*args)

    fromIndirectBytesToCount = staticmethod(fromIndirectBytesToCount)

    def deserialize(*args):
        """deserialize(long const bytes, char const [] charBuffer, long const count, unsigned int [] buffer)"""
        return _Teuchos.DirectSerializationTraitsUint_deserialize(*args)

    deserialize = staticmethod(deserialize)

    def __init__(self, *args):
        """__init__(Teuchos::DirectSerializationTraits<(long,unsigned int)> self) -> DirectSerializationTraitsUint"""
        this = _Teuchos.new_DirectSerializationTraitsUint(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _Teuchos.delete_DirectSerializationTraitsUint
DirectSerializationTraitsUint_swigregister = _Teuchos.DirectSerializationTraitsUint_swigregister
DirectSerializationTraitsUint_swigregister(DirectSerializationTraitsUint)

def DirectSerializationTraitsUint_fromCountToDirectBytes(*args):
    """DirectSerializationTraitsUint_fromCountToDirectBytes(long const count) -> long"""
    return _Teuchos.DirectSerializationTraitsUint_fromCountToDirectBytes(*args)

def DirectSerializationTraitsUint_convertToCharPtr(*args):
    """DirectSerializationTraitsUint_convertToCharPtr(unsigned int * ptr) -> char *"""
    return _Teuchos.DirectSerializationTraitsUint_convertToCharPtr(*args)

def DirectSerializationTraitsUint_fromDirectBytesToCount(*args):
    """DirectSerializationTraitsUint_fromDirectBytesToCount(long const count) -> long"""
    return _Teuchos.DirectSerializationTraitsUint_fromDirectBytesToCount(*args)

def DirectSerializationTraitsUint_convertFromCharPtr(*args):
    """DirectSerializationTraitsUint_convertFromCharPtr(char * ptr) -> unsigned int *"""
    return _Teuchos.DirectSerializationTraitsUint_convertFromCharPtr(*args)

def DirectSerializationTraitsUint_fromCountToIndirectBytes(*args):
    """DirectSerializationTraitsUint_fromCountToIndirectBytes(long const count, unsigned int const [] buffer) -> long"""
    return _Teuchos.DirectSerializationTraitsUint_fromCountToIndirectBytes(*args)

def DirectSerializationTraitsUint_serialize(*args):
    """DirectSerializationTraitsUint_serialize(long const count, unsigned int const [] buffer, long const bytes, char [] charBuffer)"""
    return _Teuchos.DirectSerializationTraitsUint_serialize(*args)

def DirectSerializationTraitsUint_fromIndirectBytesToCount(*args):
    """DirectSerializationTraitsUint_fromIndirectBytesToCount(long const bytes, char const [] charBuffer) -> long"""
    return _Teuchos.DirectSerializationTraitsUint_fromIndirectBytesToCount(*args)

def DirectSerializationTraitsUint_deserialize(*args):
    """DirectSerializationTraitsUint_deserialize(long const bytes, char const [] charBuffer, long const count, unsigned int [] buffer)"""
    return _Teuchos.DirectSerializationTraitsUint_deserialize(*args)

class SerializationTraitsUint(DirectSerializationTraitsUint):
    """Proxy of C++ Teuchos::SerializationTraits<(long,unsigned int)> class."""

    __swig_setmethods__ = {}
    for _s in [DirectSerializationTraitsUint]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, SerializationTraitsUint, name, value)
    __swig_getmethods__ = {}
    for _s in [DirectSerializationTraitsUint]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, SerializationTraitsUint, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """__init__(Teuchos::SerializationTraits<(long,unsigned int)> self) -> SerializationTraitsUint"""
        this = _Teuchos.new_SerializationTraitsUint(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _Teuchos.delete_SerializationTraitsUint
SerializationTraitsUint_swigregister = _Teuchos.SerializationTraitsUint_swigregister
SerializationTraitsUint_swigregister(SerializationTraitsUint)

class DirectSerializationTraitsLong(_object):
    """Proxy of C++ Teuchos::DirectSerializationTraits<(long,long)> class."""

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, DirectSerializationTraitsLong, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, DirectSerializationTraitsLong, name)
    __repr__ = _swig_repr
    supportsDirectSerialization = _Teuchos.DirectSerializationTraitsLong_supportsDirectSerialization

    def fromCountToDirectBytes(*args):
        """fromCountToDirectBytes(long const count) -> long"""
        return _Teuchos.DirectSerializationTraitsLong_fromCountToDirectBytes(*args)

    fromCountToDirectBytes = staticmethod(fromCountToDirectBytes)

    def convertToCharPtr(*args):
        """convertToCharPtr(long * ptr) -> char *"""
        return _Teuchos.DirectSerializationTraitsLong_convertToCharPtr(*args)

    convertToCharPtr = staticmethod(convertToCharPtr)

    def fromDirectBytesToCount(*args):
        """fromDirectBytesToCount(long const count) -> long"""
        return _Teuchos.DirectSerializationTraitsLong_fromDirectBytesToCount(*args)

    fromDirectBytesToCount = staticmethod(fromDirectBytesToCount)

    def convertFromCharPtr(*args):
        """convertFromCharPtr(char * ptr) -> long *"""
        return _Teuchos.DirectSerializationTraitsLong_convertFromCharPtr(*args)

    convertFromCharPtr = staticmethod(convertFromCharPtr)

    def fromCountToIndirectBytes(*args):
        """fromCountToIndirectBytes(long const count, long const [] buffer) -> long"""
        return _Teuchos.DirectSerializationTraitsLong_fromCountToIndirectBytes(*args)

    fromCountToIndirectBytes = staticmethod(fromCountToIndirectBytes)

    def serialize(*args):
        """serialize(long const count, long const [] buffer, long const bytes, char [] charBuffer)"""
        return _Teuchos.DirectSerializationTraitsLong_serialize(*args)

    serialize = staticmethod(serialize)

    def fromIndirectBytesToCount(*args):
        """fromIndirectBytesToCount(long const bytes, char const [] charBuffer) -> long"""
        return _Teuchos.DirectSerializationTraitsLong_fromIndirectBytesToCount(*args)

    fromIndirectBytesToCount = staticmethod(fromIndirectBytesToCount)

    def deserialize(*args):
        """deserialize(long const bytes, char const [] charBuffer, long const count, long [] buffer)"""
        return _Teuchos.DirectSerializationTraitsLong_deserialize(*args)

    deserialize = staticmethod(deserialize)

    def __init__(self, *args):
        """__init__(Teuchos::DirectSerializationTraits<(long,long)> self) -> DirectSerializationTraitsLong"""
        this = _Teuchos.new_DirectSerializationTraitsLong(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _Teuchos.delete_DirectSerializationTraitsLong
DirectSerializationTraitsLong_swigregister = _Teuchos.DirectSerializationTraitsLong_swigregister
DirectSerializationTraitsLong_swigregister(DirectSerializationTraitsLong)

def DirectSerializationTraitsLong_fromCountToDirectBytes(*args):
    """DirectSerializationTraitsLong_fromCountToDirectBytes(long const count) -> long"""
    return _Teuchos.DirectSerializationTraitsLong_fromCountToDirectBytes(*args)

def DirectSerializationTraitsLong_convertToCharPtr(*args):
    """DirectSerializationTraitsLong_convertToCharPtr(long * ptr) -> char *"""
    return _Teuchos.DirectSerializationTraitsLong_convertToCharPtr(*args)

def DirectSerializationTraitsLong_fromDirectBytesToCount(*args):
    """DirectSerializationTraitsLong_fromDirectBytesToCount(long const count) -> long"""
    return _Teuchos.DirectSerializationTraitsLong_fromDirectBytesToCount(*args)

def DirectSerializationTraitsLong_convertFromCharPtr(*args):
    """DirectSerializationTraitsLong_convertFromCharPtr(char * ptr) -> long *"""
    return _Teuchos.DirectSerializationTraitsLong_convertFromCharPtr(*args)

def DirectSerializationTraitsLong_fromCountToIndirectBytes(*args):
    """DirectSerializationTraitsLong_fromCountToIndirectBytes(long const count, long const [] buffer) -> long"""
    return _Teuchos.DirectSerializationTraitsLong_fromCountToIndirectBytes(*args)

def DirectSerializationTraitsLong_serialize(*args):
    """DirectSerializationTraitsLong_serialize(long const count, long const [] buffer, long const bytes, char [] charBuffer)"""
    return _Teuchos.DirectSerializationTraitsLong_serialize(*args)

def DirectSerializationTraitsLong_fromIndirectBytesToCount(*args):
    """DirectSerializationTraitsLong_fromIndirectBytesToCount(long const bytes, char const [] charBuffer) -> long"""
    return _Teuchos.DirectSerializationTraitsLong_fromIndirectBytesToCount(*args)

def DirectSerializationTraitsLong_deserialize(*args):
    """DirectSerializationTraitsLong_deserialize(long const bytes, char const [] charBuffer, long const count, long [] buffer)"""
    return _Teuchos.DirectSerializationTraitsLong_deserialize(*args)

class SerializationTraitsLong(DirectSerializationTraitsLong):
    """Proxy of C++ Teuchos::SerializationTraits<(long,long)> class."""

    __swig_setmethods__ = {}
    for _s in [DirectSerializationTraitsLong]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, SerializationTraitsLong, name, value)
    __swig_getmethods__ = {}
    for _s in [DirectSerializationTraitsLong]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, SerializationTraitsLong, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """__init__(Teuchos::SerializationTraits<(long,long)> self) -> SerializationTraitsLong"""
        this = _Teuchos.new_SerializationTraitsLong(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _Teuchos.delete_SerializationTraitsLong
SerializationTraitsLong_swigregister = _Teuchos.SerializationTraitsLong_swigregister
SerializationTraitsLong_swigregister(SerializationTraitsLong)

class DirectSerializationTraitsUlong(_object):
    """Proxy of C++ Teuchos::DirectSerializationTraits<(long,unsigned long)> class."""

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, DirectSerializationTraitsUlong, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, DirectSerializationTraitsUlong, name)
    __repr__ = _swig_repr
    supportsDirectSerialization = _Teuchos.DirectSerializationTraitsUlong_supportsDirectSerialization

    def fromCountToDirectBytes(*args):
        """fromCountToDirectBytes(long const count) -> long"""
        return _Teuchos.DirectSerializationTraitsUlong_fromCountToDirectBytes(*args)

    fromCountToDirectBytes = staticmethod(fromCountToDirectBytes)

    def convertToCharPtr(*args):
        """convertToCharPtr(unsigned long * ptr) -> char *"""
        return _Teuchos.DirectSerializationTraitsUlong_convertToCharPtr(*args)

    convertToCharPtr = staticmethod(convertToCharPtr)

    def fromDirectBytesToCount(*args):
        """fromDirectBytesToCount(long const count) -> long"""
        return _Teuchos.DirectSerializationTraitsUlong_fromDirectBytesToCount(*args)

    fromDirectBytesToCount = staticmethod(fromDirectBytesToCount)

    def convertFromCharPtr(*args):
        """convertFromCharPtr(char * ptr) -> unsigned long *"""
        return _Teuchos.DirectSerializationTraitsUlong_convertFromCharPtr(*args)

    convertFromCharPtr = staticmethod(convertFromCharPtr)

    def fromCountToIndirectBytes(*args):
        """fromCountToIndirectBytes(long const count, unsigned long const [] buffer) -> long"""
        return _Teuchos.DirectSerializationTraitsUlong_fromCountToIndirectBytes(*args)

    fromCountToIndirectBytes = staticmethod(fromCountToIndirectBytes)

    def serialize(*args):
        """serialize(long const count, unsigned long const [] buffer, long const bytes, char [] charBuffer)"""
        return _Teuchos.DirectSerializationTraitsUlong_serialize(*args)

    serialize = staticmethod(serialize)

    def fromIndirectBytesToCount(*args):
        """fromIndirectBytesToCount(long const bytes, char const [] charBuffer) -> long"""
        return _Teuchos.DirectSerializationTraitsUlong_fromIndirectBytesToCount(*args)

    fromIndirectBytesToCount = staticmethod(fromIndirectBytesToCount)

    def deserialize(*args):
        """deserialize(long const bytes, char const [] charBuffer, long const count, unsigned long [] buffer)"""
        return _Teuchos.DirectSerializationTraitsUlong_deserialize(*args)

    deserialize = staticmethod(deserialize)

    def __init__(self, *args):
        """__init__(Teuchos::DirectSerializationTraits<(long,unsigned long)> self) -> DirectSerializationTraitsUlong"""
        this = _Teuchos.new_DirectSerializationTraitsUlong(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _Teuchos.delete_DirectSerializationTraitsUlong
DirectSerializationTraitsUlong_swigregister = _Teuchos.DirectSerializationTraitsUlong_swigregister
DirectSerializationTraitsUlong_swigregister(DirectSerializationTraitsUlong)

def DirectSerializationTraitsUlong_fromCountToDirectBytes(*args):
    """DirectSerializationTraitsUlong_fromCountToDirectBytes(long const count) -> long"""
    return _Teuchos.DirectSerializationTraitsUlong_fromCountToDirectBytes(*args)

def DirectSerializationTraitsUlong_convertToCharPtr(*args):
    """DirectSerializationTraitsUlong_convertToCharPtr(unsigned long * ptr) -> char *"""
    return _Teuchos.DirectSerializationTraitsUlong_convertToCharPtr(*args)

def DirectSerializationTraitsUlong_fromDirectBytesToCount(*args):
    """DirectSerializationTraitsUlong_fromDirectBytesToCount(long const count) -> long"""
    return _Teuchos.DirectSerializationTraitsUlong_fromDirectBytesToCount(*args)

def DirectSerializationTraitsUlong_convertFromCharPtr(*args):
    """DirectSerializationTraitsUlong_convertFromCharPtr(char * ptr) -> unsigned long *"""
    return _Teuchos.DirectSerializationTraitsUlong_convertFromCharPtr(*args)

def DirectSerializationTraitsUlong_fromCountToIndirectBytes(*args):
    """DirectSerializationTraitsUlong_fromCountToIndirectBytes(long const count, unsigned long const [] buffer) -> long"""
    return _Teuchos.DirectSerializationTraitsUlong_fromCountToIndirectBytes(*args)

def DirectSerializationTraitsUlong_serialize(*args):
    """DirectSerializationTraitsUlong_serialize(long const count, unsigned long const [] buffer, long const bytes, char [] charBuffer)"""
    return _Teuchos.DirectSerializationTraitsUlong_serialize(*args)

def DirectSerializationTraitsUlong_fromIndirectBytesToCount(*args):
    """DirectSerializationTraitsUlong_fromIndirectBytesToCount(long const bytes, char const [] charBuffer) -> long"""
    return _Teuchos.DirectSerializationTraitsUlong_fromIndirectBytesToCount(*args)

def DirectSerializationTraitsUlong_deserialize(*args):
    """DirectSerializationTraitsUlong_deserialize(long const bytes, char const [] charBuffer, long const count, unsigned long [] buffer)"""
    return _Teuchos.DirectSerializationTraitsUlong_deserialize(*args)

class SerializationTraitsUlong(DirectSerializationTraitsUlong):
    """Proxy of C++ Teuchos::SerializationTraits<(long,unsigned long)> class."""

    __swig_setmethods__ = {}
    for _s in [DirectSerializationTraitsUlong]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, SerializationTraitsUlong, name, value)
    __swig_getmethods__ = {}
    for _s in [DirectSerializationTraitsUlong]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, SerializationTraitsUlong, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """__init__(Teuchos::SerializationTraits<(long,unsigned long)> self) -> SerializationTraitsUlong"""
        this = _Teuchos.new_SerializationTraitsUlong(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _Teuchos.delete_SerializationTraitsUlong
SerializationTraitsUlong_swigregister = _Teuchos.SerializationTraitsUlong_swigregister
SerializationTraitsUlong_swigregister(SerializationTraitsUlong)

class DirectSerializationTraitsLongLong(_object):
    """Proxy of C++ Teuchos::DirectSerializationTraits<(long,long long)> class."""

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, DirectSerializationTraitsLongLong, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, DirectSerializationTraitsLongLong, name)
    __repr__ = _swig_repr
    supportsDirectSerialization = _Teuchos.DirectSerializationTraitsLongLong_supportsDirectSerialization

    def fromCountToDirectBytes(*args):
        """fromCountToDirectBytes(long const count) -> long"""
        return _Teuchos.DirectSerializationTraitsLongLong_fromCountToDirectBytes(*args)

    fromCountToDirectBytes = staticmethod(fromCountToDirectBytes)

    def convertToCharPtr(*args):
        """convertToCharPtr(long long * ptr) -> char *"""
        return _Teuchos.DirectSerializationTraitsLongLong_convertToCharPtr(*args)

    convertToCharPtr = staticmethod(convertToCharPtr)

    def fromDirectBytesToCount(*args):
        """fromDirectBytesToCount(long const count) -> long"""
        return _Teuchos.DirectSerializationTraitsLongLong_fromDirectBytesToCount(*args)

    fromDirectBytesToCount = staticmethod(fromDirectBytesToCount)

    def convertFromCharPtr(*args):
        """convertFromCharPtr(char * ptr) -> long long *"""
        return _Teuchos.DirectSerializationTraitsLongLong_convertFromCharPtr(*args)

    convertFromCharPtr = staticmethod(convertFromCharPtr)

    def fromCountToIndirectBytes(*args):
        """fromCountToIndirectBytes(long const count, long long const [] buffer) -> long"""
        return _Teuchos.DirectSerializationTraitsLongLong_fromCountToIndirectBytes(*args)

    fromCountToIndirectBytes = staticmethod(fromCountToIndirectBytes)

    def serialize(*args):
        """serialize(long const count, long long const [] buffer, long const bytes, char [] charBuffer)"""
        return _Teuchos.DirectSerializationTraitsLongLong_serialize(*args)

    serialize = staticmethod(serialize)

    def fromIndirectBytesToCount(*args):
        """fromIndirectBytesToCount(long const bytes, char const [] charBuffer) -> long"""
        return _Teuchos.DirectSerializationTraitsLongLong_fromIndirectBytesToCount(*args)

    fromIndirectBytesToCount = staticmethod(fromIndirectBytesToCount)

    def deserialize(*args):
        """deserialize(long const bytes, char const [] charBuffer, long const count, long long [] buffer)"""
        return _Teuchos.DirectSerializationTraitsLongLong_deserialize(*args)

    deserialize = staticmethod(deserialize)

    def __init__(self, *args):
        """__init__(Teuchos::DirectSerializationTraits<(long,long long)> self) -> DirectSerializationTraitsLongLong"""
        this = _Teuchos.new_DirectSerializationTraitsLongLong(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _Teuchos.delete_DirectSerializationTraitsLongLong
DirectSerializationTraitsLongLong_swigregister = _Teuchos.DirectSerializationTraitsLongLong_swigregister
DirectSerializationTraitsLongLong_swigregister(DirectSerializationTraitsLongLong)

def DirectSerializationTraitsLongLong_fromCountToDirectBytes(*args):
    """DirectSerializationTraitsLongLong_fromCountToDirectBytes(long const count) -> long"""
    return _Teuchos.DirectSerializationTraitsLongLong_fromCountToDirectBytes(*args)

def DirectSerializationTraitsLongLong_convertToCharPtr(*args):
    """DirectSerializationTraitsLongLong_convertToCharPtr(long long * ptr) -> char *"""
    return _Teuchos.DirectSerializationTraitsLongLong_convertToCharPtr(*args)

def DirectSerializationTraitsLongLong_fromDirectBytesToCount(*args):
    """DirectSerializationTraitsLongLong_fromDirectBytesToCount(long const count) -> long"""
    return _Teuchos.DirectSerializationTraitsLongLong_fromDirectBytesToCount(*args)

def DirectSerializationTraitsLongLong_convertFromCharPtr(*args):
    """DirectSerializationTraitsLongLong_convertFromCharPtr(char * ptr) -> long long *"""
    return _Teuchos.DirectSerializationTraitsLongLong_convertFromCharPtr(*args)

def DirectSerializationTraitsLongLong_fromCountToIndirectBytes(*args):
    """DirectSerializationTraitsLongLong_fromCountToIndirectBytes(long const count, long long const [] buffer) -> long"""
    return _Teuchos.DirectSerializationTraitsLongLong_fromCountToIndirectBytes(*args)

def DirectSerializationTraitsLongLong_serialize(*args):
    """DirectSerializationTraitsLongLong_serialize(long const count, long long const [] buffer, long const bytes, char [] charBuffer)"""
    return _Teuchos.DirectSerializationTraitsLongLong_serialize(*args)

def DirectSerializationTraitsLongLong_fromIndirectBytesToCount(*args):
    """DirectSerializationTraitsLongLong_fromIndirectBytesToCount(long const bytes, char const [] charBuffer) -> long"""
    return _Teuchos.DirectSerializationTraitsLongLong_fromIndirectBytesToCount(*args)

def DirectSerializationTraitsLongLong_deserialize(*args):
    """DirectSerializationTraitsLongLong_deserialize(long const bytes, char const [] charBuffer, long const count, long long [] buffer)"""
    return _Teuchos.DirectSerializationTraitsLongLong_deserialize(*args)

class SerializationTraitsLongLong(DirectSerializationTraitsLongLong):
    """Proxy of C++ Teuchos::SerializationTraits<(long,long long)> class."""

    __swig_setmethods__ = {}
    for _s in [DirectSerializationTraitsLongLong]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, SerializationTraitsLongLong, name, value)
    __swig_getmethods__ = {}
    for _s in [DirectSerializationTraitsLongLong]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, SerializationTraitsLongLong, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """__init__(Teuchos::SerializationTraits<(long,long long)> self) -> SerializationTraitsLongLong"""
        this = _Teuchos.new_SerializationTraitsLongLong(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _Teuchos.delete_SerializationTraitsLongLong
SerializationTraitsLongLong_swigregister = _Teuchos.SerializationTraitsLongLong_swigregister
SerializationTraitsLongLong_swigregister(SerializationTraitsLongLong)

class DirectSerializationTraitsUlongLong(_object):
    """Proxy of C++ Teuchos::DirectSerializationTraits<(long,unsigned long long)> class."""

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, DirectSerializationTraitsUlongLong, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, DirectSerializationTraitsUlongLong, name)
    __repr__ = _swig_repr
    supportsDirectSerialization = _Teuchos.DirectSerializationTraitsUlongLong_supportsDirectSerialization

    def fromCountToDirectBytes(*args):
        """fromCountToDirectBytes(long const count) -> long"""
        return _Teuchos.DirectSerializationTraitsUlongLong_fromCountToDirectBytes(*args)

    fromCountToDirectBytes = staticmethod(fromCountToDirectBytes)

    def convertToCharPtr(*args):
        """convertToCharPtr(unsigned long long * ptr) -> char *"""
        return _Teuchos.DirectSerializationTraitsUlongLong_convertToCharPtr(*args)

    convertToCharPtr = staticmethod(convertToCharPtr)

    def fromDirectBytesToCount(*args):
        """fromDirectBytesToCount(long const count) -> long"""
        return _Teuchos.DirectSerializationTraitsUlongLong_fromDirectBytesToCount(*args)

    fromDirectBytesToCount = staticmethod(fromDirectBytesToCount)

    def convertFromCharPtr(*args):
        """convertFromCharPtr(char * ptr) -> unsigned long long *"""
        return _Teuchos.DirectSerializationTraitsUlongLong_convertFromCharPtr(*args)

    convertFromCharPtr = staticmethod(convertFromCharPtr)

    def fromCountToIndirectBytes(*args):
        """fromCountToIndirectBytes(long const count, unsigned long long const [] buffer) -> long"""
        return _Teuchos.DirectSerializationTraitsUlongLong_fromCountToIndirectBytes(*args)

    fromCountToIndirectBytes = staticmethod(fromCountToIndirectBytes)

    def serialize(*args):
        """serialize(long const count, unsigned long long const [] buffer, long const bytes, char [] charBuffer)"""
        return _Teuchos.DirectSerializationTraitsUlongLong_serialize(*args)

    serialize = staticmethod(serialize)

    def fromIndirectBytesToCount(*args):
        """fromIndirectBytesToCount(long const bytes, char const [] charBuffer) -> long"""
        return _Teuchos.DirectSerializationTraitsUlongLong_fromIndirectBytesToCount(*args)

    fromIndirectBytesToCount = staticmethod(fromIndirectBytesToCount)

    def deserialize(*args):
        """deserialize(long const bytes, char const [] charBuffer, long const count, unsigned long long [] buffer)"""
        return _Teuchos.DirectSerializationTraitsUlongLong_deserialize(*args)

    deserialize = staticmethod(deserialize)

    def __init__(self, *args):
        """__init__(Teuchos::DirectSerializationTraits<(long,unsigned long long)> self) -> DirectSerializationTraitsUlongLong"""
        this = _Teuchos.new_DirectSerializationTraitsUlongLong(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _Teuchos.delete_DirectSerializationTraitsUlongLong
DirectSerializationTraitsUlongLong_swigregister = _Teuchos.DirectSerializationTraitsUlongLong_swigregister
DirectSerializationTraitsUlongLong_swigregister(DirectSerializationTraitsUlongLong)

def DirectSerializationTraitsUlongLong_fromCountToDirectBytes(*args):
    """DirectSerializationTraitsUlongLong_fromCountToDirectBytes(long const count) -> long"""
    return _Teuchos.DirectSerializationTraitsUlongLong_fromCountToDirectBytes(*args)

def DirectSerializationTraitsUlongLong_convertToCharPtr(*args):
    """DirectSerializationTraitsUlongLong_convertToCharPtr(unsigned long long * ptr) -> char *"""
    return _Teuchos.DirectSerializationTraitsUlongLong_convertToCharPtr(*args)

def DirectSerializationTraitsUlongLong_fromDirectBytesToCount(*args):
    """DirectSerializationTraitsUlongLong_fromDirectBytesToCount(long const count) -> long"""
    return _Teuchos.DirectSerializationTraitsUlongLong_fromDirectBytesToCount(*args)

def DirectSerializationTraitsUlongLong_convertFromCharPtr(*args):
    """DirectSerializationTraitsUlongLong_convertFromCharPtr(char * ptr) -> unsigned long long *"""
    return _Teuchos.DirectSerializationTraitsUlongLong_convertFromCharPtr(*args)

def DirectSerializationTraitsUlongLong_fromCountToIndirectBytes(*args):
    """DirectSerializationTraitsUlongLong_fromCountToIndirectBytes(long const count, unsigned long long const [] buffer) -> long"""
    return _Teuchos.DirectSerializationTraitsUlongLong_fromCountToIndirectBytes(*args)

def DirectSerializationTraitsUlongLong_serialize(*args):
    """DirectSerializationTraitsUlongLong_serialize(long const count, unsigned long long const [] buffer, long const bytes, char [] charBuffer)"""
    return _Teuchos.DirectSerializationTraitsUlongLong_serialize(*args)

def DirectSerializationTraitsUlongLong_fromIndirectBytesToCount(*args):
    """DirectSerializationTraitsUlongLong_fromIndirectBytesToCount(long const bytes, char const [] charBuffer) -> long"""
    return _Teuchos.DirectSerializationTraitsUlongLong_fromIndirectBytesToCount(*args)

def DirectSerializationTraitsUlongLong_deserialize(*args):
    """DirectSerializationTraitsUlongLong_deserialize(long const bytes, char const [] charBuffer, long const count, unsigned long long [] buffer)"""
    return _Teuchos.DirectSerializationTraitsUlongLong_deserialize(*args)

class SerializationTraitsUlongLong(DirectSerializationTraitsUlongLong):
    """Proxy of C++ Teuchos::SerializationTraits<(long,unsigned long long)> class."""

    __swig_setmethods__ = {}
    for _s in [DirectSerializationTraitsUlongLong]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, SerializationTraitsUlongLong, name, value)
    __swig_getmethods__ = {}
    for _s in [DirectSerializationTraitsUlongLong]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, SerializationTraitsUlongLong, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """__init__(Teuchos::SerializationTraits<(long,unsigned long long)> self) -> SerializationTraitsUlongLong"""
        this = _Teuchos.new_SerializationTraitsUlongLong(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _Teuchos.delete_SerializationTraitsUlongLong
SerializationTraitsUlongLong_swigregister = _Teuchos.SerializationTraitsUlongLong_swigregister
SerializationTraitsUlongLong_swigregister(SerializationTraitsUlongLong)

class DirectSerializationTraitsFloat(_object):
    """Proxy of C++ Teuchos::DirectSerializationTraits<(long,float)> class."""

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, DirectSerializationTraitsFloat, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, DirectSerializationTraitsFloat, name)
    __repr__ = _swig_repr
    supportsDirectSerialization = _Teuchos.DirectSerializationTraitsFloat_supportsDirectSerialization

    def fromCountToDirectBytes(*args):
        """fromCountToDirectBytes(long const count) -> long"""
        return _Teuchos.DirectSerializationTraitsFloat_fromCountToDirectBytes(*args)

    fromCountToDirectBytes = staticmethod(fromCountToDirectBytes)

    def convertToCharPtr(*args):
        """convertToCharPtr(float * ptr) -> char *"""
        return _Teuchos.DirectSerializationTraitsFloat_convertToCharPtr(*args)

    convertToCharPtr = staticmethod(convertToCharPtr)

    def fromDirectBytesToCount(*args):
        """fromDirectBytesToCount(long const count) -> long"""
        return _Teuchos.DirectSerializationTraitsFloat_fromDirectBytesToCount(*args)

    fromDirectBytesToCount = staticmethod(fromDirectBytesToCount)

    def convertFromCharPtr(*args):
        """convertFromCharPtr(char * ptr) -> float *"""
        return _Teuchos.DirectSerializationTraitsFloat_convertFromCharPtr(*args)

    convertFromCharPtr = staticmethod(convertFromCharPtr)

    def fromCountToIndirectBytes(*args):
        """fromCountToIndirectBytes(long const count, float const [] buffer) -> long"""
        return _Teuchos.DirectSerializationTraitsFloat_fromCountToIndirectBytes(*args)

    fromCountToIndirectBytes = staticmethod(fromCountToIndirectBytes)

    def serialize(*args):
        """serialize(long const count, float const [] buffer, long const bytes, char [] charBuffer)"""
        return _Teuchos.DirectSerializationTraitsFloat_serialize(*args)

    serialize = staticmethod(serialize)

    def fromIndirectBytesToCount(*args):
        """fromIndirectBytesToCount(long const bytes, char const [] charBuffer) -> long"""
        return _Teuchos.DirectSerializationTraitsFloat_fromIndirectBytesToCount(*args)

    fromIndirectBytesToCount = staticmethod(fromIndirectBytesToCount)

    def deserialize(*args):
        """deserialize(long const bytes, char const [] charBuffer, long const count, float [] buffer)"""
        return _Teuchos.DirectSerializationTraitsFloat_deserialize(*args)

    deserialize = staticmethod(deserialize)

    def __init__(self, *args):
        """__init__(Teuchos::DirectSerializationTraits<(long,float)> self) -> DirectSerializationTraitsFloat"""
        this = _Teuchos.new_DirectSerializationTraitsFloat(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _Teuchos.delete_DirectSerializationTraitsFloat
DirectSerializationTraitsFloat_swigregister = _Teuchos.DirectSerializationTraitsFloat_swigregister
DirectSerializationTraitsFloat_swigregister(DirectSerializationTraitsFloat)

def DirectSerializationTraitsFloat_fromCountToDirectBytes(*args):
    """DirectSerializationTraitsFloat_fromCountToDirectBytes(long const count) -> long"""
    return _Teuchos.DirectSerializationTraitsFloat_fromCountToDirectBytes(*args)

def DirectSerializationTraitsFloat_convertToCharPtr(*args):
    """DirectSerializationTraitsFloat_convertToCharPtr(float * ptr) -> char *"""
    return _Teuchos.DirectSerializationTraitsFloat_convertToCharPtr(*args)

def DirectSerializationTraitsFloat_fromDirectBytesToCount(*args):
    """DirectSerializationTraitsFloat_fromDirectBytesToCount(long const count) -> long"""
    return _Teuchos.DirectSerializationTraitsFloat_fromDirectBytesToCount(*args)

def DirectSerializationTraitsFloat_convertFromCharPtr(*args):
    """DirectSerializationTraitsFloat_convertFromCharPtr(char * ptr) -> float *"""
    return _Teuchos.DirectSerializationTraitsFloat_convertFromCharPtr(*args)

def DirectSerializationTraitsFloat_fromCountToIndirectBytes(*args):
    """DirectSerializationTraitsFloat_fromCountToIndirectBytes(long const count, float const [] buffer) -> long"""
    return _Teuchos.DirectSerializationTraitsFloat_fromCountToIndirectBytes(*args)

def DirectSerializationTraitsFloat_serialize(*args):
    """DirectSerializationTraitsFloat_serialize(long const count, float const [] buffer, long const bytes, char [] charBuffer)"""
    return _Teuchos.DirectSerializationTraitsFloat_serialize(*args)

def DirectSerializationTraitsFloat_fromIndirectBytesToCount(*args):
    """DirectSerializationTraitsFloat_fromIndirectBytesToCount(long const bytes, char const [] charBuffer) -> long"""
    return _Teuchos.DirectSerializationTraitsFloat_fromIndirectBytesToCount(*args)

def DirectSerializationTraitsFloat_deserialize(*args):
    """DirectSerializationTraitsFloat_deserialize(long const bytes, char const [] charBuffer, long const count, float [] buffer)"""
    return _Teuchos.DirectSerializationTraitsFloat_deserialize(*args)

class SerializationTraitsFloat(DirectSerializationTraitsFloat):
    """Proxy of C++ Teuchos::SerializationTraits<(long,float)> class."""

    __swig_setmethods__ = {}
    for _s in [DirectSerializationTraitsFloat]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, SerializationTraitsFloat, name, value)
    __swig_getmethods__ = {}
    for _s in [DirectSerializationTraitsFloat]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, SerializationTraitsFloat, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """__init__(Teuchos::SerializationTraits<(long,float)> self) -> SerializationTraitsFloat"""
        this = _Teuchos.new_SerializationTraitsFloat(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _Teuchos.delete_SerializationTraitsFloat
SerializationTraitsFloat_swigregister = _Teuchos.SerializationTraitsFloat_swigregister
SerializationTraitsFloat_swigregister(SerializationTraitsFloat)

class DirectSerializationTraitsDouble(_object):
    """Proxy of C++ Teuchos::DirectSerializationTraits<(long,double)> class."""

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, DirectSerializationTraitsDouble, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, DirectSerializationTraitsDouble, name)
    __repr__ = _swig_repr
    supportsDirectSerialization = _Teuchos.DirectSerializationTraitsDouble_supportsDirectSerialization

    def fromCountToDirectBytes(*args):
        """fromCountToDirectBytes(long const count) -> long"""
        return _Teuchos.DirectSerializationTraitsDouble_fromCountToDirectBytes(*args)

    fromCountToDirectBytes = staticmethod(fromCountToDirectBytes)

    def convertToCharPtr(*args):
        """convertToCharPtr(double * ptr) -> char *"""
        return _Teuchos.DirectSerializationTraitsDouble_convertToCharPtr(*args)

    convertToCharPtr = staticmethod(convertToCharPtr)

    def fromDirectBytesToCount(*args):
        """fromDirectBytesToCount(long const count) -> long"""
        return _Teuchos.DirectSerializationTraitsDouble_fromDirectBytesToCount(*args)

    fromDirectBytesToCount = staticmethod(fromDirectBytesToCount)

    def convertFromCharPtr(*args):
        """convertFromCharPtr(char * ptr) -> double *"""
        return _Teuchos.DirectSerializationTraitsDouble_convertFromCharPtr(*args)

    convertFromCharPtr = staticmethod(convertFromCharPtr)

    def fromCountToIndirectBytes(*args):
        """fromCountToIndirectBytes(long const count, double const [] buffer) -> long"""
        return _Teuchos.DirectSerializationTraitsDouble_fromCountToIndirectBytes(*args)

    fromCountToIndirectBytes = staticmethod(fromCountToIndirectBytes)

    def serialize(*args):
        """serialize(long const count, double const [] buffer, long const bytes, char [] charBuffer)"""
        return _Teuchos.DirectSerializationTraitsDouble_serialize(*args)

    serialize = staticmethod(serialize)

    def fromIndirectBytesToCount(*args):
        """fromIndirectBytesToCount(long const bytes, char const [] charBuffer) -> long"""
        return _Teuchos.DirectSerializationTraitsDouble_fromIndirectBytesToCount(*args)

    fromIndirectBytesToCount = staticmethod(fromIndirectBytesToCount)

    def deserialize(*args):
        """deserialize(long const bytes, char const [] charBuffer, long const count, double [] buffer)"""
        return _Teuchos.DirectSerializationTraitsDouble_deserialize(*args)

    deserialize = staticmethod(deserialize)

    def __init__(self, *args):
        """__init__(Teuchos::DirectSerializationTraits<(long,double)> self) -> DirectSerializationTraitsDouble"""
        this = _Teuchos.new_DirectSerializationTraitsDouble(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _Teuchos.delete_DirectSerializationTraitsDouble
DirectSerializationTraitsDouble_swigregister = _Teuchos.DirectSerializationTraitsDouble_swigregister
DirectSerializationTraitsDouble_swigregister(DirectSerializationTraitsDouble)

def DirectSerializationTraitsDouble_fromCountToDirectBytes(*args):
    """DirectSerializationTraitsDouble_fromCountToDirectBytes(long const count) -> long"""
    return _Teuchos.DirectSerializationTraitsDouble_fromCountToDirectBytes(*args)

def DirectSerializationTraitsDouble_convertToCharPtr(*args):
    """DirectSerializationTraitsDouble_convertToCharPtr(double * ptr) -> char *"""
    return _Teuchos.DirectSerializationTraitsDouble_convertToCharPtr(*args)

def DirectSerializationTraitsDouble_fromDirectBytesToCount(*args):
    """DirectSerializationTraitsDouble_fromDirectBytesToCount(long const count) -> long"""
    return _Teuchos.DirectSerializationTraitsDouble_fromDirectBytesToCount(*args)

def DirectSerializationTraitsDouble_convertFromCharPtr(*args):
    """DirectSerializationTraitsDouble_convertFromCharPtr(char * ptr) -> double *"""
    return _Teuchos.DirectSerializationTraitsDouble_convertFromCharPtr(*args)

def DirectSerializationTraitsDouble_fromCountToIndirectBytes(*args):
    """DirectSerializationTraitsDouble_fromCountToIndirectBytes(long const count, double const [] buffer) -> long"""
    return _Teuchos.DirectSerializationTraitsDouble_fromCountToIndirectBytes(*args)

def DirectSerializationTraitsDouble_serialize(*args):
    """DirectSerializationTraitsDouble_serialize(long const count, double const [] buffer, long const bytes, char [] charBuffer)"""
    return _Teuchos.DirectSerializationTraitsDouble_serialize(*args)

def DirectSerializationTraitsDouble_fromIndirectBytesToCount(*args):
    """DirectSerializationTraitsDouble_fromIndirectBytesToCount(long const bytes, char const [] charBuffer) -> long"""
    return _Teuchos.DirectSerializationTraitsDouble_fromIndirectBytesToCount(*args)

def DirectSerializationTraitsDouble_deserialize(*args):
    """DirectSerializationTraitsDouble_deserialize(long const bytes, char const [] charBuffer, long const count, double [] buffer)"""
    return _Teuchos.DirectSerializationTraitsDouble_deserialize(*args)

class SerializationTraitsDouble(DirectSerializationTraitsDouble):
    """Proxy of C++ Teuchos::SerializationTraits<(long,double)> class."""

    __swig_setmethods__ = {}
    for _s in [DirectSerializationTraitsDouble]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, SerializationTraitsDouble, name, value)
    __swig_getmethods__ = {}
    for _s in [DirectSerializationTraitsDouble]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, SerializationTraitsDouble, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """__init__(Teuchos::SerializationTraits<(long,double)> self) -> SerializationTraitsDouble"""
        this = _Teuchos.new_SerializationTraitsDouble(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _Teuchos.delete_SerializationTraitsDouble
SerializationTraitsDouble_swigregister = _Teuchos.SerializationTraitsDouble_swigregister
SerializationTraitsDouble_swigregister(SerializationTraitsDouble)


def DirectSerializationTraits(scalarType):
    """
    DirectSerializationTraits(str scalarType) -> DirectSerializationTraits<...>

    The scalarType argument is for specifying the type of scalar for
    which direct serialization is requested.  Limited NumPy-style type
    specification is supported:

        'b'  byte
        'B'  unsigned byte
        'h'  short
        'H'  unsigned short
        'i'  int
        'I'  unsigned int
        'l'  long
        'L'  unsigned long
        'q'  long long
        'Q'  unsigned long long
        'f'  float
        'd'  double
    """
    if   scalarType == 'b': return DirectSerializationTraitsByte()
    elif scalarType == 'B': return DirectSerializationTraitsUbyte()
    elif scalarType == 'h': return DirectSerializationTraitsShort()
    elif scalarType == 'H': return DirectSerializationTraitsUshort()
    elif scalarType == 'i': return DirectSerializationTraitsInt()
    elif scalarType == 'I': return DirectSerializationTraitsUint()
    elif scalarType == 'l': return DirectSerializationTraitsLong()
    elif scalarType == 'L': return DirectSerializationTraitsUlong()
    elif scalarType == 'q': return DirectSerializationTraitsLongLong()
    elif scalarType == 'Q': return DirectSerializationTraitsUlongLong()
    elif scalarType == 'f': return DirectSerializationTraitsFloat()
    elif scalarType == 'd': return DirectSerializationTraitsDouble()
    raise NotImplementedError, "DirectSerializationTraits for " + repr(scalarType) + \
	  " not supported"

def SerializationTraits(scalarType):
    """
    SerializationTraits(str scalarType) -> SerializationTraits<...>

    The scalarType argument is for specifying the type of scalar for
    which serialization is requested.  Limited NumPy-style type
    specification is supported:

        'b'  byte
        'B'  unsigned byte
        'h'  short
        'H'  unsigned short
        'i'  int
        'I'  unsigned int
        'l'  long
        'L'  unsigned long
        'q'  long long
        'Q'  unsigned long long
        'f'  float
        'd'  double
    """
    if   scalarType == 'b': return SerializationTraitsByte()
    elif scalarType == 'B': return SerializationTraitsUbyte()
    elif scalarType == 'h': return SerializationTraitsShort()
    elif scalarType == 'H': return SerializationTraitsUshort()
    elif scalarType == 'i': return SerializationTraitsInt()
    elif scalarType == 'I': return SerializationTraitsUint()
    elif scalarType == 'l': return SerializationTraitsLong()
    elif scalarType == 'L': return SerializationTraitsUlong()
    elif scalarType == 'q': return SerializationTraitsLongLong()
    elif scalarType == 'Q': return SerializationTraitsUlongLong()
    elif scalarType == 'f': return SerializationTraitsFloat()
    elif scalarType == 'd': return SerializationTraitsDouble()
    raise NotImplementedError, "SerializationTraits for " + repr(scalarType) + \
	  " not supported"

VERB_DEFAULT = _Teuchos.VERB_DEFAULT
VERB_NONE = _Teuchos.VERB_NONE
VERB_LOW = _Teuchos.VERB_LOW
VERB_MEDIUM = _Teuchos.VERB_MEDIUM
VERB_HIGH = _Teuchos.VERB_HIGH
VERB_EXTREME = _Teuchos.VERB_EXTREME

def __rshift__(*args):
    """__rshift__(std::istream & std_is, Teuchos::EVerbosityLevel & enum_value) -> std::istream &"""
    return _Teuchos.__rshift__(*args)

def verbosityLevelToString(*args):
    """verbosityLevelToString(Teuchos::EVerbosityLevel const verbLevel) -> std::string"""
    return _Teuchos.verbosityLevelToString(*args)

def includesVerbLevel(*args):
    """includesVerbLevel(Teuchos::EVerbosityLevel const verbLevel, Teuchos::EVerbosityLevel const requestedVerbLevel, bool const isDefaultLevel=False) -> bool"""
    return _Teuchos.includesVerbLevel(*args)

def incrVerbLevel(*args):
    """incrVerbLevel(Teuchos::EVerbosityLevel const inputVerbLevel, int const numLevels) -> Teuchos::EVerbosityLevel"""
    return _Teuchos.incrVerbLevel(*args)

def fancyOStream(*args):
    """fancyOStream(Teuchos::RCP< std::basic_ostream< char > > const & oStream, std::basic_string< char > const & tabIndentStr, int const startingTab=0, bool const showLinePrefix=False, int const maxLenLinePrefix=10, bool const showTabCount=False, bool const showProcRank=False) -> Teuchos::RCP< Teuchos::basic_FancyOStream< char,std::char_traits< char > > >"""
    return _Teuchos.fancyOStream(*args)

def getFancyOStream(*args):
    """getFancyOStream(Teuchos::RCP< std::basic_ostream< char > > const & out) -> Teuchos::RCP< Teuchos::basic_FancyOStream< char,std::char_traits< char > > >"""
    return _Teuchos.getFancyOStream(*args)
class LabeledObject(_object):
    """Proxy of C++ Teuchos::LabeledObject class."""

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, LabeledObject, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, LabeledObject, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """__init__(Teuchos::LabeledObject self) -> LabeledObject"""
        if self.__class__ == LabeledObject:
            _self = None
        else:
            _self = self
        this = _Teuchos.new_LabeledObject(_self, *args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _Teuchos.delete_LabeledObject

    def setObjectLabel(self, *args):
        """setObjectLabel(LabeledObject self, std::string const & objectLabel)"""
        return _Teuchos.LabeledObject_setObjectLabel(self, *args)


    def getObjectLabel(self, *args):
        """getObjectLabel(LabeledObject self) -> std::string"""
        return _Teuchos.LabeledObject_getObjectLabel(self, *args)

    def __disown__(self):
        self.this.disown()
        _Teuchos.disown_LabeledObject(self)
        return weakref_proxy(self)
LabeledObject_swigregister = _Teuchos.LabeledObject_swigregister
LabeledObject_swigregister(LabeledObject)

class Describable(LabeledObject):
    """Proxy of C++ Teuchos::Describable class."""

    __swig_setmethods__ = {}
    for _s in [LabeledObject]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, Describable, name, value)
    __swig_getmethods__ = {}
    for _s in [LabeledObject]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, Describable, name)
    __repr__ = _swig_repr

    def description(self, *args):
        """description(Describable self) -> std::string"""
        return _Teuchos.Describable_description(self, *args)


    def describe(self, *args):
        """
        describe(Describable self, Teuchos::FancyOStream & out, Teuchos::EVerbosityLevel const verbLevel)
        describe(Describable self, std::ostream & out, Teuchos::EVerbosityLevel const verbLevel)
        """
        return _Teuchos.Describable_describe(self, *args)

    __swig_destroy__ = _Teuchos.delete_Describable

    def __init__(self, *args):
        """__init__(Teuchos::Describable self) -> Describable"""
        if self.__class__ == Describable:
            _self = None
        else:
            _self = self
        this = _Teuchos.new_Describable(_self, *args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    def __disown__(self):
        self.this.disown()
        _Teuchos.disown_Describable(self)
        return weakref_proxy(self)
Describable_swigregister = _Teuchos.Describable_swigregister
Describable_swigregister(Describable)
Describable.verbLevel_default = _Teuchos.cvar.Describable_verbLevel_default

class DescribableStreamManipulatorState(_object):
    """Proxy of C++ Teuchos::DescribableStreamManipulatorState class."""

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, DescribableStreamManipulatorState, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, DescribableStreamManipulatorState, name)
    __repr__ = _swig_repr
    __swig_getmethods__["describable"] = _Teuchos.DescribableStreamManipulatorState_describable_get
    if _newclass:
        describable = _swig_property(_Teuchos.DescribableStreamManipulatorState_describable_get)
    __swig_getmethods__["verbLevel"] = _Teuchos.DescribableStreamManipulatorState_verbLevel_get
    if _newclass:
        verbLevel = _swig_property(_Teuchos.DescribableStreamManipulatorState_verbLevel_get)

    def __init__(self, *args):
        """__init__(Teuchos::DescribableStreamManipulatorState self, Describable _describable, Teuchos::EVerbosityLevel const _verbLevel) -> DescribableStreamManipulatorState"""
        this = _Teuchos.new_DescribableStreamManipulatorState(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _Teuchos.delete_DescribableStreamManipulatorState
DescribableStreamManipulatorState_swigregister = _Teuchos.DescribableStreamManipulatorState_swigregister
DescribableStreamManipulatorState_swigregister(DescribableStreamManipulatorState)


def describe(*args):
    """describe(Describable describable, Teuchos::EVerbosityLevel const verbLevel) -> DescribableStreamManipulatorState"""
    return _Teuchos.describe(*args)
class Comm_int(Describable):
    """Proxy of C++ Teuchos::Comm<(int)> class."""

    __swig_setmethods__ = {}
    for _s in [Describable]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, Comm_int, name, value)
    __swig_getmethods__ = {}
    for _s in [Describable]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, Comm_int, name)

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr

    def getTag(self, *args):
        """getTag(Comm_int self) -> int"""
        return _Teuchos.Comm_int_getTag(self, *args)

    __swig_destroy__ = _Teuchos.delete_Comm_int

    def getRank(self, *args):
        """getRank(Comm_int self) -> int"""
        return _Teuchos.Comm_int_getRank(self, *args)


    def getSize(self, *args):
        """getSize(Comm_int self) -> int"""
        return _Teuchos.Comm_int_getSize(self, *args)


    def barrier(self, *args):
        """barrier(Comm_int self)"""
        return _Teuchos.Comm_int_barrier(self, *args)


    def gather(self, *args):
        """gather(Comm_int self, int const sendBytes, char const [] sendBuffer, int const recvBytes, char [] recvBuffer, int const root)"""
        return _Teuchos.Comm_int_gather(self, *args)


    def reduceAllAndScatter(self, *args):
        """reduceAllAndScatter(Comm_int self, Teuchos::ValueTypeReductionOp< int,char > const & reductOp, int const sendBytes, char const [] sendBuffer, int const [] recvCounts, char [] myGlobalReducts)"""
        return _Teuchos.Comm_int_reduceAllAndScatter(self, *args)


    def send(self, *args):
        """
        send(Comm_int self, int const bytes, char const [] sendBuffer, int const destRank)
        send(Comm_int self, int const bytes, char const [] sendBuffer, int const destRank, int const tag)
        """
        return _Teuchos.Comm_int_send(self, *args)


    def ssend(self, *args):
        """
        ssend(Comm_int self, int const bytes, char const [] sendBuffer, int const destRank)
        ssend(Comm_int self, int const bytes, char const [] sendBuffer, int const destRank, int const tag)
        """
        return _Teuchos.Comm_int_ssend(self, *args)


    def receive(self, *args):
        """receive(Comm_int self, int const sourceRank, int const bytes, char [] recvBuffer) -> int"""
        return _Teuchos.Comm_int_receive(self, *args)


    def duplicate(self, *args):
        """duplicate(Comm_int self) -> Teuchos::RCP< Teuchos::Comm< int > >"""
        return _Teuchos.Comm_int_duplicate(self, *args)


    def split(self, *args):
        """split(Comm_int self, int const color, int const key) -> Teuchos::RCP< Teuchos::Comm< int > >"""
        return _Teuchos.Comm_int_split(self, *args)


    def createSubcommunicator(self, *args):
        """createSubcommunicator(Comm_int self, ArrayView< int const > const & ranks) -> Teuchos::RCP< Teuchos::Comm< int > >"""
        return _Teuchos.Comm_int_createSubcommunicator(self, *args)


    def __str__(self, *args):
        """__str__(Comm_int self) -> std::string"""
        return _Teuchos.Comm_int___str__(self, *args)

Comm_int_swigregister = _Teuchos.Comm_int_swigregister
Comm_int_swigregister(Comm_int)


Comm = Comm_int

class SerialComm_int(Comm_int):
    """Proxy of C++ Teuchos::SerialComm<(int)> class."""

    __swig_setmethods__ = {}
    for _s in [Comm_int]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, SerialComm_int, name, value)
    __swig_getmethods__ = {}
    for _s in [Comm_int]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, SerialComm_int, name)
    __repr__ = _swig_repr

    def getTag(self, *args):
        """getTag(SerialComm_int self) -> int"""
        return _Teuchos.SerialComm_int_getTag(self, *args)


    def __init__(self, *args):
        """
        __init__(Teuchos::SerialComm<(int)> self) -> SerialComm_int
        __init__(Teuchos::SerialComm<(int)> self, SerialComm_int other) -> SerialComm_int
        """
        this = _Teuchos.new_SerialComm_int(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

    def getRank(self, *args):
        """getRank(SerialComm_int self) -> int"""
        return _Teuchos.SerialComm_int_getRank(self, *args)


    def getSize(self, *args):
        """getSize(SerialComm_int self) -> int"""
        return _Teuchos.SerialComm_int_getSize(self, *args)


    def barrier(self, *args):
        """barrier(SerialComm_int self)"""
        return _Teuchos.SerialComm_int_barrier(self, *args)


    def gather(self, *args):
        """gather(SerialComm_int self, int const sendBytes, char const [] sendBuffer, int const recvBytes, char [] recvBuffer, int const root)"""
        return _Teuchos.SerialComm_int_gather(self, *args)


    def reduceAllAndScatter(self, *args):
        """reduceAllAndScatter(SerialComm_int self, Teuchos::ValueTypeReductionOp< int,char > const & reductOp, int const sendBytes, char const [] sendBuffer, int const [] recvCounts, char [] myGlobalReducts)"""
        return _Teuchos.SerialComm_int_reduceAllAndScatter(self, *args)


    def send(self, *args):
        """
        send(SerialComm_int self, int const bytes, char const [] sendBuffer, int const destRank)
        send(SerialComm_int self, int const bytes, char const [] sendBuffer, int const destRank, int const tag)
        """
        return _Teuchos.SerialComm_int_send(self, *args)


    def ssend(self, *args):
        """
        ssend(SerialComm_int self, int const bytes, char const [] sendBuffer, int const destRank)
        ssend(SerialComm_int self, int const bytes, char const [] sendBuffer, int const destRank, int const tag)
        """
        return _Teuchos.SerialComm_int_ssend(self, *args)


    def receive(self, *args):
        """receive(SerialComm_int self, int const sourceRank, int const bytes, char [] recvBuffer) -> int"""
        return _Teuchos.SerialComm_int_receive(self, *args)


    def duplicate(self, *args):
        """duplicate(SerialComm_int self) -> Teuchos::RCP< Teuchos::Comm< int > >"""
        return _Teuchos.SerialComm_int_duplicate(self, *args)


    def split(self, *args):
        """split(SerialComm_int self, int const color, int const key) -> Teuchos::RCP< Teuchos::Comm< int > >"""
        return _Teuchos.SerialComm_int_split(self, *args)


    def createSubcommunicator(self, *args):
        """createSubcommunicator(SerialComm_int self, ArrayView< int const > const & ranks) -> Teuchos::RCP< Teuchos::Comm< int > >"""
        return _Teuchos.SerialComm_int_createSubcommunicator(self, *args)


    def description(self, *args):
        """description(SerialComm_int self) -> std::string"""
        return _Teuchos.SerialComm_int_description(self, *args)

    __swig_destroy__ = _Teuchos.delete_SerialComm_int
SerialComm_int_swigregister = _Teuchos.SerialComm_int_swigregister
SerialComm_int_swigregister(SerialComm_int)


SerialComm = SerialComm_int

REDUCE_SUM = _Teuchos.REDUCE_SUM
REDUCE_MIN = _Teuchos.REDUCE_MIN
REDUCE_MAX = _Teuchos.REDUCE_MAX
REDUCE_AND = _Teuchos.REDUCE_AND

def rank_int(*args):
    """rank_int(Comm_int comm) -> int"""
    return _Teuchos.rank_int(*args)

def size_int(*args):
    """size_int(Comm_int comm) -> int"""
    return _Teuchos.size_int(*args)

def barrier_int(*args):
    """barrier_int(Comm_int comm)"""
    return _Teuchos.barrier_int(*args)


rank    = rank_int
size    = size_int
barrier = barrier_int

def broadcast(comm, rootRank, buffer):
  """
  broadcast(Comm comm, int rootRank, numpy.ndarray buffer)

  Broadcast the contents of buffer from processor rootRank to all of
  the other processors.  Argument buffer must be a numpy array, so
  that the broadcast can be performed in-place.  Its scalar data type
  can be any numerical type supported by numpy.
  """
  comm.broadcast(rootRank, buffer)

def gatherAll(comm, buffer):
  """
  gatherAll(Comm comm, buffer) -> numpy.ndarray

  Gather the contents of buffer to all of the processors.  Argument
  buffer can be a numpy array or any sequence that can be converted to
  a numpy array.  Its scalar data type can be any numerical type
  supported by numpy.  The return argument is a numpy array of the
  same type.
  """
  return comm.gatherAll(buffer)

def reduceAll(comm, reductOp, buffer):
  """
  reduceAll(Comm comm, EReductionType reductOp, buffer) -> numpy.ndarray

  Reduce the contents of buffer according to the operation designated
  by reductOp on all of the processors.  Argument reductOp can be
  Teuchos.REDUCE_SUM, Teuchos.REDUCE_MAX, or Teuchos.REDUCE_MIN.
  Argument buffer can be a numpy array or any sequence that can be
  converted to a numpy array.  Its scalar data type can be any
  numerical type supported by numpy.  The return argument is a numpy
  array of the same type.
  """
  return comm.reduceAll(reductOp, buffer)

def scan(comm, reductOp, buffer):
  """
  scan(Comm comm, EReductionType reductOp, buffer) -> numpy.ndarray

  Return the scan of the contents of buffer according to the operation
  designated by reductOp on each of the processors.  Argument reductOp
  can be Teuchos.REDUCE_SUM, Teuchos.REDUCE_MAX, or
  Teuchos.REDUCE_MIN.  Argument buffer can be a numpy array or any
  sequence that can be converted to a numpy array.  Its scalar data
  type can be any numerical type supported by numpy.  The return
  argument is a numpy array of the same type.
  """
  return comm.scan(reductOp, buffer)


def Teuchos_MPI_Init_Argv(*args):
    """Teuchos_MPI_Init_Argv(PyObject * args) -> PyObject *"""
    return _Teuchos.Teuchos_MPI_Init_Argv(*args)

def Teuchos_MPI_Finalize(*args):
    """Teuchos_MPI_Finalize() -> PyObject *"""
    return _Teuchos.Teuchos_MPI_Finalize(*args)


# Call MPI_Init if appropriate
import sys
calledMpiInit = Teuchos_MPI_Init_Argv(sys.argv)

# Proceed according to calledMpiInit.  If calledMpiInit is true, then register a
# call to MPI_Finalize() with the atexit module and use the default value for
# mpiCommunicator, equivalent to MPI_COMM_WORLD.  If calledMpiInit is false, try
# to assess what package is responsible for calling MPI_Init(), currently either
# distarray or mpi4py, and extract the appropriate value for mpiCommunicator.
mpiCommunicator = None
if calledMpiInit:
    import atexit
    atexit.register(Teuchos_MPI_Finalize)
else:
    if sys.modules.get("distarray.localapi.mpiutils"):
        dlm = sys.modules["distarray.localapi.mpiutils"]
        mpiCommunicator = dlm.get_base_comm()
    elif sys.modules.get("mpi4py.MPI"):
        MPI = sys.modules["mpi4py.MPI"]
        mpiCommunicator = MPI.COMM_WORLD


def mpiErrorCodeToString(*args):
    """mpiErrorCodeToString(int const err) -> std::string"""
    return _Teuchos.mpiErrorCodeToString(*args)

def safeCommFree(*args):
    """safeCommFree(MPI_Comm * comm)"""
    return _Teuchos.safeCommFree(*args)

def setCommErrhandler(*args):
    """setCommErrhandler(MPI_Comm comm, MPI_Errhandler handler) -> int"""
    return _Teuchos.setCommErrhandler(*args)
class MpiComm_int(Comm_int):
    """Proxy of C++ Teuchos::MpiComm<(int)> class."""

    __swig_setmethods__ = {}
    for _s in [Comm_int]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, MpiComm_int, name, value)
    __swig_getmethods__ = {}
    for _s in [Comm_int]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, MpiComm_int, name)

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr

    def setErrorHandler(self, *args):
        """setErrorHandler(MpiComm_int self, Teuchos::RCP< OpaqueWrapper< MPI_Errhandler > const > const & errHandler)"""
        return _Teuchos.MpiComm_int_setErrorHandler(self, *args)


    def getRank(self, *args):
        """getRank(MpiComm_int self) -> int"""
        return _Teuchos.MpiComm_int_getRank(self, *args)


    def getSize(self, *args):
        """getSize(MpiComm_int self) -> int"""
        return _Teuchos.MpiComm_int_getSize(self, *args)


    def barrier(self, *args):
        """barrier(MpiComm_int self)"""
        return _Teuchos.MpiComm_int_barrier(self, *args)


    def gather(self, *args):
        """gather(MpiComm_int self, int const sendBytes, char const [] sendBuffer, int const recvBytes, char [] recvBuffer, int const root)"""
        return _Teuchos.MpiComm_int_gather(self, *args)


    def reduceAllAndScatter(self, *args):
        """reduceAllAndScatter(MpiComm_int self, Teuchos::ValueTypeReductionOp< int,char > const & reductOp, int const sendBytes, char const [] sendBuffer, int const [] recvCounts, char [] myGlobalReducts)"""
        return _Teuchos.MpiComm_int_reduceAllAndScatter(self, *args)


    def send(self, *args):
        """
        send(MpiComm_int self, int const bytes, char const [] sendBuffer, int const destRank)
        send(MpiComm_int self, int const bytes, char const [] sendBuffer, int const destRank, int const tag)
        """
        return _Teuchos.MpiComm_int_send(self, *args)


    def ssend(self, *args):
        """
        ssend(MpiComm_int self, int const bytes, char const [] sendBuffer, int const destRank)
        ssend(MpiComm_int self, int const bytes, char const [] sendBuffer, int const destRank, int const tag)
        """
        return _Teuchos.MpiComm_int_ssend(self, *args)


    def receive(self, *args):
        """receive(MpiComm_int self, int const sourceRank, int const bytes, char [] recvBuffer) -> int"""
        return _Teuchos.MpiComm_int_receive(self, *args)


    def duplicate(self, *args):
        """duplicate(MpiComm_int self) -> Teuchos::RCP< Teuchos::Comm< int > >"""
        return _Teuchos.MpiComm_int_duplicate(self, *args)


    def split(self, *args):
        """split(MpiComm_int self, int const color, int const key) -> Teuchos::RCP< Teuchos::Comm< int > >"""
        return _Teuchos.MpiComm_int_split(self, *args)


    def createSubcommunicator(self, *args):
        """createSubcommunicator(MpiComm_int self, ArrayView< int const > const & ranks) -> Teuchos::RCP< Teuchos::Comm< int > >"""
        return _Teuchos.MpiComm_int_createSubcommunicator(self, *args)


    def description(self, *args):
        """description(MpiComm_int self) -> std::string"""
        return _Teuchos.MpiComm_int_description(self, *args)

    minTag_ = _Teuchos.MpiComm_int_minTag_
    maxTag_ = _Teuchos.MpiComm_int_maxTag_

    def getTag(self, *args):
        """getTag(MpiComm_int self) -> int"""
        return _Teuchos.MpiComm_int_getTag(self, *args)

    __swig_destroy__ = _Teuchos.delete_MpiComm_int
MpiComm_int_swigregister = _Teuchos.MpiComm_int_swigregister
MpiComm_int_swigregister(MpiComm_int)


MpiComm = MpiComm_int



class DefaultComm:
    "Encapsulate the default global communicator"
    __defaultComm = MpiComm(mpiCommunicator)
    @classmethod
    def getComm(cls):
        "Return the default global communicator"
        return cls.__defaultComm

VALIDATE_USED_ENABLED = _Teuchos.VALIDATE_USED_ENABLED
VALIDATE_USED_DISABLED = _Teuchos.VALIDATE_USED_DISABLED
VALIDATE_DEFAULTS_ENABLED = _Teuchos.VALIDATE_DEFAULTS_ENABLED
VALIDATE_DEFAULTS_DISABLED = _Teuchos.VALIDATE_DEFAULTS_DISABLED
class ParameterList(_object):
    """
    The ``ParameterList`` class is an important utility class that is used
    by several Trilinos packages for communicating arbitrary-type
    parameters between users and packages.

    Often, the ``ParameterList`` class is invisible to the user.  It is
    analagous to the python dictionary (with the restriction that the
    dictionary keys must be strings), and python programmers can provide a
    python dictionary wherever a ``ParameterList`` is expected.
    ``Teuchos`` is imported by other packages that use the
    ``ParameterList`` class and converts between dictionaries and
    ``ParameterList`` objects automatically.

    The user can create a ``Teuchos.ParameterList`` directly, using the
    constructor, ``set`` and ``sublist`` methods, if he so chooses, and
    methods that accept ``ParameterList`` objects will work as expected.
    It is really just a question of verbosity and elegance that argues in
    favor of using a python dictionary.

    The python implementation of the ``ParameterList`` class has been
    expanded extensively.  Its constructor can accept a python dictionary,
    and several methods and operators have been added to the class so that
    it behaves somewhat like a dictionary.

    C++ ``ParameterList`` objects are designed to support parameters of
    arbitrary type.  The python implementation supports a subset of types
    *a priori* :

      +-------------------------+-----+-------------------+
      |       Python type       | Dir |     C/C++ type    |
      +-------------------------+-----+-------------------+
      | ``bool``                | <-> | ``bool``          |
      +-------------------------+-----+-------------------+
      | ``int``                 | <-> | ``int``           |
      +-------------------------+-----+-------------------+
      | ``float``               | <-> | ``double``        |
      +-------------------------+-----+-------------------+
      | ``str``                 | <-- | ``char *``        |
      +-------------------------+-----+-------------------+
      | ``str``                 | <-> | ``std::string``   |
      +-------------------------+-----+-------------------+
      | ``dict``                | --> | ``ParameterList`` |
      +-------------------------+-----+-------------------+
      | ``ParameterList``       | <-> | ``ParameterList`` |
      +-------------------------+-----+-------------------+
      | ``ndarray(dtype='i')``  | <-> | ``Array<int>``    |
      +-------------------------+-----+-------------------+
      | ``ndarray(dtype='l')``  | <-> | ``Array<long>``   |
      +-------------------------+-----+-------------------+
      | ``ndarray(dtype='f')``  | <-> | ``Array<float>``  |
      +-------------------------+-----+-------------------+
      | ``ndarray(dtype='d')``  | <-> | ``Array<double>`` |
      +-------------------------+-----+-------------------+
      | ``sequence(int)``       | --> | ``Array<long>``   |
      +-------------------------+-----+-------------------+
      | ``sequence(float)``     | --> | ``Array<double>`` |
      +-------------------------+-----+-------------------+

    ``ndarray`` refers to the NumPy ndarray class and ``sequence`` refers
    to a Python sequence, either a list or a tuple.  The C++ Array class
    is the ``Teuchos::Array``.

    The C++ ``ParameterList`` class supports ``begin()`` and ``end()``
    methods for iterating over the parameters.  These methods are disabled
    in the python implementation, in favor of the dictionary iterator
    methods: ``__iter__()``, ``iteritems()``, ``iterkeys()`` and
    ``itervalues()``.

    Note that the C++ implementation of the ``ParameterList`` class does
    not support parameter deletion.  Therefore, python dictionary methods
    that delete items, such as ``pop()`` or ``__delitem__()``, have not
    been added to the ``ParameterList`` class.
    """

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, ParameterList, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, ParameterList, name)
    __swig_destroy__ = _Teuchos.delete_ParameterList

    def numParams(self, *args):
        """numParams(ParameterList self) -> Teuchos::Ordinal"""
        return _Teuchos.ParameterList_numParams(self, *args)


    def setName(self, *args):
        """setName(ParameterList self, std::string const & name) -> ParameterList"""
        return _Teuchos.ParameterList_setName(self, *args)


    def setParameters(self, *args):
        """
        setParameters(ParameterList self, ParameterList source) -> ParameterList

        The ``setParameters()`` method can take either a ``ParameterList`` or
        a python dictionary as its argument.  The ``ParameterList`` is updated
        to contain all of the entries of the argument.
        """
        return _Teuchos.ParameterList_setParameters(self, *args)


    def setParametersNotAlreadySet(self, *args):
        """setParametersNotAlreadySet(ParameterList self, ParameterList source) -> ParameterList"""
        return _Teuchos.ParameterList_setParametersNotAlreadySet(self, *args)


    def disableRecursiveValidation(self, *args):
        """disableRecursiveValidation(ParameterList self) -> ParameterList"""
        return _Teuchos.ParameterList_disableRecursiveValidation(self, *args)


    def getEntry(self, *args):
        """
        getEntry(ParameterList self, std::string const & name) -> ParameterEntry
        getEntry(ParameterList self, std::string const & name) -> ParameterEntry
        """
        return _Teuchos.ParameterList_getEntry(self, *args)


    def getEntryRCP(self, *args):
        """
        getEntryRCP(ParameterList self, std::string const & name) -> Teuchos::RCP< Teuchos::ParameterEntry >
        getEntryRCP(ParameterList self, std::string const & name) -> Teuchos::RCP< Teuchos::ParameterEntry const >
        """
        return _Teuchos.ParameterList_getEntryRCP(self, *args)


    def remove(self, *args):
        """remove(ParameterList self, std::string const & name, bool throwIfNotExists=True) -> bool"""
        return _Teuchos.ParameterList_remove(self, *args)


    def sublist(self, *args):
        """sublist(ParameterList self, std::string const & name, bool mustAlreadyExist=False, std::string const & docString) -> ParameterList"""
        return _Teuchos.ParameterList_sublist(self, *args)


    def name(self, *args):
        """name(ParameterList self) -> std::string const &"""
        return _Teuchos.ParameterList_name(self, *args)


    def isParameter(self, *args):
        """isParameter(ParameterList self, std::string const & name) -> bool"""
        return _Teuchos.ParameterList_isParameter(self, *args)


    def isSublist(self, *args):
        """isSublist(ParameterList self, std::string const & name) -> bool"""
        return _Teuchos.ParameterList_isSublist(self, *args)


    def currentParametersString(self, *args):
        """currentParametersString(ParameterList self) -> std::string"""
        return _Teuchos.ParameterList_currentParametersString(self, *args)


    def validateParameters(self, *args):
        """validateParameters(ParameterList self, ParameterList validParamList, int const depth=1000, Teuchos::EValidateUsed const validateUsed, Teuchos::EValidateDefaults const validateDefaults)"""
        return _Teuchos.ParameterList_validateParameters(self, *args)


    def validateParametersAndSetDefaults(self, *args):
        """validateParametersAndSetDefaults(ParameterList self, ParameterList validParamList, int const depth=1000)"""
        return _Teuchos.ParameterList_validateParametersAndSetDefaults(self, *args)


    def __init__(self, *args):
        """
        __init__(Teuchos::ParameterList self) -> ParameterList
        __init__(Teuchos::ParameterList self, std::string const & name) -> ParameterList
        __init__(Teuchos::ParameterList self, ParameterList source) -> ParameterList
        __init__(Teuchos::ParameterList self, PyObject * dict, string name) -> ParameterList

        If ``dict`` is provided, it must be a dictionary whose keys are all
        strings and whose values are all of supported types.  The string name
        argument is optional and defaults to ``ANONYMOUS``.
        """
        this = _Teuchos.new_ParameterList(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

    def set(self, *args):
        """
        set(ParameterList self, string const & name, PyObject * value) -> ParameterList

        The templated C++ ``set()`` method is replaced in python with a method
        that takes a string name and a python object of supported type.  For
        example::

            plist = Teuchos.ParameterList()
            plist.set('b',True)
            plist.set('i',10)
            plist.set('f',2.718)
            plist.set('s','Trilinos')
            plist.set('d',{'a':1, 'b':2})
        """
        return _Teuchos.ParameterList_set(self, *args)


    def get(self, *args):
        """
        get(ParameterList self, string const & name, PyObject * default_value=None) -> PyObject *

        The templated C++ ``get()`` method is replaced in python with a method
        that returns a python object.  For example::

            plist = Teuchos.ParameterList({'f':2.718, 'd':{'a':1. 'b':2}})
            print plist.get('f')
            print plist.get('d')

          will output::

            2.718
            {'a': 1, 'b': 2}
        """
        return _Teuchos.ParameterList_get(self, *args)


    def _print(self, *args):
        """
        _print(ParameterList self, PyObject * pf=None, int indent=0, bool showTypes=False, bool showFlags=True) -> PyObject *

        Since ``print`` is a python keyword, the ``print()`` C++ method has
        been renamed ``_print`` in python.  It takes an optional file argument
        that defaults to standard output.  Its output is the same as the C++
        implementation.
        """
        return _Teuchos.ParameterList__print(self, *args)


    def unused(self, *args):
        """
        unused(self, pf=None)

        The ``unused()`` method in python takes an optional python file object
        as its argument, defaulting to standard output.  This specifies where
        the output should go.
        unused(self, pf=None)

        The ``unused()`` method in python takes an optional python file object
        as its argument, defaulting to standard output.  This specifies where
        the output should go.
        """
        return _Teuchos.ParameterList_unused(self, *args)


    def type(self, *args):
        """
        type(ParameterList self, std::string const & name) -> PyObject *

        Parameter type determination.  With the templated ``isType()`` methods
        disabled, type determination of python ``ParameterList`` entries is
        accomplished with the ``type()`` method, which returns python type
        objects.  For example::

          plist = Teuchos.ParameterList({'b':True, 's':'Trilinos'})
          print plist.type('b')
          print plist.type('s')

        results in::

          <type 'bool'>
          <type 'str'>

        A non-existent key given as the argument will raise a ``KeyError``
        exception.
        """
        return _Teuchos.ParameterList_type(self, *args)


    def __cmp__(self, *args):
        """
        __cmp__(ParameterList self, PyObject * obj) -> int
        __cmp__(ParameterList self, ParameterList plist) -> int
        """
        return _Teuchos.ParameterList___cmp__(self, *args)


    def __contains__(self, *args):
        """
        __contains__(ParameterList self, std::string const & name) -> int

        The python ``in`` operator works for ``ParameterList`` objects,
        searching the parameter names::

          plist = Teuchos.ParameterList({'b':False})
          print 'a' in plist
          print 'b' in plist

        produces::

          False
          True
        """
        return _Teuchos.ParameterList___contains__(self, *args)


    def __eq__(self, *args):
        """
        __eq__(ParameterList self, PyObject * obj) -> PyObject
        __eq__(ParameterList self, ParameterList plist) -> PyObject *

        The ``ParameterList`` equals operator (==)
        """
        return _Teuchos.ParameterList___eq__(self, *args)


    def __getitem__(self, *args):
        """
        __getitem__(ParameterList self, std::string const & name) -> PyObject *

        Like dictionaries, parameters can be gotten using square brackets::

          plist = Teuchos.ParameterList()
          plist['f'] = 2.718
          e = plist['f']
        """
        return _Teuchos.ParameterList___getitem__(self, *args)


    def __iter__(self, *args):
        """
        __iter__(ParameterList self) -> PyObject *

        To iterate over the parameters in a ``ParameterList``, treat it like a
        dictionary::

          plist = Teuchos.ParameterList({'b':True,
                                         'i':10,
                                         'f':2.718,
                                         's':'Trilinos',
                                         'd':{'a':1, 'b':2}})
          for key in plist:
            print key, ':', plist[key]

        will result in the output::

          b : True
          d : {'a': 1, 'b': 2}
          f : 2.718
          i : 10
          s : Trilinos

        Note that the order of the parameters is somewhat indeterminant, as
        with dictionaries, because the iteration object is obtained from an
        equivalent dictionary, and dictionaries are ordered by hash
        function.
        """
        return _Teuchos.ParameterList___iter__(self, *args)


    def __len__(self, *args):
        """
        __len__(ParameterList self) -> int

        The python ``len()`` function works on ``ParameterList`` objects just
        as on python dictionaries::

          plist = Teuchos.ParameterList({'b':True,
                                         'i':10,
                                         'f':2.718,
                                         's':'Trilinos',
                                         'd':{'a':1, 'b':2}})
          print len(plist)

        gives::

          5
        """
        return _Teuchos.ParameterList___len__(self, *args)


    def __ne__(self, *args):
        """
        __ne__(ParameterList self, PyObject * obj) -> PyObject
        __ne__(ParameterList self, ParameterList plist) -> PyObject *

        The ``ParameterList`` not equals operator (!=)
        """
        return _Teuchos.ParameterList___ne__(self, *args)


    def __setitem__(self, *args):
        """
        __setitem__(ParameterList self, std::string const & name, PyObject * value)

        Like dictionaries, parameters can be set using square brackets::

          plist = Teuchos.ParameterList()
          plist['zero'] = 0
        """
        return _Teuchos.ParameterList___setitem__(self, *args)


    def __repr__(self, *args):
        """
        __repr__(self) -> string

        The ``__repr__()`` method returns the ``__str__()`` output
        encapsulated by ``ParameterList(...)``.  The python ``eval`` function
        applied to the output of ``__repr__()`` will produce an equivalent
        ``ParameterList``.
        """
        return _Teuchos.ParameterList___repr__(self, *args)


    def __str__(self, *args):
        """
        __str__(self) -> string

        The ``__str__()`` method returns a string representation of the
        ``ParameterList`` as though it were a python dictionary.  The python
        ``eval`` function applied to the output of ``__str__()`` will produce
        an equivalent dictionary.
        """
        return _Teuchos.ParameterList___str__(self, *args)


    def has_key(self, *args):
        """
        has_key(ParameterList self, std::string const & name) -> int

        Equivalent to the python dictionary has_key() method
        """
        return _Teuchos.ParameterList_has_key(self, *args)


    def items(self, *args):
        """
        items(ParameterList self) -> PyObject *

        Equivalent to the python dictionary items() method
        """
        return _Teuchos.ParameterList_items(self, *args)


    def iteritems(self, *args):
        """
        iteritems(ParameterList self) -> PyObject *

        Equivalent to the python dictionary iteritems() method
        """
        return _Teuchos.ParameterList_iteritems(self, *args)


    def iterkeys(self, *args):
        """
        iterkeys(ParameterList self) -> PyObject *

        Equivalent to the python dictionary iterkeys() method
        """
        return _Teuchos.ParameterList_iterkeys(self, *args)


    def itervalues(self, *args):
        """
        itervalues(ParameterList self) -> PyObject *

        Equivalent to the python dictionary itervalues() method
        """
        return _Teuchos.ParameterList_itervalues(self, *args)


    def keys(self, *args):
        """
        keys(ParameterList self) -> PyObject *

        Equivalent to the python dictionary keys() method
        """
        return _Teuchos.ParameterList_keys(self, *args)


    def update(self, *args):
        """
        update(ParameterList self, PyObject * dict, bool strict=True)
        update(ParameterList self, ParameterList plist)

        An ``update()`` method has been added to the ``ParameterList`` class
        that can accept either a ``ParameterList`` or a python dictionary.
        Otherwise, it behaves just as the dictionary method, which is
        functionally equivalent to the ``setParameters()`` method.
        """
        return _Teuchos.ParameterList_update(self, *args)


    def values(self, *args):
        """
        values(ParameterList self) -> PyObject *

        Equivalent to the python dictionary values() method
        """
        return _Teuchos.ParameterList_values(self, *args)


    def asDict(self, *args):
        """
        asDict(ParameterList self) -> PyObject *

        The ``asDict()`` method has been added to ``ParameterList``, which
        returns the contents of the ``ParameterList`` converted to a python
        dictionary.

        """
        return _Teuchos.ParameterList_asDict(self, *args)

ParameterList_swigregister = _Teuchos.ParameterList_swigregister
ParameterList_swigregister(ParameterList)

class PrintOptions(_object):
    """Proxy of C++ Teuchos::ParameterList::PrintOptions class."""

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, PrintOptions, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, PrintOptions, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """__init__(Teuchos::ParameterList::PrintOptions self) -> PrintOptions"""
        this = _Teuchos.new_PrintOptions(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

    def incrIndent(self, *args):
        """incrIndent(PrintOptions self, int indents) -> PrintOptions"""
        return _Teuchos.PrintOptions_incrIndent(self, *args)


    def indent(self, *args):
        """
        indent(PrintOptions self, int _indent) -> PrintOptions
        indent(PrintOptions self) -> int
        """
        return _Teuchos.PrintOptions_indent(self, *args)


    def showTypes(self, *args):
        """
        showTypes(PrintOptions self, bool _showTypes) -> PrintOptions
        showTypes(PrintOptions self) -> bool
        """
        return _Teuchos.PrintOptions_showTypes(self, *args)


    def showFlags(self, *args):
        """
        showFlags(PrintOptions self, bool _showFlags) -> PrintOptions
        showFlags(PrintOptions self) -> bool
        """
        return _Teuchos.PrintOptions_showFlags(self, *args)


    def showDoc(self, *args):
        """
        showDoc(PrintOptions self, bool _showDoc) -> PrintOptions
        showDoc(PrintOptions self) -> bool
        """
        return _Teuchos.PrintOptions_showDoc(self, *args)


    def copy(self, *args):
        """copy(PrintOptions self) -> PrintOptions"""
        return _Teuchos.PrintOptions_copy(self, *args)

    __swig_destroy__ = _Teuchos.delete_PrintOptions
PrintOptions_swigregister = _Teuchos.PrintOptions_swigregister
PrintOptions_swigregister(PrintOptions)


def parameterList(*args):
    """
    parameterList() -> Teuchos::RCP< Teuchos::ParameterList >
    parameterList(std::string const & name) -> Teuchos::RCP< Teuchos::ParameterList >
    parameterList(ParameterList source) -> Teuchos::RCP< Teuchos::ParameterList >
    """
    return _Teuchos.parameterList(*args)

def createParameterList(*args):
    """
    createParameterList() -> Teuchos::RCP< Teuchos::ParameterList >
    createParameterList(std::string const & name) -> Teuchos::RCP< Teuchos::ParameterList >
    """
    return _Teuchos.createParameterList(*args)

def __eq__(*args):
    """
    __eq__(ParameterEntry e1, ParameterEntry e2) -> bool
    __eq__(ParameterList list1, ParameterList list2) -> bool
    """
    return _Teuchos.__eq__(*args)

def __ne__(*args):
    """
    __ne__(ParameterEntry e1, ParameterEntry e2) -> bool
    __ne__(ParameterList list1, ParameterList list2) -> bool
    """
    return _Teuchos.__ne__(*args)

def haveSameValues(*args):
    """haveSameValues(ParameterList list1, ParameterList list2) -> bool"""
    return _Teuchos.haveSameValues(*args)

def sublist(*args):
    """
    sublist(Teuchos::RCP< Teuchos::ParameterList > const & paramList, std::string const & name, bool mustAlreadyExist=False, std::string const & docString) -> Teuchos::RCP< Teuchos::ParameterList >
    sublist(Teuchos::RCP< Teuchos::ParameterList const > const & paramList, std::string const & name) -> Teuchos::RCP< Teuchos::ParameterList const >
    """
    return _Teuchos.sublist(*args)
class ParameterListAcceptor(_object):
    """Proxy of C++ Teuchos::ParameterListAcceptor class."""

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, ParameterListAcceptor, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, ParameterListAcceptor, name)

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _Teuchos.delete_ParameterListAcceptor

    def setParameterList(self, *args):
        """setParameterList(ParameterListAcceptor self, Teuchos::RCP< Teuchos::ParameterList > const & paramList)"""
        return _Teuchos.ParameterListAcceptor_setParameterList(self, *args)


    def getNonconstParameterList(self, *args):
        """getNonconstParameterList(ParameterListAcceptor self) -> Teuchos::RCP< Teuchos::ParameterList >"""
        return _Teuchos.ParameterListAcceptor_getNonconstParameterList(self, *args)


    def unsetParameterList(self, *args):
        """unsetParameterList(ParameterListAcceptor self) -> Teuchos::RCP< Teuchos::ParameterList >"""
        return _Teuchos.ParameterListAcceptor_unsetParameterList(self, *args)


    def getParameterList(self, *args):
        """getParameterList(ParameterListAcceptor self) -> Teuchos::RCP< Teuchos::ParameterList const >"""
        return _Teuchos.ParameterListAcceptor_getParameterList(self, *args)


    def getValidParameters(self, *args):
        """getValidParameters(ParameterListAcceptor self) -> Teuchos::RCP< Teuchos::ParameterList const >"""
        return _Teuchos.ParameterListAcceptor_getValidParameters(self, *args)


    def getDependencies(self, *args):
        """getDependencies(ParameterListAcceptor self) -> Teuchos::RCP< Teuchos::DependencySheet const >"""
        return _Teuchos.ParameterListAcceptor_getDependencies(self, *args)

ParameterListAcceptor_swigregister = _Teuchos.ParameterListAcceptor_swigregister
ParameterListAcceptor_swigregister(ParameterListAcceptor)

class EmptyXMLError(_object):
    """Proxy of C++ Teuchos::EmptyXMLError class."""

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, EmptyXMLError, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, EmptyXMLError, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """__init__(Teuchos::EmptyXMLError self, std::string const & what_arg) -> EmptyXMLError"""
        this = _Teuchos.new_EmptyXMLError(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _Teuchos.delete_EmptyXMLError
EmptyXMLError_swigregister = _Teuchos.EmptyXMLError_swigregister
EmptyXMLError_swigregister(EmptyXMLError)

class XMLObject(_object):
    """Representation of an XML data tree."""

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, XMLObject, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, XMLObject, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(Teuchos::XMLObject self) -> XMLObject
        __init__(Teuchos::XMLObject self, std::string const & tag) -> XMLObject

        The constructor that takes an ``XMLObjectImplem*`` argument has been
        removed.  The ``XMLObjectImplem`` class is hidden from the python
        user.
        """
        this = _Teuchos.new_XMLObject(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

    def deepCopy(self, *args):
        """deepCopy(XMLObject self) -> XMLObject"""
        return _Teuchos.XMLObject_deepCopy(self, *args)


    def getTag(self, *args):
        """getTag(XMLObject self) -> std::string const &"""
        return _Teuchos.XMLObject_getTag(self, *args)


    def hasAttribute(self, *args):
        """hasAttribute(XMLObject self, std::string const & name) -> bool"""
        return _Teuchos.XMLObject_hasAttribute(self, *args)


    def getAttribute(self, *args):
        """getAttribute(XMLObject self, std::string const & name) -> std::string const &"""
        return _Teuchos.XMLObject_getAttribute(self, *args)


    def getRequired(self, *args):
        """getRequired(XMLObject self, std::string const & name) -> std::string const &"""
        return _Teuchos.XMLObject_getRequired(self, *args)


    def getRequiredDouble(self, *args):
        """getRequiredDouble(XMLObject self, std::string const & name) -> double"""
        return _Teuchos.XMLObject_getRequiredDouble(self, *args)


    def getRequiredInt(self, *args):
        """getRequiredInt(XMLObject self, std::string const & name) -> int"""
        return _Teuchos.XMLObject_getRequiredInt(self, *args)


    def getRequiredBool(self, *args):
        """getRequiredBool(XMLObject self, std::string const & name) -> bool"""
        return _Teuchos.XMLObject_getRequiredBool(self, *args)


    def numChildren(self, *args):
        """numChildren(XMLObject self) -> int"""
        return _Teuchos.XMLObject_numChildren(self, *args)


    def getChild(self, *args):
        """getChild(XMLObject self, int i) -> XMLObject"""
        return _Teuchos.XMLObject_getChild(self, *args)


    def findFirstChild(self, *args):
        """findFirstChild(XMLObject self, std::string tagName) -> int"""
        return _Teuchos.XMLObject_findFirstChild(self, *args)


    def numContentLines(self, *args):
        """numContentLines(XMLObject self) -> int"""
        return _Teuchos.XMLObject_numContentLines(self, *args)


    def getContentLine(self, *args):
        """getContentLine(XMLObject self, int i) -> std::string const &"""
        return _Teuchos.XMLObject_getContentLine(self, *args)


    def toString(self, *args):
        """toString(XMLObject self) -> std::string"""
        return _Teuchos.XMLObject_toString(self, *args)


    def header(self, *args):
        """header(XMLObject self) -> std::string"""
        return _Teuchos.XMLObject_header(self, *args)


    def terminatedHeader(self, *args):
        """terminatedHeader(XMLObject self) -> std::string"""
        return _Teuchos.XMLObject_terminatedHeader(self, *args)


    def footer(self, *args):
        """footer(XMLObject self) -> std::string"""
        return _Teuchos.XMLObject_footer(self, *args)


    def isEmpty(self, *args):
        """isEmpty(XMLObject self) -> bool"""
        return _Teuchos.XMLObject_isEmpty(self, *args)


    def checkTag(self, *args):
        """checkTag(XMLObject self, std::string const & expected)"""
        return _Teuchos.XMLObject_checkTag(self, *args)


    def addDouble(self, *args):
        """addDouble(XMLObject self, std::string const & name, double val)"""
        return _Teuchos.XMLObject_addDouble(self, *args)


    def addInt(self, *args):
        """addInt(XMLObject self, std::string const & name, int val)"""
        return _Teuchos.XMLObject_addInt(self, *args)


    def addBool(self, *args):
        """addBool(XMLObject self, std::string const & name, bool val)"""
        return _Teuchos.XMLObject_addBool(self, *args)


    def addChild(self, *args):
        """addChild(XMLObject self, XMLObject child)"""
        return _Teuchos.XMLObject_addChild(self, *args)


    def addContent(self, *args):
        """addContent(XMLObject self, std::string const & contentLine)"""
        return _Teuchos.XMLObject_addContent(self, *args)


    def appendContentLine(self, *args):
        """appendContentLine(XMLObject self, size_t const & i, std::string const & str)"""
        return _Teuchos.XMLObject_appendContentLine(self, *args)


    def removeContentLine(self, *args):
        """removeContentLine(XMLObject self, size_t const & i)"""
        return _Teuchos.XMLObject_removeContentLine(self, *args)


    def addAttribute(self, *args):
        """
        addAttribute(XMLObject self, std::string const & name, PyObject * value)

        The ``addAttribute(name, value)`` method converts the value to its
        string representation and adds it as an attribute to the XML object.
        """
        return _Teuchos.XMLObject_addAttribute(self, *args)


    def getWithDefault(self, *args):
        """
        getWithDefault(XMLObject self, std::string const & name, PyObject * defaultValue) -> PyObject *

        The ``getWithDefault(name, defaultValue)`` method will return the
        typed value of attribute ``name``.  If the attribute does not exist,
        then ``defaultValue``, which can be any python object, is returned.
        If the underlying object cannot be converted to a python object, then
        a python string is returned.
        """
        return _Teuchos.XMLObject_getWithDefault(self, *args)


    def __str__(self, *args):
        """
        __str__(XMLObject self) -> std::string

        The ``__str__()`` method is provided so that it is possible to
        ``print`` an ``XMLObject`` object.  It returns the same string as the
        ``toString()`` method, but if ``toString()`` raises an exception (such
        as when the ``XMLObject`` is empty), the ``__str__()`` method returns
        the empty string.
        """
        return _Teuchos.XMLObject___str__(self, *args)

    __swig_destroy__ = _Teuchos.delete_XMLObject
XMLObject_swigregister = _Teuchos.XMLObject_swigregister
XMLObject_swigregister(XMLObject)


def __lshift__(*args):
    """
    __lshift__(std::ostream & os, DescribableStreamManipulatorState d) -> std::ostream
    __lshift__(std::ostream & os, ParameterEntry e) -> std::ostream
    __lshift__(std::ostream & os, ParameterList l) -> std::ostream
    __lshift__(std::ostream & os, XMLObject xml) -> std::ostream &
    """
    return _Teuchos.__lshift__(*args)

def reductionTypeToString(*args):
    """
    reductionTypeToString(Teuchos::EReductionType const reductType) -> char const
    reductionTypeToString(XMLObject xml) -> std::string
    """
    return _Teuchos.reductionTypeToString(*args)
class XMLParameterListReader(_object):
    """Proxy of C++ Teuchos::XMLParameterListReader class."""

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, XMLParameterListReader, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, XMLParameterListReader, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """__init__(Teuchos::XMLParameterListReader self) -> XMLParameterListReader"""
        this = _Teuchos.new_XMLParameterListReader(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

    def toParameterList(self, *args):
        """toParameterList(XMLParameterListReader self, XMLObject xml) -> ParameterList"""
        return _Teuchos.XMLParameterListReader_toParameterList(self, *args)


    def setAllowsDuplicateSublists(self, *args):
        """setAllowsDuplicateSublists(XMLParameterListReader self, bool policy)"""
        return _Teuchos.XMLParameterListReader_setAllowsDuplicateSublists(self, *args)


    def getAllowsDuplicateSublists(self, *args):
        """getAllowsDuplicateSublists(XMLParameterListReader self) -> bool"""
        return _Teuchos.XMLParameterListReader_getAllowsDuplicateSublists(self, *args)

    __swig_destroy__ = _Teuchos.delete_XMLParameterListReader
XMLParameterListReader_swigregister = _Teuchos.XMLParameterListReader_swigregister
XMLParameterListReader_swigregister(XMLParameterListReader)

class XMLParameterListWriter(_object):
    """Proxy of C++ Teuchos::XMLParameterListWriter class."""

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, XMLParameterListWriter, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, XMLParameterListWriter, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """__init__(Teuchos::XMLParameterListWriter self) -> XMLParameterListWriter"""
        this = _Teuchos.new_XMLParameterListWriter(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

    def getParameterListTagName(*args):
        """getParameterListTagName() -> std::string const &"""
        return _Teuchos.XMLParameterListWriter_getParameterListTagName(*args)

    getParameterListTagName = staticmethod(getParameterListTagName)

    def getNameAttributeName(*args):
        """getNameAttributeName() -> std::string const &"""
        return _Teuchos.XMLParameterListWriter_getNameAttributeName(*args)

    getNameAttributeName = staticmethod(getNameAttributeName)

    def getValidatorsTagName(*args):
        """getValidatorsTagName() -> std::string const &"""
        return _Teuchos.XMLParameterListWriter_getValidatorsTagName(*args)

    getValidatorsTagName = staticmethod(getValidatorsTagName)

    def getDependenciesTagName(*args):
        """getDependenciesTagName() -> std::string const &"""
        return _Teuchos.XMLParameterListWriter_getDependenciesTagName(*args)

    getDependenciesTagName = staticmethod(getDependenciesTagName)

    def toXML(self, *args):
        """toXML(XMLParameterListWriter self, ParameterList p) -> XMLObject"""
        return _Teuchos.XMLParameterListWriter_toXML(self, *args)

    __swig_destroy__ = _Teuchos.delete_XMLParameterListWriter
XMLParameterListWriter_swigregister = _Teuchos.XMLParameterListWriter_swigregister
XMLParameterListWriter_swigregister(XMLParameterListWriter)

def XMLParameterListWriter_getParameterListTagName(*args):
    """XMLParameterListWriter_getParameterListTagName() -> std::string const &"""
    return _Teuchos.XMLParameterListWriter_getParameterListTagName(*args)

def XMLParameterListWriter_getNameAttributeName(*args):
    """XMLParameterListWriter_getNameAttributeName() -> std::string const &"""
    return _Teuchos.XMLParameterListWriter_getNameAttributeName(*args)

def XMLParameterListWriter_getValidatorsTagName(*args):
    """XMLParameterListWriter_getValidatorsTagName() -> std::string const &"""
    return _Teuchos.XMLParameterListWriter_getValidatorsTagName(*args)

def XMLParameterListWriter_getDependenciesTagName(*args):
    """XMLParameterListWriter_getDependenciesTagName() -> std::string const &"""
    return _Teuchos.XMLParameterListWriter_getDependenciesTagName(*args)

class XMLInputSource(_object):
    """Proxy of C++ Teuchos::XMLInputSource class."""

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, XMLInputSource, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, XMLInputSource, name)

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _Teuchos.delete_XMLInputSource

    def getObject(self, *args):
        """getObject(XMLInputSource self) -> XMLObject"""
        return _Teuchos.XMLInputSource_getObject(self, *args)

XMLInputSource_swigregister = _Teuchos.XMLInputSource_swigregister
XMLInputSource_swigregister(XMLInputSource)

class FileInputSource(XMLInputSource):
    """Proxy of C++ Teuchos::FileInputSource class."""

    __swig_setmethods__ = {}
    for _s in [XMLInputSource]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, FileInputSource, name, value)
    __swig_getmethods__ = {}
    for _s in [XMLInputSource]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, FileInputSource, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """__init__(Teuchos::FileInputSource self, std::string const & filename) -> FileInputSource"""
        this = _Teuchos.new_FileInputSource(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _Teuchos.delete_FileInputSource
FileInputSource_swigregister = _Teuchos.FileInputSource_swigregister
FileInputSource_swigregister(FileInputSource)

class StringInputSource(XMLInputSource):
    """Proxy of C++ Teuchos::StringInputSource class."""

    __swig_setmethods__ = {}
    for _s in [XMLInputSource]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, StringInputSource, name, value)
    __swig_getmethods__ = {}
    for _s in [XMLInputSource]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, StringInputSource, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """__init__(Teuchos::StringInputSource self, std::string const & text) -> StringInputSource"""
        this = _Teuchos.new_StringInputSource(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _Teuchos.delete_StringInputSource
StringInputSource_swigregister = _Teuchos.StringInputSource_swigregister
StringInputSource_swigregister(StringInputSource)


def Teuchos_Version(*args):
    """Teuchos_Version() -> std::string"""
    return _Teuchos.Teuchos_Version(*args)

__version__ = Teuchos_Version().split()[2]

class Time(_object):
    """Proxy of C++ Teuchos::Time class."""

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, Time, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, Time, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """__init__(Teuchos::Time self, std::string const & name, bool start=False) -> Time"""
        this = _Teuchos.new_Time(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

    def wallTime(*args):
        """wallTime() -> double"""
        return _Teuchos.Time_wallTime(*args)

    wallTime = staticmethod(wallTime)

    def start(self, *args):
        """start(Time self, bool reset=False)"""
        return _Teuchos.Time_start(self, *args)


    def stop(self, *args):
        """stop(Time self) -> double"""
        return _Teuchos.Time_stop(self, *args)


    def disable(self, *args):
        """disable(Time self)"""
        return _Teuchos.Time_disable(self, *args)


    def enable(self, *args):
        """enable(Time self)"""
        return _Teuchos.Time_enable(self, *args)


    def isEnabled(self, *args):
        """isEnabled(Time self) -> bool"""
        return _Teuchos.Time_isEnabled(self, *args)


    def totalElapsedTime(self, *args):
        """totalElapsedTime(Time self, bool readCurrentTime=False) -> double"""
        return _Teuchos.Time_totalElapsedTime(self, *args)


    def reset(self, *args):
        """reset(Time self)"""
        return _Teuchos.Time_reset(self, *args)


    def isRunning(self, *args):
        """isRunning(Time self) -> bool"""
        return _Teuchos.Time_isRunning(self, *args)


    def name(self, *args):
        """name(Time self) -> std::string const &"""
        return _Teuchos.Time_name(self, *args)


    def incrementNumCalls(self, *args):
        """incrementNumCalls(Time self)"""
        return _Teuchos.Time_incrementNumCalls(self, *args)


    def numCalls(self, *args):
        """numCalls(Time self) -> int"""
        return _Teuchos.Time_numCalls(self, *args)

    __swig_destroy__ = _Teuchos.delete_Time
Time_swigregister = _Teuchos.Time_swigregister
Time_swigregister(Time)

def Time_wallTime(*args):
    """Time_wallTime() -> double"""
    return _Teuchos.Time_wallTime(*args)

Copy = _Teuchos.Copy
View = _Teuchos.View
# This file is compatible with both classic and new-style classes.


