# This file was automatically generated by SWIG (http://www.swig.org).
# Version 3.0.12
#
# Do not make changes to this file unless you know what you are doing--modify
# the SWIG interface file instead.

"""

PyTrilinos.NOX.Epetra is the python interface to namespace Epetra for
the Trilinos package NOX:

    http://trilinos.sandia.gov/packages/nox

The purpose of NOX.Epetra is to provide a concrete interface beteen
NOX and Epetra.

NOX.Epetra provides the following user-level classes:

    * Group                    - Epetra implementation of Abstract.Group
    * Vector                   - Epetra implementation of Abstract.Vector
    * FiniteDifference         - Class for estimating Jacobian w/finite differences
    * FiniteDifferenceColoring - FiniteDifference class, w/coloring efficiencies
    * MatrixFree               - Base class for Jacobian-free algorithms
    * Scaling                  - Class for controlling scalling of algebraic objects
    * LinearSystem             - Base class for interface to linear solvers
    * LinearSystemAztecOO      - Concrete implementation of LinearSystem

"""


from sys import version_info as _swig_python_version_info
if _swig_python_version_info >= (2, 7, 0):
    def swig_import_helper():
        import importlib
        pkg = __name__.rpartition('.')[0]
        mname = '.'.join((pkg, '___init__')).lstrip('.')
        try:
            return importlib.import_module(mname)
        except ImportError:
            return importlib.import_module('___init__')
    ___init__ = swig_import_helper()
    del swig_import_helper
elif _swig_python_version_info >= (2, 6, 0):
    def swig_import_helper():
        from os.path import dirname
        import imp
        fp = None
        try:
            fp, pathname, description = imp.find_module('___init__', [dirname(__file__)])
        except ImportError:
            import ___init__
            return ___init__
        try:
            _mod = imp.load_module('___init__', fp, pathname, description)
        finally:
            if fp is not None:
                fp.close()
        return _mod
    ___init__ = swig_import_helper()
    del swig_import_helper
else:
    import ___init__
del _swig_python_version_info

try:
    _swig_property = property
except NameError:
    pass  # Python < 2.2 doesn't have 'property'.

try:
    import builtins as __builtin__
except ImportError:
    import __builtin__

def _swig_setattr_nondynamic(self, class_type, name, value, static=1):
    if (name == "thisown"):
        return self.this.own(value)
    if (name == "this"):
        if type(value).__name__ == 'SwigPyObject':
            self.__dict__[name] = value
            return
    method = class_type.__swig_setmethods__.get(name, None)
    if method:
        return method(self, value)
    if (not static):
        if _newclass:
            object.__setattr__(self, name, value)
        else:
            self.__dict__[name] = value
    else:
        raise AttributeError("You cannot add attributes to %s" % self)


def _swig_setattr(self, class_type, name, value):
    return _swig_setattr_nondynamic(self, class_type, name, value, 0)


def _swig_getattr(self, class_type, name):
    if (name == "thisown"):
        return self.this.own()
    method = class_type.__swig_getmethods__.get(name, None)
    if method:
        return method(self)
    raise AttributeError("'%s' object has no attribute '%s'" % (class_type.__name__, name))


def _swig_repr(self):
    try:
        strthis = "proxy of " + self.this.__repr__()
    except __builtin__.Exception:
        strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)

try:
    _object = object
    _newclass = 1
except __builtin__.Exception:
    class _object:
        pass
    _newclass = 0

try:
    import weakref
    weakref_proxy = weakref.proxy
except __builtin__.Exception:
    weakref_proxy = lambda x: x


class SwigPyIterator(_object):
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, SwigPyIterator, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, SwigPyIterator, name)

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = ___init__.delete_SwigPyIterator

    def value(self):
        return ___init__.SwigPyIterator_value(self)

    def incr(self, n=1):
        return ___init__.SwigPyIterator_incr(self, n)

    def decr(self, n=1):
        return ___init__.SwigPyIterator_decr(self, n)

    def distance(self, x):
        return ___init__.SwigPyIterator_distance(self, x)

    def equal(self, x):
        return ___init__.SwigPyIterator_equal(self, x)

    def copy(self):
        return ___init__.SwigPyIterator_copy(self)

    def next(self):
        return ___init__.SwigPyIterator_next(self)

    def __next__(self):
        return ___init__.SwigPyIterator___next__(self)

    def previous(self):
        return ___init__.SwigPyIterator_previous(self)

    def advance(self, n):
        return ___init__.SwigPyIterator_advance(self, n)

    def __eq__(self, x):
        return ___init__.SwigPyIterator___eq__(self, x)

    def __ne__(self, x):
        return ___init__.SwigPyIterator___ne__(self, x)

    def __iadd__(self, n):
        return ___init__.SwigPyIterator___iadd__(self, n)

    def __isub__(self, n):
        return ___init__.SwigPyIterator___isub__(self, n)

    def __add__(self, n):
        return ___init__.SwigPyIterator___add__(self, n)

    def __sub__(self, *args):
        return ___init__.SwigPyIterator___sub__(self, *args)
    def __iter__(self):
        return self
SwigPyIterator_swigregister = ___init__.SwigPyIterator_swigregister
SwigPyIterator_swigregister(SwigPyIterator)

import PyTrilinos.Teuchos
import PyTrilinos.Epetra

def EpetraExt_Version(*args):
    """EpetraExt_Version() -> std::string"""
    return ___init__.EpetraExt_Version(*args)

__version__ = EpetraExt_Version().split()[2]

class XMLReader(_object):
    """Proxy of C++ EpetraExt::XMLReader class."""

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, XMLReader, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, XMLReader, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """__init__(EpetraExt::XMLReader self, Comm Comm, std::string const & FileName) -> XMLReader"""
        this = ___init__.new_XMLReader(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = ___init__.delete_XMLReader

    def ReadMap(self, *args):
        """
        ReadMap(XMLReader self, std::string const & name) -> Map


        Return a Map read from an XML file specified by filename 'name'.

        """
        return ___init__.XMLReader_ReadMap(self, *args)


    def Read64Map(self, *args):
        """Read64Map(XMLReader self, std::string const & name) -> Map"""
        return ___init__.XMLReader_Read64Map(self, *args)


    def ReadMultiVector(self, *args):
        """
        ReadMultiVector(XMLReader self, std::string const & name) -> MultiVector


        Return a MultiVector read from an XML file specified by filename
        'name'.

        """
        return ___init__.XMLReader_ReadMultiVector(self, *args)


    def Read64MultiVector(self, *args):
        """Read64MultiVector(XMLReader self, std::string const & name) -> MultiVector"""
        return ___init__.XMLReader_Read64MultiVector(self, *args)


    def ReadCrsGraph(self, *args):
        """
        ReadCrsGraph(XMLReader self, std::string const & name) -> CrsGraph


        Return a CrsGraph read from an XML file specified by filename 'name'.

        """
        return ___init__.XMLReader_ReadCrsGraph(self, *args)


    def Read64CrsGraph(self, *args):
        """Read64CrsGraph(XMLReader self, std::string const & name) -> CrsGraph"""
        return ___init__.XMLReader_Read64CrsGraph(self, *args)


    def ReadCrsMatrix(self, *args):
        """
        ReadCrsMatrix(XMLReader self, std::string const & name) -> CrsMatrix


        Return a CrsMatrix read from an XML file specified by filename 'name'.

        """
        return ___init__.XMLReader_ReadCrsMatrix(self, *args)


    def Read64CrsMatrix(self, *args):
        """Read64CrsMatrix(XMLReader self, std::string const & name) -> CrsMatrix"""
        return ___init__.XMLReader_Read64CrsMatrix(self, *args)

XMLReader_swigregister = ___init__.XMLReader_swigregister
XMLReader_swigregister(XMLReader)

class XMLWriter(_object):
    """Proxy of C++ EpetraExt::XMLWriter class."""

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, XMLWriter, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, XMLWriter, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """__init__(EpetraExt::XMLWriter self, Comm Comm, std::string const & FileName) -> XMLWriter"""
        this = ___init__.new_XMLWriter(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = ___init__.delete_XMLWriter

    def Create(self, *args):
        """Create(XMLWriter self, std::string const & Label)"""
        return ___init__.XMLWriter_Create(self, *args)


    def Close(self, *args):
        """Close(XMLWriter self)"""
        return ___init__.XMLWriter_Close(self, *args)


    def Write(self, *args):
        """
        Write(XMLWriter self, std::string const & Label, Map Map)
        Write(XMLWriter self, std::string const & Label, RowMatrix Matrix)
        Write(XMLWriter self, std::string const & Label, MultiVector MultiVector)
        Write(XMLWriter self, std::string const & Label, std::vector< std::string,std::allocator< std::string > > const & Content)
        Write(XMLWriter self, std::string const & Label, std::string const & Text)
        Write(XMLWriter self, std::string const & Label, ParameterList List)
        """
        return ___init__.XMLWriter_Write(self, *args)

XMLWriter_swigregister = ___init__.XMLWriter_swigregister
XMLWriter_swigregister(XMLWriter)

class Xform_CrsGraph_MapColoring(_object):
    """Proxy of C++ EpetraExt::Transform<(Epetra_CrsGraph,Epetra_MapColoring)> class."""

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, Xform_CrsGraph_MapColoring, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, Xform_CrsGraph_MapColoring, name)

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = ___init__.delete_Xform_CrsGraph_MapColoring

    def __call__(self, *args):
        """__call__(Xform_CrsGraph_MapColoring self, CrsGraph orig) -> MapColoring"""
        return ___init__.Xform_CrsGraph_MapColoring___call__(self, *args)


    def fwd(self, *args):
        """fwd(Xform_CrsGraph_MapColoring self) -> bool"""
        return ___init__.Xform_CrsGraph_MapColoring_fwd(self, *args)


    def rvs(self, *args):
        """rvs(Xform_CrsGraph_MapColoring self) -> bool"""
        return ___init__.Xform_CrsGraph_MapColoring_rvs(self, *args)


    def analyze(self, *args):
        """analyze(Xform_CrsGraph_MapColoring self, CrsGraph orig) -> bool"""
        return ___init__.Xform_CrsGraph_MapColoring_analyze(self, *args)


    def construct(self, *args):
        """construct(Xform_CrsGraph_MapColoring self) -> MapColoring"""
        return ___init__.Xform_CrsGraph_MapColoring_construct(self, *args)


    def isConstructed(self, *args):
        """isConstructed(Xform_CrsGraph_MapColoring self) -> bool"""
        return ___init__.Xform_CrsGraph_MapColoring_isConstructed(self, *args)

Xform_CrsGraph_MapColoring_swigregister = ___init__.Xform_CrsGraph_MapColoring_swigregister
Xform_CrsGraph_MapColoring_swigregister(Xform_CrsGraph_MapColoring)

class Xform_CrsGraph_vecIntVector(_object):
    """Proxy of C++ EpetraExt::Transform<(Epetra_CrsGraph,std::vector<(Epetra_GIDTypeVector<(int)>::impl,std::allocator<(Epetra_GIDTypeVector<(int)>::impl)>)>)> class."""

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, Xform_CrsGraph_vecIntVector, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, Xform_CrsGraph_vecIntVector, name)

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = ___init__.delete_Xform_CrsGraph_vecIntVector

    def __call__(self, *args):
        """__call__(Xform_CrsGraph_vecIntVector self, CrsGraph orig) -> EpetraExt::Transform< Epetra_CrsGraph,std::vector< Epetra_GIDTypeVector< int >::impl,std::allocator< Epetra_GIDTypeVector< int >::impl > > >::NewTypeRef"""
        return ___init__.Xform_CrsGraph_vecIntVector___call__(self, *args)


    def fwd(self, *args):
        """fwd(Xform_CrsGraph_vecIntVector self) -> bool"""
        return ___init__.Xform_CrsGraph_vecIntVector_fwd(self, *args)


    def rvs(self, *args):
        """rvs(Xform_CrsGraph_vecIntVector self) -> bool"""
        return ___init__.Xform_CrsGraph_vecIntVector_rvs(self, *args)


    def analyze(self, *args):
        """analyze(Xform_CrsGraph_vecIntVector self, CrsGraph orig) -> bool"""
        return ___init__.Xform_CrsGraph_vecIntVector_analyze(self, *args)


    def construct(self, *args):
        """construct(Xform_CrsGraph_vecIntVector self) -> EpetraExt::Transform< Epetra_CrsGraph,std::vector< Epetra_GIDTypeVector< int >::impl,std::allocator< Epetra_GIDTypeVector< int >::impl > > >::NewTypeRef"""
        return ___init__.Xform_CrsGraph_vecIntVector_construct(self, *args)


    def isConstructed(self, *args):
        """isConstructed(Xform_CrsGraph_vecIntVector self) -> bool"""
        return ___init__.Xform_CrsGraph_vecIntVector_isConstructed(self, *args)

Xform_CrsGraph_vecIntVector_swigregister = ___init__.Xform_CrsGraph_vecIntVector_swigregister
Xform_CrsGraph_vecIntVector_swigregister(Xform_CrsGraph_vecIntVector)

class Xform_CrsGraph_vecLongVector(_object):
    """Proxy of C++ EpetraExt::Transform<(Epetra_CrsGraph,std::vector<(Epetra_GIDTypeVector<(long long)>::impl,std::allocator<(Epetra_GIDTypeVector<(long long)>::impl)>)>)> class."""

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, Xform_CrsGraph_vecLongVector, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, Xform_CrsGraph_vecLongVector, name)

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = ___init__.delete_Xform_CrsGraph_vecLongVector

    def __call__(self, *args):
        """__call__(Xform_CrsGraph_vecLongVector self, CrsGraph orig) -> EpetraExt::Transform< Epetra_CrsGraph,std::vector< Epetra_GIDTypeVector< long long >::impl,std::allocator< Epetra_GIDTypeVector< long long >::impl > > >::NewTypeRef"""
        return ___init__.Xform_CrsGraph_vecLongVector___call__(self, *args)


    def fwd(self, *args):
        """fwd(Xform_CrsGraph_vecLongVector self) -> bool"""
        return ___init__.Xform_CrsGraph_vecLongVector_fwd(self, *args)


    def rvs(self, *args):
        """rvs(Xform_CrsGraph_vecLongVector self) -> bool"""
        return ___init__.Xform_CrsGraph_vecLongVector_rvs(self, *args)


    def analyze(self, *args):
        """analyze(Xform_CrsGraph_vecLongVector self, CrsGraph orig) -> bool"""
        return ___init__.Xform_CrsGraph_vecLongVector_analyze(self, *args)


    def construct(self, *args):
        """construct(Xform_CrsGraph_vecLongVector self) -> EpetraExt::Transform< Epetra_CrsGraph,std::vector< Epetra_GIDTypeVector< long long >::impl,std::allocator< Epetra_GIDTypeVector< long long >::impl > > >::NewTypeRef"""
        return ___init__.Xform_CrsGraph_vecLongVector_construct(self, *args)


    def isConstructed(self, *args):
        """isConstructed(Xform_CrsGraph_vecLongVector self) -> bool"""
        return ___init__.Xform_CrsGraph_vecLongVector_isConstructed(self, *args)

Xform_CrsGraph_vecLongVector_swigregister = ___init__.Xform_CrsGraph_vecLongVector_swigregister
Xform_CrsGraph_vecLongVector_swigregister(Xform_CrsGraph_vecLongVector)

class Xform_CrsMatrix_CrsMatrix(_object):
    """Proxy of C++ EpetraExt::Transform<(Epetra_CrsMatrix,Epetra_CrsMatrix)> class."""

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, Xform_CrsMatrix_CrsMatrix, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, Xform_CrsMatrix_CrsMatrix, name)

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = ___init__.delete_Xform_CrsMatrix_CrsMatrix

    def __call__(self, *args):
        """__call__(Xform_CrsMatrix_CrsMatrix self, CrsMatrix orig) -> CrsMatrix"""
        return ___init__.Xform_CrsMatrix_CrsMatrix___call__(self, *args)


    def fwd(self, *args):
        """fwd(Xform_CrsMatrix_CrsMatrix self) -> bool"""
        return ___init__.Xform_CrsMatrix_CrsMatrix_fwd(self, *args)


    def rvs(self, *args):
        """rvs(Xform_CrsMatrix_CrsMatrix self) -> bool"""
        return ___init__.Xform_CrsMatrix_CrsMatrix_rvs(self, *args)


    def analyze(self, *args):
        """analyze(Xform_CrsMatrix_CrsMatrix self, CrsMatrix orig) -> bool"""
        return ___init__.Xform_CrsMatrix_CrsMatrix_analyze(self, *args)


    def construct(self, *args):
        """construct(Xform_CrsMatrix_CrsMatrix self) -> CrsMatrix"""
        return ___init__.Xform_CrsMatrix_CrsMatrix_construct(self, *args)


    def isConstructed(self, *args):
        """isConstructed(Xform_CrsMatrix_CrsMatrix self) -> bool"""
        return ___init__.Xform_CrsMatrix_CrsMatrix_isConstructed(self, *args)

Xform_CrsMatrix_CrsMatrix_swigregister = ___init__.Xform_CrsMatrix_CrsMatrix_swigregister
Xform_CrsMatrix_CrsMatrix_swigregister(Xform_CrsMatrix_CrsMatrix)

class SXform_CrsGraph_MapColoring(Xform_CrsGraph_MapColoring):
    """Proxy of C++ EpetraExt::StructuralTransform<(Epetra_CrsGraph,Epetra_MapColoring)> class."""

    __swig_setmethods__ = {}
    for _s in [Xform_CrsGraph_MapColoring]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, SXform_CrsGraph_MapColoring, name, value)
    __swig_getmethods__ = {}
    for _s in [Xform_CrsGraph_MapColoring]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, SXform_CrsGraph_MapColoring, name)

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr

    def fwd(self, *args):
        """fwd(SXform_CrsGraph_MapColoring self) -> bool"""
        return ___init__.SXform_CrsGraph_MapColoring_fwd(self, *args)


    def rvs(self, *args):
        """rvs(SXform_CrsGraph_MapColoring self) -> bool"""
        return ___init__.SXform_CrsGraph_MapColoring_rvs(self, *args)

    __swig_destroy__ = ___init__.delete_SXform_CrsGraph_MapColoring
SXform_CrsGraph_MapColoring_swigregister = ___init__.SXform_CrsGraph_MapColoring_swigregister
SXform_CrsGraph_MapColoring_swigregister(SXform_CrsGraph_MapColoring)

class SXform_CrsGraph_vecIntVector(Xform_CrsGraph_vecIntVector):
    """Proxy of C++ EpetraExt::StructuralTransform<(Epetra_CrsGraph,std::vector<(Epetra_GIDTypeVector<(int)>::impl)>)> class."""

    __swig_setmethods__ = {}
    for _s in [Xform_CrsGraph_vecIntVector]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, SXform_CrsGraph_vecIntVector, name, value)
    __swig_getmethods__ = {}
    for _s in [Xform_CrsGraph_vecIntVector]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, SXform_CrsGraph_vecIntVector, name)

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr

    def fwd(self, *args):
        """fwd(SXform_CrsGraph_vecIntVector self) -> bool"""
        return ___init__.SXform_CrsGraph_vecIntVector_fwd(self, *args)


    def rvs(self, *args):
        """rvs(SXform_CrsGraph_vecIntVector self) -> bool"""
        return ___init__.SXform_CrsGraph_vecIntVector_rvs(self, *args)

    __swig_destroy__ = ___init__.delete_SXform_CrsGraph_vecIntVector
SXform_CrsGraph_vecIntVector_swigregister = ___init__.SXform_CrsGraph_vecIntVector_swigregister
SXform_CrsGraph_vecIntVector_swigregister(SXform_CrsGraph_vecIntVector)

class SXform_CrsGraph_vecLongVector(Xform_CrsGraph_vecLongVector):
    """Proxy of C++ EpetraExt::StructuralTransform<(Epetra_CrsGraph,std::vector<(Epetra_GIDTypeVector<(long long)>::impl)>)> class."""

    __swig_setmethods__ = {}
    for _s in [Xform_CrsGraph_vecLongVector]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, SXform_CrsGraph_vecLongVector, name, value)
    __swig_getmethods__ = {}
    for _s in [Xform_CrsGraph_vecLongVector]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, SXform_CrsGraph_vecLongVector, name)

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr

    def fwd(self, *args):
        """fwd(SXform_CrsGraph_vecLongVector self) -> bool"""
        return ___init__.SXform_CrsGraph_vecLongVector_fwd(self, *args)


    def rvs(self, *args):
        """rvs(SXform_CrsGraph_vecLongVector self) -> bool"""
        return ___init__.SXform_CrsGraph_vecLongVector_rvs(self, *args)

    __swig_destroy__ = ___init__.delete_SXform_CrsGraph_vecLongVector
SXform_CrsGraph_vecLongVector_swigregister = ___init__.SXform_CrsGraph_vecLongVector_swigregister
SXform_CrsGraph_vecLongVector_swigregister(SXform_CrsGraph_vecLongVector)

class SameXform_CrsMatrix(Xform_CrsMatrix_CrsMatrix):
    """Proxy of C++ EpetraExt::SameTypeTransform<(Epetra_CrsMatrix)> class."""

    __swig_setmethods__ = {}
    for _s in [Xform_CrsMatrix_CrsMatrix]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, SameXform_CrsMatrix, name, value)
    __swig_getmethods__ = {}
    for _s in [Xform_CrsMatrix_CrsMatrix]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, SameXform_CrsMatrix, name)

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = ___init__.delete_SameXform_CrsMatrix
SameXform_CrsMatrix_swigregister = ___init__.SameXform_CrsMatrix_swigregister
SameXform_CrsMatrix_swigregister(SameXform_CrsMatrix)

class CrsGraph_MapColoring(SXform_CrsGraph_MapColoring):
    """Proxy of C++ EpetraExt::CrsGraph_MapColoring class."""

    __swig_setmethods__ = {}
    for _s in [SXform_CrsGraph_MapColoring]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, CrsGraph_MapColoring, name, value)
    __swig_getmethods__ = {}
    for _s in [SXform_CrsGraph_MapColoring]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, CrsGraph_MapColoring, name)
    __repr__ = _swig_repr
    GREEDY = ___init__.CrsGraph_MapColoring_GREEDY
    LUBY = ___init__.CrsGraph_MapColoring_LUBY
    JONES_PLASSMAN = ___init__.CrsGraph_MapColoring_JONES_PLASSMAN
    PSEUDO_PARALLEL = ___init__.CrsGraph_MapColoring_PSEUDO_PARALLEL
    __swig_destroy__ = ___init__.delete_CrsGraph_MapColoring

    def __init__(self, *args):
        """__init__(EpetraExt::CrsGraph_MapColoring self, EpetraExt::CrsGraph_MapColoring::ColoringAlgorithm algo, int reordering=0, bool distance1=False, int verbosity=0) -> CrsGraph_MapColoring"""
        this = ___init__.new_CrsGraph_MapColoring(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

    def __call__(self, *args):
        """__call__(CrsGraph_MapColoring self, CrsGraph orig) -> MapColoring"""
        return ___init__.CrsGraph_MapColoring___call__(self, *args)

CrsGraph_MapColoring_swigregister = ___init__.CrsGraph_MapColoring_swigregister
CrsGraph_MapColoring_swigregister(CrsGraph_MapColoring)

class TCrsGraph_MapColoringIndex_int(SXform_CrsGraph_vecIntVector):
    """Proxy of C++ EpetraExt::TCrsGraph_MapColoringIndex<(int)> class."""

    __swig_setmethods__ = {}
    for _s in [SXform_CrsGraph_vecIntVector]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, TCrsGraph_MapColoringIndex_int, name, value)
    __swig_getmethods__ = {}
    for _s in [SXform_CrsGraph_vecIntVector]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, TCrsGraph_MapColoringIndex_int, name)

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr
TCrsGraph_MapColoringIndex_int_swigregister = ___init__.TCrsGraph_MapColoringIndex_int_swigregister
TCrsGraph_MapColoringIndex_int_swigregister(TCrsGraph_MapColoringIndex_int)

class TCrsGraph_MapColoringIndex_long(SXform_CrsGraph_vecLongVector):
    """Proxy of C++ EpetraExt::TCrsGraph_MapColoringIndex<(long long)> class."""

    __swig_setmethods__ = {}
    for _s in [SXform_CrsGraph_vecLongVector]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, TCrsGraph_MapColoringIndex_long, name, value)
    __swig_getmethods__ = {}
    for _s in [SXform_CrsGraph_vecLongVector]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, TCrsGraph_MapColoringIndex_long, name)

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr
TCrsGraph_MapColoringIndex_long_swigregister = ___init__.TCrsGraph_MapColoringIndex_long_swigregister
TCrsGraph_MapColoringIndex_long_swigregister(TCrsGraph_MapColoringIndex_long)

class CrsGraph_MapColoringIndex(TCrsGraph_MapColoringIndex_int):
    """Proxy of C++ EpetraExt::CrsGraph_MapColoringIndex class."""

    __swig_setmethods__ = {}
    for _s in [TCrsGraph_MapColoringIndex_int]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, CrsGraph_MapColoringIndex, name, value)
    __swig_getmethods__ = {}
    for _s in [TCrsGraph_MapColoringIndex_int]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, CrsGraph_MapColoringIndex, name)
    __repr__ = _swig_repr
    __swig_destroy__ = ___init__.delete_CrsGraph_MapColoringIndex

    def __init__(self, *args):
        """__init__(EpetraExt::CrsGraph_MapColoringIndex self, MapColoring ColorMap) -> CrsGraph_MapColoringIndex"""
        this = ___init__.new_CrsGraph_MapColoringIndex(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

    def __call__(self, *args):
        """__call__(CrsGraph_MapColoringIndex self, CrsGraph orig) -> std::vector< Epetra_IntVector,std::allocator< Epetra_IntVector > > &"""
        return ___init__.CrsGraph_MapColoringIndex___call__(self, *args)

CrsGraph_MapColoringIndex_swigregister = ___init__.CrsGraph_MapColoringIndex_swigregister
CrsGraph_MapColoringIndex_swigregister(CrsGraph_MapColoringIndex)

class CrsGraph_MapColoringIndex64(TCrsGraph_MapColoringIndex_long):
    """Proxy of C++ EpetraExt::CrsGraph_MapColoringIndex64 class."""

    __swig_setmethods__ = {}
    for _s in [TCrsGraph_MapColoringIndex_long]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, CrsGraph_MapColoringIndex64, name, value)
    __swig_getmethods__ = {}
    for _s in [TCrsGraph_MapColoringIndex_long]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, CrsGraph_MapColoringIndex64, name)
    __repr__ = _swig_repr
    __swig_destroy__ = ___init__.delete_CrsGraph_MapColoringIndex64

    def __init__(self, *args):
        """__init__(EpetraExt::CrsGraph_MapColoringIndex64 self, MapColoring ColorMap) -> CrsGraph_MapColoringIndex64"""
        this = ___init__.new_CrsGraph_MapColoringIndex64(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

    def __call__(self, *args):
        """__call__(CrsGraph_MapColoringIndex64 self, CrsGraph orig) -> std::vector< Epetra_LongLongVector,std::allocator< Epetra_LongLongVector > > &"""
        return ___init__.CrsGraph_MapColoringIndex64___call__(self, *args)

CrsGraph_MapColoringIndex64_swigregister = ___init__.CrsGraph_MapColoringIndex64_swigregister
CrsGraph_MapColoringIndex64_swigregister(CrsGraph_MapColoringIndex64)


def MatrixMarketFileToMultiVector(*args):
    """
    MatrixMarketFileToMultiVector(str filename, Epetra.BlockMap) ->
        Epetra.MultiVector

    Return a MultiVector read from a matix market file.
    """
    return ___init__.MatrixMarketFileToMultiVector(*args)

def MultiVectorToMatrixMarketFile(*args):
    """MultiVectorToMatrixMarketFile(char const * filename, MultiVector A, char const * matrixName=None, char const * matrixDescription=None, bool writeHeader=True) -> int"""
    return ___init__.MultiVectorToMatrixMarketFile(*args)

def MultiVectorToMatlabFile(*args):
    """MultiVectorToMatlabFile(char const * filename, MultiVector A) -> int"""
    return ___init__.MultiVectorToMatlabFile(*args)

def MultiVectorToMatrixMarketHandle(*args):
    """MultiVectorToMatrixMarketHandle(std::FILE * handle, MultiVector A) -> int"""
    return ___init__.MultiVectorToMatrixMarketHandle(*args)

def MultiVectorToMatlabHandle(*args):
    """MultiVectorToMatlabHandle(std::FILE * handle, MultiVector A) -> int"""
    return ___init__.MultiVectorToMatlabHandle(*args)

def MultiVectorToHandle(*args):
    """MultiVectorToHandle(std::FILE * handle, MultiVector A, bool mmFormat) -> int"""
    return ___init__.MultiVectorToHandle(*args)

def writeMultiVector(*args):
    """writeMultiVector(std::FILE * handle, MultiVector A, bool mmFormat) -> int"""
    return ___init__.writeMultiVector(*args)

def MatlabFileToCrsMatrix(*args):
    """
    MatlabFileToCrsMatrix(str filename, Epetra.Comm) -> Epetra.CrsMatrix

    Return a CrsMatrix read from a matlab file.
    """
    return ___init__.MatlabFileToCrsMatrix(*args)

def MatrixMarketFileToCrsMatrix(*args):
    """
    MatrixMarketFileToCrsMatrix(str filename, Epetra.Map rowMap, Epetra.Map
        colMap=None, Epetra.Map rangeMap=None, Epetra.Map domainMap=None) ->
        Epetra.CrsMatrix

    Return a CrsMatrix read from a matrix market file.
    MatrixMarketFileToCrsMatrix(str filename, Epetra.Map rowMap, Epetra.Map
        colMap=None, Epetra.Map rangeMap=None, Epetra.Map domainMap=None) ->
        Epetra.CrsMatrix

    Return a CrsMatrix read from a matrix market file.
    MatrixMarketFileToCrsMatrix(str filename, Epetra.Map rowMap, Epetra.Map
        colMap=None, Epetra.Map rangeMap=None, Epetra.Map domainMap=None) ->
        Epetra.CrsMatrix

    Return a CrsMatrix read from a matrix market file.
    MatrixMarketFileToCrsMatrix(str filename, Epetra.Map rowMap, Epetra.Map
        colMap=None, Epetra.Map rangeMap=None, Epetra.Map domainMap=None) ->
        Epetra.CrsMatrix

    Return a CrsMatrix read from a matrix market file.
    MatrixMarketFileToCrsMatrix(str filename, Epetra.Map rowMap, Epetra.Map
        colMap=None, Epetra.Map rangeMap=None, Epetra.Map domainMap=None) ->
        Epetra.CrsMatrix

    Return a CrsMatrix read from a matrix market file.
    """
    return ___init__.MatrixMarketFileToCrsMatrix(*args)

def HypreFileToCrsMatrix(*args):
    """HypreFileToCrsMatrix(char const * filename, Comm comm) -> int"""
    return ___init__.HypreFileToCrsMatrix(*args)

def MatrixMarketFileToCrsMatrixHandle(*args):
    """MatrixMarketFileToCrsMatrixHandle(char const * filename, Comm comm, Map rowMap=None, Map colMap=None, Map rangeMap=None, Map domainMap=None, bool const transpose=0, bool const verbose=0) -> int"""
    return ___init__.MatrixMarketFileToCrsMatrixHandle(*args)

def MatlabFileToCrsMatrix64(*args):
    """MatlabFileToCrsMatrix64(char const * filename, Comm comm) -> int"""
    return ___init__.MatlabFileToCrsMatrix64(*args)

def MatrixMarketFileToCrsMatrix64(*args):
    """
    MatrixMarketFileToCrsMatrix64(char const * filename, Comm comm, bool const transpose=0, bool const verbose=0) -> int
    MatrixMarketFileToCrsMatrix64(char const * filename, Map rowMap, Map rangeMap, Map domainMap, bool const transpose=0, bool const verbose=0) -> int
    MatrixMarketFileToCrsMatrix64(char const * filename, Map rowMap, bool const transpose=0, bool const verbose=0) -> int
    MatrixMarketFileToCrsMatrix64(char const * filename, Map rowMap, Map colMap, bool const transpose=0, bool const verbose=0) -> int
    MatrixMarketFileToCrsMatrix64(char const * filename, Map rowMap, Map colMap, Map rangeMap, Map domainMap, bool const transpose=0, bool const verbose=0) -> int
    """
    return ___init__.MatrixMarketFileToCrsMatrix64(*args)

def HypreFileToCrsMatrix64(*args):
    """HypreFileToCrsMatrix64(char const * filename, Comm comm) -> int"""
    return ___init__.HypreFileToCrsMatrix64(*args)

def MatrixMarketFileToCrsMatrixHandle64(*args):
    """MatrixMarketFileToCrsMatrixHandle64(char const * filename, Comm comm, Map rowMap=None, Map colMap=None, Map rangeMap=None, Map domainMap=None, bool const transpose=0, bool const verbose=0) -> int"""
    return ___init__.MatrixMarketFileToCrsMatrixHandle64(*args)

def RowMatrixToMatrixMarketFile(*args):
    """RowMatrixToMatrixMarketFile(char const * filename, RowMatrix A, char const * matrixName=None, char const * matrixDescription=None, bool writeHeader=True) -> int"""
    return ___init__.RowMatrixToMatrixMarketFile(*args)

def RowMatrixToMatlabFile(*args):
    """RowMatrixToMatlabFile(char const * filename, RowMatrix A) -> int"""
    return ___init__.RowMatrixToMatlabFile(*args)

def RowMatrixToHandle(*args):
    """RowMatrixToHandle(std::FILE * handle, RowMatrix A) -> int"""
    return ___init__.RowMatrixToHandle(*args)

def writeRowMatrix(*args):
    """writeRowMatrix(std::FILE * handle, RowMatrix A) -> int"""
    return ___init__.writeRowMatrix(*args)

def MatrixMarketFileToBlockMap(*args):
    """
    MatrixMarketFileToBlockMap(str filename, Epetra.Comm) -> Epetra.BlockMap

    Return a BlockMap read from a matrix market file.
    """
    return ___init__.MatrixMarketFileToBlockMap(*args)

def MatrixMarketFileToBlockMap64(*args):
    """MatrixMarketFileToBlockMap64(char const * filename, Comm comm) -> int"""
    return ___init__.MatrixMarketFileToBlockMap64(*args)

def MatrixMarketFileToMap(*args):
    """
    MatrixMarketFileToMap(str filename, Epetra.Comm) -> Epetra.Map

    Return a Map read from a matrix market file.
    """
    return ___init__.MatrixMarketFileToMap(*args)

def MatrixMarketFileToMap64(*args):
    """MatrixMarketFileToMap64(char const * filename, Comm comm) -> int"""
    return ___init__.MatrixMarketFileToMap64(*args)

def MatrixMarketFileToBlockMaps(*args):
    """
    MatrixMarketFileToBlockMaps(str filename, Epetra.Comm) ->
        (Epetra.BlockMap rowMap, Epetra.BlockMap colMap, Epetra.BlockMap rangeMap,
         Epetra.BlockMap domainMap)

    Return a tuple of BlockMaps read from a matrix market file.  The
    BlockMaps, listed in order, are the row map, the column map, the range
    map and the domain map.
    """
    return ___init__.MatrixMarketFileToBlockMaps(*args)

def MatrixMarketFileToBlockMaps64(*args):
    """MatrixMarketFileToBlockMaps64(char const * filename, Comm comm) -> int"""
    return ___init__.MatrixMarketFileToBlockMaps64(*args)

def BlockMapToMatrixMarketFile(*args):
    """BlockMapToMatrixMarketFile(char const * filename, BlockMap blockMap, char const * mapName=None, char const * mapDescription=None, bool writeHeader=True) -> int"""
    return ___init__.BlockMapToMatrixMarketFile(*args)

def BlockMapToHandle(*args):
    """BlockMapToHandle(std::FILE * handle, BlockMap blockMap) -> int"""
    return ___init__.BlockMapToHandle(*args)

def writeBlockMap(*args):
    """
    writeBlockMap(std::FILE * handle, long long length, int const * v1, int const * v2, bool doSizes) -> int
    writeBlockMap(std::FILE * handle, long long length, long long const * v1, int const * v2, bool doSizes) -> int
    """
    return ___init__.writeBlockMap(*args)
class CrsMatrix_SubCopy(SameXform_CrsMatrix):
    """Proxy of C++ EpetraExt::CrsMatrix_SubCopy class."""

    __swig_setmethods__ = {}
    for _s in [SameXform_CrsMatrix]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, CrsMatrix_SubCopy, name, value)
    __swig_getmethods__ = {}
    for _s in [SameXform_CrsMatrix]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, CrsMatrix_SubCopy, name)
    __repr__ = _swig_repr
    __swig_destroy__ = ___init__.delete_CrsMatrix_SubCopy

    def __init__(self, *args):
        """
        __init__(EpetraExt::CrsMatrix_SubCopy self, Map newMap) -> CrsMatrix_SubCopy
        __init__(EpetraExt::CrsMatrix_SubCopy self, Map newRangeAndRowMap, Map newDomainMap) -> CrsMatrix_SubCopy
        """
        this = ___init__.new_CrsMatrix_SubCopy(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

    def __call__(self, *args):
        """__call__(CrsMatrix_SubCopy self, CrsMatrix orig) -> CrsMatrix"""
        return ___init__.CrsMatrix_SubCopy___call__(self, *args)


    def fwd(self, *args):
        """fwd(CrsMatrix_SubCopy self) -> bool"""
        return ___init__.CrsMatrix_SubCopy_fwd(self, *args)


    def rvs(self, *args):
        """rvs(CrsMatrix_SubCopy self) -> bool"""
        return ___init__.CrsMatrix_SubCopy_rvs(self, *args)

CrsMatrix_SubCopy_swigregister = ___init__.CrsMatrix_SubCopy_swigregister
CrsMatrix_SubCopy_swigregister(CrsMatrix_SubCopy)


def Multiply(*args):
    """
    Multiply(Epetra.CrsMatrix A, bool transposeA, Epetra.CrsMatrix B, bool
        transposeB, Epetra.CrsMatrix C) -> int

    Compute C <- A * B, where transposeA and transposeB control the
    transposition of A and B respectively.  C must have the structure of A
    * B, or not yet have FillComplete() called on it.
    """
    return ___init__.Multiply(*args)

from PyTrilinos import Epetra
from PyTrilinos import PropertyBase
from PyTrilinos import typed_tuple
from PyTrilinos import tuple_of_int
from PyTrilinos import tuple_of_str
tuple_of_Vector = typed_tuple(Epetra.Vector)



class InArgs(PropertyBase):
    """
    InArgs proxy class.

    This is a 'Property' class restricted to specific attributes that are
    type-checked. These properties are:

    description  - string description of associated ModelEvaluation
    x            - bool or Epetra.Vector: solution vector support.  If True, the
                   solver should allocate the vector.  If False, x is not
                   supported.  If a vector, the solver should use the
                   user-provided data.  (default False)
    x_dot        - bool or Epetra.Vector: time derivative of solution vector
                   support.  If True, the solver should allocate the vector.  If
                   False, x_dot is not supported.  If a vector, the solver
                   should use the user- provided data.  (default False)
    p            - int or tuple_of_Vector: VARIABLE P support.  If an int, the
                   solver should allocate an array of the given number of
                   vectors.  If 0, p is not supported.  If a tuple_of_Vector,
                   the solver should use the user-provided data.  (default 0)
    t            - float: time (default None)
    alpha        - float: VARIABLE ALPHA (default None)
    beta         - float: VARIABLE BETA (default None)
    """
    props = {'description' : str,
             'x'           : (bool, Epetra.Vector),
#'x_poly'      : Teuchos.Polynomial,
             'x_dot'       : (bool, Epetra.Vector),
#'x_dot_poly'  : Teuchos.Polynomial,
             'p'           : (int, tuple_of_Vector),
             't'           : float,
             'alpha'       : float,
             'beta'        : float
             }
    defaults = {'description' : 'WARNING!  THIS INARGS OBJECT IS UNINITALIZED!',
                'x'           : False,
                'x_dot'       : False,
                'p'           : 0
                }
    def __init__(self, **kwargs):
        PropertyBase.__init__(self, **kwargs)



class Evaluation(PropertyBase):
    """
    Evaluation< RCP<Epetra_Vector> > proxy class

    This is a 'Property' class restricted to specific attributes that are
    type-checked. These properties are:

    vector  - Epetra.Vector: (default None)
    type    - str: an enumeration limited to 'exact', 'approx_deriv', and
              'very_approx_deriv' (default None)
    """
    props = {'vector' : Epetra.Vector,
             'type'   : ('exact', 'approx_deriv', 'very_approx_deriv')
             }
    def __init__(self, **kwargs):
        PropertyBase.__init__(self, **kwargs)

tuple_of_Evaluation = typed_tuple(Evaluation)



class DerivativeSupport(PropertyBase):
    """
    DerivativeSupport proxy class

    This is a 'Property' class restricted to specific attributes that are
    type-checked. These properties are:

    linearOp      - bool: True indicates that derivative is a linear operator
                    (default False)
    mVByCol       - bool: True indicates that derivative is a MultiVector stored
                    by column (defualt False)
    transMVByRow  - bool: True indicates that derivative is a transpose
                    MultiVector stored by row (default False)
    """
    props = {'linearOp'     : bool,
             'mVByCol'      : bool,
             'transMVByRow' : bool
             }
    defaults = {'linearOp'     : False,
                'mVByCol'      : False,
                'transMVByRow' : False
                }
    def __init__(self, **kwargs):
        PropertyBase.__init__(self, **kwargs)
    def none(self):
        noTrue = [True] * len(self.props)
        return (props.values() == noTrue)

tuple_of_DerivativeSupport = typed_tuple(DerivativeSupport)



class DerivativeProperties(PropertyBase):
    """
    DerivativeProperties proxy class

    This is a 'Property' class restricted to specific attributes that are
    type-checked. These properties are:

    linearity        - str: an enumeration limited to 'unknown', 'const' and
                       'nonconst' (default 'unknown')
    rank             - str: an enumeration limited to 'unknown', 'full' and
                       'deficient' (default 'unknown')
    supportsAdjoint  - bool: True indicates that the adjoint is supported
                       (default False)
    """
    props = {'linearity'       : ('unknown', 'const', 'nonconst'),
             'rank'            : ('unknown', 'full', 'deficient'),
             'supportsAdjoint' : bool}
    defaults = {'linearity'       : 'unknown',
                'rank'            : 'unknown',
                'supportsAdjoint' : False}
    def __init__(self, **kwargs):
        PropertyBase.__init__(self, **kwargs)

tuple_of_DerivativeProperties = typed_tuple(DerivativeProperties)



class DerivativeMultiVector(PropertyBase):
    """
    DerivativeMultiVector proxy class

    This is a 'Property' class restricted to specific attributes that are
    type-checked. These properties are:

    multiVector   - Epetra.MultiVector: (default None)
    orientation   - str: an enumeration limited to 'mv_by_col', and
                    'trans_mv_by_row' (default None)
    paramIndexes  - tuple_of_int: (default None)
    """
    props = {'multiVector'  : Epetra.MultiVector,
             'orientation'  : ('mv_by_col', 'trans_mv_by_row'),
             'paramIndexes' : tuple_of_int
             }
    def __init__(self, **kwargs):
        PropertyBase.__init__(self, **kwargs)



class Derivative(PropertyBase):
    """
    Derivative proxy class

    This is a 'Property' class restricted to specific attributes that are
    type-checked. These properties are:

    operator               - Epetra.Operator (default None)
    derivativeMultiVector  - DerivativeMultiVector (default None)

    Only one or the other of these two attributes should be set, to indicate the
    nature of the derivitive evaluation.
    """
    props = {'operator'              : Epetra.Operator,
             'derivativeMultiVector' : DerivativeMultiVector
             }
    def __init__(self, **kwargs):
        PropertyBase.__init__(self, **kwargs)
    def isEmpty(self):
        return (self.operator is None) and (self.derivativeMultiVector is None)

tuple_of_Derivative = typed_tuple(Derivative)



class OutArgs(PropertyBase):
    """
    OutArgs proxy class

    This is a 'Property' class restricted to specific attributes that are
    type-checked. These properties are:

    description          - string description of associated ModelEvaluation
    g                    - (int, tuple_of_Evaluation): VARIABLE G support.  If
                           an int, the solver should allocate an array of the
                           given number of Evaluations.  If 0, g is not
                           supported.  If a tuple_of_Evaluation, the solver
                           should use the user-provided data.  (default 0)
    f                    - (bool, Evaluation): VARIABLE F support.  If True, the
                           solver should allocate the Evaluation.  If False, f
                           is not supported.  If an Evaluation, the solver
                           should use the user-supplied data.  (default False)
    W                    - (bool, Epetra.Operator): VARIABLE W support.  If True, the
                           solver should allocate the operator.  If False, W
                           is not supported.  If an operator, the solver
                           should use the user-supplied data.  (default False)
    W_properties         - DerivativeProperties: derivative properties for
                           VARIABLE W.  (default None)
    DfDp                 - (int, tuple_of_Derivative): VARIABLE DFDP support.  If
                           an int, the solver should allocate an array of the
                           given number of Derivatives.  If 0, DfDp is not
                           supported.  If a tuple_of_Derivative, the solver
                           should use the user-provided data.  (default 0)
    DfDp_properties      - tuple_of_DerivativeProperties: derivative properties
                           for VARIABLE DFDP.  (default None)
    DgDx                 - (int, tuple_of_Derivative): VARIABLE DGDX support.  If
                           an int, the solver should allocate an array of the
                           given number of Derivatives.  If 0, DgDx is not
                           supported.  If a tuple_of_Derivative, the solver
                           should use the user-provided data.  (default 0)
    DgDx_properties      - tuple_of_DerivativeProperties: derivative properties
                           for VARIABLE DGDX.  (default None)
    DgDx_dot             - (int, tuple_of_Derivative): VARIABLE DGDX_DOT support.
                           If an int, the solver should allocate an array of the
                           given number of Derivatives.  If 0, DgDx_dot is not
                           supported.  If a tuple_of_Derivative, the solver
                           should use the user-provided data.  (default 0)
    DgDx_dot_properties  - tuple_of_DerivativeProperties: derivative properties
                           for VARIABLE DGDX_DOT.  (default None)
    DgDp                 - (int, tuple_of_Derivative): VARIABLE DGDP support.  If
                           an int, the solver should allocate an array of the
                           given number of Derivatives.  If 0, DgDp is not
                           supported.  If a tuple_of_Derivative, the solver
                           should use the user-provided data.  (default 0)
    DgDp_properties      - tuple_of_DerivativeProperties: derivative properties
                           for VARIABLE DGDP.  (default None)
    """
    props = {'description'         : str,
             'g'                   : (int, tuple_of_Evaluation),
             'f'                   : (bool, Evaluation),
             'W'                   : (bool, Epetra.Operator),
             'W_properties'        : DerivativeProperties,
#'f_poly'              : Teuchos.Polynomial,
             'DfDp'                : (int, tuple_of_Derivative),
             'DfDp_properties'     : tuple_of_DerivativeProperties,
             'DgDx'                : (int, tuple_of_Derivative),
             'DgDx_properties'     : tuple_of_DerivativeProperties,
             'DgDx_dot'            : (int, tuple_of_Derivative),
             'DgDx_dot_properties' : tuple_of_DerivativeProperties,
             'DgDp'                : (int, tuple_of_Derivative),
             'DgDp_properties'     : tuple_of_DerivativeProperties
             }
    defaults = {'description' : 'WARNING!  THIS OUTARGS OBJECT IS UNINITALIZED!',
                'g'           : 0,
                'f'           : False,
                'W'           : False,
                'DfDp'        : 0,
                'DgDx'        : 0,
                'DgDx_dot'    : 0,
                'DgDp'        : 0
                }
    def __init__(self, **kwargs):
        PropertyBase.__init__(self, **kwargs)


class ModelEvaluator(PyTrilinos.Teuchos.Describable):
    """Proxy of C++ EpetraExt::ModelEvaluator class."""

    __swig_setmethods__ = {}
    for _s in [PyTrilinos.Teuchos.Describable]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, ModelEvaluator, name, value)
    __swig_getmethods__ = {}
    for _s in [PyTrilinos.Teuchos.Describable]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, ModelEvaluator, name)
    __repr__ = _swig_repr
    __swig_destroy__ = ___init__.delete_ModelEvaluator

    def get_x_map(self, *args):
        """get_x_map(ModelEvaluator self) -> Teuchos::RCP< Epetra_Map const >"""
        return ___init__.ModelEvaluator_get_x_map(self, *args)


    def get_f_map(self, *args):
        """get_f_map(ModelEvaluator self) -> Teuchos::RCP< Epetra_Map const >"""
        return ___init__.ModelEvaluator_get_f_map(self, *args)


    def get_p_map(self, *args):
        """get_p_map(ModelEvaluator self, int l) -> Teuchos::RCP< Epetra_Map const >"""
        return ___init__.ModelEvaluator_get_p_map(self, *args)


    def get_p_names(self, *args):
        """get_p_names(ModelEvaluator self, int l) -> Teuchos::RCP< Teuchos::Array< std::string > const >"""
        return ___init__.ModelEvaluator_get_p_names(self, *args)


    def get_g_map(self, *args):
        """get_g_map(ModelEvaluator self, int j) -> Teuchos::RCP< Epetra_Map const >"""
        return ___init__.ModelEvaluator_get_g_map(self, *args)


    def get_x_init(self, *args):
        """get_x_init(ModelEvaluator self) -> Teuchos::RCP< Epetra_Vector const >"""
        return ___init__.ModelEvaluator_get_x_init(self, *args)


    def get_x_dot_init(self, *args):
        """get_x_dot_init(ModelEvaluator self) -> Teuchos::RCP< Epetra_Vector const >"""
        return ___init__.ModelEvaluator_get_x_dot_init(self, *args)


    def get_p_init(self, *args):
        """get_p_init(ModelEvaluator self, int l) -> Teuchos::RCP< Epetra_Vector const >"""
        return ___init__.ModelEvaluator_get_p_init(self, *args)


    def get_t_init(self, *args):
        """get_t_init(ModelEvaluator self) -> double"""
        return ___init__.ModelEvaluator_get_t_init(self, *args)


    def getInfBound(self, *args):
        """getInfBound(ModelEvaluator self) -> double"""
        return ___init__.ModelEvaluator_getInfBound(self, *args)


    def get_x_lower_bounds(self, *args):
        """get_x_lower_bounds(ModelEvaluator self) -> Teuchos::RCP< Epetra_Vector const >"""
        return ___init__.ModelEvaluator_get_x_lower_bounds(self, *args)


    def get_x_upper_bounds(self, *args):
        """get_x_upper_bounds(ModelEvaluator self) -> Teuchos::RCP< Epetra_Vector const >"""
        return ___init__.ModelEvaluator_get_x_upper_bounds(self, *args)


    def get_p_lower_bounds(self, *args):
        """get_p_lower_bounds(ModelEvaluator self, int l) -> Teuchos::RCP< Epetra_Vector const >"""
        return ___init__.ModelEvaluator_get_p_lower_bounds(self, *args)


    def get_p_upper_bounds(self, *args):
        """get_p_upper_bounds(ModelEvaluator self, int l) -> Teuchos::RCP< Epetra_Vector const >"""
        return ___init__.ModelEvaluator_get_p_upper_bounds(self, *args)


    def get_t_lower_bound(self, *args):
        """get_t_lower_bound(ModelEvaluator self) -> double"""
        return ___init__.ModelEvaluator_get_t_lower_bound(self, *args)


    def get_t_upper_bound(self, *args):
        """get_t_upper_bound(ModelEvaluator self) -> double"""
        return ___init__.ModelEvaluator_get_t_upper_bound(self, *args)


    def create_W(self, *args):
        """create_W(ModelEvaluator self) -> Teuchos::RCP< Epetra_Operator >"""
        return ___init__.ModelEvaluator_create_W(self, *args)


    def create_DfDp_op(self, *args):
        """create_DfDp_op(ModelEvaluator self, int l) -> Teuchos::RCP< Epetra_Operator >"""
        return ___init__.ModelEvaluator_create_DfDp_op(self, *args)


    def create_DgDx_dot_op(self, *args):
        """create_DgDx_dot_op(ModelEvaluator self, int j) -> Teuchos::RCP< Epetra_Operator >"""
        return ___init__.ModelEvaluator_create_DgDx_dot_op(self, *args)


    def create_DgDx_op(self, *args):
        """create_DgDx_op(ModelEvaluator self, int j) -> Teuchos::RCP< Epetra_Operator >"""
        return ___init__.ModelEvaluator_create_DgDx_op(self, *args)


    def create_DgDp_op(self, *args):
        """create_DgDp_op(ModelEvaluator self, int j, int l) -> Teuchos::RCP< Epetra_Operator >"""
        return ___init__.ModelEvaluator_create_DgDp_op(self, *args)


    def createInArgs(self, *args):
        """createInArgs(ModelEvaluator self) -> EpetraExt::ModelEvaluator::InArgs"""
        return ___init__.ModelEvaluator_createInArgs(self, *args)


    def createOutArgs(self, *args):
        """createOutArgs(ModelEvaluator self) -> EpetraExt::ModelEvaluator::OutArgs"""
        return ___init__.ModelEvaluator_createOutArgs(self, *args)


    def evalModel(self, *args):
        """evalModel(ModelEvaluator self, EpetraExt::ModelEvaluator::InArgs const & inArgs, EpetraExt::ModelEvaluator::OutArgs const & outArgs)"""
        return ___init__.ModelEvaluator_evalModel(self, *args)


    def __init__(self, *args):
        """__init__(EpetraExt::ModelEvaluator self) -> ModelEvaluator"""
        if self.__class__ == ModelEvaluator:
            _self = None
        else:
            _self = self
        this = ___init__.new_ModelEvaluator(_self, *args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    def __disown__(self):
        self.this.disown()
        ___init__.disown_ModelEvaluator(self)
        return weakref_proxy(self)
ModelEvaluator_swigregister = ___init__.ModelEvaluator_swigregister
ModelEvaluator_swigregister(ModelEvaluator)


import sys, os.path as op
parentDir = op.normpath(op.join(op.dirname(op.abspath(__file__)),".."))
if not parentDir in sys.path: sys.path.append(parentDir)
del sys, op

import Abstract
import Interface
class Group(Abstract.Group):
    """Proxy of C++ NOX::Epetra::Group class."""

    __swig_setmethods__ = {}
    for _s in [Abstract.Group]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, Group, name, value)
    __swig_getmethods__ = {}
    for _s in [Abstract.Group]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, Group, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(NOX::Epetra::Group self, ParameterList printingParams, Teuchos::RCP< NOX::Epetra::Interface::Required > const & i, Vector initialGuess) -> Group
        __init__(NOX::Epetra::Group self, ParameterList printingParams, Teuchos::RCP< NOX::Epetra::Interface::Required > const & i, Vector initialGuess, Teuchos::RCP< NOX::Epetra::LinearSystem > const & linSys) -> Group
        __init__(NOX::Epetra::Group self, Group source, NOX::CopyType type) -> Group
        """
        this = ___init__.new_Group(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = ___init__.delete_Group

    def setX(self, *args):
        """
        setX(Group self, Vector y)
        setX(Group self, Vector y)
        """
        return ___init__.Group_setX(self, *args)


    def computeX(self, *args):
        """
        computeX(Group self, Group grp, Vector d, double step)
        computeX(Group self, Group grp, Vector d, double step)
        """
        return ___init__.Group_computeX(self, *args)


    def computeF(self, *args):
        """computeF(Group self) -> NOX::Abstract::Group::ReturnType"""
        return ___init__.Group_computeF(self, *args)


    def computeJacobian(self, *args):
        """computeJacobian(Group self) -> NOX::Abstract::Group::ReturnType"""
        return ___init__.Group_computeJacobian(self, *args)


    def computeGradient(self, *args):
        """computeGradient(Group self) -> NOX::Abstract::Group::ReturnType"""
        return ___init__.Group_computeGradient(self, *args)


    def computeNewton(self, *args):
        """computeNewton(Group self, ParameterList params) -> NOX::Abstract::Group::ReturnType"""
        return ___init__.Group_computeNewton(self, *args)


    def applyJacobian(self, *args):
        """
        applyJacobian(Group self, Vector input, Vector result) -> NOX::Abstract::Group::ReturnType
        applyJacobian(Group self, Vector input, Vector result) -> NOX::Abstract::Group::ReturnType
        """
        return ___init__.Group_applyJacobian(self, *args)


    def applyJacobianTranspose(self, *args):
        """
        applyJacobianTranspose(Group self, Vector input, Vector result) -> NOX::Abstract::Group::ReturnType
        applyJacobianTranspose(Group self, Vector input, Vector result) -> NOX::Abstract::Group::ReturnType
        """
        return ___init__.Group_applyJacobianTranspose(self, *args)


    def applyJacobianInverse(self, *args):
        """
        applyJacobianInverse(Group self, ParameterList params, Vector input, Vector result) -> NOX::Abstract::Group::ReturnType
        applyJacobianInverse(Group self, ParameterList params, Vector input, Vector result) -> NOX::Abstract::Group::ReturnType
        """
        return ___init__.Group_applyJacobianInverse(self, *args)


    def applyRightPreconditioning(self, *args):
        """
        applyRightPreconditioning(Group self, bool useTranspose, ParameterList params, Vector input, Vector result) -> NOX::Abstract::Group::ReturnType
        applyRightPreconditioning(Group self, bool useTranspose, ParameterList params, Vector input, Vector result) -> NOX::Abstract::Group::ReturnType
        """
        return ___init__.Group_applyRightPreconditioning(self, *args)


    def isF(self, *args):
        """isF(Group self) -> bool"""
        return ___init__.Group_isF(self, *args)


    def isJacobian(self, *args):
        """isJacobian(Group self) -> bool"""
        return ___init__.Group_isJacobian(self, *args)


    def isGradient(self, *args):
        """isGradient(Group self) -> bool"""
        return ___init__.Group_isGradient(self, *args)


    def isNewton(self, *args):
        """isNewton(Group self) -> bool"""
        return ___init__.Group_isNewton(self, *args)


    def isNormNewtonSolveResidual(self, *args):
        """isNormNewtonSolveResidual(Group self) -> bool"""
        return ___init__.Group_isNormNewtonSolveResidual(self, *args)


    def isPreconditioner(self, *args):
        """isPreconditioner(Group self) -> bool"""
        return ___init__.Group_isPreconditioner(self, *args)


    def isConditionNumber(self, *args):
        """isConditionNumber(Group self) -> bool"""
        return ___init__.Group_isConditionNumber(self, *args)


    def getX(self, *args):
        """getX(Group self) -> Vector"""
        return ___init__.Group_getX(self, *args)


    def getF(self, *args):
        """getF(Group self) -> Vector"""
        return ___init__.Group_getF(self, *args)


    def getNormF(self, *args):
        """getNormF(Group self) -> double"""
        return ___init__.Group_getNormF(self, *args)


    def getGradient(self, *args):
        """getGradient(Group self) -> Vector"""
        return ___init__.Group_getGradient(self, *args)


    def getNewton(self, *args):
        """getNewton(Group self) -> Vector"""
        return ___init__.Group_getNewton(self, *args)


    def getXPtr(self, *args):
        """getXPtr(Group self) -> Teuchos::RCP< NOX::Abstract::Vector const >"""
        return ___init__.Group_getXPtr(self, *args)


    def getFPtr(self, *args):
        """getFPtr(Group self) -> Teuchos::RCP< NOX::Abstract::Vector const >"""
        return ___init__.Group_getFPtr(self, *args)


    def getGradientPtr(self, *args):
        """getGradientPtr(Group self) -> Teuchos::RCP< NOX::Abstract::Vector const >"""
        return ___init__.Group_getGradientPtr(self, *args)


    def getNewtonPtr(self, *args):
        """getNewtonPtr(Group self) -> Teuchos::RCP< NOX::Abstract::Vector const >"""
        return ___init__.Group_getNewtonPtr(self, *args)


    def getNormLastLinearSolveResidual(self, *args):
        """getNormLastLinearSolveResidual(Group self, double & residual) -> NOX::Abstract::Group::ReturnType"""
        return ___init__.Group_getNormLastLinearSolveResidual(self, *args)


    def clone(self, *args):
        """clone(Group self, NOX::CopyType type) -> Teuchos::RCP< NOX::Abstract::Group >"""
        return ___init__.Group_clone(self, *args)


    def getRequiredInterface(self, *args):
        """getRequiredInterface(Group self) -> Teuchos::RCP< NOX::Epetra::Interface::Required >"""
        return ___init__.Group_getRequiredInterface(self, *args)


    def getLinearSystem(self, *args):
        """
        getLinearSystem(Group self) -> Teuchos::RCP< NOX::Epetra::LinearSystem const >
        getLinearSystem(Group self) -> Teuchos::RCP< NOX::Epetra::LinearSystem >
        """
        return ___init__.Group_getLinearSystem(self, *args)


    def computeJacobianConditionNumber(self, *args):
        """computeJacobianConditionNumber(Group self, int maxIters, double tolerance, int krylovSubspaceSize=100, bool printOutput=False) -> NOX::Abstract::Group::ReturnType"""
        return ___init__.Group_computeJacobianConditionNumber(self, *args)


    def getJacobianConditionNumber(self, *args):
        """getJacobianConditionNumber(Group self) -> double"""
        return ___init__.Group_getJacobianConditionNumber(self, *args)


    def disableLinearResidualComputation(self, *args):
        """disableLinearResidualComputation(Group self, bool const disableChoice)"""
        return ___init__.Group_disableLinearResidualComputation(self, *args)

Group_swigregister = ___init__.Group_swigregister
Group_swigregister(Group)

class Vector(Abstract.Vector):
    """Proxy of C++ NOX::Epetra::Vector class."""

    __swig_setmethods__ = {}
    for _s in [Abstract.Vector]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, Vector, name, value)
    __swig_getmethods__ = {}
    for _s in [Abstract.Vector]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, Vector, name)
    __repr__ = _swig_repr
    CreateView = ___init__.Vector_CreateView
    CreateCopy = ___init__.Vector_CreateCopy

    def __init__(self, *args):
        """
        __init__(NOX::Epetra::Vector self, Teuchos::RCP< Epetra_Vector > const & source, NOX::Epetra::Vector::MemoryType memoryType, NOX::CopyType type, Teuchos::RCP< NOX::Epetra::VectorSpace > vs) -> Vector
        __init__(NOX::Epetra::Vector self, Vector source, NOX::CopyType type, Teuchos::RCP< NOX::Epetra::VectorSpace > vs) -> Vector
        __init__(NOX::Epetra::Vector self, Vector source, NOX::CopyType type) -> Vector
        """
        this = ___init__.new_Vector(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = ___init__.delete_Vector

    def getEpetraVector(self, *args):
        """getEpetraVector(Vector self) -> Vector"""
        return ___init__.Vector_getEpetraVector(self, *args)


    def init(self, *args):
        """init(Vector self, double gamma) -> Vector"""
        return ___init__.Vector_init(self, *args)


    def random(self, *args):
        """random(Vector self, bool useSeed=False, int seed=1) -> Vector"""
        return ___init__.Vector_random(self, *args)


    def abs(self, *args):
        """
        abs(Vector self, Vector y) -> Vector
        abs(Vector self, Vector y) -> Vector
        """
        return ___init__.Vector_abs(self, *args)


    def reciprocal(self, *args):
        """
        reciprocal(Vector self, Vector y) -> Vector
        reciprocal(Vector self, Vector y) -> Vector
        """
        return ___init__.Vector_reciprocal(self, *args)


    def scale(self, *args):
        """
        scale(Vector self, double gamma) -> Vector
        scale(Vector self, Vector a) -> Vector
        scale(Vector self, Vector a) -> Vector
        """
        return ___init__.Vector_scale(self, *args)


    def update(self, *args):
        """
        update(Vector self, double alpha, Vector a, double gamma=0.0) -> Vector
        update(Vector self, double alpha, Vector a, double gamma=0.0) -> Vector
        update(Vector self, double alpha, Vector a, double beta, Vector b, double gamma=0.0) -> Vector
        update(Vector self, double alpha, Vector a, double beta, Vector b, double gamma=0.0) -> Vector
        """
        return ___init__.Vector_update(self, *args)


    def clone(self, *args):
        """clone(Vector self, NOX::CopyType type) -> Teuchos::RCP< NOX::Abstract::Vector >"""
        return ___init__.Vector_clone(self, *args)


    def createMultiVector(self, *args):
        """
        createMultiVector(Vector self, NOX::Abstract::Vector const *const * vecs, int numVecs, NOX::CopyType type) -> Teuchos::RCP< NOX::Abstract::MultiVector >
        createMultiVector(Vector self, int numVecs, NOX::CopyType type) -> Teuchos::RCP< NOX::Abstract::MultiVector >
        """
        return ___init__.Vector_createMultiVector(self, *args)


    def norm(self, *args):
        """
        norm(Vector self, NOX::Abstract::Vector::NormType type) -> double
        norm(Vector self, Vector weights) -> double
        norm(Vector self, Vector weights) -> double
        """
        return ___init__.Vector_norm(self, *args)


    def innerProduct(self, *args):
        """
        innerProduct(Vector self, Vector y) -> double
        innerProduct(Vector self, Vector y) -> double
        """
        return ___init__.Vector_innerProduct(self, *args)


    def length(self, *args):
        """length(Vector self) -> NOX::size_type"""
        return ___init__.Vector_length(self, *args)


    def getVectorSpace(self, *args):
        """getVectorSpace(Vector self) -> Teuchos::RCP< NOX::Epetra::VectorSpace >"""
        return ___init__.Vector_getVectorSpace(self, *args)

Vector_swigregister = ___init__.Vector_swigregister
Vector_swigregister(Vector)

class FiniteDifference(PyTrilinos.Epetra.RowMatrix, Interface.Jacobian, Interface.Preconditioner):
    """Proxy of C++ NOX::Epetra::FiniteDifference class."""

    __swig_setmethods__ = {}
    for _s in [PyTrilinos.Epetra.RowMatrix, Interface.Jacobian, Interface.Preconditioner]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, FiniteDifference, name, value)
    __swig_getmethods__ = {}
    for _s in [PyTrilinos.Epetra.RowMatrix, Interface.Jacobian, Interface.Preconditioner]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, FiniteDifference, name)
    __repr__ = _swig_repr
    Forward = ___init__.FiniteDifference_Forward
    Backward = ___init__.FiniteDifference_Backward
    Centered = ___init__.FiniteDifference_Centered

    def __init__(self, *args):
        """
        __init__(NOX::Epetra::FiniteDifference self, ParameterList printingParams, Teuchos::RCP< NOX::Epetra::Interface::Required > const & i, Vector initialGuess, double beta=1.0e-6, double alpha=1.0e-4) -> FiniteDifference
        __init__(NOX::Epetra::FiniteDifference self, ParameterList printingParams, Teuchos::RCP< NOX::Epetra::Interface::Required > const & i, Vector initialGuess, Teuchos::RCP< Epetra_Vector const > const & beta, double alpha=1.0e-4) -> FiniteDifference
        __init__(NOX::Epetra::FiniteDifference self, ParameterList printingParams, Teuchos::RCP< NOX::Epetra::Interface::Required > const & i, Vector initialGuess, Teuchos::RCP< Epetra_CrsGraph > const & g, double beta=1.0e-6, double alpha=1.0e-4) -> FiniteDifference
        __init__(NOX::Epetra::FiniteDifference self, ParameterList printingParams, Teuchos::RCP< NOX::Epetra::Interface::Required > const & i, Vector initialGuess, Teuchos::RCP< Epetra_CrsGraph > const & g, Teuchos::RCP< Epetra_Vector const > const & beta, double alpha=1.0e-4) -> FiniteDifference
        """
        this = ___init__.new_FiniteDifference(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = ___init__.delete_FiniteDifference

    def Label(self, *args):
        """Label(FiniteDifference self) -> char const *"""
        return ___init__.FiniteDifference_Label(self, *args)


    def SetUseTranspose(self, *args):
        """SetUseTranspose(FiniteDifference self, bool UseTranspose) -> int"""
        return ___init__.FiniteDifference_SetUseTranspose(self, *args)


    def Apply(self, *args):
        """
        Apply(self, MultiVector x, MultiVector y) -> int

        In C++, the Apply() method is pure virtual, thus intended to be
        overridden by derived classes.  In python, cross-language polymorphism
        is supported, and you are expected to derive classes from this base
        class and redefine the Apply() method.  C++ code (e.g., AztecOO
        solvers) can call back to your Apply() method as needed.  You must
        support two arguments, labeled here MultiVector x and MultiVector y.
        These will be converted from Epetra_MultiVector C++ objects to
        numpy-hybrid Epetra.MultiVector objects before they are passed to you.
        Thus, it is legal to use slice indexing and other numpy features to
        compute y from x.

        If application of your operator is successful, return 0; else return
        some non-zero error code.

        It is strongly suggested that you prevent Apply() from raising any
        exceptions.  Accidental errors can be prevented by wrapping your code
        in a try block:

            try:
                # Your code goes here...
            except Exception, e:
                print 'A python exception was raised by method Apply:'
                print e
                return -1

        By returning a -1, you inform the calling routine that Apply() was
        unsuccessful.

        """
        return ___init__.FiniteDifference_Apply(self, *args)


    def ApplyInverse(self, *args):
        """
        ApplyInverse(self, MultiVector x, MultiVector y) -> int

        In C++, the ApplyInverse() method is pure virtual, thus intended to be
        overridden by derived classes.  In python, cross-language polymorphism
        is supported, and you are expected to derive classes from this base
        class and redefine the ApplyInverse() method.  C++ code (e.g., AztecOO
        solvers) can call back to your ApplyInverse() method as needed.  You
        must support two arguments, labeled here MultiVector x and MultiVector
        y.  These will be converted from Epetra_MultiVector C++ objects to
        numpy-hybrid Epetra.MultiVector objects before they are passed to you.
        Thus, it is legal to use slice indexing and other numpy features to
        compute y from x.

        If application of your operator is successful, return 0; else return
        some non-zero error code.

        It is strongly suggested that you prevent ApplyInverse() from raising
        any exceptions.  Accidental errors can be prevented by wrapping your
        code in a try block:

            try:
                # Your code goes here...
            except Exception, e:
                print 'A python exception was raised by method ApplyInverse:'
                print e
                return -1

        By returning a -1, you inform the calling routine that ApplyInverse()
        was unsuccessful.

        """
        return ___init__.FiniteDifference_ApplyInverse(self, *args)


    def UseTranspose(self, *args):
        """UseTranspose(FiniteDifference self) -> bool"""
        return ___init__.FiniteDifference_UseTranspose(self, *args)


    def HasNormInf(self, *args):
        """HasNormInf(FiniteDifference self) -> bool"""
        return ___init__.FiniteDifference_HasNormInf(self, *args)


    def OperatorDomainMap(self, *args):
        """OperatorDomainMap(FiniteDifference self) -> Map"""
        return ___init__.FiniteDifference_OperatorDomainMap(self, *args)


    def OperatorRangeMap(self, *args):
        """OperatorRangeMap(FiniteDifference self) -> Map"""
        return ___init__.FiniteDifference_OperatorRangeMap(self, *args)


    def Filled(self, *args):
        """Filled(FiniteDifference self) -> bool"""
        return ___init__.FiniteDifference_Filled(self, *args)


    def NumMyRowEntries(self, *args):
        """
        NumMyRowEntries(int myRow, numpy.ndarray numEntries) -> int

        In C++, numEntries in an int&.  In python, it is provided to you as a
        numpy array of length one so that you can set its value in-place using
        numEntries[0] = ....
        """
        return ___init__.FiniteDifference_NumMyRowEntries(self, *args)


    def MaxNumEntries(self, *args):
        """MaxNumEntries(FiniteDifference self) -> int"""
        return ___init__.FiniteDifference_MaxNumEntries(self, *args)


    def ExtractMyRowCopy(self, *args):
        """
        ExtractMyRowCopy(int myRow, int length, numpy.ndarray numEntries,
            numpy.ndarray values, numpy.ndarray indices) -> int

        In C++, numEntries in an int&.  In python, it is provided to you as a
        numpy array of length one so that you can set its value in-place using
        numEntries[0] = ....

        Arguments values and indices are double* and int*, respectively, in
        C++.  In python, these are provided to you as numpy arrays of the
        given length, so that you may alter their entries in-place.
        """
        return ___init__.FiniteDifference_ExtractMyRowCopy(self, *args)


    def ExtractDiagonalCopy(self, *args):
        """
        ExtractDiagonalCopy(Vector diagonal) -> int

        Argument diagonal is provided to you as a numpy-hybrid Epetra.Vector,
        giving you access to the numpy interface in addition to the
        Epetra_Vector C++ interface.
        """
        return ___init__.FiniteDifference_ExtractDiagonalCopy(self, *args)


    def Multiply(self, *args):
        """
        Multiply(bool useTranspose, MultiVector x, MultiVector y) -> int

        In C++, arguments x and y are Epetra_MultiVectors.  In python, they
        are provided to you as numpy-hybrid Epetra.MultiVectors, giving you
        access to the numpy interface in addition to the Epetra_MultiVector
        C++ interface.
        """
        return ___init__.FiniteDifference_Multiply(self, *args)


    def Solve(self, *args):
        """
        Solve((bool upper, bool trans, bool unitDiagonal, MultiVector x,
            MultiVector y) -> int

        In C++, arguments x and y are Epetra_MultiVectors.  In python, they
        are provided to you as numpy-hybrid Epetra.MultiVectors, giving you
        access to the numpy interface in addition to the Epetra_MultiVector
        C++ interface.
        """
        return ___init__.FiniteDifference_Solve(self, *args)


    def InvRowSums(self, *args):
        """
        InvRowSums(Vector x) -> int

        Argument x is provided to you as a numpy-hybrid Epetra.Vector, giving
        you access to the numpy interface in addition to the Epetra_Vector C++
        interface.
        """
        return ___init__.FiniteDifference_InvRowSums(self, *args)


    def LeftScale(self, *args):
        """
        LeftScale(Vector x) -> int

        Argument x is provided to you as a numpy-hybrid Epetra.Vector, giving
        you access to the numpy interface in addition to the Epetra_Vector C++
        interface.
        """
        return ___init__.FiniteDifference_LeftScale(self, *args)


    def InvColSums(self, *args):
        """
        InvColSums(Vector x) -> int

        Argument x is provided to you as a numpy-hybrid Epetra.Vector, giving
        you access to the numpy interface in addition to the Epetra_Vector C++
        interface.
        """
        return ___init__.FiniteDifference_InvColSums(self, *args)


    def RightScale(self, *args):
        """
        RightScale(Vector x) -> int

        Argument x is provided to you as a numpy-hybrid Epetra.Vector, giving
        you access to the numpy interface in addition to the Epetra_Vector C++
        interface.
        """
        return ___init__.FiniteDifference_RightScale(self, *args)


    def NormInf(self, *args):
        """NormInf(FiniteDifference self) -> double"""
        return ___init__.FiniteDifference_NormInf(self, *args)


    def NormOne(self, *args):
        """NormOne(FiniteDifference self) -> double"""
        return ___init__.FiniteDifference_NormOne(self, *args)


    def NumGlobalNonzeros(self, *args):
        """NumGlobalNonzeros(FiniteDifference self) -> int"""
        return ___init__.FiniteDifference_NumGlobalNonzeros(self, *args)


    def NumGlobalNonzeros64(self, *args):
        """NumGlobalNonzeros64(FiniteDifference self) -> long long"""
        return ___init__.FiniteDifference_NumGlobalNonzeros64(self, *args)


    def NumGlobalRows(self, *args):
        """NumGlobalRows(FiniteDifference self) -> int"""
        return ___init__.FiniteDifference_NumGlobalRows(self, *args)


    def NumGlobalRows64(self, *args):
        """NumGlobalRows64(FiniteDifference self) -> long long"""
        return ___init__.FiniteDifference_NumGlobalRows64(self, *args)


    def NumGlobalCols(self, *args):
        """NumGlobalCols(FiniteDifference self) -> int"""
        return ___init__.FiniteDifference_NumGlobalCols(self, *args)


    def NumGlobalCols64(self, *args):
        """NumGlobalCols64(FiniteDifference self) -> long long"""
        return ___init__.FiniteDifference_NumGlobalCols64(self, *args)


    def NumGlobalDiagonals(self, *args):
        """NumGlobalDiagonals(FiniteDifference self) -> int"""
        return ___init__.FiniteDifference_NumGlobalDiagonals(self, *args)


    def NumGlobalDiagonals64(self, *args):
        """NumGlobalDiagonals64(FiniteDifference self) -> long long"""
        return ___init__.FiniteDifference_NumGlobalDiagonals64(self, *args)


    def NumMyNonzeros(self, *args):
        """NumMyNonzeros(FiniteDifference self) -> int"""
        return ___init__.FiniteDifference_NumMyNonzeros(self, *args)


    def NumMyRows(self, *args):
        """NumMyRows(FiniteDifference self) -> int"""
        return ___init__.FiniteDifference_NumMyRows(self, *args)


    def NumMyCols(self, *args):
        """NumMyCols(FiniteDifference self) -> int"""
        return ___init__.FiniteDifference_NumMyCols(self, *args)


    def NumMyDiagonals(self, *args):
        """NumMyDiagonals(FiniteDifference self) -> int"""
        return ___init__.FiniteDifference_NumMyDiagonals(self, *args)


    def LowerTriangular(self, *args):
        """LowerTriangular(FiniteDifference self) -> bool"""
        return ___init__.FiniteDifference_LowerTriangular(self, *args)


    def UpperTriangular(self, *args):
        """UpperTriangular(FiniteDifference self) -> bool"""
        return ___init__.FiniteDifference_UpperTriangular(self, *args)


    def Comm(self, *args):
        """Comm(FiniteDifference self) -> Comm"""
        return ___init__.FiniteDifference_Comm(self, *args)


    def RowMatrixRowMap(self, *args):
        """RowMatrixRowMap(FiniteDifference self) -> Map"""
        return ___init__.FiniteDifference_RowMatrixRowMap(self, *args)


    def RowMatrixColMap(self, *args):
        """RowMatrixColMap(FiniteDifference self) -> Map"""
        return ___init__.FiniteDifference_RowMatrixColMap(self, *args)


    def RowMatrixImporter(self, *args):
        """RowMatrixImporter(FiniteDifference self) -> Import"""
        return ___init__.FiniteDifference_RowMatrixImporter(self, *args)


    def Map(self, *args):
        """Map(FiniteDifference self) -> BlockMap"""
        return ___init__.FiniteDifference_Map(self, *args)


    def computeJacobian(self, *args):
        """
        computeJacobian(FiniteDifference self, Vector x, Operator Jac) -> bool
        computeJacobian(FiniteDifference self, Vector x) -> bool
        """
        return ___init__.FiniteDifference_computeJacobian(self, *args)


    def computePreconditioner(self, *args):
        """computePreconditioner(FiniteDifference self, Vector x, Operator Prec, ParameterList precParams=None) -> bool"""
        return ___init__.FiniteDifference_computePreconditioner(self, *args)


    def setDifferenceMethod(self, *args):
        """setDifferenceMethod(FiniteDifference self, NOX::Epetra::FiniteDifference::DifferenceType type)"""
        return ___init__.FiniteDifference_setDifferenceMethod(self, *args)


    def getUnderlyingMatrix(self, *args):
        """getUnderlyingMatrix(FiniteDifference self) -> CrsMatrix"""
        return ___init__.FiniteDifference_getUnderlyingMatrix(self, *args)


    def setGroupForComputeF(self, *args):
        """setGroupForComputeF(FiniteDifference self, Group group)"""
        return ___init__.FiniteDifference_setGroupForComputeF(self, *args)

FiniteDifference_swigregister = ___init__.FiniteDifference_swigregister
FiniteDifference_swigregister(FiniteDifference)

class FiniteDifferenceColoring(FiniteDifference):
    """Proxy of C++ NOX::Epetra::FiniteDifferenceColoring class."""

    __swig_setmethods__ = {}
    for _s in [FiniteDifference]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, FiniteDifferenceColoring, name, value)
    __swig_getmethods__ = {}
    for _s in [FiniteDifference]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, FiniteDifferenceColoring, name)
    __repr__ = _swig_repr
    __swig_destroy__ = ___init__.delete_FiniteDifferenceColoring

    def computeJacobian(self, *args):
        """
        computeJacobian(FiniteDifferenceColoring self, Vector x, Operator Jac) -> bool
        computeJacobian(FiniteDifferenceColoring self, Vector x) -> bool
        """
        return ___init__.FiniteDifferenceColoring_computeJacobian(self, *args)


    def createColorContainers(self, *args):
        """createColorContainers(FiniteDifferenceColoring self)"""
        return ___init__.FiniteDifferenceColoring_createColorContainers(self, *args)


    def __init__(self, *args):
        """__init__(NOX::Epetra::FiniteDifferenceColoring self, ParameterList printingParams, Teuchos::RCP< NOX::Epetra::Interface::Required > const & i, Vector initialGuess, Teuchos::RCP< Epetra_CrsGraph > const & rawGraph, bool parallelColoring=False, bool distance1=False, double beta=1.0e-6, double alpha=1.0e-4) -> FiniteDifferenceColoring"""
        this = ___init__.new_FiniteDifferenceColoring(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
FiniteDifferenceColoring_swigregister = ___init__.FiniteDifferenceColoring_swigregister
FiniteDifferenceColoring_swigregister(FiniteDifferenceColoring)

class MatrixFree(PyTrilinos.Epetra.Operator, Interface.Jacobian):
    """Proxy of C++ NOX::Epetra::MatrixFree class."""

    __swig_setmethods__ = {}
    for _s in [PyTrilinos.Epetra.Operator, Interface.Jacobian]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, MatrixFree, name, value)
    __swig_getmethods__ = {}
    for _s in [PyTrilinos.Epetra.Operator, Interface.Jacobian]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, MatrixFree, name)
    __repr__ = _swig_repr
    Forward = ___init__.MatrixFree_Forward
    Backward = ___init__.MatrixFree_Backward
    Centered = ___init__.MatrixFree_Centered

    def __init__(self, *args):
        """__init__(NOX::Epetra::MatrixFree self, ParameterList printParams, Teuchos::RCP< NOX::Epetra::Interface::Required > const & i, Vector cloneVector, bool useNewPerturbation=False) -> MatrixFree"""
        this = ___init__.new_MatrixFree(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = ___init__.delete_MatrixFree

    def SetUseTranspose(self, *args):
        """SetUseTranspose(MatrixFree self, bool UseTranspose) -> int"""
        return ___init__.MatrixFree_SetUseTranspose(self, *args)


    def Apply(self, *args):
        """
        Apply(self, MultiVector x, MultiVector y) -> int

        In C++, the Apply() method is pure virtual, thus intended to be
        overridden by derived classes.  In python, cross-language polymorphism
        is supported, and you are expected to derive classes from this base
        class and redefine the Apply() method.  C++ code (e.g., AztecOO
        solvers) can call back to your Apply() method as needed.  You must
        support two arguments, labeled here MultiVector x and MultiVector y.
        These will be converted from Epetra_MultiVector C++ objects to
        numpy-hybrid Epetra.MultiVector objects before they are passed to you.
        Thus, it is legal to use slice indexing and other numpy features to
        compute y from x.

        If application of your operator is successful, return 0; else return
        some non-zero error code.

        It is strongly suggested that you prevent Apply() from raising any
        exceptions.  Accidental errors can be prevented by wrapping your code
        in a try block:

            try:
                # Your code goes here...
            except Exception, e:
                print 'A python exception was raised by method Apply:'
                print e
                return -1

        By returning a -1, you inform the calling routine that Apply() was
        unsuccessful.

        """
        return ___init__.MatrixFree_Apply(self, *args)


    def ApplyInverse(self, *args):
        """
        ApplyInverse(self, MultiVector x, MultiVector y) -> int

        In C++, the ApplyInverse() method is pure virtual, thus intended to be
        overridden by derived classes.  In python, cross-language polymorphism
        is supported, and you are expected to derive classes from this base
        class and redefine the ApplyInverse() method.  C++ code (e.g., AztecOO
        solvers) can call back to your ApplyInverse() method as needed.  You
        must support two arguments, labeled here MultiVector x and MultiVector
        y.  These will be converted from Epetra_MultiVector C++ objects to
        numpy-hybrid Epetra.MultiVector objects before they are passed to you.
        Thus, it is legal to use slice indexing and other numpy features to
        compute y from x.

        If application of your operator is successful, return 0; else return
        some non-zero error code.

        It is strongly suggested that you prevent ApplyInverse() from raising
        any exceptions.  Accidental errors can be prevented by wrapping your
        code in a try block:

            try:
                # Your code goes here...
            except Exception, e:
                print 'A python exception was raised by method ApplyInverse:'
                print e
                return -1

        By returning a -1, you inform the calling routine that ApplyInverse()
        was unsuccessful.

        """
        return ___init__.MatrixFree_ApplyInverse(self, *args)


    def NormInf(self, *args):
        """NormInf(MatrixFree self) -> double"""
        return ___init__.MatrixFree_NormInf(self, *args)


    def Label(self, *args):
        """Label(MatrixFree self) -> char const *"""
        return ___init__.MatrixFree_Label(self, *args)


    def UseTranspose(self, *args):
        """UseTranspose(MatrixFree self) -> bool"""
        return ___init__.MatrixFree_UseTranspose(self, *args)


    def HasNormInf(self, *args):
        """HasNormInf(MatrixFree self) -> bool"""
        return ___init__.MatrixFree_HasNormInf(self, *args)


    def Comm(self, *args):
        """Comm(MatrixFree self) -> Comm"""
        return ___init__.MatrixFree_Comm(self, *args)


    def OperatorDomainMap(self, *args):
        """OperatorDomainMap(MatrixFree self) -> Map"""
        return ___init__.MatrixFree_OperatorDomainMap(self, *args)


    def OperatorRangeMap(self, *args):
        """OperatorRangeMap(MatrixFree self) -> Map"""
        return ___init__.MatrixFree_OperatorRangeMap(self, *args)


    def computeJacobian(self, *args):
        """computeJacobian(MatrixFree self, Vector x, Operator Jac) -> bool"""
        return ___init__.MatrixFree_computeJacobian(self, *args)


    def setDifferenceMethod(self, *args):
        """setDifferenceMethod(MatrixFree self, NOX::Epetra::MatrixFree::DifferenceType type)"""
        return ___init__.MatrixFree_setDifferenceMethod(self, *args)


    def setLambda(self, *args):
        """setLambda(MatrixFree self, double lambda_)"""
        return ___init__.MatrixFree_setLambda(self, *args)


    def setComputePerturbation(self, *args):
        """setComputePerturbation(MatrixFree self, bool bVal)"""
        return ___init__.MatrixFree_setComputePerturbation(self, *args)


    def setPerturbation(self, *args):
        """setPerturbation(MatrixFree self, double eta_)"""
        return ___init__.MatrixFree_setPerturbation(self, *args)


    def getPerturbation(self, *args):
        """getPerturbation(MatrixFree self) -> double"""
        return ___init__.MatrixFree_getPerturbation(self, *args)


    def setGroupForComputeF(self, *args):
        """setGroupForComputeF(MatrixFree self, Group group)"""
        return ___init__.MatrixFree_setGroupForComputeF(self, *args)


    def setSolverForComputeJacobian(self, *args):
        """setSolverForComputeJacobian(MatrixFree self, Teuchos::RCP< NOX::Solver::Generic > const & slvr)"""
        return ___init__.MatrixFree_setSolverForComputeJacobian(self, *args)

MatrixFree_swigregister = ___init__.MatrixFree_swigregister
MatrixFree_swigregister(MatrixFree)

class Scaling(_object):
    """Proxy of C++ NOX::Epetra::Scaling class."""

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, Scaling, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, Scaling, name)
    __repr__ = _swig_repr
    Scaling_None = ___init__.Scaling_Scaling_None
    RowSum = ___init__.Scaling_RowSum
    ColSum = ___init__.Scaling_ColSum
    UserDefined = ___init__.Scaling_UserDefined
    Left = ___init__.Scaling_Left
    Right = ___init__.Scaling_Right

    def __init__(self, *args):
        """__init__(NOX::Epetra::Scaling self) -> Scaling"""
        this = ___init__.new_Scaling(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = ___init__.delete_Scaling

    def addUserScaling(self, *args):
        """addUserScaling(Scaling self, NOX::Epetra::Scaling::ScaleType type, Teuchos::RCP< Epetra_Vector > const & D)"""
        return ___init__.Scaling_addUserScaling(self, *args)


    def addRowSumScaling(self, *args):
        """addRowSumScaling(Scaling self, NOX::Epetra::Scaling::ScaleType type, Teuchos::RCP< Epetra_Vector > const & D)"""
        return ___init__.Scaling_addRowSumScaling(self, *args)


    def addColSumScaling(self, *args):
        """addColSumScaling(Scaling self, NOX::Epetra::Scaling::ScaleType type, Teuchos::RCP< Epetra_Vector > const & D)"""
        return ___init__.Scaling_addColSumScaling(self, *args)


    def computeScaling(self, *args):
        """computeScaling(Scaling self, Epetra_LinearProblem problem)"""
        return ___init__.Scaling_computeScaling(self, *args)


    def scaleLinearSystem(self, *args):
        """scaleLinearSystem(Scaling self, Epetra_LinearProblem problem)"""
        return ___init__.Scaling_scaleLinearSystem(self, *args)


    def unscaleLinearSystem(self, *args):
        """unscaleLinearSystem(Scaling self, Epetra_LinearProblem problem)"""
        return ___init__.Scaling_unscaleLinearSystem(self, *args)


    def applyRightScaling(self, *args):
        """applyRightScaling(Scaling self, Vector input, Vector result)"""
        return ___init__.Scaling_applyRightScaling(self, *args)


    def applyLeftScaling(self, *args):
        """applyLeftScaling(Scaling self, Vector input, Vector result)"""
        return ___init__.Scaling_applyLeftScaling(self, *args)

Scaling_swigregister = ___init__.Scaling_swigregister
Scaling_swigregister(Scaling)

class LinearSystem(_object):
    """Proxy of C++ NOX::Epetra::LinearSystem class."""

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, LinearSystem, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, LinearSystem, name)
    __repr__ = _swig_repr
    PRPT_REBUILD = ___init__.LinearSystem_PRPT_REBUILD
    PRPT_RECOMPUTE = ___init__.LinearSystem_PRPT_RECOMPUTE
    PRPT_REUSE = ___init__.LinearSystem_PRPT_REUSE

    def __init__(self, *args):
        """__init__(NOX::Epetra::LinearSystem self) -> LinearSystem"""
        if self.__class__ == LinearSystem:
            _self = None
        else:
            _self = self
        this = ___init__.new_LinearSystem(_self, *args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = ___init__.delete_LinearSystem

    def applyJacobian(self, *args):
        """applyJacobian(LinearSystem self, Vector input, Vector nox_result) -> bool"""
        return ___init__.LinearSystem_applyJacobian(self, *args)


    def applyJacobianTranspose(self, *args):
        """applyJacobianTranspose(LinearSystem self, Vector input, Vector nox_result) -> bool"""
        return ___init__.LinearSystem_applyJacobianTranspose(self, *args)


    def applyJacobianInverse(self, *args):
        """applyJacobianInverse(LinearSystem self, ParameterList params, Vector input, Vector nox_result) -> bool"""
        return ___init__.LinearSystem_applyJacobianInverse(self, *args)


    def applyRightPreconditioning(self, *args):
        """applyRightPreconditioning(LinearSystem self, bool useTranspose, ParameterList params, Vector input, Vector nox_result) -> bool"""
        return ___init__.LinearSystem_applyRightPreconditioning(self, *args)


    def getScaling(self, *args):
        """getScaling(LinearSystem self) -> Teuchos::RCP< NOX::Epetra::Scaling >"""
        return ___init__.LinearSystem_getScaling(self, *args)


    def resetScaling(self, *args):
        """resetScaling(LinearSystem self, Teuchos::RCP< NOX::Epetra::Scaling > const & s)"""
        return ___init__.LinearSystem_resetScaling(self, *args)


    def computeJacobian(self, *args):
        """computeJacobian(LinearSystem self, Vector x) -> bool"""
        return ___init__.LinearSystem_computeJacobian(self, *args)


    def createPreconditioner(self, *args):
        """createPreconditioner(LinearSystem self, Vector x, ParameterList p, bool recomputeGraph) -> bool"""
        return ___init__.LinearSystem_createPreconditioner(self, *args)


    def destroyPreconditioner(self, *args):
        """destroyPreconditioner(LinearSystem self) -> bool"""
        return ___init__.LinearSystem_destroyPreconditioner(self, *args)


    def recomputePreconditioner(self, *args):
        """recomputePreconditioner(LinearSystem self, Vector x, ParameterList linearSolverParams) -> bool"""
        return ___init__.LinearSystem_recomputePreconditioner(self, *args)


    def getPreconditionerPolicy(self, *args):
        """getPreconditionerPolicy(LinearSystem self, bool advanceReuseCounter=True) -> NOX::Epetra::LinearSystem::PreconditionerReusePolicyType"""
        return ___init__.LinearSystem_getPreconditionerPolicy(self, *args)


    def isPreconditionerConstructed(self, *args):
        """isPreconditionerConstructed(LinearSystem self) -> bool"""
        return ___init__.LinearSystem_isPreconditionerConstructed(self, *args)


    def hasPreconditioner(self, *args):
        """hasPreconditioner(LinearSystem self) -> bool"""
        return ___init__.LinearSystem_hasPreconditioner(self, *args)


    def getJacobianOperator(self, *args):
        """
        getJacobianOperator(LinearSystem self) -> Teuchos::RCP< Epetra_Operator const >
        getJacobianOperator(LinearSystem self) -> Teuchos::RCP< Epetra_Operator >
        """
        return ___init__.LinearSystem_getJacobianOperator(self, *args)


    def getGeneratedPrecOperator(self, *args):
        """
        getGeneratedPrecOperator(LinearSystem self) -> Teuchos::RCP< Epetra_Operator const >
        getGeneratedPrecOperator(LinearSystem self) -> Teuchos::RCP< Epetra_Operator >
        """
        return ___init__.LinearSystem_getGeneratedPrecOperator(self, *args)


    def setJacobianOperatorForSolve(self, *args):
        """setJacobianOperatorForSolve(LinearSystem self, Teuchos::RCP< Epetra_Operator const > const & solveJacOp)"""
        return ___init__.LinearSystem_setJacobianOperatorForSolve(self, *args)


    def setPrecOperatorForSolve(self, *args):
        """setPrecOperatorForSolve(LinearSystem self, Teuchos::RCP< Epetra_Operator const > const & solvePrecOp)"""
        return ___init__.LinearSystem_setPrecOperatorForSolve(self, *args)


    def getNumLinearSolves(self, *args):
        """getNumLinearSolves(LinearSystem self) -> int"""
        return ___init__.LinearSystem_getNumLinearSolves(self, *args)


    def getLinearItersLastSolve(self, *args):
        """getLinearItersLastSolve(LinearSystem self) -> int"""
        return ___init__.LinearSystem_getLinearItersLastSolve(self, *args)


    def getLinearItersTotal(self, *args):
        """getLinearItersTotal(LinearSystem self) -> int"""
        return ___init__.LinearSystem_getLinearItersTotal(self, *args)


    def getAchievedTol(self, *args):
        """getAchievedTol(LinearSystem self) -> double"""
        return ___init__.LinearSystem_getAchievedTol(self, *args)

    def __disown__(self):
        self.this.disown()
        ___init__.disown_LinearSystem(self)
        return weakref_proxy(self)
LinearSystem_swigregister = ___init__.LinearSystem_swigregister
LinearSystem_swigregister(LinearSystem)

class LinearSystemAztecOO(LinearSystem):
    """Proxy of C++ NOX::Epetra::LinearSystemAztecOO class."""

    __swig_setmethods__ = {}
    for _s in [LinearSystem]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, LinearSystemAztecOO, name, value)
    __swig_getmethods__ = {}
    for _s in [LinearSystem]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, LinearSystemAztecOO, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(NOX::Epetra::LinearSystemAztecOO self, ParameterList printingParams, ParameterList linearSolverParams, Teuchos::RCP< NOX::Epetra::Interface::Required > const & iReq, Vector cloneVector, Teuchos::RCP< NOX::Epetra::Scaling > const scalingObject) -> LinearSystemAztecOO
        __init__(NOX::Epetra::LinearSystemAztecOO self, ParameterList printingParams, ParameterList linearSolverParams, Teuchos::RCP< NOX::Epetra::Interface::Required > const & iReq, Teuchos::RCP< NOX::Epetra::Interface::Jacobian > const & iJac, Teuchos::RCP< Epetra_Operator > const & J, Vector cloneVector, Teuchos::RCP< NOX::Epetra::Scaling > const scalingObject) -> LinearSystemAztecOO
        __init__(NOX::Epetra::LinearSystemAztecOO self, ParameterList printingParams, ParameterList linearSolverParams, Teuchos::RCP< NOX::Epetra::Interface::Required > const & i, Teuchos::RCP< NOX::Epetra::Interface::Preconditioner > const & iPrec, Teuchos::RCP< Epetra_Operator > const & M, Vector cloneVector, Teuchos::RCP< NOX::Epetra::Scaling > const scalingObject) -> LinearSystemAztecOO
        __init__(NOX::Epetra::LinearSystemAztecOO self, ParameterList printingParams, ParameterList linearSolverParams, Teuchos::RCP< NOX::Epetra::Interface::Jacobian > const & iJac, Teuchos::RCP< Epetra_Operator > const & J, Teuchos::RCP< NOX::Epetra::Interface::Preconditioner > const & iPrec, Teuchos::RCP< Epetra_Operator > const & M, Vector cloneVector, Teuchos::RCP< NOX::Epetra::Scaling > const scalingObject) -> LinearSystemAztecOO
        """
        this = ___init__.new_LinearSystemAztecOO(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = ___init__.delete_LinearSystemAztecOO

    def applyJacobian(self, *args):
        """applyJacobian(LinearSystemAztecOO self, Vector input, Vector result) -> bool"""
        return ___init__.LinearSystemAztecOO_applyJacobian(self, *args)


    def applyJacobianTranspose(self, *args):
        """applyJacobianTranspose(LinearSystemAztecOO self, Vector input, Vector result) -> bool"""
        return ___init__.LinearSystemAztecOO_applyJacobianTranspose(self, *args)


    def applyJacobianInverse(self, *args):
        """applyJacobianInverse(LinearSystemAztecOO self, ParameterList linearSolverParams, Vector input, Vector result) -> bool"""
        return ___init__.LinearSystemAztecOO_applyJacobianInverse(self, *args)


    def applyRightPreconditioning(self, *args):
        """applyRightPreconditioning(LinearSystemAztecOO self, bool useTranspose, ParameterList linearSolverParams, Vector input, Vector result) -> bool"""
        return ___init__.LinearSystemAztecOO_applyRightPreconditioning(self, *args)


    def createPreconditioner(self, *args):
        """createPreconditioner(LinearSystemAztecOO self, Vector x, ParameterList linearSolverParams, bool recomputeGraph) -> bool"""
        return ___init__.LinearSystemAztecOO_createPreconditioner(self, *args)


    def destroyPreconditioner(self, *args):
        """destroyPreconditioner(LinearSystemAztecOO self) -> bool"""
        return ___init__.LinearSystemAztecOO_destroyPreconditioner(self, *args)


    def recomputePreconditioner(self, *args):
        """recomputePreconditioner(LinearSystemAztecOO self, Vector x, ParameterList linearSolverParams) -> bool"""
        return ___init__.LinearSystemAztecOO_recomputePreconditioner(self, *args)


    def getPreconditionerPolicy(self, *args):
        """getPreconditionerPolicy(LinearSystemAztecOO self, bool advanceReuseCounter=True) -> NOX::Epetra::LinearSystem::PreconditionerReusePolicyType"""
        return ___init__.LinearSystemAztecOO_getPreconditionerPolicy(self, *args)


    def reset(self, *args):
        """reset(LinearSystemAztecOO self, ParameterList linearSolverParams)"""
        return ___init__.LinearSystemAztecOO_reset(self, *args)


    def getScaling(self, *args):
        """getScaling(LinearSystemAztecOO self) -> Teuchos::RCP< NOX::Epetra::Scaling >"""
        return ___init__.LinearSystemAztecOO_getScaling(self, *args)


    def resetScaling(self, *args):
        """resetScaling(LinearSystemAztecOO self, Teuchos::RCP< NOX::Epetra::Scaling > const & s)"""
        return ___init__.LinearSystemAztecOO_resetScaling(self, *args)


    def computeJacobian(self, *args):
        """computeJacobian(LinearSystemAztecOO self, Vector x) -> bool"""
        return ___init__.LinearSystemAztecOO_computeJacobian(self, *args)


    def getJacobianInterface(self, *args):
        """getJacobianInterface(LinearSystemAztecOO self) -> Teuchos::RCP< NOX::Epetra::Interface::Jacobian const >"""
        return ___init__.LinearSystemAztecOO_getJacobianInterface(self, *args)


    def getPrecInterface(self, *args):
        """getPrecInterface(LinearSystemAztecOO self) -> Teuchos::RCP< NOX::Epetra::Interface::Preconditioner const >"""
        return ___init__.LinearSystemAztecOO_getPrecInterface(self, *args)


    def isPreconditionerConstructed(self, *args):
        """isPreconditionerConstructed(LinearSystemAztecOO self) -> bool"""
        return ___init__.LinearSystemAztecOO_isPreconditionerConstructed(self, *args)


    def hasPreconditioner(self, *args):
        """hasPreconditioner(LinearSystemAztecOO self) -> bool"""
        return ___init__.LinearSystemAztecOO_hasPreconditioner(self, *args)


    def getJacobianOperator(self, *args):
        """
        getJacobianOperator(LinearSystemAztecOO self) -> Teuchos::RCP< Epetra_Operator const >
        getJacobianOperator(LinearSystemAztecOO self) -> Teuchos::RCP< Epetra_Operator >
        """
        return ___init__.LinearSystemAztecOO_getJacobianOperator(self, *args)


    def getPrecOperator(self, *args):
        """getPrecOperator(LinearSystemAztecOO self) -> Teuchos::RCP< Epetra_Operator const >"""
        return ___init__.LinearSystemAztecOO_getPrecOperator(self, *args)


    def getGeneratedPrecOperator(self, *args):
        """
        getGeneratedPrecOperator(LinearSystemAztecOO self) -> Teuchos::RCP< Epetra_Operator const >
        getGeneratedPrecOperator(LinearSystemAztecOO self) -> Teuchos::RCP< Epetra_Operator >
        """
        return ___init__.LinearSystemAztecOO_getGeneratedPrecOperator(self, *args)


    def getTimeCreatePreconditioner(self, *args):
        """getTimeCreatePreconditioner(LinearSystemAztecOO self) -> double"""
        return ___init__.LinearSystemAztecOO_getTimeCreatePreconditioner(self, *args)


    def getTimeApplyJacobianInverse(self, *args):
        """getTimeApplyJacobianInverse(LinearSystemAztecOO self) -> double"""
        return ___init__.LinearSystemAztecOO_getTimeApplyJacobianInverse(self, *args)


    def setJacobianOperatorForSolve(self, *args):
        """setJacobianOperatorForSolve(LinearSystemAztecOO self, Teuchos::RCP< Epetra_Operator const > const & solveJacOp)"""
        return ___init__.LinearSystemAztecOO_setJacobianOperatorForSolve(self, *args)


    def setPrecOperatorForSolve(self, *args):
        """setPrecOperatorForSolve(LinearSystemAztecOO self, Teuchos::RCP< Epetra_Operator const > const & solvePrecOp)"""
        return ___init__.LinearSystemAztecOO_setPrecOperatorForSolve(self, *args)

LinearSystemAztecOO_swigregister = ___init__.LinearSystemAztecOO_swigregister
LinearSystemAztecOO_swigregister(LinearSystemAztecOO)

class ModelEvaluatorInterface(Interface.Required, Interface.Jacobian, Interface.Preconditioner):
    """Proxy of C++ NOX::Epetra::ModelEvaluatorInterface class."""

    __swig_setmethods__ = {}
    for _s in [Interface.Required, Interface.Jacobian, Interface.Preconditioner]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, ModelEvaluatorInterface, name, value)
    __swig_getmethods__ = {}
    for _s in [Interface.Required, Interface.Jacobian, Interface.Preconditioner]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, ModelEvaluatorInterface, name)
    __repr__ = _swig_repr
    __swig_destroy__ = ___init__.delete_ModelEvaluatorInterface

    def computeF(self, *args):
        """computeF(ModelEvaluatorInterface self, Vector x, Vector F, NOX::Epetra::Interface::Required::FillType const fillFlag) -> bool"""
        return ___init__.ModelEvaluatorInterface_computeF(self, *args)


    def computeJacobian(self, *args):
        """computeJacobian(ModelEvaluatorInterface self, Vector x, Operator Jac) -> bool"""
        return ___init__.ModelEvaluatorInterface_computeJacobian(self, *args)


    def computePreconditioner(self, *args):
        """computePreconditioner(ModelEvaluatorInterface self, Vector x, Operator M, ParameterList precParams=None) -> bool"""
        return ___init__.ModelEvaluatorInterface_computePreconditioner(self, *args)


    def inargs_set_p(self, *args):
        """inargs_set_p(ModelEvaluatorInterface self, Teuchos::RCP< Epetra_Vector const > const p, int const l=0) -> bool"""
        return ___init__.ModelEvaluatorInterface_inargs_set_p(self, *args)


    def set_inargs(self, *args):
        """set_inargs(ModelEvaluatorInterface self, EpetraExt::ModelEvaluator::InArgs const & inargs_in) -> bool"""
        return ___init__.ModelEvaluatorInterface_set_inargs(self, *args)


    def __init__(self, *args):
        """__init__(NOX::Epetra::ModelEvaluatorInterface self, ModelEvaluator eeme) -> ModelEvaluatorInterface"""
        this = ___init__.new_ModelEvaluatorInterface(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
ModelEvaluatorInterface_swigregister = ___init__.ModelEvaluatorInterface_swigregister
ModelEvaluatorInterface_swigregister(ModelEvaluatorInterface)


def defaultNonlinearParameters(comm=None, verbosity=0, outputPrec=3,
                               maxIterations=800, tolerance=1.0e-4):
    """
    defaultNonlinearParameters(comm=None, verbosity=0, outputPrec=3,
                               maxIterations=800, tolerance=1.0e-4) -> dict

    Return a dictionary that can serve as a default list of parameters for a NOX
    solver.  Entries can be altered before passing to a NOX solver constructor.

    comm          - Epetra communicator object.  If not provided, the function
                    uses an Epetra.SerialComm communicator.

    verbosity     - A simple indication of verbosity level.  0: errors and test
                    details.  1: debugging, warnings, details, parameters and
                    linear solver details.  2: inner iteration, outer iteration
                    status test and outer iteration.  Default 0.

    outputPrec    - Number of significant digits to output.  Default 3.

    maxIterations - Maximum allowable linear (inner) iterations.  Default 800.

    tolerance     - Linear solver tolerance level.  Default 1.0e-4.
    """
# Communicator
    if comm is None:
        comm = PyTrilinos.Epetra.SerialComm()
    myPID = comm.MyPID()

# Create the printing parameter list
    Utils = PyTrilinos.NOX.Utils
    outputInfo = Utils.Error + Utils.TestDetails
    if verbosity: outputInfo += Utils.Debug      + \
                                Utils.Warning    + \
                                Utils.Details    + \
                                Utils.Parameters + \
                                Utils.LinearSolverDetails
    if verbosity > 1: outputInfo += Utils.InnerIteration           + \
                                    Utils.OuterIterationStatusTest + \
                                    Utils.OuterIteration
    printParams = {"MyPID"              : myPID,
                   "Output Precision"   : outputPrec,
                   "Output Processor"   : 0,
                   "Output Information" : outputInfo}

# Create the linear solver parameter list
    lsParams = {"Aztec Solver"    : "GMRES",
                "Max Iterations"  : maxIterations,
                "Tolerance"       : tolerance,
                "Preconditioner"  : "Ifpack",
                "Max Age Of Prec" : 5       }

# Create the nonlinear solver parameter list
    nlParams = {"Nonlinear Solver" : "Line Search Based",
                "Printing"         : printParams,
                "Line Search"      : {"Method" : "Full Step"},
                "Direction"        : {"Method" : "Newton"},
                "Newton"           : {"Forcing Term Method" : "Constant"},
                "Linear Solver"    : lsParams,
                "Solver Options"   : {"Status Test Check Type" : "Complete"}
                }

    return nlParams

def defaultGroup(nonlinearParameters, initGuess, reqInterface, jacInterface=None,
                 jacobian=None, precInterface=None, preconditioner=None):
    """
    defaultGroup(nonlinearParameters, initGuess, reqInterface, jacInterface=None,
                 jacobian=None, precInterface=None, preconditioner=None) -> Group

    Return a NOX.Epetra.Group based upon the given input arguments:

    nonlinearParameters - a dict with nonlinear parameters.  Can be obtained
                          from defaultNonlinearParameters()
    initGuess           - an initial guess Epetra.Vector.
    reqInterface        - a NOX.Epetra.Interface.Required object that defines
                          the interface to the nonlinear problem.  May be
                          None if both the Jacobian and preconditioner are
                          provided.
    jacInterface        - a NOX.Epetra.Interface.Jacobian object that defines the
                          Jacobian of the nonlinear problem.  Default None.
    jacobian            - if jacInterface is provided, this is the Epetra.Operator
                          that defines the Jacobian matrix.  Default None.
    precInterface       - a NOX.Epetra.Interface.Preconditioner object that defines
                          the preconditioner to the nonlinear problem.  Default None.
    preconditioner      - if precInterface is provided, this is the
                          Epetra.Operator that defines the preconditioner.
                          Default None.
    """

# Sanity checks to prevent more cryptic problems down the road...
    if jacInterface is None or precInterface is None:
        assert isinstance(reqInterface, Interface.Required)
    if jacInterface is not None:
        assert isinstance(jacInterface, Interface.Jacobian        )
        assert isinstance(jacobian    , (PyTrilinos.Epetra.Operator, Epetra.Operator))
    if precInterface is not None:
        assert isinstance(precInterface , Interface.Preconditioner  )
        assert isinstance(preconditioner, (PyTrilinos.Epetra.Operator, Epetra.Operator))

# Extract parameter lists
    printParams = nonlinearParameters["Printing"     ]
    lsParams    = nonlinearParameters["Linear Solver"]

# Construct a NOX.Epetra.Vector from the Epetra.Vector
    clone = Vector(initGuess, Vector.CreateView)

# Construct the linear system
    if jacInterface:
        if precInterface:
            linSys = LinearSystemAztecOO(printParams, lsParams,
                                         jacInterface, jacobian,
                                         precInterface, preconditioner,
                                         clone)
        else:
            linSys = LinearSystemAztecOO(printParams, lsParams,
                                         reqInterface,
                                         jacInterface, jacobian,
                                         clone)
    else:
        if precInterface:
            linSys = LinearSystemAztecOO(printParams, lsParams,
                                         reqInterface,
                                         precInterface, preconditioner,
                                         clone)
        else:
            linSys = LinearSystemAztecOO(printParams, lsParams,
                                         reqInterface,
                                         clone)

# Construct and return the default Group
    group = Group(printParams, reqInterface, clone, linSys)
    group.linSys = linSys   ### By adding linSys as an attribute to the Group
### variable, we ensure that linSys does not get
### destroyed.  This is a workaround for a
### Teuchos::RCP wrapper bug.
    return group

def defaultStatusTest(absTol=None, relTol=None, relGroup=None, updateTol=None,
                      wAbsTol=None, wRelTol=None, maxIters=None,
                      finiteValue=False):
    """
    defaultStatusTest(absTol=None, relTol=None, relGroup=None, updateTol=None,
                      wAbsTol=None, wRelTol=None, maxIters=None,
                      finiteValue=False) -> StatusTest

    Return a StatusTest object based upon the input arguments:

    absTol      - if specified, include an absolute residual status test, using
                  this value as the tolerance
    relTol      - if specified, along with relGroup, include a relative residual
                  status test, using this value as the tolerance
    relGroup    - if specified, along with relTol, include a relative residual
                  status test, using this Group to determine the scaling
    updateTol   - if specified, include an update status test, using this value
                  as the tolerance
    wAbsTol     - if specified, along with wRelTol, include a weighted RMS
                  status test, using this value as the absolute tolerance
    wRelTol     - if specified, along with wAbsTol, include a weighted RMS
                  status test, using this value as the relative tolerance
    maxIters    - if specified, include a maximum iterations status test, using
                  this value as the maximum allowable iterations
    finiteValue - if True, include a finite value status test.  Default False.
    """
# Build the convergence portion of the status test
    StatusTest = PyTrilinos.NOX.StatusTest
    converged  = StatusTest.Combo(StatusTest.Combo.AND)
    converged.tests = [ ]   ### By adding this list of tests as an attribute to
### the StatusTest variables, we ensure that linSys
### does not get destroyed.  This is a workaround
### for a Teuchos::RCP wrapper bug.

    if absTol:
        absTest = StatusTest.NormF(absTol)
        converged.addStatusTest(absTest)
        converged.tests.append(absTest)
    if relGroup and relTol:
        relTest = StatusTest.NormF(relGroup,relTol)
        converged.addStatusTest(relTest)
        converged.tests.append(relTest)
    if wAbsTol and wRelTol:
        wrmsTest = StatusTest.NormWRMS(wRelTol,wAbsTol)
        converged.addStatusTest(wrmsTest)
        converged.tests.append(wrmsTest)
    if updateTol:
        updateTest = StatusTest.NormUpdate(updateTol)
        converged.addStatusTest(updateTest)
        converged.tests.append(updateTest)

# Return if done
    if not (maxIters or finiteValue):
        return converged

# Add the divergence portion of the default status test
    combo = StatusTest.Combo(StatusTest.Combo.OR)
    combo.tests = [ ]
    if finiteValue:
        fvTest = StatusTest.FiniteValue()
        combo.addStatusTest(fvTest)
        combo.tests.append(fvTest)
    combo.addStatusTest(converged)
    combo.tests.append(converged)
    if maxIters:
        maxIterTest = StatusTest.MaxIters(maxIters)
        combo.addStatusTest(maxIterTest)
        combo.tests.append(maxIterTest)
    return combo

def defaultSolver(initGuess, reqInterface, jacInterface=None, jacobian=None,
                  precInterface=None, preconditioner=None, nlParams=None,
                  absTol=1.0e-8, relTol=1.0e-2, relGroup=None, updateTol=1.0e-5,
                  wAbsTol=1.0e-8, wRelTol=1.0e-2, maxIters=20, finiteValue=True):
    """
    defaultSolver(initGuess, reqInterface, jacInterface=None, jacobian=None,
                  precInterface=None, preconditioner=None, nlParams=None) -> Solver

    Return a default NOX Solver based on the given arguments:

    initGuess      - an Epetra.Vector initial guess
    reqInterface   - a NOX.Epetra.Interface.Required object that defines
                     the interface to the nonlinear problem.  May be
                     None if both the Jacobian and preconditioner are
                     provided.
    jacInterface   - a NOX.Epetra.Interface.Jacobian object that defines the
                     Jacobian of the nonlinear problem.  Default None.
    jacobian       - if jacInterface is provided, this should also be provided
                     and is the Epetra.Operator that defines the Jacobian
                     matrix.  Default None. 
    precInterface  - a NOX.Epetra.Interface.Preconditioner object that defines
                     the preconditioner to the nonlinear problem.  Default None.
    preconditioner - if precInterface is provided, this should also be provided
                     and is the Epetra.Operator that defines the preconditioner.
                     Default None.
    nlParams       - dict that contains a list of nonlinear parameters.  Default
                     None, in which case defaultNonlinearParameters() is used.
    absTol         - if not None, include an absolute residual status test,
                     using this value as the tolerance.  Default 1.0e-8.
    relTol         - if not None, include a relative residual status test, using
                     this value as the tolerance.  Default 1.0e-2.
    relGroup       - if relTol is specified, use this Group to determine the
                     scaling.  If relGroup is None, use the result of
                     defaultGroup().  Default None.
    updateTol      - if not None, include an update status test, using this
                     value as the tolerance.  Default 1.0e-5.
    wAbsTol        - if not None, along with wRelTol, include a weighted RMS
                     status test, using this value as the absolute tolerance.
                     Default 1.0e-8.
    wRelTol        - if not None, along with wAbsTol, include a weighted RMS
                     status test, using this value as the relative tolerance.
                     Default 1.0e-2.
    maxIters       - if not None, include a maximum nonlinear iterations status
                     test, using this value as the maximum allowable iterations.
                     Default 20. 
    finiteValue    - if True, include a finite value status test.  Default
                     True. 
    """

# Sanity checks to prevent more cryptic problems down the road...
    if jacInterface is None or precInterface is None:
        assert isinstance(reqInterface, Interface.Required)
    if jacInterface is not None:
        assert isinstance(jacInterface, Interface.Jacobian        )
        assert isinstance(jacobian    , (PyTrilinos.Epetra.Operator, Epetra.Operator))
    if precInterface is not None:
        assert isinstance(precInterface , Interface.Preconditioner  )
        assert isinstance(preconditioner, (PyTrilinos.Epetra.Operator, Epetra.Operator))

# Get the communicator
    comm = initGuess.Comm()

# Get the nonlinear parameters
    if nlParams is None:
        nlParams = defaultNonlinearParameters(comm,2)

# Build the default Group
    group = defaultGroup(nlParams, initGuess, reqInterface, jacInterface,
                         jacobian, precInterface, preconditioner)

# Get the default StatusTest
    if relTol and (relGroup is None): relGroup = group
    statusTest = defaultStatusTest(absTol      = absTol,
                                   relTol      = relTol,
                                   relGroup    = relGroup,
                                   updateTol   = updateTol,
                                   wAbsTol     = wAbsTol,
                                   wRelTol     = wRelTol,
                                   maxIters    = maxIters,
                                   finiteValue = finiteValue)

# Return the default Solver
    solver = PyTrilinos.NOX.Solver.buildSolver(group, statusTest, nlParams)
#solver.group      = group        ### By adding group, statusTest and
    solver.statusTest = statusTest   ### nlParams as attributes to the Solver
    solver.nlParams   = nlParams     ### variable, we ensure that they do not
### get destroyed.  This is a workaround for
### a Teuchos::RCP wrapper bug.
    return solver

# This file is compatible with both classic and new-style classes.


