# This file was automatically generated by SWIG (http://www.swig.org).
# Version 3.0.12
#
# Do not make changes to this file unless you know what you are doing--modify
# the SWIG interface file instead.

"""

PyTrilinos.NOX.Abstract is the python interface to namespace Abstract
of the Trilinos package NOX:

    http://trilinos.sandia.gov/packages/nox

The purpose of NOX.Abstract is to provide base classes from which
concrete NOX interfaces can be derived.  Currently, the only concrete
implementation is for Epetra, in the NOX.Epetra module.

NOX.Abstract provides the following user-level classes:

    * Group            - Class defining a collection of objects needed by NOX
    * PrePostOperator  - Pre- and post-iteration operators
    * MultiVector      - Multivector class
    * Vector           - Vector class

"""


from sys import version_info as _swig_python_version_info
if _swig_python_version_info >= (2, 7, 0):
    def swig_import_helper():
        import importlib
        pkg = __name__.rpartition('.')[0]
        mname = '.'.join((pkg, '_Abstract')).lstrip('.')
        try:
            return importlib.import_module(mname)
        except ImportError:
            return importlib.import_module('_Abstract')
    _Abstract = swig_import_helper()
    del swig_import_helper
elif _swig_python_version_info >= (2, 6, 0):
    def swig_import_helper():
        from os.path import dirname
        import imp
        fp = None
        try:
            fp, pathname, description = imp.find_module('_Abstract', [dirname(__file__)])
        except ImportError:
            import _Abstract
            return _Abstract
        try:
            _mod = imp.load_module('_Abstract', fp, pathname, description)
        finally:
            if fp is not None:
                fp.close()
        return _mod
    _Abstract = swig_import_helper()
    del swig_import_helper
else:
    import _Abstract
del _swig_python_version_info

try:
    _swig_property = property
except NameError:
    pass  # Python < 2.2 doesn't have 'property'.

try:
    import builtins as __builtin__
except ImportError:
    import __builtin__

def _swig_setattr_nondynamic(self, class_type, name, value, static=1):
    if (name == "thisown"):
        return self.this.own(value)
    if (name == "this"):
        if type(value).__name__ == 'SwigPyObject':
            self.__dict__[name] = value
            return
    method = class_type.__swig_setmethods__.get(name, None)
    if method:
        return method(self, value)
    if (not static):
        if _newclass:
            object.__setattr__(self, name, value)
        else:
            self.__dict__[name] = value
    else:
        raise AttributeError("You cannot add attributes to %s" % self)


def _swig_setattr(self, class_type, name, value):
    return _swig_setattr_nondynamic(self, class_type, name, value, 0)


def _swig_getattr(self, class_type, name):
    if (name == "thisown"):
        return self.this.own()
    method = class_type.__swig_getmethods__.get(name, None)
    if method:
        return method(self)
    raise AttributeError("'%s' object has no attribute '%s'" % (class_type.__name__, name))


def _swig_repr(self):
    try:
        strthis = "proxy of " + self.this.__repr__()
    except __builtin__.Exception:
        strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)

try:
    _object = object
    _newclass = 1
except __builtin__.Exception:
    class _object:
        pass
    _newclass = 0

try:
    import weakref
    weakref_proxy = weakref.proxy
except __builtin__.Exception:
    weakref_proxy = lambda x: x


import PyTrilinos.Teuchos
class Group(_object):
    """Proxy of C++ NOX::Abstract::Group class."""

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, Group, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, Group, name)

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    Ok = _Abstract.Group_Ok
    NotDefined = _Abstract.Group_NotDefined
    BadDependency = _Abstract.Group_BadDependency
    NotConverged = _Abstract.Group_NotConverged
    Failed = _Abstract.Group_Failed
    __swig_destroy__ = _Abstract.delete_Group

    def setX(self, *args):
        """setX(Group self, Vector y)"""
        return _Abstract.Group_setX(self, *args)


    def computeX(self, *args):
        """computeX(Group self, Group grp, Vector d, double step)"""
        return _Abstract.Group_computeX(self, *args)


    def computeF(self, *args):
        """computeF(Group self) -> NOX::Abstract::Group::ReturnType"""
        return _Abstract.Group_computeF(self, *args)


    def computeJacobian(self, *args):
        """computeJacobian(Group self) -> NOX::Abstract::Group::ReturnType"""
        return _Abstract.Group_computeJacobian(self, *args)


    def computeGradient(self, *args):
        """computeGradient(Group self) -> NOX::Abstract::Group::ReturnType"""
        return _Abstract.Group_computeGradient(self, *args)


    def computeNewton(self, *args):
        """computeNewton(Group self, ParameterList params) -> NOX::Abstract::Group::ReturnType"""
        return _Abstract.Group_computeNewton(self, *args)


    def applyJacobian(self, *args):
        """applyJacobian(Group self, Vector input, Vector result) -> NOX::Abstract::Group::ReturnType"""
        return _Abstract.Group_applyJacobian(self, *args)


    def applyJacobianTranspose(self, *args):
        """applyJacobianTranspose(Group self, Vector input, Vector result) -> NOX::Abstract::Group::ReturnType"""
        return _Abstract.Group_applyJacobianTranspose(self, *args)


    def applyJacobianInverse(self, *args):
        """applyJacobianInverse(Group self, ParameterList params, Vector input, Vector result) -> NOX::Abstract::Group::ReturnType"""
        return _Abstract.Group_applyJacobianInverse(self, *args)


    def applyRightPreconditioning(self, *args):
        """applyRightPreconditioning(Group self, bool useTranspose, ParameterList params, Vector input, Vector result) -> NOX::Abstract::Group::ReturnType"""
        return _Abstract.Group_applyRightPreconditioning(self, *args)


    def applyJacobianMultiVector(self, *args):
        """applyJacobianMultiVector(Group self, MultiVector input, MultiVector result) -> NOX::Abstract::Group::ReturnType"""
        return _Abstract.Group_applyJacobianMultiVector(self, *args)


    def applyJacobianTransposeMultiVector(self, *args):
        """applyJacobianTransposeMultiVector(Group self, MultiVector input, MultiVector result) -> NOX::Abstract::Group::ReturnType"""
        return _Abstract.Group_applyJacobianTransposeMultiVector(self, *args)


    def applyJacobianInverseMultiVector(self, *args):
        """applyJacobianInverseMultiVector(Group self, ParameterList params, MultiVector input, MultiVector result) -> NOX::Abstract::Group::ReturnType"""
        return _Abstract.Group_applyJacobianInverseMultiVector(self, *args)


    def applyRightPreconditioningMultiVector(self, *args):
        """applyRightPreconditioningMultiVector(Group self, bool useTranspose, ParameterList params, MultiVector input, MultiVector result) -> NOX::Abstract::Group::ReturnType"""
        return _Abstract.Group_applyRightPreconditioningMultiVector(self, *args)


    def isF(self, *args):
        """isF(Group self) -> bool"""
        return _Abstract.Group_isF(self, *args)


    def isJacobian(self, *args):
        """isJacobian(Group self) -> bool"""
        return _Abstract.Group_isJacobian(self, *args)


    def isGradient(self, *args):
        """isGradient(Group self) -> bool"""
        return _Abstract.Group_isGradient(self, *args)


    def isNewton(self, *args):
        """isNewton(Group self) -> bool"""
        return _Abstract.Group_isNewton(self, *args)


    def getNormF(self, *args):
        """getNormF(Group self) -> double"""
        return _Abstract.Group_getNormF(self, *args)


    def getX(self, *args):
        """getX(Group self) -> Teuchos::RCP< NOX::Abstract::Vector const >"""
        return _Abstract.Group_getX(self, *args)


    def getF(self, *args):
        """getF(Group self) -> Teuchos::RCP< NOX::Abstract::Vector const >"""
        return _Abstract.Group_getF(self, *args)


    def getGradient(self, *args):
        """getGradient(Group self) -> Teuchos::RCP< NOX::Abstract::Vector const >"""
        return _Abstract.Group_getGradient(self, *args)


    def getNewton(self, *args):
        """getNewton(Group self) -> Teuchos::RCP< NOX::Abstract::Vector const >"""
        return _Abstract.Group_getNewton(self, *args)


    def getNormLastLinearSolveResidual(self, *args):
        """getNormLastLinearSolveResidual(Group self, double & residual) -> NOX::Abstract::Group::ReturnType"""
        return _Abstract.Group_getNormLastLinearSolveResidual(self, *args)


    def clone(self, *args):
        """clone(Group self, NOX::CopyType type) -> Teuchos::RCP< NOX::Abstract::Group >"""
        return _Abstract.Group_clone(self, *args)

Group_swigregister = _Abstract.Group_swigregister
Group_swigregister(Group)

class PrePostOperator(_object):
    """Proxy of C++ NOX::Abstract::PrePostOperator class."""

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, PrePostOperator, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, PrePostOperator, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(NOX::Abstract::PrePostOperator self) -> PrePostOperator
        __init__(NOX::Abstract::PrePostOperator self, PrePostOperator arg2) -> PrePostOperator
        """
        if self.__class__ == PrePostOperator:
            _self = None
        else:
            _self = self
        this = _Abstract.new_PrePostOperator(_self, *args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _Abstract.delete_PrePostOperator

    def runPreIterate(self, *args):
        """runPreIterate(PrePostOperator self, NOX::Solver::Generic const & solver)"""
        return _Abstract.PrePostOperator_runPreIterate(self, *args)


    def runPostIterate(self, *args):
        """runPostIterate(PrePostOperator self, NOX::Solver::Generic const & solver)"""
        return _Abstract.PrePostOperator_runPostIterate(self, *args)


    def runPreSolve(self, *args):
        """runPreSolve(PrePostOperator self, NOX::Solver::Generic const & solver)"""
        return _Abstract.PrePostOperator_runPreSolve(self, *args)


    def runPostSolve(self, *args):
        """runPostSolve(PrePostOperator self, NOX::Solver::Generic const & solver)"""
        return _Abstract.PrePostOperator_runPostSolve(self, *args)

    def __disown__(self):
        self.this.disown()
        _Abstract.disown_PrePostOperator(self)
        return weakref_proxy(self)
PrePostOperator_swigregister = _Abstract.PrePostOperator_swigregister
PrePostOperator_swigregister(PrePostOperator)

class MultiVector(_object):
    """Proxy of C++ NOX::Abstract::MultiVector class."""

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, MultiVector, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, MultiVector, name)

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _Abstract.delete_MultiVector

    def init(self, *args):
        """init(MultiVector self, double gamma) -> MultiVector"""
        return _Abstract.MultiVector_init(self, *args)


    def random(self, *args):
        """random(MultiVector self, bool useSeed=False, int seed=1) -> MultiVector"""
        return _Abstract.MultiVector_random(self, *args)


    def setBlock(self, *args):
        """setBlock(MultiVector self, MultiVector source, std::vector< int,std::allocator< int > > const & index) -> MultiVector"""
        return _Abstract.MultiVector_setBlock(self, *args)


    def augment(self, *args):
        """augment(MultiVector self, MultiVector source) -> MultiVector"""
        return _Abstract.MultiVector_augment(self, *args)


    def scale(self, *args):
        """scale(MultiVector self, double gamma) -> MultiVector"""
        return _Abstract.MultiVector_scale(self, *args)


    def update(self, *args):
        """
        update(MultiVector self, double alpha, MultiVector a, double gamma=0.0) -> MultiVector
        update(MultiVector self, double alpha, MultiVector a, double beta, MultiVector b, double gamma=0.0) -> MultiVector
        update(MultiVector self, Teuchos::ETransp transb, double alpha, MultiVector a, NOX::Abstract::MultiVector::DenseMatrix const & b, double gamma=0.0) -> MultiVector
        """
        return _Abstract.MultiVector_update(self, *args)


    def clone(self, *args):
        """clone(MultiVector self, NOX::CopyType type) -> Teuchos::RCP< NOX::Abstract::MultiVector >"""
        return _Abstract.MultiVector_clone(self, *args)


    def subCopy(self, *args):
        """subCopy(MultiVector self, std::vector< int,std::allocator< int > > const & index) -> Teuchos::RCP< NOX::Abstract::MultiVector >"""
        return _Abstract.MultiVector_subCopy(self, *args)


    def subView(self, *args):
        """subView(MultiVector self, std::vector< int,std::allocator< int > > const & index) -> Teuchos::RCP< NOX::Abstract::MultiVector >"""
        return _Abstract.MultiVector_subView(self, *args)


    def norm(self, *args):
        """norm(MultiVector self, std::vector< double,std::allocator< double > > & result, NOX::Abstract::Vector::NormType type)"""
        return _Abstract.MultiVector_norm(self, *args)


    def multiply(self, *args):
        """multiply(MultiVector self, double alpha, MultiVector y, NOX::Abstract::MultiVector::DenseMatrix & b)"""
        return _Abstract.MultiVector_multiply(self, *args)


    def length(self, *args):
        """length(MultiVector self) -> NOX::size_type"""
        return _Abstract.MultiVector_length(self, *args)


    def numVectors(self, *args):
        """numVectors(MultiVector self) -> int"""
        return _Abstract.MultiVector_numVectors(self, *args)


    def _print(self, *args):
        """_print(MultiVector self, std::ostream & stream)"""
        return _Abstract.MultiVector__print(self, *args)

MultiVector_swigregister = _Abstract.MultiVector_swigregister
MultiVector_swigregister(MultiVector)

DeepCopy = _Abstract.DeepCopy
ShapeCopy = _Abstract.ShapeCopy
class Vector(_object):
    """Proxy of C++ NOX::Abstract::Vector class."""

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, Vector, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, Vector, name)

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    TwoNorm = _Abstract.Vector_TwoNorm
    OneNorm = _Abstract.Vector_OneNorm
    MaxNorm = _Abstract.Vector_MaxNorm
    __swig_destroy__ = _Abstract.delete_Vector

    def init(self, *args):
        """init(Vector self, double gamma) -> Vector"""
        return _Abstract.Vector_init(self, *args)


    def random(self, *args):
        """random(Vector self, bool useSeed=False, int seed=1) -> Vector"""
        return _Abstract.Vector_random(self, *args)


    def abs(self, *args):
        """abs(Vector self, Vector y) -> Vector"""
        return _Abstract.Vector_abs(self, *args)


    def reciprocal(self, *args):
        """reciprocal(Vector self, Vector y) -> Vector"""
        return _Abstract.Vector_reciprocal(self, *args)


    def scale(self, *args):
        """
        scale(Vector self, double gamma) -> Vector
        scale(Vector self, Vector a) -> Vector
        """
        return _Abstract.Vector_scale(self, *args)


    def update(self, *args):
        """
        update(Vector self, double alpha, Vector a, double gamma=0.0) -> Vector
        update(Vector self, double alpha, Vector a, double beta, Vector b, double gamma=0.0) -> Vector
        """
        return _Abstract.Vector_update(self, *args)


    def clone(self, *args):
        """clone(Vector self, NOX::CopyType type) -> Teuchos::RCP< NOX::Abstract::Vector >"""
        return _Abstract.Vector_clone(self, *args)


    def createMultiVector(self, *args):
        """
        createMultiVector(Vector self, NOX::Abstract::Vector const *const * vecs, int numVecs, NOX::CopyType type) -> Teuchos::RCP< NOX::Abstract::MultiVector >
        createMultiVector(Vector self, int numVecs, NOX::CopyType type) -> Teuchos::RCP< NOX::Abstract::MultiVector >
        """
        return _Abstract.Vector_createMultiVector(self, *args)


    def norm(self, *args):
        """
        norm(Vector self, NOX::Abstract::Vector::NormType type) -> double
        norm(Vector self, Vector weights) -> double
        """
        return _Abstract.Vector_norm(self, *args)


    def innerProduct(self, *args):
        """innerProduct(Vector self, Vector y) -> double"""
        return _Abstract.Vector_innerProduct(self, *args)


    def length(self, *args):
        """length(Vector self) -> NOX::size_type"""
        return _Abstract.Vector_length(self, *args)


    def _print(self, *args):
        """_print(Vector self, std::ostream & stream)"""
        return _Abstract.Vector__print(self, *args)

Vector_swigregister = _Abstract.Vector_swigregister
Vector_swigregister(Vector)

# This file is compatible with both classic and new-style classes.


