# This file was automatically generated by SWIG (http://www.swig.org).
# Version 3.0.12
#
# Do not make changes to this file unless you know what you are doing--modify
# the SWIG interface file instead.

"""

PyTrilinos.LOCA.MultiContinuation is the python interface to namespace
MultiContinuation of the Trilinos continuation algorithm package LOCA:

    http://trilinos.sandia.gov/packages/nox

The purpose of LOCA.MultiContinuation is to provide groups and vectors
for multi-parameter continuation.  The python version of
LOCA.MultiContinuation supports the following classes:

    * AbstractGroup            - LOCA abstract interface for continuation,
                                 derived from the NOX.Abstract.Group.  This
                                 abstract class provides the interface
                                 necessary to perform continuation, i.e.,
                                 compute families of solutions to F(x,p) = 0
    * FiniteDifferenceGroup    - Concrete class that provides a concrete
                                 implementation of the computeDfDp() method of
                                 the LOCA.Continuation.AbstractGroup using
                                 first-order finite differencing
    * ConstraintInterface      - Abstract interface for the constraint portion
                                 of a constrained nonlinear system
    * ConstraintInterfaceMVDX  - Abstract interface for the constraint portion
                                 of a constrained nonlinear system for
                                 constraints that support computing a solution
                                 component derivative as a multi-vector
    * ExtendedMultiVector      - MultiVector class to hold solution vectors,
                                 Newton vectors, etc. for continuation equations
    * ExtendedVector           - Vector class to hold solution vectors, Newton
                                 vectors, etc. for continuation equations
    * Factory                  - Factory for creating continuation strategy
                                 objects

"""


from sys import version_info as _swig_python_version_info
if _swig_python_version_info >= (2, 7, 0):
    def swig_import_helper():
        import importlib
        pkg = __name__.rpartition('.')[0]
        mname = '.'.join((pkg, '_MultiContinuation')).lstrip('.')
        try:
            return importlib.import_module(mname)
        except ImportError:
            return importlib.import_module('_MultiContinuation')
    _MultiContinuation = swig_import_helper()
    del swig_import_helper
elif _swig_python_version_info >= (2, 6, 0):
    def swig_import_helper():
        from os.path import dirname
        import imp
        fp = None
        try:
            fp, pathname, description = imp.find_module('_MultiContinuation', [dirname(__file__)])
        except ImportError:
            import _MultiContinuation
            return _MultiContinuation
        try:
            _mod = imp.load_module('_MultiContinuation', fp, pathname, description)
        finally:
            if fp is not None:
                fp.close()
        return _mod
    _MultiContinuation = swig_import_helper()
    del swig_import_helper
else:
    import _MultiContinuation
del _swig_python_version_info

try:
    _swig_property = property
except NameError:
    pass  # Python < 2.2 doesn't have 'property'.

try:
    import builtins as __builtin__
except ImportError:
    import __builtin__

def _swig_setattr_nondynamic(self, class_type, name, value, static=1):
    if (name == "thisown"):
        return self.this.own(value)
    if (name == "this"):
        if type(value).__name__ == 'SwigPyObject':
            self.__dict__[name] = value
            return
    method = class_type.__swig_setmethods__.get(name, None)
    if method:
        return method(self, value)
    if (not static):
        if _newclass:
            object.__setattr__(self, name, value)
        else:
            self.__dict__[name] = value
    else:
        raise AttributeError("You cannot add attributes to %s" % self)


def _swig_setattr(self, class_type, name, value):
    return _swig_setattr_nondynamic(self, class_type, name, value, 0)


def _swig_getattr(self, class_type, name):
    if (name == "thisown"):
        return self.this.own()
    method = class_type.__swig_getmethods__.get(name, None)
    if method:
        return method(self)
    raise AttributeError("'%s' object has no attribute '%s'" % (class_type.__name__, name))


def _swig_repr(self):
    try:
        strthis = "proxy of " + self.this.__repr__()
    except __builtin__.Exception:
        strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)

try:
    _object = object
    _newclass = 1
except __builtin__.Exception:
    class _object:
        pass
    _newclass = 0

try:
    import weakref
    weakref_proxy = weakref.proxy
except __builtin__.Exception:
    weakref_proxy = lambda x: x


import PyTrilinos.Teuchos
import PyTrilinos.NOX.Abstract
import Extended
class AbstractGroup(PyTrilinos.NOX.Abstract.Group):
    """Proxy of C++ LOCA::MultiContinuation::AbstractGroup class."""

    __swig_setmethods__ = {}
    for _s in [PyTrilinos.NOX.Abstract.Group]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, AbstractGroup, name, value)
    __swig_getmethods__ = {}
    for _s in [PyTrilinos.NOX.Abstract.Group]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, AbstractGroup, name)

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _MultiContinuation.delete_AbstractGroup

    def copy(self, *args):
        """copy(AbstractGroup self, Group source)"""
        return _MultiContinuation.AbstractGroup_copy(self, *args)


    def setParamsMulti(self, *args):
        """setParamsMulti(AbstractGroup self, std::vector< int,std::allocator< int > > const & paramIDs, NOX::Abstract::MultiVector::DenseMatrix const & vals)"""
        return _MultiContinuation.AbstractGroup_setParamsMulti(self, *args)


    def setParams(self, *args):
        """setParams(AbstractGroup self, LOCA::ParameterVector const & p)"""
        return _MultiContinuation.AbstractGroup_setParams(self, *args)


    def setParam(self, *args):
        """
        setParam(AbstractGroup self, int paramID, double val)
        setParam(AbstractGroup self, std::string paramID, double val)
        """
        return _MultiContinuation.AbstractGroup_setParam(self, *args)


    def getParams(self, *args):
        """getParams(AbstractGroup self) -> LOCA::ParameterVector const &"""
        return _MultiContinuation.AbstractGroup_getParams(self, *args)


    def getParam(self, *args):
        """
        getParam(AbstractGroup self, int paramID) -> double
        getParam(AbstractGroup self, std::string paramID) -> double
        """
        return _MultiContinuation.AbstractGroup_getParam(self, *args)


    def computeDfDpMulti(self, *args):
        """computeDfDpMulti(AbstractGroup self, std::vector< int,std::allocator< int > > const & paramIDs, MultiVector dfdp, bool isValidF) -> NOX::Abstract::Group::ReturnType"""
        return _MultiContinuation.AbstractGroup_computeDfDpMulti(self, *args)


    def preProcessContinuationStep(self, *args):
        """preProcessContinuationStep(AbstractGroup self, LOCA::Abstract::Iterator::StepStatus stepStatus)"""
        return _MultiContinuation.AbstractGroup_preProcessContinuationStep(self, *args)


    def postProcessContinuationStep(self, *args):
        """postProcessContinuationStep(AbstractGroup self, LOCA::Abstract::Iterator::StepStatus stepStatus)"""
        return _MultiContinuation.AbstractGroup_postProcessContinuationStep(self, *args)


    def projectToDraw(self, *args):
        """projectToDraw(AbstractGroup self, Vector x, double * px)"""
        return _MultiContinuation.AbstractGroup_projectToDraw(self, *args)


    def projectToDrawDimension(self, *args):
        """projectToDrawDimension(AbstractGroup self) -> int"""
        return _MultiContinuation.AbstractGroup_projectToDrawDimension(self, *args)


    def computeScaledDotProduct(self, *args):
        """computeScaledDotProduct(AbstractGroup self, Vector a, Vector b) -> double"""
        return _MultiContinuation.AbstractGroup_computeScaledDotProduct(self, *args)


    def printSolution(self, *args):
        """
        printSolution(AbstractGroup self, double const conParam)
        printSolution(AbstractGroup self, Vector x_, double const conParam)
        """
        return _MultiContinuation.AbstractGroup_printSolution(self, *args)


    def scaleVector(self, *args):
        """scaleVector(AbstractGroup self, Vector x)"""
        return _MultiContinuation.AbstractGroup_scaleVector(self, *args)

AbstractGroup_swigregister = _MultiContinuation.AbstractGroup_swigregister
AbstractGroup_swigregister(AbstractGroup)

class FiniteDifferenceGroup(AbstractGroup):
    """Proxy of C++ LOCA::MultiContinuation::FiniteDifferenceGroup class."""

    __swig_setmethods__ = {}
    for _s in [AbstractGroup]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, FiniteDifferenceGroup, name, value)
    __swig_getmethods__ = {}
    for _s in [AbstractGroup]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, FiniteDifferenceGroup, name)

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _MultiContinuation.delete_FiniteDifferenceGroup

    def copy(self, *args):
        """copy(FiniteDifferenceGroup self, Group source)"""
        return _MultiContinuation.FiniteDifferenceGroup_copy(self, *args)


    def setDerivUtils(self, *args):
        """setDerivUtils(FiniteDifferenceGroup self, Teuchos::RCP< LOCA::DerivUtils > const & deriv)"""
        return _MultiContinuation.FiniteDifferenceGroup_setDerivUtils(self, *args)


    def computeDfDpMulti(self, *args):
        """computeDfDpMulti(FiniteDifferenceGroup self, std::vector< int,std::allocator< int > > const & paramIDs, MultiVector dfdp, bool isValidF) -> NOX::Abstract::Group::ReturnType"""
        return _MultiContinuation.FiniteDifferenceGroup_computeDfDpMulti(self, *args)

FiniteDifferenceGroup_swigregister = _MultiContinuation.FiniteDifferenceGroup_swigregister
FiniteDifferenceGroup_swigregister(FiniteDifferenceGroup)

class ConstraintInterface(_object):
    """Proxy of C++ LOCA::MultiContinuation::ConstraintInterface class."""

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, ConstraintInterface, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, ConstraintInterface, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """__init__(LOCA::MultiContinuation::ConstraintInterface self) -> ConstraintInterface"""
        if self.__class__ == ConstraintInterface:
            _self = None
        else:
            _self = self
        this = _MultiContinuation.new_ConstraintInterface(_self, *args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _MultiContinuation.delete_ConstraintInterface

    def copy(self, *args):
        """copy(ConstraintInterface self, ConstraintInterface source)"""
        return _MultiContinuation.ConstraintInterface_copy(self, *args)


    def clone(self, *args):
        """clone(ConstraintInterface self, NOX::CopyType type) -> Teuchos::RCP< LOCA::MultiContinuation::ConstraintInterface >"""
        return _MultiContinuation.ConstraintInterface_clone(self, *args)


    def numConstraints(self, *args):
        """numConstraints(ConstraintInterface self) -> int"""
        return _MultiContinuation.ConstraintInterface_numConstraints(self, *args)


    def setX(self, *args):
        """setX(ConstraintInterface self, Vector x)"""
        return _MultiContinuation.ConstraintInterface_setX(self, *args)


    def setParam(self, *args):
        """setParam(ConstraintInterface self, int paramID, double val)"""
        return _MultiContinuation.ConstraintInterface_setParam(self, *args)


    def setParams(self, *args):
        """setParams(ConstraintInterface self, std::vector< int,std::allocator< int > > const & paramIDs, NOX::Abstract::MultiVector::DenseMatrix const & vals)"""
        return _MultiContinuation.ConstraintInterface_setParams(self, *args)


    def computeConstraints(self, *args):
        """computeConstraints(ConstraintInterface self) -> NOX::Abstract::Group::ReturnType"""
        return _MultiContinuation.ConstraintInterface_computeConstraints(self, *args)


    def computeDX(self, *args):
        """computeDX(ConstraintInterface self) -> NOX::Abstract::Group::ReturnType"""
        return _MultiContinuation.ConstraintInterface_computeDX(self, *args)


    def computeDP(self, *args):
        """computeDP(ConstraintInterface self, std::vector< int,std::allocator< int > > const & paramIDs, NOX::Abstract::MultiVector::DenseMatrix & dgdp, bool isValidG) -> NOX::Abstract::Group::ReturnType"""
        return _MultiContinuation.ConstraintInterface_computeDP(self, *args)


    def isConstraints(self, *args):
        """isConstraints(ConstraintInterface self) -> bool"""
        return _MultiContinuation.ConstraintInterface_isConstraints(self, *args)


    def isDX(self, *args):
        """isDX(ConstraintInterface self) -> bool"""
        return _MultiContinuation.ConstraintInterface_isDX(self, *args)


    def getConstraints(self, *args):
        """getConstraints(ConstraintInterface self) -> NOX::Abstract::MultiVector::DenseMatrix const &"""
        return _MultiContinuation.ConstraintInterface_getConstraints(self, *args)


    def multiplyDX(self, *args):
        """multiplyDX(ConstraintInterface self, double alpha, MultiVector input_x, NOX::Abstract::MultiVector::DenseMatrix & result_p) -> NOX::Abstract::Group::ReturnType"""
        return _MultiContinuation.ConstraintInterface_multiplyDX(self, *args)


    def addDX(self, *args):
        """addDX(ConstraintInterface self, Teuchos::ETransp transb, double alpha, NOX::Abstract::MultiVector::DenseMatrix const & b, double beta, MultiVector result_x) -> NOX::Abstract::Group::ReturnType"""
        return _MultiContinuation.ConstraintInterface_addDX(self, *args)


    def isDXZero(self, *args):
        """isDXZero(ConstraintInterface self) -> bool"""
        return _MultiContinuation.ConstraintInterface_isDXZero(self, *args)


    def preProcessContinuationStep(self, *args):
        """preProcessContinuationStep(ConstraintInterface self, LOCA::Abstract::Iterator::StepStatus stepStatus)"""
        return _MultiContinuation.ConstraintInterface_preProcessContinuationStep(self, *args)


    def postProcessContinuationStep(self, *args):
        """postProcessContinuationStep(ConstraintInterface self, LOCA::Abstract::Iterator::StepStatus stepStatus)"""
        return _MultiContinuation.ConstraintInterface_postProcessContinuationStep(self, *args)

    def __disown__(self):
        self.this.disown()
        _MultiContinuation.disown_ConstraintInterface(self)
        return weakref_proxy(self)
ConstraintInterface_swigregister = _MultiContinuation.ConstraintInterface_swigregister
ConstraintInterface_swigregister(ConstraintInterface)

class ConstraintInterfaceMVDX(ConstraintInterface):
    """Proxy of C++ LOCA::MultiContinuation::ConstraintInterfaceMVDX class."""

    __swig_setmethods__ = {}
    for _s in [ConstraintInterface]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, ConstraintInterfaceMVDX, name, value)
    __swig_getmethods__ = {}
    for _s in [ConstraintInterface]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, ConstraintInterfaceMVDX, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """__init__(LOCA::MultiContinuation::ConstraintInterfaceMVDX self) -> ConstraintInterfaceMVDX"""
        if self.__class__ == ConstraintInterfaceMVDX:
            _self = None
        else:
            _self = self
        this = _MultiContinuation.new_ConstraintInterfaceMVDX(_self, *args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _MultiContinuation.delete_ConstraintInterfaceMVDX

    def getDX(self, *args):
        """getDX(ConstraintInterfaceMVDX self) -> MultiVector"""
        return _MultiContinuation.ConstraintInterfaceMVDX_getDX(self, *args)


    def multiplyDX(self, *args):
        """multiplyDX(ConstraintInterfaceMVDX self, double alpha, MultiVector input_x, NOX::Abstract::MultiVector::DenseMatrix & result_p) -> NOX::Abstract::Group::ReturnType"""
        return _MultiContinuation.ConstraintInterfaceMVDX_multiplyDX(self, *args)


    def addDX(self, *args):
        """addDX(ConstraintInterfaceMVDX self, Teuchos::ETransp transb, double alpha, NOX::Abstract::MultiVector::DenseMatrix const & b, double beta, MultiVector result_x) -> NOX::Abstract::Group::ReturnType"""
        return _MultiContinuation.ConstraintInterfaceMVDX_addDX(self, *args)

    def __disown__(self):
        self.this.disown()
        _MultiContinuation.disown_ConstraintInterfaceMVDX(self)
        return weakref_proxy(self)
ConstraintInterfaceMVDX_swigregister = _MultiContinuation.ConstraintInterfaceMVDX_swigregister
ConstraintInterfaceMVDX_swigregister(ConstraintInterfaceMVDX)

class ExtendedMultiVector(Extended.MultiVector):
    """Proxy of C++ LOCA::MultiContinuation::ExtendedMultiVector class."""

    __swig_setmethods__ = {}
    for _s in [Extended.MultiVector]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, ExtendedMultiVector, name, value)
    __swig_getmethods__ = {}
    for _s in [Extended.MultiVector]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, ExtendedMultiVector, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(LOCA::MultiContinuation::ExtendedMultiVector self, Teuchos::RCP< LOCA::GlobalData > const & global_data, Vector xVec, int nColumns, int nScalarRows, NOX::CopyType type) -> ExtendedMultiVector
        __init__(LOCA::MultiContinuation::ExtendedMultiVector self, Teuchos::RCP< LOCA::GlobalData > const & global_data, MultiVector xVec, int nScalarRows) -> ExtendedMultiVector
        __init__(LOCA::MultiContinuation::ExtendedMultiVector self, Teuchos::RCP< LOCA::GlobalData > const & global_data, MultiVector xVec, NOX::Abstract::MultiVector::DenseMatrix const & params) -> ExtendedMultiVector
        __init__(LOCA::MultiContinuation::ExtendedMultiVector self, ExtendedMultiVector source, NOX::CopyType type) -> ExtendedMultiVector
        __init__(LOCA::MultiContinuation::ExtendedMultiVector self, ExtendedMultiVector source, int nColumns) -> ExtendedMultiVector
        __init__(LOCA::MultiContinuation::ExtendedMultiVector self, ExtendedMultiVector source, std::vector< int,std::allocator< int > > const & index, bool view) -> ExtendedMultiVector
        """
        this = _MultiContinuation.new_ExtendedMultiVector(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _MultiContinuation.delete_ExtendedMultiVector

    def clone(self, *args):
        """clone(ExtendedMultiVector self, NOX::CopyType type) -> Teuchos::RCP< NOX::Abstract::MultiVector >"""
        return _MultiContinuation.ExtendedMultiVector_clone(self, *args)


    def subCopy(self, *args):
        """subCopy(ExtendedMultiVector self, std::vector< int,std::allocator< int > > const & index) -> Teuchos::RCP< NOX::Abstract::MultiVector >"""
        return _MultiContinuation.ExtendedMultiVector_subCopy(self, *args)


    def subView(self, *args):
        """subView(ExtendedMultiVector self, std::vector< int,std::allocator< int > > const & index) -> Teuchos::RCP< NOX::Abstract::MultiVector >"""
        return _MultiContinuation.ExtendedMultiVector_subView(self, *args)


    def getXMultiVec(self, *args):
        """
        getXMultiVec(ExtendedMultiVector self) -> Teuchos::RCP< NOX::Abstract::MultiVector const >
        getXMultiVec(ExtendedMultiVector self) -> Teuchos::RCP< NOX::Abstract::MultiVector >
        """
        return _MultiContinuation.ExtendedMultiVector_getXMultiVec(self, *args)

ExtendedMultiVector_swigregister = _MultiContinuation.ExtendedMultiVector_swigregister
ExtendedMultiVector_swigregister(ExtendedMultiVector)

class ExtendedVector(Extended.Vector):
    """Proxy of C++ LOCA::MultiContinuation::ExtendedVector class."""

    __swig_setmethods__ = {}
    for _s in [Extended.Vector]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, ExtendedVector, name, value)
    __swig_getmethods__ = {}
    for _s in [Extended.Vector]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, ExtendedVector, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(LOCA::MultiContinuation::ExtendedVector self, Teuchos::RCP< LOCA::GlobalData > const & global_data, Vector xVec, int nScalars) -> ExtendedVector
        __init__(LOCA::MultiContinuation::ExtendedVector self, ExtendedVector source, NOX::CopyType type) -> ExtendedVector
        """
        this = _MultiContinuation.new_ExtendedVector(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _MultiContinuation.delete_ExtendedVector

    def clone(self, *args):
        """clone(ExtendedVector self, NOX::CopyType type) -> Teuchos::RCP< NOX::Abstract::Vector >"""
        return _MultiContinuation.ExtendedVector_clone(self, *args)


    def getXVec(self, *args):
        """
        getXVec(ExtendedVector self) -> Teuchos::RCP< NOX::Abstract::Vector const >
        getXVec(ExtendedVector self) -> Teuchos::RCP< NOX::Abstract::Vector >
        """
        return _MultiContinuation.ExtendedVector_getXVec(self, *args)

ExtendedVector_swigregister = _MultiContinuation.ExtendedVector_swigregister
ExtendedVector_swigregister(ExtendedVector)

class Factory(_object):
    """Proxy of C++ LOCA::MultiContinuation::Factory class."""

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, Factory, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, Factory, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """__init__(LOCA::MultiContinuation::Factory self, Teuchos::RCP< LOCA::GlobalData > const & global_data) -> Factory"""
        this = _MultiContinuation.new_Factory(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _MultiContinuation.delete_Factory

    def create(self, *args):
        """create(Factory self, Teuchos::RCP< LOCA::Parameter::SublistParser > const & topParams, Teuchos::RCP< Teuchos::ParameterList > const & stepperParams, Teuchos::RCP< LOCA::MultiContinuation::AbstractGroup > const & grp, Teuchos::RCP< LOCA::MultiPredictor::AbstractStrategy > const & pred, std::vector< int,std::allocator< int > > const & paramIDs) -> Teuchos::RCP< LOCA::MultiContinuation::AbstractStrategy >"""
        return _MultiContinuation.Factory_create(self, *args)


    def strategyName(self, *args):
        """strategyName(Factory self, ParameterList stepperParams) -> std::string const &"""
        return _MultiContinuation.Factory_strategyName(self, *args)

Factory_swigregister = _MultiContinuation.Factory_swigregister
Factory_swigregister(Factory)

# This file is compatible with both classic and new-style classes.


