# This file was automatically generated by SWIG (http://www.swig.org).
# Version 3.0.12
#
# Do not make changes to this file unless you know what you are doing--modify
# the SWIG interface file instead.

"""

PyTrilinos.LOCA.Epetra is the python interface to namespace Epetra of
the Trilinos continuation algorithm package LOCA:

    http://trilinos.sandia.gov/packages/nox

The purpose of LOCA.Epetra is to provide an extension of the
NOX.Epetra.Group to LOCA.  The python version of LOCA.Epetra supports
the following classes:

    * Group  - Extension of the NOX.Epetra.Group to LOCA

"""


from sys import version_info as _swig_python_version_info
if _swig_python_version_info >= (2, 7, 0):
    def swig_import_helper():
        import importlib
        pkg = __name__.rpartition('.')[0]
        mname = '.'.join((pkg, '___init__')).lstrip('.')
        try:
            return importlib.import_module(mname)
        except ImportError:
            return importlib.import_module('___init__')
    ___init__ = swig_import_helper()
    del swig_import_helper
elif _swig_python_version_info >= (2, 6, 0):
    def swig_import_helper():
        from os.path import dirname
        import imp
        fp = None
        try:
            fp, pathname, description = imp.find_module('___init__', [dirname(__file__)])
        except ImportError:
            import ___init__
            return ___init__
        try:
            _mod = imp.load_module('___init__', fp, pathname, description)
        finally:
            if fp is not None:
                fp.close()
        return _mod
    ___init__ = swig_import_helper()
    del swig_import_helper
else:
    import ___init__
del _swig_python_version_info

try:
    _swig_property = property
except NameError:
    pass  # Python < 2.2 doesn't have 'property'.

try:
    import builtins as __builtin__
except ImportError:
    import __builtin__

def _swig_setattr_nondynamic(self, class_type, name, value, static=1):
    if (name == "thisown"):
        return self.this.own(value)
    if (name == "this"):
        if type(value).__name__ == 'SwigPyObject':
            self.__dict__[name] = value
            return
    method = class_type.__swig_setmethods__.get(name, None)
    if method:
        return method(self, value)
    if (not static):
        if _newclass:
            object.__setattr__(self, name, value)
        else:
            self.__dict__[name] = value
    else:
        raise AttributeError("You cannot add attributes to %s" % self)


def _swig_setattr(self, class_type, name, value):
    return _swig_setattr_nondynamic(self, class_type, name, value, 0)


def _swig_getattr(self, class_type, name):
    if (name == "thisown"):
        return self.this.own()
    method = class_type.__swig_getmethods__.get(name, None)
    if method:
        return method(self)
    raise AttributeError("'%s' object has no attribute '%s'" % (class_type.__name__, name))


def _swig_repr(self):
    try:
        strthis = "proxy of " + self.this.__repr__()
    except __builtin__.Exception:
        strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)

try:
    _object = object
    _newclass = 1
except __builtin__.Exception:
    class _object:
        pass
    _newclass = 0

try:
    import weakref
    weakref_proxy = weakref.proxy
except __builtin__.Exception:
    weakref_proxy = lambda x: x


class SwigPyIterator(_object):
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, SwigPyIterator, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, SwigPyIterator, name)

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = ___init__.delete_SwigPyIterator

    def value(self):
        return ___init__.SwigPyIterator_value(self)

    def incr(self, n=1):
        return ___init__.SwigPyIterator_incr(self, n)

    def decr(self, n=1):
        return ___init__.SwigPyIterator_decr(self, n)

    def distance(self, x):
        return ___init__.SwigPyIterator_distance(self, x)

    def equal(self, x):
        return ___init__.SwigPyIterator_equal(self, x)

    def copy(self):
        return ___init__.SwigPyIterator_copy(self)

    def next(self):
        return ___init__.SwigPyIterator_next(self)

    def __next__(self):
        return ___init__.SwigPyIterator___next__(self)

    def previous(self):
        return ___init__.SwigPyIterator_previous(self)

    def advance(self, n):
        return ___init__.SwigPyIterator_advance(self, n)

    def __eq__(self, x):
        return ___init__.SwigPyIterator___eq__(self, x)

    def __ne__(self, x):
        return ___init__.SwigPyIterator___ne__(self, x)

    def __iadd__(self, n):
        return ___init__.SwigPyIterator___iadd__(self, n)

    def __isub__(self, n):
        return ___init__.SwigPyIterator___isub__(self, n)

    def __add__(self, n):
        return ___init__.SwigPyIterator___add__(self, n)

    def __sub__(self, *args):
        return ___init__.SwigPyIterator___sub__(self, *args)
    def __iter__(self):
        return self
SwigPyIterator_swigregister = ___init__.SwigPyIterator_swigregister
SwigPyIterator_swigregister(SwigPyIterator)

import PyTrilinos.Teuchos

# Much of the Epetra module is compatible with the numpy module
import numpy

Error = ___init__.Error

def class_array_inplace_op(self, op_str, other):
  in_op = getattr(self.array, "__i"+op_str+"__")
  in_op(other.array)
  return self

def class_array_math_op(self, op_str, other):
# Initialize the result by calling the copy constructor
  result = self.__class__(self)
# Get the equivalent in-place operator for the result
  in_op = getattr(result.array, "__i"+op_str+"__")
  try:
    in_op(other.array)
  except AttributeError:
    in_op(other)
  return result

def class_array_rmath_op(self, op_str, other):
# Initialize the result by calling the copy constructor
  result = self.__class__(self)
  indices = (slice(None),) * len(self.array.shape)
  result.array[indices] = other
  in_op = getattr(result.array, "__i"+op_str+"__")
  in_op(self.array)
  return result

def class_array_add_math_ops(cls, op_str):
  setattr(cls,
          "__i"+op_str+"__",
          lambda self, other: class_array_inplace_op(self, op_str, other))
  setattr(cls,
          "__"+op_str+"__",
          lambda self, other: class_array_math_op(self, op_str, other))
  setattr(cls,
          "__r"+op_str+"__",
          lambda self, other: class_array_rmath_op(self, op_str, other))

def class_array_add_math(cls):
  class_array_add_math_ops(cls, "add")
  class_array_add_math_ops(cls, "sub")
  class_array_add_math_ops(cls, "mul")
  class_array_add_math_ops(cls, "add")

def class_array_comp_op(self, op_str, other):
  comp_op = getattr(self.array, "__"+op_str+"__")
  try:
    return comp_op(other.array)
  except AttributeError:
    return comp_op(other)

def class_array_add_comp_op(cls, op_str):
  setattr(cls,
          "__"+op_str+"__",
          lambda self, other: class_array_comp_op(self, op_str, other))

def class_array_add_comp(cls):
  class_array_add_comp_op(cls, "lt")
  class_array_add_comp_op(cls, "le")
  class_array_add_comp_op(cls, "eq")
  class_array_add_comp_op(cls, "ne")
  class_array_add_comp_op(cls, "gt")
  class_array_add_comp_op(cls, "ge")


def Epetra_Version(*args):
    """Epetra_Version() -> std::string"""
    return ___init__.Epetra_Version(*args)

Version = Epetra_Version
__version__ = Version().split()[2]

Add = ___init__.Add
Zero = ___init__.Zero
Insert = ___init__.Insert
InsertAdd = ___init__.InsertAdd
Average = ___init__.Average
Epetra_Max = ___init__.Epetra_Max
Epetra_Min = ___init__.Epetra_Min
AbsMax = ___init__.AbsMax
AbsMin = ___init__.AbsMin
Epetra_AddLocalAlso = ___init__.Epetra_AddLocalAlso
Copy = ___init__.Copy
View = ___init__.View
class Object(_object):
    """
    The base Epetra class.

    The Epetra_Object class provides capabilities common to all Epetra
    objects, such as a label that identifies an object instance, constant
    definitions, enum types.  In C++, it supports a ``Print()`` method
    that takes an output stream as an argument.  In the python
    implementation for this and all derived classes, this method takes an
    optional file object argument whose default value is standard out.
    """

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, Object, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, Object, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(Epetra_Object self, int TracebackModeIn=-1, bool set_label=True) -> Object
        __init__(Epetra_Object self, char const *const Label, int TracebackModeIn=-1) -> Object
        __init__(Epetra_Object self, Object Object) -> Object

        The base Epetra class.

        The Epetra_Object class provides capabilities common to all Epetra
        objects, such as a label that identifies an object instance, constant
        definitions, enum types.  In C++, it supports a ``Print()`` method
        that takes an output stream as an argument.  In the python
        implementation for this and all derived classes, this method takes an
        optional file object argument whose default value is standard out.
        """
        this = ___init__.new_Object(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = ___init__.delete_Object

    def SetLabel(self, *args):
        """SetLabel(Object self, char const *const Label)"""
        return ___init__.Object_SetLabel(self, *args)


    def Label(self, *args):
        """Label(Object self) -> char const *"""
        return ___init__.Object_Label(self, *args)


    def SetTracebackMode(*args):
        """SetTracebackMode(int TracebackModeValue)"""
        return ___init__.Object_SetTracebackMode(*args)

    SetTracebackMode = staticmethod(SetTracebackMode)

    def GetTracebackMode(*args):
        """GetTracebackMode() -> int"""
        return ___init__.Object_GetTracebackMode(*args)

    GetTracebackMode = staticmethod(GetTracebackMode)

    def GetTracebackStream(*args):
        """GetTracebackStream() -> std::ostream &"""
        return ___init__.Object_GetTracebackStream(*args)

    GetTracebackStream = staticmethod(GetTracebackStream)

    def ReportError(self, *args):
        """ReportError(Object self, std::string const Message, int ErrorCode) -> int"""
        return ___init__.Object_ReportError(self, *args)

    __swig_setmethods__["TracebackMode"] = ___init__.Object_TracebackMode_set
    __swig_getmethods__["TracebackMode"] = ___init__.Object_TracebackMode_get
    if _newclass:
        TracebackMode = _swig_property(___init__.Object_TracebackMode_get, ___init__.Object_TracebackMode_set)

    def __str__(self, *args):
        """
        __str__(Object self) -> PyObject *

        Returns the results of ``Print()`` in a string, so that
        the python ``print`` command will work on ``Epetra`` objects.  The
        ``Print()`` methods are designed to run correctly in parallel, so do
        not execute ``print`` on an Epetra object conditionally on the
        processor number.  For example, do not do

          ``if comm.MyPID() == 0: print epetra_obj``

        or it will hang your code.
        """
        return ___init__.Object___str__(self, *args)


    def Print(self, *args):
        """Print(Object self, PyObject * pf=None)"""
        return ___init__.Object_Print(self, *args)

Object_swigregister = ___init__.Object_swigregister
Object_swigregister(Object)

def Object_SetTracebackMode(*args):
    """Object_SetTracebackMode(int TracebackModeValue)"""
    return ___init__.Object_SetTracebackMode(*args)

def Object_GetTracebackMode(*args):
    """Object_GetTracebackMode() -> int"""
    return ___init__.Object_GetTracebackMode(*args)

def Object_GetTracebackStream(*args):
    """Object_GetTracebackStream() -> std::ostream &"""
    return ___init__.Object_GetTracebackStream(*args)
cvar = ___init__.cvar

class CompObject(_object):
    """Proxy of C++ Epetra_CompObject class."""

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, CompObject, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, CompObject, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(Epetra_CompObject self) -> CompObject
        __init__(Epetra_CompObject self, CompObject Source) -> CompObject
        """
        this = ___init__.new_CompObject(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = ___init__.delete_CompObject

    def SetFlopCounter(self, *args):
        """
        SetFlopCounter(CompObject self, FLOPS FlopCounter_in)
        SetFlopCounter(CompObject self, CompObject CompObject)
        """
        return ___init__.CompObject_SetFlopCounter(self, *args)


    def UnsetFlopCounter(self, *args):
        """UnsetFlopCounter(CompObject self)"""
        return ___init__.CompObject_UnsetFlopCounter(self, *args)


    def GetFlopCounter(self, *args):
        """GetFlopCounter(CompObject self) -> FLOPS"""
        return ___init__.CompObject_GetFlopCounter(self, *args)


    def ResetFlops(self, *args):
        """ResetFlops(CompObject self)"""
        return ___init__.CompObject_ResetFlops(self, *args)


    def Flops(self, *args):
        """Flops(CompObject self) -> double"""
        return ___init__.CompObject_Flops(self, *args)


    def UpdateFlops(self, *args):
        """
        UpdateFlops(CompObject self, long Flops_in)
        UpdateFlops(CompObject self, long long Flops_in)
        UpdateFlops(CompObject self, double Flops_in)
        """
        return ___init__.CompObject_UpdateFlops(self, *args)

CompObject_swigregister = ___init__.CompObject_swigregister
CompObject_swigregister(CompObject)

class BLAS(_object):
    """Proxy of C++ Epetra_BLAS class."""

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, BLAS, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, BLAS, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(Epetra_BLAS self) -> BLAS
        __init__(Epetra_BLAS self, BLAS BLAS) -> BLAS
        """
        this = ___init__.new_BLAS(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = ___init__.delete_BLAS

    def SYRK(self, *args):
        """
        SYRK(BLAS self, char const UPLO, char const TRANS, int const N, int const K, float const ALPHA, float const * A, int const LDA, float const BETA, float * C, int const LDC)
        SYRK(BLAS self, char const UPLO, char const TRANS, int const N, int const K, double const ALPHA, double const * A, int const LDA, double const BETA, double * C, int const LDC)
        """
        return ___init__.BLAS_SYRK(self, *args)

BLAS_swigregister = ___init__.BLAS_swigregister
BLAS_swigregister(BLAS)

class LAPACK(_object):
    """Proxy of C++ Epetra_LAPACK class."""

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, LAPACK, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, LAPACK, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(Epetra_LAPACK self) -> LAPACK
        __init__(Epetra_LAPACK self, LAPACK LAPACK) -> LAPACK
        """
        this = ___init__.new_LAPACK(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = ___init__.delete_LAPACK

    def TRTRS(self, *args):
        """
        TRTRS(LAPACK self, char const UPLO, char const TRANS, char const DIAG, int const N, int const NRHS, float const * A, int const LDA, float * B, int const LDB, int * INFO)
        TRTRS(LAPACK self, char const UPLO, char const TRANS, char const DIAG, int const N, int const NRHS, double const * A, int const LDA, double * B, int const LDB, int * INFO)
        """
        return ___init__.LAPACK_TRTRS(self, *args)

LAPACK_swigregister = ___init__.LAPACK_swigregister
LAPACK_swigregister(LAPACK)

class FLOPS(_object):
    """Proxy of C++ Epetra_Flops class."""

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, FLOPS, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, FLOPS, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(Epetra_Flops self) -> FLOPS
        __init__(Epetra_Flops self, FLOPS Flops_in) -> FLOPS
        """
        this = ___init__.new_FLOPS(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

    def Flops(self, *args):
        """Flops(FLOPS self) -> double"""
        return ___init__.FLOPS_Flops(self, *args)


    def ResetFlops(self, *args):
        """ResetFlops(FLOPS self)"""
        return ___init__.FLOPS_ResetFlops(self, *args)

    __swig_destroy__ = ___init__.delete_FLOPS
FLOPS_swigregister = ___init__.FLOPS_swigregister
FLOPS_swigregister(FLOPS)

class Time(Object):
    """Proxy of C++ Epetra_Time class."""

    __swig_setmethods__ = {}
    for _s in [Object]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, Time, name, value)
    __swig_getmethods__ = {}
    for _s in [Object]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, Time, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(Epetra_Time self, Comm Comm) -> Time
        __init__(Epetra_Time self, Time Time) -> Time
        """
        this = ___init__.new_Time(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

    def WallTime(self, *args):
        """WallTime(Time self) -> double"""
        return ___init__.Time_WallTime(self, *args)


    def ResetStartTime(self, *args):
        """ResetStartTime(Time self)"""
        return ___init__.Time_ResetStartTime(self, *args)


    def ElapsedTime(self, *args):
        """ElapsedTime(Time self) -> double"""
        return ___init__.Time_ElapsedTime(self, *args)

    __swig_destroy__ = ___init__.delete_Time
Time_swigregister = ___init__.Time_swigregister
Time_swigregister(Time)

import PyTrilinos.Epetra
import PyTrilinos.NOX.Abstract
import PyTrilinos.NOX.Epetra.__init__
import Interface
import PyTrilinos.NOX.Epetra.Interface

import sys, os.path as op
parentDir = op.normpath(op.join(op.dirname(op.abspath(__file__)),".."))
if not parentDir in sys.path: sys.path.append(parentDir)
del sys, op
from .. import Abstract

import Extended
import MultiContinuation
import PhaseTransition
import TimeDependent
import BorderedSystem
import Homotopy
import TurningPoint.MooreSpence
import TurningPoint.MinimallyAugmented
import Hopf.MooreSpence
import Hopf.MinimallyAugmented
import Pitchfork.MooreSpence
import Pitchfork.MinimallyAugmented
import Abstract

del ___init__
from .. import Abstract
from .  import ___init__

class Group(PyTrilinos.NOX.Epetra.__init__.Group, Abstract.Group, Abstract.TransposeSolveGroup):
    """Proxy of C++ LOCA::Epetra::Group class."""

    __swig_setmethods__ = {}
    for _s in [PyTrilinos.NOX.Epetra.__init__.Group, Abstract.Group, Abstract.TransposeSolveGroup]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, Group, name, value)
    __swig_getmethods__ = {}
    for _s in [PyTrilinos.NOX.Epetra.__init__.Group, Abstract.Group, Abstract.TransposeSolveGroup]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, Group, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(LOCA::Epetra::Group self, Teuchos::RCP< LOCA::GlobalData > const & global_data, ParameterList printingParams, Teuchos::RCP< LOCA::Epetra::Interface::Required > const & i, Vector initialGuess, LOCA::ParameterVector const & p) -> Group
        __init__(LOCA::Epetra::Group self, Teuchos::RCP< LOCA::GlobalData > const & global_data, ParameterList printingParams, Teuchos::RCP< LOCA::Epetra::Interface::Required > const & i, Vector initialGuess, Teuchos::RCP< NOX::Epetra::LinearSystem > const & linSys, LOCA::ParameterVector const & p) -> Group
        __init__(LOCA::Epetra::Group self, Teuchos::RCP< LOCA::GlobalData > const & global_data, ParameterList printingParams, Teuchos::RCP< LOCA::Epetra::Interface::TimeDependent > const & i, Vector initialGuess, Teuchos::RCP< NOX::Epetra::LinearSystem > const & linSys, Teuchos::RCP< NOX::Epetra::LinearSystem > const & shiftedLinSys, LOCA::ParameterVector const & p) -> Group
        __init__(LOCA::Epetra::Group self, Group source, NOX::CopyType type) -> Group
        """
        this = ___init__.new_Group(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = ___init__.delete_Group

    def clone(self, *args):
        """clone(Group self, NOX::CopyType type) -> Teuchos::RCP< NOX::Abstract::Group >"""
        return ___init__.Group_clone(self, *args)


    def computeF(self, *args):
        """computeF(Group self) -> NOX::Abstract::Group::ReturnType"""
        return ___init__.Group_computeF(self, *args)


    def computeJacobian(self, *args):
        """computeJacobian(Group self) -> NOX::Abstract::Group::ReturnType"""
        return ___init__.Group_computeJacobian(self, *args)


    def applyJacobianTransposeInverse(self, *args):
        """applyJacobianTransposeInverse(Group self, ParameterList params, Vector input, Vector result) -> NOX::Abstract::Group::ReturnType"""
        return ___init__.Group_applyJacobianTransposeInverse(self, *args)


    def applyJacobianTransposeInverseMultiVector(self, *args):
        """applyJacobianTransposeInverseMultiVector(Group self, ParameterList params, MultiVector input, MultiVector result) -> NOX::Abstract::Group::ReturnType"""
        return ___init__.Group_applyJacobianTransposeInverseMultiVector(self, *args)


    def copy(self, *args):
        """copy(Group self, Group source)"""
        return ___init__.Group_copy(self, *args)


    def setParams(self, *args):
        """setParams(Group self, LOCA::ParameterVector const & p)"""
        return ___init__.Group_setParams(self, *args)


    def setParam(self, *args):
        """
        setParam(Group self, int paramID, double val)
        setParam(Group self, std::string paramID, double val)
        """
        return ___init__.Group_setParam(self, *args)


    def getParams(self, *args):
        """getParams(Group self) -> LOCA::ParameterVector const &"""
        return ___init__.Group_getParams(self, *args)


    def getParam(self, *args):
        """
        getParam(Group self, int paramID) -> double
        getParam(Group self, std::string paramID) -> double
        """
        return ___init__.Group_getParam(self, *args)


    def preProcessContinuationStep(self, *args):
        """preProcessContinuationStep(Group self, LOCA::Abstract::Iterator::StepStatus stepStatus)"""
        return ___init__.Group_preProcessContinuationStep(self, *args)


    def postProcessContinuationStep(self, *args):
        """postProcessContinuationStep(Group self, LOCA::Abstract::Iterator::StepStatus stepStatus)"""
        return ___init__.Group_postProcessContinuationStep(self, *args)


    def projectToDraw(self, *args):
        """projectToDraw(Group self, Vector x, double * px)"""
        return ___init__.Group_projectToDraw(self, *args)


    def projectToDrawDimension(self, *args):
        """projectToDrawDimension(Group self) -> int"""
        return ___init__.Group_projectToDrawDimension(self, *args)


    def computeScaledDotProduct(self, *args):
        """computeScaledDotProduct(Group self, Vector a, Vector b) -> double"""
        return ___init__.Group_computeScaledDotProduct(self, *args)


    def scaleVector(self, *args):
        """scaleVector(Group self, Vector x)"""
        return ___init__.Group_scaleVector(self, *args)


    def augmentJacobianForHomotopy(self, *args):
        """augmentJacobianForHomotopy(Group self, double a, double b) -> NOX::Abstract::Group::ReturnType"""
        return ___init__.Group_augmentJacobianForHomotopy(self, *args)


    def computeShiftedMatrix(self, *args):
        """computeShiftedMatrix(Group self, double alpha, double beta) -> NOX::Abstract::Group::ReturnType"""
        return ___init__.Group_computeShiftedMatrix(self, *args)


    def applyShiftedMatrix(self, *args):
        """applyShiftedMatrix(Group self, Vector input, Vector result) -> NOX::Abstract::Group::ReturnType"""
        return ___init__.Group_applyShiftedMatrix(self, *args)


    def applyShiftedMatrixMultiVector(self, *args):
        """applyShiftedMatrixMultiVector(Group self, MultiVector input, MultiVector result) -> NOX::Abstract::Group::ReturnType"""
        return ___init__.Group_applyShiftedMatrixMultiVector(self, *args)


    def applyShiftedMatrixInverseMultiVector(self, *args):
        """applyShiftedMatrixInverseMultiVector(Group self, ParameterList params, MultiVector input, MultiVector result) -> NOX::Abstract::Group::ReturnType"""
        return ___init__.Group_applyShiftedMatrixInverseMultiVector(self, *args)


    def computeSecondShiftedMatrix(self, *args):
        """computeSecondShiftedMatrix(Group self, double alpha, double beta) -> NOX::Abstract::Group::ReturnType"""
        return ___init__.Group_computeSecondShiftedMatrix(self, *args)


    def applySecondShiftedMatrix(self, *args):
        """applySecondShiftedMatrix(Group self, Vector input, Vector result) -> NOX::Abstract::Group::ReturnType"""
        return ___init__.Group_applySecondShiftedMatrix(self, *args)


    def applySecondShiftedMatrixMultiVector(self, *args):
        """applySecondShiftedMatrixMultiVector(Group self, MultiVector input, MultiVector result) -> NOX::Abstract::Group::ReturnType"""
        return ___init__.Group_applySecondShiftedMatrixMultiVector(self, *args)


    def isComplex(self, *args):
        """isComplex(Group self) -> bool"""
        return ___init__.Group_isComplex(self, *args)


    def computeComplex(self, *args):
        """computeComplex(Group self, double frequency) -> NOX::Abstract::Group::ReturnType"""
        return ___init__.Group_computeComplex(self, *args)


    def applyComplex(self, *args):
        """applyComplex(Group self, Vector input_real, Vector input_imag, Vector result_real, Vector result_imag) -> NOX::Abstract::Group::ReturnType"""
        return ___init__.Group_applyComplex(self, *args)


    def applyComplexMultiVector(self, *args):
        """applyComplexMultiVector(Group self, MultiVector input_real, MultiVector input_imag, MultiVector result_real, MultiVector result_imag) -> NOX::Abstract::Group::ReturnType"""
        return ___init__.Group_applyComplexMultiVector(self, *args)


    def applyComplexInverseMultiVector(self, *args):
        """applyComplexInverseMultiVector(Group self, ParameterList params, MultiVector input_real, MultiVector input_imag, MultiVector result_real, MultiVector result_imag) -> NOX::Abstract::Group::ReturnType"""
        return ___init__.Group_applyComplexInverseMultiVector(self, *args)


    def applyComplexTranspose(self, *args):
        """applyComplexTranspose(Group self, Vector input_real, Vector input_imag, Vector result_real, Vector result_imag) -> NOX::Abstract::Group::ReturnType"""
        return ___init__.Group_applyComplexTranspose(self, *args)


    def applyComplexTransposeMultiVector(self, *args):
        """applyComplexTransposeMultiVector(Group self, MultiVector input_real, MultiVector input_imag, MultiVector result_real, MultiVector result_imag) -> NOX::Abstract::Group::ReturnType"""
        return ___init__.Group_applyComplexTransposeMultiVector(self, *args)


    def applyComplexTransposeInverseMultiVector(self, *args):
        """applyComplexTransposeInverseMultiVector(Group self, ParameterList params, MultiVector input_real, MultiVector input_imag, MultiVector result_real, MultiVector result_imag) -> NOX::Abstract::Group::ReturnType"""
        return ___init__.Group_applyComplexTransposeInverseMultiVector(self, *args)


    def setFreeEnergyInterface(self, *args):
        """setFreeEnergyInterface(Group self, Teuchos::RCP< LOCA::Epetra::Interface::FreeEnergy > const & iFE)"""
        return ___init__.Group_setFreeEnergyInterface(self, *args)


    def declareSeparateMatrixMemory(self, *args):
        """declareSeparateMatrixMemory(Group self, bool separateMem=True)"""
        return ___init__.Group_declareSeparateMatrixMemory(self, *args)


    def computeFreeEnergy(self, *args):
        """computeFreeEnergy(Group self) -> double"""
        return ___init__.Group_computeFreeEnergy(self, *args)


    def getUserInterface(self, *args):
        """getUserInterface(Group self) -> Teuchos::RCP< NOX::Epetra::Interface::Required >"""
        return ___init__.Group_getUserInterface(self, *args)


    def printSolution(self, *args):
        """
        printSolution(Group self, double const conParam)
        printSolution(Group self, Vector x, double const conParam)
        printSolution(Group self, Vector x, double const conParam)
        """
        return ___init__.Group_printSolution(self, *args)


    def setScaleVector(self, *args):
        """setScaleVector(Group self, Vector s)"""
        return ___init__.Group_setScaleVector(self, *args)


    def setJacobianOperatorForSolve(self, *args):
        """setJacobianOperatorForSolve(Group self, Teuchos::RCP< Epetra_Operator const > const & op)"""
        return ___init__.Group_setJacobianOperatorForSolve(self, *args)


    def getComplexLinearSystem(self, *args):
        """
        getComplexLinearSystem(Group self) -> Teuchos::RCP< NOX::Epetra::LinearSystem const >
        getComplexLinearSystem(Group self) -> Teuchos::RCP< NOX::Epetra::LinearSystem >
        """
        return ___init__.Group_getComplexLinearSystem(self, *args)


    def getComplexMaps(self, *args):
        """getComplexMaps(Group self, Teuchos::RCP< Epetra_BlockMap const > & baseMap, Teuchos::RCP< Epetra_BlockMap const > & globalMap)"""
        return ___init__.Group_getComplexMaps(self, *args)

Group_swigregister = ___init__.Group_swigregister
Group_swigregister(Group)


def defaultContinuationParameters(comm=None,
                                  verbosity=0,
                                  outputPrec=3,
                                  maxIterations=800,
                                  tolerance=1.0e-4):
    """
    defaultContinuationParameters(comm=None,
                                  verbosity=0,
                                  outputPrec=3,
                                  maxIterations=800,
                                  tolerance=1.0e-4) -> dict

    Return a dictionary that can serve as a default list of parameters for LOCA
    constructors.  Entries can be altered before passing to a LOCA constructor.

    comm          - Epetra communicator object.  If not provided, the function
                    uses an Epetra.SerialComm communicator.

    verbosity     - A simple indication of verbosity level.  0: errors and test
                    details.  1: debugging, warnings, details, parameters and
                    linear solver details.  2: inner iteration, outer iteration
                    status test and outer iteration.  Default 0.

    outputPrec    - Number of significant digits to output.  Default 3.

    maxIterations - Maximum allowable linear (inner) iterations.  Default 800.

    tolerance     - Linear solver tolerance level.  Default 1.0e-4.
    """
    nlParams = PyTrilinos.NOX.Epetra.defaultNonlinearParameters(comm,
                                                                verbosity,
                                                                outputPrec,
                                                                maxIterations,
                                                                tolerance)
    direction    = nlParams["Direction"]
    newton       = nlParams["Newton"]
    linearSolver = nlParams["Linear Solver"]
    linearSolver["Output Frequency"           ] = 1
    linearSolver["Preconditioner"             ] = "None"
    linearSolver["Preconditioner Operator"    ] = "Use Jacobian"
    linearSolver["Size of Krylov Subspace"    ] = 100
    linearSolver["Tolerance"                  ] = 1e-08
    linearSolver["Zero Initial Guess"         ] = False
    linearSolver["Compute Scaling Manually"   ] = True
    linearSolver["Throw Error on Prec Failure"] = True
    linearSolver["RCM Reordering"             ] = "Disabled"
    linearSolver["Orthogonalization"          ] = "Classical"
    linearSolver["Convergence Test"           ] = "r0"
    linearSolver["Preconditioner Reuse Policy"] = "Rebuild"
    newton["Linear Solver"] = linearSolver
    direction["Newton"] = newton
    noxParams = {"Tolerance"        : tolerance,
                 "Printing"         : nlParams["Printing"],
                 "Nonlinear Solver" : nlParams["Nonlinear Solver"],
                 "Direction"        : direction
                 }

    predictor   = {"Method" : "Secant"}
    bifurcation = {"Type"   : "None"  }
    stepSize    = {"Method"            : "Adaptive",  
                   "Initial Step Size" : 0.01,
                   "Min Step Size"     : 1.0e-3,
                   "Max Step Size"     : .02
                   }
    eigensolver = {"Method"                : "Anasazi",
                   "Sorting Order"         : "LM",
                   "Block Size"            : 4,
                   "Num Blocks"            : 100,
                   "Num Eigenvalues"       : 15,
                   "Convergence Tolerance" : 1e-11,
                   "Step Size"             : 20,
                   "Maximum Restarts"      : 20,
                   "Maximum Iterations"    : 500,
                   "Operator"              : "Jacobian Inverse",
                   "Operator"              : "Shift-Invert",
                   "Shift"                 : 0.03,
                   "Cayley Pole"           : 0.001,
                   "Cayley Zero"           : 0.02,
                   "Symmetric"             : False
                   }
    stepper = {"Continuation Method"      : "Arc Length",
               "Continuation Parameter"   : "sigma",
               "Initial Value"            : 0.0,
               "Max Value"                : 10.0,
               "Min Value"                : 0.0,
               "Max Nonlinear Iterations" : 100,
               "Max Steps"                : 100,
               "Compute Eigenvalues"      : False,
               "Eigensolver"              : eigensolver
               }

    locaParams = {"Enable Arc Length Scaling"               : False,
                  "Goal Arc Length Parameter Contribution"  : 0.8,
                  "Max Arc Length Parameter Contribution"   : 0.8,
                  "Initial Scale Factor"                    : 1.0,
                  "Min Scale Factor"                        : 1e-7,
                  "Enable Tangent Factor Step Size Scaling" : True,
                  "Min Tangent Factor"                      : 0.8,
                  "Tangent Factor Exponent"                 : 1.5,
                  "Predictor"                               : predictor,
                  "Bifurcation"                             : bifurcation, 
                  "Step Size"                               : stepSize,
                  "Stepper"                                 : stepper
                  }

    result = {"NOX"  : noxParams,
              "LOCA" : locaParams
              }

    return result

# This file is compatible with both classic and new-style classes.


