# This file was automatically generated by SWIG (http://www.swig.org).
# Version 3.0.12
#
# Do not make changes to this file unless you know what you are doing--modify
# the SWIG interface file instead.

"""

PyTrilinos.Isorropia.Epetra is the python interface to namespace Epetra for
the Trilinos package Isorropia:

    http://trilinos.sandia.gov/packages/isorropia

The purpose of Isorropia.Epetra is to ....

"""


from sys import version_info as _swig_python_version_info
if _swig_python_version_info >= (2, 7, 0):
    def swig_import_helper():
        import importlib
        pkg = __name__.rpartition('.')[0]
        mname = '.'.join((pkg, '_IsorropiaEpetra')).lstrip('.')
        try:
            return importlib.import_module(mname)
        except ImportError:
            return importlib.import_module('_IsorropiaEpetra')
    _IsorropiaEpetra = swig_import_helper()
    del swig_import_helper
elif _swig_python_version_info >= (2, 6, 0):
    def swig_import_helper():
        from os.path import dirname
        import imp
        fp = None
        try:
            fp, pathname, description = imp.find_module('_IsorropiaEpetra', [dirname(__file__)])
        except ImportError:
            import _IsorropiaEpetra
            return _IsorropiaEpetra
        try:
            _mod = imp.load_module('_IsorropiaEpetra', fp, pathname, description)
        finally:
            if fp is not None:
                fp.close()
        return _mod
    _IsorropiaEpetra = swig_import_helper()
    del swig_import_helper
else:
    import _IsorropiaEpetra
del _swig_python_version_info

try:
    _swig_property = property
except NameError:
    pass  # Python < 2.2 doesn't have 'property'.

try:
    import builtins as __builtin__
except ImportError:
    import __builtin__

def _swig_setattr_nondynamic(self, class_type, name, value, static=1):
    if (name == "thisown"):
        return self.this.own(value)
    if (name == "this"):
        if type(value).__name__ == 'SwigPyObject':
            self.__dict__[name] = value
            return
    method = class_type.__swig_setmethods__.get(name, None)
    if method:
        return method(self, value)
    if (not static):
        if _newclass:
            object.__setattr__(self, name, value)
        else:
            self.__dict__[name] = value
    else:
        raise AttributeError("You cannot add attributes to %s" % self)


def _swig_setattr(self, class_type, name, value):
    return _swig_setattr_nondynamic(self, class_type, name, value, 0)


def _swig_getattr(self, class_type, name):
    if (name == "thisown"):
        return self.this.own()
    method = class_type.__swig_getmethods__.get(name, None)
    if method:
        return method(self)
    raise AttributeError("'%s' object has no attribute '%s'" % (class_type.__name__, name))


def _swig_repr(self):
    try:
        strthis = "proxy of " + self.this.__repr__()
    except __builtin__.Exception:
        strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)

try:
    _object = object
    _newclass = 1
except __builtin__.Exception:
    class _object:
        pass
    _newclass = 0

try:
    import weakref
    weakref_proxy = weakref.proxy
except __builtin__.Exception:
    weakref_proxy = lambda x: x


import PyTrilinos.Teuchos
import PyTrilinos.Epetra
import __init__
class Operator(__init__.Operator):
    """Proxy of C++ Isorropia::Epetra::Operator class."""

    __swig_setmethods__ = {}
    for _s in [__init__.Operator]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, Operator, name, value)
    __swig_getmethods__ = {}
    for _s in [__init__.Operator]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, Operator, name)

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _IsorropiaEpetra.delete_Operator

    def setParameters(self, *args):
        """setParameters(Operator self, ParameterList paramlist)"""
        return _IsorropiaEpetra.Operator_setParameters(self, *args)


    def getCosts(self, *args):
        """getCosts(Operator self) -> Teuchos::RCP< Isorropia::Epetra::CostDescriber > &"""
        return _IsorropiaEpetra.Operator_getCosts(self, *args)


    def compute(self, *args):
        """compute(Operator self, bool force_compute)"""
        return _IsorropiaEpetra.Operator_compute(self, *args)


    def alreadyComputed(self, *args):
        """alreadyComputed(Operator self) -> bool"""
        return _IsorropiaEpetra.Operator_alreadyComputed(self, *args)


    def numProperties(self, *args):
        """numProperties(Operator self) -> int"""
        return _IsorropiaEpetra.Operator_numProperties(self, *args)


    def numLocalProperties(self, *args):
        """numLocalProperties(Operator self) -> int"""
        return _IsorropiaEpetra.Operator_numLocalProperties(self, *args)


    def numElemsWithProperty(self, *args):
        """numElemsWithProperty(Operator self, int property) -> int"""
        return _IsorropiaEpetra.Operator_numElemsWithProperty(self, *args)


    def elemsWithProperty(self, *args):
        """elemsWithProperty(Operator self, int property, int * elementList)"""
        return _IsorropiaEpetra.Operator_elemsWithProperty(self, *args)


    def extractPropertiesCopy(self, *args):
        """extractPropertiesCopy(Operator self, int len, int & size, int * array) -> int"""
        return _IsorropiaEpetra.Operator_extractPropertiesCopy(self, *args)


    def extractPropertiesView(self, *args):
        """extractPropertiesView(Operator self, int & size, int const *& array) -> int"""
        return _IsorropiaEpetra.Operator_extractPropertiesView(self, *args)

Operator_swigregister = _IsorropiaEpetra.Operator_swigregister
Operator_swigregister(Operator)

class Colorer(__init__.Colorer, Operator):
    """Proxy of C++ Isorropia::Epetra::Colorer class."""

    __swig_setmethods__ = {}
    for _s in [__init__.Colorer, Operator]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, Colorer, name, value)
    __swig_getmethods__ = {}
    for _s in [__init__.Colorer, Operator]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, Colorer, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(Isorropia::Epetra::Colorer self, Teuchos::RCP< Epetra_CrsGraph const > input_graph, ParameterList paramlist, bool compute_now=True) -> Colorer
        __init__(Isorropia::Epetra::Colorer self, CrsGraph input_graph, ParameterList paramlist, bool compute_now=True) -> Colorer
        __init__(Isorropia::Epetra::Colorer self, Teuchos::RCP< Epetra_RowMatrix const > input_matrix, ParameterList paramlist, bool compute_now=True) -> Colorer
        __init__(Isorropia::Epetra::Colorer self, RowMatrix input_matrix, ParameterList paramlist, bool compute_now=True) -> Colorer
        """
        this = _IsorropiaEpetra.new_Colorer(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _IsorropiaEpetra.delete_Colorer

    def color(self, *args):
        """color(Colorer self, bool force_coloring=False)"""
        return _IsorropiaEpetra.Colorer_color(self, *args)


    def compute(self, *args):
        """compute(Colorer self, bool force_compute=False)"""
        return _IsorropiaEpetra.Colorer_compute(self, *args)

Colorer_swigregister = _IsorropiaEpetra.Colorer_swigregister
Colorer_swigregister(Colorer)

class Partitioner(__init__.Partitioner, Operator):
    """Proxy of C++ Isorropia::Epetra::Partitioner class."""

    __swig_setmethods__ = {}
    for _s in [__init__.Partitioner, Operator]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, Partitioner, name, value)
    __swig_getmethods__ = {}
    for _s in [__init__.Partitioner, Operator]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, Partitioner, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(Isorropia::Epetra::Partitioner self, Teuchos::RCP< Epetra_CrsGraph const > inputGraph, ParameterList paramlist, bool compute_partitioning_now=True) -> Partitioner
        __init__(Isorropia::Epetra::Partitioner self, CrsGraph inputGraph, ParameterList paramlist, bool compute_partitioning_now=True) -> Partitioner
        __init__(Isorropia::Epetra::Partitioner self, Teuchos::RCP< Epetra_CrsGraph const > inputGraph, Teuchos::RCP< Isorropia::Epetra::CostDescriber > costs, ParameterList paramlist, bool compute_partitioning_now=True) -> Partitioner
        __init__(Isorropia::Epetra::Partitioner self, CrsGraph inputGraph, CostDescriber costs, ParameterList paramlist, bool compute_partitioning_now=True) -> Partitioner
        __init__(Isorropia::Epetra::Partitioner self, Teuchos::RCP< Epetra_RowMatrix const > inputMatrix, ParameterList paramlist, bool compute_partitioning_now=True) -> Partitioner
        __init__(Isorropia::Epetra::Partitioner self, RowMatrix inputMatrix, ParameterList paramlist, bool compute_partitioning_now=True) -> Partitioner
        __init__(Isorropia::Epetra::Partitioner self, Teuchos::RCP< Epetra_RowMatrix const > inputMatrix, Teuchos::RCP< Isorropia::Epetra::CostDescriber > costs, ParameterList paramlist, bool compute_partitioning_now=True) -> Partitioner
        __init__(Isorropia::Epetra::Partitioner self, RowMatrix inputMatrix, CostDescriber costs, ParameterList paramlist, bool compute_partitioning_now=True) -> Partitioner
        __init__(Isorropia::Epetra::Partitioner self, Teuchos::RCP< Epetra_MultiVector const > coords, ParameterList paramlist, bool compute_partitioning_now=True) -> Partitioner
        __init__(Isorropia::Epetra::Partitioner self, MultiVector coords, ParameterList paramlist, bool compute_partitioning_now=True) -> Partitioner
        __init__(Isorropia::Epetra::Partitioner self, Teuchos::RCP< Epetra_MultiVector const > coords, Teuchos::RCP< Epetra_MultiVector const > weights, ParameterList paramlist, bool compute_partitioning_now=True) -> Partitioner
        __init__(Isorropia::Epetra::Partitioner self, MultiVector coords, MultiVector weights, ParameterList paramlist, bool compute_partitioning_now=True) -> Partitioner
        __init__(Isorropia::Epetra::Partitioner self, Teuchos::RCP< Epetra_BlockMap const > inputMap, ParameterList paramlist, bool compute_partitioning_now=True) -> Partitioner
        __init__(Isorropia::Epetra::Partitioner self, BlockMap inputMap, ParameterList paramlist, bool compute_partitioning_now=True) -> Partitioner
        __init__(Isorropia::Epetra::Partitioner self, Teuchos::RCP< Epetra_CrsGraph const > inputGraph, Teuchos::RCP< Epetra_MultiVector const > coords, ParameterList paramlist, bool compute_partitioning_now=True) -> Partitioner
        __init__(Isorropia::Epetra::Partitioner self, CrsGraph inputGraph, MultiVector coords, ParameterList paramlist, bool compute_partitioning_now=True) -> Partitioner
        __init__(Isorropia::Epetra::Partitioner self, Teuchos::RCP< Epetra_CrsGraph const > inputGraph, Teuchos::RCP< Isorropia::Epetra::CostDescriber > costs, Teuchos::RCP< Epetra_MultiVector const > coords, Teuchos::RCP< Epetra_MultiVector const > weights, ParameterList paramlist, bool compute_partitioning_now=True) -> Partitioner
        __init__(Isorropia::Epetra::Partitioner self, CrsGraph inputGraph, CostDescriber costs, MultiVector coords, MultiVector weights, ParameterList paramlist, bool compute_partitioning_now=True) -> Partitioner
        __init__(Isorropia::Epetra::Partitioner self, Teuchos::RCP< Epetra_RowMatrix const > inputMatrix, Teuchos::RCP< Epetra_MultiVector const > coords, ParameterList paramlist, bool compute_partitioning_now=True) -> Partitioner
        __init__(Isorropia::Epetra::Partitioner self, RowMatrix inputMatrix, MultiVector coords, ParameterList paramlist, bool compute_partitioning_now=True) -> Partitioner
        __init__(Isorropia::Epetra::Partitioner self, Teuchos::RCP< Epetra_RowMatrix const > inputMatrix, Teuchos::RCP< Isorropia::Epetra::CostDescriber > costs, Teuchos::RCP< Epetra_MultiVector const > coords, Teuchos::RCP< Epetra_MultiVector const > weights, ParameterList paramlist, bool compute_partitioning_now=True) -> Partitioner
        __init__(Isorropia::Epetra::Partitioner self, RowMatrix inputMatrix, CostDescriber costs, MultiVector coords, MultiVector weights, ParameterList paramlist, bool compute_partitioning_now=True) -> Partitioner
        """
        this = _IsorropiaEpetra.new_Partitioner(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _IsorropiaEpetra.delete_Partitioner

    def setPartSizes(self, *args):
        """setPartSizes(Partitioner self, int len, int * global_part_id, float * part_size)"""
        return _IsorropiaEpetra.Partitioner_setPartSizes(self, *args)


    def clearPartSizes(self, *args):
        """clearPartSizes(Partitioner self)"""
        return _IsorropiaEpetra.Partitioner_clearPartSizes(self, *args)


    def partition(self, *args):
        """partition(Partitioner self, bool force_repartitioning=False)"""
        return _IsorropiaEpetra.Partitioner_partition(self, *args)


    def compute(self, *args):
        """compute(Partitioner self, bool forceRecomputing=False)"""
        return _IsorropiaEpetra.Partitioner_compute(self, *args)


    def numElemsInPart(self, *args):
        """numElemsInPart(Partitioner self, int part) -> int"""
        return _IsorropiaEpetra.Partitioner_numElemsInPart(self, *args)


    def elemsInPart(self, *args):
        """elemsInPart(Partitioner self, int part, int * elementList)"""
        return _IsorropiaEpetra.Partitioner_elemsInPart(self, *args)


    def createNewMap(self, *args):
        """createNewMap(Partitioner self) -> Teuchos::RCP< Epetra_Map >"""
        return _IsorropiaEpetra.Partitioner_createNewMap(self, *args)


    def printZoltanMetrics(self, *args):
        """printZoltanMetrics(Partitioner self) -> int"""
        return _IsorropiaEpetra.Partitioner_printZoltanMetrics(self, *args)

Partitioner_swigregister = _IsorropiaEpetra.Partitioner_swigregister
Partitioner_swigregister(Partitioner)

class Redistributor(__init__.Redistributor):
    """Proxy of C++ Isorropia::Epetra::Redistributor class."""

    __swig_setmethods__ = {}
    for _s in [__init__.Redistributor]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, Redistributor, name, value)
    __swig_getmethods__ = {}
    for _s in [__init__.Redistributor]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, Redistributor, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(Isorropia::Epetra::Redistributor self, Teuchos::RCP< Isorropia::Epetra::Partitioner > partitioner) -> Redistributor
        __init__(Isorropia::Epetra::Redistributor self, Teuchos::RCP< Epetra_Map > target_map) -> Redistributor
        __init__(Isorropia::Epetra::Redistributor self, Partitioner partitioner) -> Redistributor
        __init__(Isorropia::Epetra::Redistributor self, Map target_map) -> Redistributor
        """
        this = _IsorropiaEpetra.new_Redistributor(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _IsorropiaEpetra.delete_Redistributor

    def redistribute(self, *args):
        """
        redistribute(Redistributor self, SrcDistObject src, DistObject target)
        redistribute(Redistributor self, CrsGraph input_graph, bool callFillComplete=True) -> Teuchos::RCP< Epetra_CrsGraph >
        redistribute(Redistributor self, CrsGraph input_graph, Epetra_CrsGraph *& outputGraphPtr, bool callFillComplete=True)
        redistribute(Redistributor self, CrsMatrix input_matrix, bool callFillComplete=True) -> Teuchos::RCP< Epetra_CrsMatrix >
        redistribute(Redistributor self, RowMatrix input_matrix, bool callFillComplete=True) -> Teuchos::RCP< Epetra_CrsMatrix >
        redistribute(Redistributor self, Vector input_vector) -> Teuchos::RCP< Epetra_Vector >
        redistribute(Redistributor self, MultiVector input_vector) -> Teuchos::RCP< Epetra_MultiVector >
        """
        return _IsorropiaEpetra.Redistributor_redistribute(self, *args)


    def redistribute_reverse(self, *args):
        """
        redistribute_reverse(Redistributor self, Vector input_vector, Vector output_vector)
        redistribute_reverse(Redistributor self, MultiVector input_vector, MultiVector output_vector)
        """
        return _IsorropiaEpetra.Redistributor_redistribute_reverse(self, *args)


    def get_importer(self, *args):
        """get_importer(Redistributor self) -> Import"""
        return _IsorropiaEpetra.Redistributor_get_importer(self, *args)

Redistributor_swigregister = _IsorropiaEpetra.Redistributor_swigregister
Redistributor_swigregister(Redistributor)

class CostDescriber(__init__.CostDescriber):
    """Proxy of C++ Isorropia::Epetra::CostDescriber class."""

    __swig_setmethods__ = {}
    for _s in [__init__.CostDescriber]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, CostDescriber, name, value)
    __swig_getmethods__ = {}
    for _s in [__init__.CostDescriber]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, CostDescriber, name)
    __repr__ = _swig_repr
    __swig_destroy__ = _IsorropiaEpetra.delete_CostDescriber

    def __init__(self, *args):
        """
        __init__(Isorropia::Epetra::CostDescriber self) -> CostDescriber
        __init__(Isorropia::Epetra::CostDescriber self, CostDescriber costs) -> CostDescriber
        """
        this = _IsorropiaEpetra.new_CostDescriber(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

    def setVertexWeights(self, *args):
        """setVertexWeights(CostDescriber self, Teuchos::RCP< Epetra_Vector const > vwgts)"""
        return _IsorropiaEpetra.CostDescriber_setVertexWeights(self, *args)


    def setGraphEdgeWeights(self, *args):
        """setGraphEdgeWeights(CostDescriber self, Teuchos::RCP< Epetra_CrsMatrix const > gewts)"""
        return _IsorropiaEpetra.CostDescriber_setGraphEdgeWeights(self, *args)


    def setHypergraphEdgeWeights(self, *args):
        """
        setHypergraphEdgeWeights(CostDescriber self, Teuchos::RCP< Epetra_Vector const > hgewts)
        setHypergraphEdgeWeights(CostDescriber self, int numHGedges, int const * hgGIDs, float const * hgEwgts)
        setHypergraphEdgeWeights(CostDescriber self, int numHGedges, int const * hgGIDs, double const * hgEwgts)
        """
        return _IsorropiaEpetra.CostDescriber_setHypergraphEdgeWeights(self, *args)


    def getCosts(self, *args):
        """getCosts(CostDescriber self, std::map< int,float,std::less< int >,std::allocator< std::pair< int const,float > > > & vertexWeights, std::map< int,std::map< int,float,std::less< int >,std::allocator< std::pair< int const,float > > >,std::less< int >,std::allocator< std::pair< int const,std::map< int,float,std::less< int >,std::allocator< std::pair< int const,float > > > > > > & graphEdgeWeights, std::map< int,float,std::less< int >,std::allocator< std::pair< int const,float > > > & hypergraphEdgeWeights)"""
        return _IsorropiaEpetra.CostDescriber_getCosts(self, *args)


    def show_cd(self, *args):
        """show_cd(CostDescriber self, std::ostream & arg2)"""
        return _IsorropiaEpetra.CostDescriber_show_cd(self, *args)

CostDescriber_swigregister = _IsorropiaEpetra.CostDescriber_swigregister
CostDescriber_swigregister(CostDescriber)

class Orderer(__init__.Orderer, Operator):
    """Proxy of C++ Isorropia::Epetra::Orderer class."""

    __swig_setmethods__ = {}
    for _s in [__init__.Orderer, Operator]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, Orderer, name, value)
    __swig_getmethods__ = {}
    for _s in [__init__.Orderer, Operator]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, Orderer, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(Isorropia::Epetra::Orderer self, Teuchos::RCP< Epetra_CrsGraph const > input_graph, ParameterList paramlist, bool compute_now=True) -> Orderer
        __init__(Isorropia::Epetra::Orderer self, CrsGraph input_graph, ParameterList paramlist, bool compute_now=True) -> Orderer
        __init__(Isorropia::Epetra::Orderer self, Teuchos::RCP< Epetra_RowMatrix const > input_matrix, ParameterList paramlist, bool compute_now=True) -> Orderer
        __init__(Isorropia::Epetra::Orderer self, RowMatrix input_matrix, ParameterList paramlist, bool compute_now=True) -> Orderer
        """
        this = _IsorropiaEpetra.new_Orderer(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _IsorropiaEpetra.delete_Orderer

    def order(self, *args):
        """order(Orderer self, bool force_ordering=False)"""
        return _IsorropiaEpetra.Orderer_order(self, *args)


    def compute(self, *args):
        """compute(Orderer self, bool forceOrdering=False)"""
        return _IsorropiaEpetra.Orderer_compute(self, *args)

Orderer_swigregister = _IsorropiaEpetra.Orderer_swigregister
Orderer_swigregister(Orderer)

class LevelScheduler(__init__.LevelScheduler, Operator):
    """Proxy of C++ Isorropia::Epetra::LevelScheduler class."""

    __swig_setmethods__ = {}
    for _s in [__init__.LevelScheduler, Operator]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, LevelScheduler, name, value)
    __swig_getmethods__ = {}
    for _s in [__init__.LevelScheduler, Operator]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, LevelScheduler, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """__init__(Isorropia::Epetra::LevelScheduler self, Teuchos::RCP< Epetra_CrsGraph const > input_graph, ParameterList paramlist, bool compute_now=True) -> LevelScheduler"""
        this = _IsorropiaEpetra.new_LevelScheduler(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _IsorropiaEpetra.delete_LevelScheduler

    def schedule(self, *args):
        """schedule(LevelScheduler self, bool force_scheduling=False)"""
        return _IsorropiaEpetra.LevelScheduler_schedule(self, *args)


    def compute(self, *args):
        """compute(LevelScheduler self, bool force_compute=False)"""
        return _IsorropiaEpetra.LevelScheduler_compute(self, *args)

LevelScheduler_swigregister = _IsorropiaEpetra.LevelScheduler_swigregister
LevelScheduler_swigregister(LevelScheduler)


try:
    import sys
    import random
    import colorsys
    import math

    try:
        from PIL import Image, ImageDraw
    except ImportError:
        import Image, ImageDraw

    Image_loaded = True
except ImportError:
    Image_loaded = False 

class Visualizer:
    """
    The Visualizer class provides a means of simply visualizing partitions
    formed by Isorropia.Epetra.Partitioner or Partitioner2D. It can also draw
    Epetra.CrsMatrix objects directly.

    The Visualizer relies on the Python Imaging Library and ImageMagick.

    To generate images of multiple sizes given the same partitioner, you'll
    need to call generateImage() several times, calling getPILImage() after
    each call and saving the result. You can then save or show those images as
    necessary.

    """

    data     = None  # The matrix/partition we are visualizing. After
# redistribution this will always be a CrsMatrix.
    dataType = None  # The type of the original data passed in.
# Currently supported: CrsMatrix, Partitioner,
# Partitioner2D

    numProcs        = 0
    verbosity       = 0
    iAmRoot         = False
    loadThreshold   = 0

    img             = None

    background      = 0x000000
    matrixHeight    = -1
    matrixWidth     = -1
    imageHeight     = -1
    imageWidth      = -1

    pointTL         = (0,0)
    pointBR         = (-1,-1)
    regionHeight    = -1
    regionWidth     = -1

    def __init__(self, data, numParts=-1, loadThreshold=0, verbosity=0):
        """
        Visualizer constructor.
        Inputs: data      - CrsMatrix or Partitioner
                numParts  - The number of parts to distribute into.
                            Defaults to the number of processes in MPI.
                loadThreshold - The threshold ratio that must be exceeded
                            for the visualizer to display something in that
                            pixel. Zero is a safe choice.
                verbosity - Print debugging output. High number increases
                            quantity of output.

       The initialization first reassigns the values in the matrix to represent
       the processor they reside on (or have been partitioned to), then
       redistributes the matrix onto the root processor for use in show().
        """

        if Image_loaded == False:
            print "Python Imaging Library, ImageMagick and colorsys libraries required for Visualizer function"
            sys.exit(1)

        if isinstance(data, PyTrilinos.Epetra.CrsMatrix):
            self.comm = data.Comm()
        elif isinstance(data, PyTrilinos.Isorropia.Epetra.Partitioner) or isinstance(data, PyTrilinos.Isorropia.Epetra.Partitioner2D):
            self.comm = data.InputMatrix().Comm()
        else:
            sys.exit(1)

        iAmRoot = self.iAmRoot = self.comm.MyPID() == 0

        if numParts == -1:
            self.numProcs = comm.NumProc()
        else:
            self.numProcs = numParts

        self.verbosity = verbosity
        self.data = data
        self.loadThreshold = loadThreshold

        if isinstance(data, PyTrilinos.Epetra.CrsMatrix):
            if iAmRoot and verbosity > 1: print "Proceeding with CrsMatrix"

            self.dataType = "CrsMatrix"

            if iAmRoot and verbosity > 2: print "Redistributing for visualization"

# Reset the values of the matrix to their respective processors
            self.centralizeMatrix()

        elif isinstance(data, PyTrilinos.Isorropia.Epetra.Partitioner):
            if iAmRoot and verbosity > 1: print "Proceeding with Partitioner"

            self.dataType = "Partitioner"

            if iAmRoot and verbosity > 2: print "Redistributing for visualization"

# Reset the values of the matrix to their partitioned processors
            self.centralizePartitioner()

        elif isinstance(data, PyTrilinos.Isorropia.Epetra.Partitioner2D):
            if iAmRoot and verbosity > 1: print "Proceeding with Partitioner2D"

            self.dataType = "Partitioner2D"

            if iAmRoot and verbosity > 2: print "Redistributing for visualization"

# Reset the values of the matrix to their partitioned processors
            self.centralizePartitioner2D()

# Only support CrsMatrix and Partitioner objects currently
        else:
            sys.exit(1)


    def processRow(self, row, draw):
        """
        processRow() is a private helper to draw an individual row of pixels of
        the image when simpleGenerate() can't be used.

        """

        if not self.iAmRoot: return

        if self.verbosity > 3: print "Processing row " + str(row)

        widthRatio = float(self.regionWidth) / float(self.imageWidth)
        heightRatio = float(self.regionHeight) / float(self.imageHeight)

# Calculate starting and ending positions in the matrix which will be 
# drawn into this row of pixels
        startY = int(math.ceil(row * heightRatio)) + self.pointTL[1]
        endY = min(int(math.floor((row + 1) * heightRatio)) + self.pointTL[1], self.matrixHeight - 1)
#startY = int(math.ceil(row * heightRatio))
#endY = min(int(math.floor((row + 1) * heightRatio)), self.matrixHeight - 1)

# Extract the rows to be represented
        nonZeroes = []
        for j in range(startY, endY + 1):
            nonZeroes += [self.data.ExtractGlobalRowCopy(j)]

# procCount: List of lists. One list per pixel, whose values represent
# the number of nonzeroes for the i-th processor found in this pixel so far
        procCount = [[0]*(self.numProcs + 1) for i in range(self.imageWidth)]
        for k in range(len(nonZeroes)):
# x = arbitrary id. Ideally would be dictionary.
            procNums = nonZeroes[k][0]          # Maps x -> processor ID
            colIndices = nonZeroes[k][1]        # Maps x -> column index.

# Go through the nonzeroes in this row and increment the appropriate
# counter
            for l in range(len(procNums)): # (len(colIndices) would be the same)
# Only show the columns we care about
                if colIndices[l] < self.pointTL[0]:
                    continue
                if colIndices[l] >= self.pointBR[0]:
                    break

# Take the matrix column and show us which pixel column it should go into
                pixelColumn = int((colIndices[l] - self.pointTL[0]) / widthRatio)
                if (pixelColumn >= len(procCount)):
                    print "Invalid value found for pixelColumn. Quitting."
                    print pixelColumn, len(procCount)
                    sys.exit(1)

# Increment the counter for whomever owns that nonzero
                if (int(procNums[l]) >= len(procCount[pixelColumn])) or (int(procNums[l]) < 0):
                    print "Invalid value found for part value. Quitting."
                    sys.exit(1)
                else:
                    procCount[pixelColumn][int(procNums[l])] += 1

# Draw each pixel in the row, once we have counted up the nonzeroes
        for col in range(self.imageWidth):
# Ensure there were enough nonzeroes in this pixel to warrant drawing.
# Currently the threshold is 0, so any nonzero is displayed, but it
# supports change.
            numElementsInPixel = int(widthRatio * (endY - startY))
            if numElementsInPixel == 0: loadRatio = 0
            else: loadRatio = float(sum(procCount[col])) / numElementsInPixel
            if(max(procCount[col]) != 0 and loadRatio > self.loadThreshold):
                draw.rectangle([col, row,
                                col + 1,
                                row + 1],
                               fill=self.fillColors[procCount[col].index(max(procCount[col])) - 1])


    def generateImage(self):
        """
        Opens an image window representing the matrix stored in this object's
        data field. This opened window allows saving the image.

        The colors chosen to represent each processor are evenly distributed
        along the hue and presently can not be customized.

        """

        if not self.iAmRoot: return

        if self.dataType != "CrsMatrix" and self.dataType != "Partitioner" and self.dataType != "Partitioner2D":
            raise "Error: Only CrsMatrix and Partitioner[2D] data formats supported at present"
            return

        self.matrixHeight = self.data.NumGlobalRows()
        self.matrixWidth  = self.data.NumGlobalCols()

        if self.pointBR[0] == -1 or self.pointBR[1] == -1:
            self.pointBR = (self.matrixWidth, self.matrixHeight)

        self.regionHeight = self.pointBR[1] - self.pointTL[1]
        self.regionWidth  = self.pointBR[0] - self.pointTL[0]

# Generate an image that maintains aspect ratio if we have not been given a height.
        if self.imageHeight == -1:
            self.imageHeight = int(float(self.regionHeight) / self.regionWidth * self.imageWidth)
            if self.verbosity > 3: print "Defining height as", self.imageHeight

# Create Image and ImageDraw objects
        im = Image.new("RGB", (self.imageWidth, self.imageHeight), self.background)
        draw = ImageDraw.Draw(im)


        if (self.pointBR[0] > self.matrixWidth or
            self.pointBR[1] > self.matrixWidth or
            self.pointBR[0] < self.pointTL[0] or
            self.pointBR[1] < self.pointTL[1] or
            self.pointTL[0] < 0 or
            self.pointTL[1] < 0 or
            self.regionHeight <= 0 or
            self.regionWidth <= 0):
            raise Exception("Invalid region of interest")

        cellWidth = self.imageWidth / self.regionWidth
        cellHeight = self.imageHeight / self.regionHeight

        self.fillColors = self.fillColorArray(self.numProcs)

        """ If we have more matrix rows or columns than we have pixels, can't use simpleGenerate() """
        if cellWidth == 0 and cellHeight == 0:    
            if self.verbosity > 2: print "NOT using simpleGenerate()"
            for i in range(self.imageHeight): # Go through the rows
                self.processRow(i, draw)
        elif cellWidth == 0 or cellHeight == 0:
            sys.stderr.write("""
                ERROR: There exists a known bug where nothing prints if you try to
                print part of your matrix such that you have more rows in your
                image than in your matrix but fewer columns than in your
                matrix. Or vice versa. We're working on fixing this. In the
                meantime, please re-size your print region, your image output,
                or both!
                """)
        else:
            if self.verbosity > 2: print "Using simpleGenerate()"
            self.simpleGenerate(draw)


        self.img = im

    def show(self):
        """
        Shows the pre-generated image. Must be preceded by a call to generateImage().
        """
        if not self.iAmRoot: return

        if self.img == None:
            print "Image must be computed before call to show(). Call generateImage() first."
            return

        self.img.show()

    def save(self, filename):
        """
        Saves the pre-generated image to the given file. The format is derived
        from the filename. Must be preceded by a call to generateImage().

        """
        if not self.iAmRoot: return

        if self.img == None:
            print "Image must be computed before call to save(). Call generateImage() first."
            return

        self.img.save(filename)

    def getPILImage(self):
        """
        Returns the PIL Image object generated by generateImage(). Returns None
        if no image has yet been generated.
        """
        return self.img

    def simpleGenerate(self, draw):
        """
        Draws the matrix to the provided image object, provided that the width
        and height of the image exceed the number of columns and rows of the matrix.

        Used by generateImage().
        """
        if not self.iAmRoot: return

        regionWidth = self.pointBR[0] - self.pointTL[0]
        regionHeight = self.pointBR[1] - self.pointTL[1]

        fillColors = self.fillColorArray(self.numProcs)

        cellWidth = float(self.imageWidth) / regionWidth
        cellHeight = float(self.imageHeight) / regionHeight

# Loop through rows of matrix
        for i in range(self.pointTL[1], self.pointBR[1]):
            nonZeroes = self.data.ExtractGlobalRowCopy(i)

            procNums = nonZeroes[0]
            colIndices = nonZeroes[1]

            startY = (i - self.pointTL[1]) * cellHeight

# Loop through nonzeroes, drawing appropriate rectangles
            for j in range(len(colIndices)):
                if colIndices[j] < self.pointTL[0]: continue
                elif colIndices[j] >= self.pointBR[0]: break
                startX = (colIndices[j] - self.pointTL[0]) * cellWidth
                draw.rectangle([int(startX), int(startY),
                                int(startX + cellWidth),
                                int(startY + cellHeight)],
                               fill=fillColors[int(procNums[j]) - 1])

    def setBgColor(self, background):
        self.background = background

    def setImageHeight(self, height):
        self.imageHeight = height

    def setImageWidth(self, width):
        self.imageWidth = width

    def setViewingWindow(self, pointTL, pointBR=(-1,-1)):
        self.pointTL = pointTL
        self.pointBR = pointBR

    def setVerbosity(self, verbosity):
        self.verbosity = verbosity

    def fillColorArray(self, numParts):
        """
        Given the number of partitions, returns an array of at least that many
        distinct color values
        """

        HSV_tuples = [(x*1.0/numParts, 0.9, 0.8) for x in range(numParts)]
        RGB_tuples = map(lambda x: colorsys.hsv_to_rgb(*x), HSV_tuples)
        hex_tuples = map(lambda x: (int(255*x[2]) << 16)+(int(255*x[1]) << 8)+(int(255*x[0])), RGB_tuples)

        random.shuffle(hex_tuples)

        return hex_tuples


    def centralizeMatrix(self):
        """
        Performs two operations:
            1. Replaces all non-zero values in the matrix with a value
               representing that non-zero's global part ID
            2. Repartitions such that all elements in the matrix are owned by
               the main process.
        """

        """ Reset the values in each row of the matrix to this processor's ID """
        for i in range(self.data.NumMyRows()):
            rowView = self.data.ExtractMyRowCopy(i) # Values first, indices second
            self.data.ReplaceMyValues(i, [self.comm.MyPID() + 1]*len(rowView[1]), rowView[1])

        globalNumRows = self.data.NumGlobalRows()

# Create a map to move all rows to the root processor
        if self.iAmRoot:
            localNumRows = globalNumRows
        else:
            localNumRows = 0

        targetMap = PyTrilinos.Epetra.Map(globalNumRows, localNumRows, 0, self.comm)
        redist = PyTrilinos.Isorropia.Epetra.Redistributor(targetMap)
# Redistribute to root processor
        self.data = redist.redistribute(self.data)

    def centralizePartitioner(self):
        """
        Performs three operations:
            1. Replaces the partitioner with a new CrsMatrix, maintaining
               non-zero distribution (with the same RowMap).
            1. Replaces all non-zero values in the matrix with a value
               representing that non-zero's global part ID
            2. Repartitions such that all elements in the matrix are owned by
               the main process.

        """

        rowMatrix = self.data.InputMatrix()
        map = rowMatrix.RowMatrixRowMap()

# Get information needed to create a duplicate CrsMatrix
        rowLengths = []
        rows = []
        for i in range(rowMatrix.NumMyRows()):
            rowView = rowMatrix.ExtractMyRowCopy(i) # Values first, indices second
            rows += [rowView[1]]
            rowLengths += [len(rowView[1])]

# Create a new CrsMatrix to duplicate the Partitioner's RowMatrix
        crsm = PyTrilinos.Epetra.CrsMatrix(PyTrilinos.Epetra.Copy, map, rowMatrix.RowMatrixColMap(), rowLengths)
        for gid in range(map.MaxLID()+1):
            values = [1]*len(rows[gid])
            crsm.InsertMyValues(gid, values, rows[gid])
        crsm.FillComplete()

# Reassign the CrsMatrix's values to their mapped processor IDs
        newMap = self.data.createNewMap()

        matrixHeight = rowMatrix.NumGlobalRows()

        for i in range(crsm.NumMyRows()):
            rowView = rowMatrix.ExtractMyRowCopy(i) # Values first, indices second
            gid = map.GID(i)
            newLoc = self.data.index(i) ###########################################################
            if newLoc < 0 or newLoc > matrixHeight:
                print "newLoc is wrong, quitting", newLoc
                sys.exit(1)
            crsm.ReplaceMyValues(i, [newLoc + 1]*len(rowView[1]), rowView[1])
        crsm.FillComplete()

# Set self.data to the CrsMatrix representation
        self.data = crsm

        globalNumRows = self.data.NumGlobalRows()

# Create a map to move all rows to the root processor
        if self.iAmRoot:
            localNumRows = globalNumRows
        else:
            localNumRows = 0

        targetMap = PyTrilinos.Epetra.Map(globalNumRows, localNumRows, 0, self.comm)
        redist = PyTrilinos.Isorropia.Epetra.Redistributor(targetMap)
# Redistribute to root processor
        self.data = redist.redistribute(self.data)

    def centralizePartitioner2D(self):
        """
        Exactly the same as centralizePartitioner(), but accepting a Partitioner2D.

        Creates a new CrsMatrix to represent the Partitioner2D's matrix
        structure. This new CrsMatrix has the same distribution as the
        Partitioner2D's matrix, but the values of the nonzeroes represent their
        'destination' processors in the Partitioner's new Map
        """

        rowMatrix = self.data.InputMatrix()
        map = rowMatrix.RowMatrixRowMap()

# Get information needed to create a duplicate CrsMatrix
        rowLengths = []
        rows = []
        for i in range(rowMatrix.NumMyRows()):
            rowView = rowMatrix.ExtractMyRowCopy(i) # Values first, indices second
            rows += [rowView[1]]
            rowLengths += [len(rowView[1])]

# Create a new CrsMatrix to duplicate the Partitioner's RowMatrix
        crsm = PyTrilinos.Epetra.CrsMatrix(PyTrilinos.Epetra.Copy, map, rowMatrix.RowMatrixColMap(), rowLengths)
        for gid in range(map.MaxLID()+1):
            values = [0]*len(rows[gid])
            crsm.InsertMyValues(gid, values, rows[gid])
        crsm.FillComplete()

# Reassign the CrsMatrix's values to their mapped processor IDs
        matrixHeight = rowMatrix.NumGlobalRows()

        numMyNZs = rowMatrix.NumMyNonzeros()
        counter = 0

        for i in range(crsm.NumMyRows()):
            rowView = rowMatrix.ExtractMyRowCopy(i) # Values first, indices second
            gid = map.GID(i)
            newProcs = [0] * len(rowView[1])
            for j in range(len(newProcs)):
                newProcs[j] = self.data.index(counter)
                counter += 1
            crsm.SumIntoMyValues(i, newProcs, rowView[1])

        crsm.FillComplete()

# Set self.data to the CrsMatrix representation
        self.data = crsm

        globalNumRows = self.data.NumGlobalRows()

# Create a map to move all rows to the root processor
        if self.iAmRoot:
            localNumRows = globalNumRows
        else:
            localNumRows = 0

        targetMap = PyTrilinos.Epetra.Map(globalNumRows, localNumRows, 0, self.comm)
        redist = PyTrilinos.Isorropia.Epetra.Redistributor(targetMap)
# Redistribute to root processor
        self.data = redist.redistribute(self.data)


# This file is compatible with both classic and new-style classes.


