# This file was automatically generated by SWIG (http://www.swig.org).
# Version 3.0.12
#
# Do not make changes to this file unless you know what you are doing--modify
# the SWIG interface file instead.

"""

PyTrilinos.IFPACK is the python interface to the Trilinos
preconditioner package IFPACK:

    http://trilinos.sandia.gov/packages/ifpack

The purpose of IFPACK is to provide incomplete foctorization
preconditioners to Trilinos.  Note that the C++ version of IFPACK uses
the prefix 'Ifpack_' which has been stripped from the python version.

IFPACK provides the following user-level classes:

    * Factory         - A factory for creating IFPACK preconditioners
    * Preconditioner  - Pure virtual base class for defining interface
    * IC              - Incomplete Cholesky preconditioner
    * ICT             - Incomplete Cholesky preconditioner w/threshold
    * ILU             - Incomplete lower/upper preconditioner
    * ILUT            - Incomplete lower/upper preconditioner w/threshold
    * PointRelaxation - Point relaxation predonditioner
    * Amesos          - Use Amesos factorizations as preconditioners

and functions:

    * AnalyzeMatrix          - Analyze the basic properties of a matrix
    * AnalyzeMatrixElements  - Analyze the distribution of values of a matrix
    * AnalyzeVectorElements  - Analyze the distribution of values of a vector
    * PrintSparsity          - Create PS file with sparsity pattern of matrix

For examples of usage, please consult the following scripts in the
example subdirectory of the PyTrilinos package:

    * exIFPACK.py

"""


from sys import version_info as _swig_python_version_info
if _swig_python_version_info >= (2, 7, 0):
    def swig_import_helper():
        import importlib
        pkg = __name__.rpartition('.')[0]
        mname = '.'.join((pkg, '_IFPACK')).lstrip('.')
        try:
            return importlib.import_module(mname)
        except ImportError:
            return importlib.import_module('_IFPACK')
    _IFPACK = swig_import_helper()
    del swig_import_helper
elif _swig_python_version_info >= (2, 6, 0):
    def swig_import_helper():
        from os.path import dirname
        import imp
        fp = None
        try:
            fp, pathname, description = imp.find_module('_IFPACK', [dirname(__file__)])
        except ImportError:
            import _IFPACK
            return _IFPACK
        try:
            _mod = imp.load_module('_IFPACK', fp, pathname, description)
        finally:
            if fp is not None:
                fp.close()
        return _mod
    _IFPACK = swig_import_helper()
    del swig_import_helper
else:
    import _IFPACK
del _swig_python_version_info

try:
    _swig_property = property
except NameError:
    pass  # Python < 2.2 doesn't have 'property'.

try:
    import builtins as __builtin__
except ImportError:
    import __builtin__

def _swig_setattr_nondynamic(self, class_type, name, value, static=1):
    if (name == "thisown"):
        return self.this.own(value)
    if (name == "this"):
        if type(value).__name__ == 'SwigPyObject':
            self.__dict__[name] = value
            return
    method = class_type.__swig_setmethods__.get(name, None)
    if method:
        return method(self, value)
    if (not static):
        if _newclass:
            object.__setattr__(self, name, value)
        else:
            self.__dict__[name] = value
    else:
        raise AttributeError("You cannot add attributes to %s" % self)


def _swig_setattr(self, class_type, name, value):
    return _swig_setattr_nondynamic(self, class_type, name, value, 0)


def _swig_getattr(self, class_type, name):
    if (name == "thisown"):
        return self.this.own()
    method = class_type.__swig_getmethods__.get(name, None)
    if method:
        return method(self)
    raise AttributeError("'%s' object has no attribute '%s'" % (class_type.__name__, name))


def _swig_repr(self):
    try:
        strthis = "proxy of " + self.this.__repr__()
    except __builtin__.Exception:
        strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)

try:
    _object = object
    _newclass = 1
except __builtin__.Exception:
    class _object:
        pass
    _newclass = 0

try:
    import weakref
    weakref_proxy = weakref.proxy
except __builtin__.Exception:
    weakref_proxy = lambda x: x


import PyTrilinos.Teuchos
import PyTrilinos.Epetra

def Ifpack_Version(*args):
    """Ifpack_Version() -> std::string"""
    return _IFPACK.Ifpack_Version(*args)

Version = Ifpack_Version
__version__ = Version().split()[3]


def Ifpack_PrintLine(*args):
    """Ifpack_PrintLine()"""
    return _IFPACK.Ifpack_PrintLine(*args)

def Ifpack_BreakForDebugger(*args):
    """Ifpack_BreakForDebugger(Comm Comm)"""
    return _IFPACK.Ifpack_BreakForDebugger(*args)

def Ifpack_CreateOverlappingCrsMatrix(*args):
    """
    Ifpack_CreateOverlappingCrsMatrix(RowMatrix Matrix, int const OverlappingLevel) -> CrsMatrix
    Ifpack_CreateOverlappingCrsMatrix(CrsGraph Graph, int const OverlappingLevel) -> CrsGraph
    """
    return _IFPACK.Ifpack_CreateOverlappingCrsMatrix(*args)

def Ifpack_toString(*args):
    """
    Ifpack_toString(int const & x) -> std::string
    Ifpack_toString(double const & x) -> std::string
    """
    return _IFPACK.Ifpack_toString(*args)

def Ifpack_PrintResidual(*args):
    """
    Ifpack_PrintResidual(char * Label, RowMatrix A, MultiVector X, MultiVector Y) -> int
    Ifpack_PrintResidual(int const iter, RowMatrix A, MultiVector X, MultiVector Y) -> int
    """
    return _IFPACK.Ifpack_PrintResidual(*args)

def Ifpack_PrintSparsity_Simple(*args):
    """Ifpack_PrintSparsity_Simple(RowMatrix A)"""
    return _IFPACK.Ifpack_PrintSparsity_Simple(*args)

def AnalyzeMatrix(*args):
    """AnalyzeMatrix(RowMatrix A, bool const Cheap=False, int const NumPDEEqns=1) -> int"""
    return _IFPACK.AnalyzeMatrix(*args)

def AnalyzeMatrixElements(*args):
    """AnalyzeMatrixElements(RowMatrix A, bool const abs=False, int const steps=10) -> int"""
    return _IFPACK.AnalyzeMatrixElements(*args)

def AnalyzeVectorElements(*args):
    """AnalyzeVectorElements(Vector Diagonal, bool const abs=False, int const steps=10) -> int"""
    return _IFPACK.AnalyzeVectorElements(*args)

def PrintSparsity(*args):
    """PrintSparsity(RowMatrix A, char const * FileName=None, int const NumPDEEqns=1) -> int"""
    return _IFPACK.PrintSparsity(*args)
class Ifpack_Element(_object):
    """Proxy of C++ Ifpack_Element class."""

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, Ifpack_Element, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, Ifpack_Element, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(Ifpack_Element self) -> Ifpack_Element
        __init__(Ifpack_Element self, Ifpack_Element rhs) -> Ifpack_Element
        """
        this = _IFPACK.new_Ifpack_Element(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

    def Index(self, *args):
        """Index(Ifpack_Element self) -> int"""
        return _IFPACK.Ifpack_Element_Index(self, *args)


    def Value(self, *args):
        """Value(Ifpack_Element self) -> double"""
        return _IFPACK.Ifpack_Element_Value(self, *args)


    def AbsValue(self, *args):
        """AbsValue(Ifpack_Element self) -> double"""
        return _IFPACK.Ifpack_Element_AbsValue(self, *args)


    def SetIndex(self, *args):
        """SetIndex(Ifpack_Element self, int const i)"""
        return _IFPACK.Ifpack_Element_SetIndex(self, *args)


    def SetValue(self, *args):
        """SetValue(Ifpack_Element self, double const val)"""
        return _IFPACK.Ifpack_Element_SetValue(self, *args)


    def __lt__(self, *args):
        """__lt__(Ifpack_Element self, Ifpack_Element rhs) -> bool"""
        return _IFPACK.Ifpack_Element___lt__(self, *args)

    __swig_destroy__ = _IFPACK.delete_Ifpack_Element
Ifpack_Element_swigregister = _IFPACK.Ifpack_Element_swigregister
Ifpack_Element_swigregister(Ifpack_Element)

class Preconditioner(PyTrilinos.Epetra.Operator):
    """Proxy of C++ Ifpack_Preconditioner class."""

    __swig_setmethods__ = {}
    for _s in [PyTrilinos.Epetra.Operator]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, Preconditioner, name, value)
    __swig_getmethods__ = {}
    for _s in [PyTrilinos.Epetra.Operator]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, Preconditioner, name)

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr

    def SetParameters(self, *args):
        """SetParameters(Preconditioner self, ParameterList List) -> int"""
        return _IFPACK.Preconditioner_SetParameters(self, *args)


    def Initialize(self, *args):
        """Initialize(Preconditioner self) -> int"""
        return _IFPACK.Preconditioner_Initialize(self, *args)


    def IsInitialized(self, *args):
        """IsInitialized(Preconditioner self) -> bool"""
        return _IFPACK.Preconditioner_IsInitialized(self, *args)


    def Compute(self, *args):
        """Compute(Preconditioner self) -> int"""
        return _IFPACK.Preconditioner_Compute(self, *args)


    def IsComputed(self, *args):
        """IsComputed(Preconditioner self) -> bool"""
        return _IFPACK.Preconditioner_IsComputed(self, *args)


    def Condest(self, *args):
        """Condest(Preconditioner self, Ifpack_CondestType const CT, int const MaxIters=1550, double const Tol=1e-9, RowMatrix Matrix=None) -> double"""
        return _IFPACK.Preconditioner_Condest(self, *args)


    def ApplyInverse(self, *args):
        """
        ApplyInverse(self, MultiVector x, MultiVector y) -> int

        In C++, the ApplyInverse() method is pure virtual, thus intended to be
        overridden by derived classes.  In python, cross-language polymorphism
        is supported, and you are expected to derive classes from this base
        class and redefine the ApplyInverse() method.  C++ code (e.g., AztecOO
        solvers) can call back to your ApplyInverse() method as needed.  You
        must support two arguments, labeled here MultiVector x and MultiVector
        y.  These will be converted from Epetra_MultiVector C++ objects to
        numpy-hybrid Epetra.MultiVector objects before they are passed to you.
        Thus, it is legal to use slice indexing and other numpy features to
        compute y from x.

        If application of your operator is successful, return 0; else return
        some non-zero error code.

        It is strongly suggested that you prevent ApplyInverse() from raising
        any exceptions.  Accidental errors can be prevented by wrapping your
        code in a try block:

            try:
                # Your code goes here...
            except Exception, e:
                print 'A python exception was raised by method ApplyInverse:'
                print e
                return -1

        By returning a -1, you inform the calling routine that ApplyInverse()
        was unsuccessful.

        """
        return _IFPACK.Preconditioner_ApplyInverse(self, *args)


    def Matrix(self, *args):
        """Matrix(Preconditioner self) -> RowMatrix"""
        return _IFPACK.Preconditioner_Matrix(self, *args)


    def NumInitialize(self, *args):
        """NumInitialize(Preconditioner self) -> int"""
        return _IFPACK.Preconditioner_NumInitialize(self, *args)


    def NumCompute(self, *args):
        """NumCompute(Preconditioner self) -> int"""
        return _IFPACK.Preconditioner_NumCompute(self, *args)


    def NumApplyInverse(self, *args):
        """NumApplyInverse(Preconditioner self) -> int"""
        return _IFPACK.Preconditioner_NumApplyInverse(self, *args)


    def InitializeTime(self, *args):
        """InitializeTime(Preconditioner self) -> double"""
        return _IFPACK.Preconditioner_InitializeTime(self, *args)


    def ComputeTime(self, *args):
        """ComputeTime(Preconditioner self) -> double"""
        return _IFPACK.Preconditioner_ComputeTime(self, *args)


    def ApplyInverseTime(self, *args):
        """ApplyInverseTime(Preconditioner self) -> double"""
        return _IFPACK.Preconditioner_ApplyInverseTime(self, *args)


    def InitializeFlops(self, *args):
        """InitializeFlops(Preconditioner self) -> double"""
        return _IFPACK.Preconditioner_InitializeFlops(self, *args)


    def ComputeFlops(self, *args):
        """ComputeFlops(Preconditioner self) -> double"""
        return _IFPACK.Preconditioner_ComputeFlops(self, *args)


    def ApplyInverseFlops(self, *args):
        """ApplyInverseFlops(Preconditioner self) -> double"""
        return _IFPACK.Preconditioner_ApplyInverseFlops(self, *args)


    def __str__(self, *args):
        """__str__(Preconditioner self) -> std::string"""
        return _IFPACK.Preconditioner___str__(self, *args)

    __swig_destroy__ = _IFPACK.delete_Preconditioner
Preconditioner_swigregister = _IFPACK.Preconditioner_swigregister
Preconditioner_swigregister(Preconditioner)

class IC(Preconditioner):
    """Proxy of C++ Ifpack_IC class."""

    __swig_setmethods__ = {}
    for _s in [Preconditioner]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, IC, name, value)
    __swig_getmethods__ = {}
    for _s in [Preconditioner]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, IC, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """__init__(Ifpack_IC self, RowMatrix A) -> IC"""
        this = _IFPACK.new_IC(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _IFPACK.delete_IC

    def SetAbsoluteThreshold(self, *args):
        """SetAbsoluteThreshold(IC self, double Athresh)"""
        return _IFPACK.IC_SetAbsoluteThreshold(self, *args)


    def SetRelativeThreshold(self, *args):
        """SetRelativeThreshold(IC self, double Rthresh)"""
        return _IFPACK.IC_SetRelativeThreshold(self, *args)


    def SetParameters(self, *args):
        """SetParameters(IC self, ParameterList parameterlis) -> int"""
        return _IFPACK.IC_SetParameters(self, *args)


    def SetParameter(self, *args):
        """
        SetParameter(IC self, std::string const Name, int const Value) -> int
        SetParameter(IC self, std::string const Name, double const Value) -> int
        """
        return _IFPACK.IC_SetParameter(self, *args)


    def Matrix(self, *args):
        """
        Matrix(IC self) -> RowMatrix
        Matrix(IC self) -> RowMatrix
        """
        return _IFPACK.IC_Matrix(self, *args)


    def IsInitialized(self, *args):
        """IsInitialized(IC self) -> bool"""
        return _IFPACK.IC_IsInitialized(self, *args)


    def Initialize(self, *args):
        """Initialize(IC self) -> int"""
        return _IFPACK.IC_Initialize(self, *args)


    def Compute(self, *args):
        """Compute(IC self) -> int"""
        return _IFPACK.IC_Compute(self, *args)


    def ComputeSetup(self, *args):
        """ComputeSetup(IC self) -> int"""
        return _IFPACK.IC_ComputeSetup(self, *args)


    def IsComputed(self, *args):
        """IsComputed(IC self) -> bool"""
        return _IFPACK.IC_IsComputed(self, *args)


    def ApplyInverse(self, *args):
        """
        ApplyInverse(self, MultiVector x, MultiVector y) -> int

        In C++, the ApplyInverse() method is pure virtual, thus intended to be
        overridden by derived classes.  In python, cross-language polymorphism
        is supported, and you are expected to derive classes from this base
        class and redefine the ApplyInverse() method.  C++ code (e.g., AztecOO
        solvers) can call back to your ApplyInverse() method as needed.  You
        must support two arguments, labeled here MultiVector x and MultiVector
        y.  These will be converted from Epetra_MultiVector C++ objects to
        numpy-hybrid Epetra.MultiVector objects before they are passed to you.
        Thus, it is legal to use slice indexing and other numpy features to
        compute y from x.

        If application of your operator is successful, return 0; else return
        some non-zero error code.

        It is strongly suggested that you prevent ApplyInverse() from raising
        any exceptions.  Accidental errors can be prevented by wrapping your
        code in a try block:

            try:
                # Your code goes here...
            except Exception, e:
                print 'A python exception was raised by method ApplyInverse:'
                print e
                return -1

        By returning a -1, you inform the calling routine that ApplyInverse()
        was unsuccessful.

        """
        return _IFPACK.IC_ApplyInverse(self, *args)


    def Apply(self, *args):
        """
        Apply(self, MultiVector x, MultiVector y) -> int

        In C++, the Apply() method is pure virtual, thus intended to be
        overridden by derived classes.  In python, cross-language polymorphism
        is supported, and you are expected to derive classes from this base
        class and redefine the Apply() method.  C++ code (e.g., AztecOO
        solvers) can call back to your Apply() method as needed.  You must
        support two arguments, labeled here MultiVector x and MultiVector y.
        These will be converted from Epetra_MultiVector C++ objects to
        numpy-hybrid Epetra.MultiVector objects before they are passed to you.
        Thus, it is legal to use slice indexing and other numpy features to
        compute y from x.

        If application of your operator is successful, return 0; else return
        some non-zero error code.

        It is strongly suggested that you prevent Apply() from raising any
        exceptions.  Accidental errors can be prevented by wrapping your code
        in a try block:

            try:
                # Your code goes here...
            except Exception, e:
                print 'A python exception was raised by method Apply:'
                print e
                return -1

        By returning a -1, you inform the calling routine that Apply() was
        unsuccessful.

        """
        return _IFPACK.IC_Apply(self, *args)


    def Condest(self, *args):
        """Condest(IC self, Ifpack_CondestType const CT, int const MaxIters=1550, double const Tol=1e-9, RowMatrix Matrix_in=None) -> double"""
        return _IFPACK.IC_Condest(self, *args)


    def GetAbsoluteThreshold(self, *args):
        """GetAbsoluteThreshold(IC self) -> double"""
        return _IFPACK.IC_GetAbsoluteThreshold(self, *args)


    def GetRelativeThreshold(self, *args):
        """GetRelativeThreshold(IC self) -> double"""
        return _IFPACK.IC_GetRelativeThreshold(self, *args)


    def NumGlobalNonzeros(self, *args):
        """NumGlobalNonzeros(IC self) -> int"""
        return _IFPACK.IC_NumGlobalNonzeros(self, *args)


    def NumGlobalNonzeros64(self, *args):
        """NumGlobalNonzeros64(IC self) -> long long"""
        return _IFPACK.IC_NumGlobalNonzeros64(self, *args)


    def NumMyNonzeros(self, *args):
        """NumMyNonzeros(IC self) -> int"""
        return _IFPACK.IC_NumMyNonzeros(self, *args)


    def D(self, *args):
        """D(IC self) -> Vector"""
        return _IFPACK.IC_D(self, *args)


    def U(self, *args):
        """U(IC self) -> CrsMatrix"""
        return _IFPACK.IC_U(self, *args)


    def SetUseTranspose(self, *args):
        """SetUseTranspose(IC self, bool UseTranspose_in) -> int"""
        return _IFPACK.IC_SetUseTranspose(self, *args)


    def NormInf(self, *args):
        """NormInf(IC self) -> double"""
        return _IFPACK.IC_NormInf(self, *args)


    def HasNormInf(self, *args):
        """HasNormInf(IC self) -> bool"""
        return _IFPACK.IC_HasNormInf(self, *args)


    def UseTranspose(self, *args):
        """UseTranspose(IC self) -> bool"""
        return _IFPACK.IC_UseTranspose(self, *args)


    def OperatorDomainMap(self, *args):
        """OperatorDomainMap(IC self) -> Map"""
        return _IFPACK.IC_OperatorDomainMap(self, *args)


    def OperatorRangeMap(self, *args):
        """OperatorRangeMap(IC self) -> Map"""
        return _IFPACK.IC_OperatorRangeMap(self, *args)


    def Comm(self, *args):
        """Comm(IC self) -> Comm"""
        return _IFPACK.IC_Comm(self, *args)


    def Label(self, *args):
        """Label(IC self) -> char const *"""
        return _IFPACK.IC_Label(self, *args)


    def SetLabel(self, *args):
        """SetLabel(IC self, char const * Label_in) -> int"""
        return _IFPACK.IC_SetLabel(self, *args)


    def NumInitialize(self, *args):
        """NumInitialize(IC self) -> int"""
        return _IFPACK.IC_NumInitialize(self, *args)


    def NumCompute(self, *args):
        """NumCompute(IC self) -> int"""
        return _IFPACK.IC_NumCompute(self, *args)


    def NumApplyInverse(self, *args):
        """NumApplyInverse(IC self) -> int"""
        return _IFPACK.IC_NumApplyInverse(self, *args)


    def InitializeTime(self, *args):
        """InitializeTime(IC self) -> double"""
        return _IFPACK.IC_InitializeTime(self, *args)


    def ComputeTime(self, *args):
        """ComputeTime(IC self) -> double"""
        return _IFPACK.IC_ComputeTime(self, *args)


    def ApplyInverseTime(self, *args):
        """ApplyInverseTime(IC self) -> double"""
        return _IFPACK.IC_ApplyInverseTime(self, *args)


    def InitializeFlops(self, *args):
        """InitializeFlops(IC self) -> double"""
        return _IFPACK.IC_InitializeFlops(self, *args)


    def ComputeFlops(self, *args):
        """ComputeFlops(IC self) -> double"""
        return _IFPACK.IC_ComputeFlops(self, *args)


    def ApplyInverseFlops(self, *args):
        """ApplyInverseFlops(IC self) -> double"""
        return _IFPACK.IC_ApplyInverseFlops(self, *args)

IC_swigregister = _IFPACK.IC_swigregister
IC_swigregister(IC)

class ICT(Preconditioner):
    """Proxy of C++ Ifpack_ICT class."""

    __swig_setmethods__ = {}
    for _s in [Preconditioner]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, ICT, name, value)
    __swig_getmethods__ = {}
    for _s in [Preconditioner]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, ICT, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """__init__(Ifpack_ICT self, RowMatrix A) -> ICT"""
        this = _IFPACK.new_ICT(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _IFPACK.delete_ICT

    def SetParameters(self, *args):
        """SetParameters(ICT self, ParameterList parameterlis) -> int"""
        return _IFPACK.ICT_SetParameters(self, *args)


    def Matrix(self, *args):
        """Matrix(ICT self) -> RowMatrix"""
        return _IFPACK.ICT_Matrix(self, *args)


    def IsInitialized(self, *args):
        """IsInitialized(ICT self) -> bool"""
        return _IFPACK.ICT_IsInitialized(self, *args)


    def Initialize(self, *args):
        """Initialize(ICT self) -> int"""
        return _IFPACK.ICT_Initialize(self, *args)


    def Compute(self, *args):
        """Compute(ICT self) -> int"""
        return _IFPACK.ICT_Compute(self, *args)


    def IsComputed(self, *args):
        """IsComputed(ICT self) -> bool"""
        return _IFPACK.ICT_IsComputed(self, *args)


    def ApplyInverse(self, *args):
        """
        ApplyInverse(self, MultiVector x, MultiVector y) -> int

        In C++, the ApplyInverse() method is pure virtual, thus intended to be
        overridden by derived classes.  In python, cross-language polymorphism
        is supported, and you are expected to derive classes from this base
        class and redefine the ApplyInverse() method.  C++ code (e.g., AztecOO
        solvers) can call back to your ApplyInverse() method as needed.  You
        must support two arguments, labeled here MultiVector x and MultiVector
        y.  These will be converted from Epetra_MultiVector C++ objects to
        numpy-hybrid Epetra.MultiVector objects before they are passed to you.
        Thus, it is legal to use slice indexing and other numpy features to
        compute y from x.

        If application of your operator is successful, return 0; else return
        some non-zero error code.

        It is strongly suggested that you prevent ApplyInverse() from raising
        any exceptions.  Accidental errors can be prevented by wrapping your
        code in a try block:

            try:
                # Your code goes here...
            except Exception, e:
                print 'A python exception was raised by method ApplyInverse:'
                print e
                return -1

        By returning a -1, you inform the calling routine that ApplyInverse()
        was unsuccessful.

        """
        return _IFPACK.ICT_ApplyInverse(self, *args)


    def Apply(self, *args):
        """
        Apply(self, MultiVector x, MultiVector y) -> int

        In C++, the Apply() method is pure virtual, thus intended to be
        overridden by derived classes.  In python, cross-language polymorphism
        is supported, and you are expected to derive classes from this base
        class and redefine the Apply() method.  C++ code (e.g., AztecOO
        solvers) can call back to your Apply() method as needed.  You must
        support two arguments, labeled here MultiVector x and MultiVector y.
        These will be converted from Epetra_MultiVector C++ objects to
        numpy-hybrid Epetra.MultiVector objects before they are passed to you.
        Thus, it is legal to use slice indexing and other numpy features to
        compute y from x.

        If application of your operator is successful, return 0; else return
        some non-zero error code.

        It is strongly suggested that you prevent Apply() from raising any
        exceptions.  Accidental errors can be prevented by wrapping your code
        in a try block:

            try:
                # Your code goes here...
            except Exception, e:
                print 'A python exception was raised by method Apply:'
                print e
                return -1

        By returning a -1, you inform the calling routine that Apply() was
        unsuccessful.

        """
        return _IFPACK.ICT_Apply(self, *args)


    def Condest(self, *args):
        """Condest(ICT self, Ifpack_CondestType const CT, int const MaxIters=1550, double const Tol=1e-9, RowMatrix Matrix_in=None) -> double"""
        return _IFPACK.ICT_Condest(self, *args)


    def NumGlobalNonzeros(self, *args):
        """NumGlobalNonzeros(ICT self) -> int"""
        return _IFPACK.ICT_NumGlobalNonzeros(self, *args)


    def NumGlobalNonzeros64(self, *args):
        """NumGlobalNonzeros64(ICT self) -> long long"""
        return _IFPACK.ICT_NumGlobalNonzeros64(self, *args)


    def NumMyNonzeros(self, *args):
        """NumMyNonzeros(ICT self) -> int"""
        return _IFPACK.ICT_NumMyNonzeros(self, *args)


    def H(self, *args):
        """H(ICT self) -> CrsMatrix"""
        return _IFPACK.ICT_H(self, *args)


    def SetUseTranspose(self, *args):
        """SetUseTranspose(ICT self, bool UseTranspose_in) -> int"""
        return _IFPACK.ICT_SetUseTranspose(self, *args)


    def NormInf(self, *args):
        """NormInf(ICT self) -> double"""
        return _IFPACK.ICT_NormInf(self, *args)


    def HasNormInf(self, *args):
        """HasNormInf(ICT self) -> bool"""
        return _IFPACK.ICT_HasNormInf(self, *args)


    def UseTranspose(self, *args):
        """UseTranspose(ICT self) -> bool"""
        return _IFPACK.ICT_UseTranspose(self, *args)


    def OperatorDomainMap(self, *args):
        """OperatorDomainMap(ICT self) -> Map"""
        return _IFPACK.ICT_OperatorDomainMap(self, *args)


    def OperatorRangeMap(self, *args):
        """OperatorRangeMap(ICT self) -> Map"""
        return _IFPACK.ICT_OperatorRangeMap(self, *args)


    def Comm(self, *args):
        """Comm(ICT self) -> Comm"""
        return _IFPACK.ICT_Comm(self, *args)


    def Label(self, *args):
        """Label(ICT self) -> char const *"""
        return _IFPACK.ICT_Label(self, *args)


    def SetLabel(self, *args):
        """SetLabel(ICT self, char const * Label_in) -> int"""
        return _IFPACK.ICT_SetLabel(self, *args)


    def NumInitialize(self, *args):
        """NumInitialize(ICT self) -> int"""
        return _IFPACK.ICT_NumInitialize(self, *args)


    def NumCompute(self, *args):
        """NumCompute(ICT self) -> int"""
        return _IFPACK.ICT_NumCompute(self, *args)


    def NumApplyInverse(self, *args):
        """NumApplyInverse(ICT self) -> int"""
        return _IFPACK.ICT_NumApplyInverse(self, *args)


    def InitializeTime(self, *args):
        """InitializeTime(ICT self) -> double"""
        return _IFPACK.ICT_InitializeTime(self, *args)


    def ComputeTime(self, *args):
        """ComputeTime(ICT self) -> double"""
        return _IFPACK.ICT_ComputeTime(self, *args)


    def ApplyInverseTime(self, *args):
        """ApplyInverseTime(ICT self) -> double"""
        return _IFPACK.ICT_ApplyInverseTime(self, *args)


    def InitializeFlops(self, *args):
        """InitializeFlops(ICT self) -> double"""
        return _IFPACK.ICT_InitializeFlops(self, *args)


    def ComputeFlops(self, *args):
        """ComputeFlops(ICT self) -> double"""
        return _IFPACK.ICT_ComputeFlops(self, *args)


    def ApplyInverseFlops(self, *args):
        """ApplyInverseFlops(ICT self) -> double"""
        return _IFPACK.ICT_ApplyInverseFlops(self, *args)


    def LevelOfFill(self, *args):
        """LevelOfFill(ICT self) -> double"""
        return _IFPACK.ICT_LevelOfFill(self, *args)


    def AbsoluteThreshold(self, *args):
        """AbsoluteThreshold(ICT self) -> double"""
        return _IFPACK.ICT_AbsoluteThreshold(self, *args)


    def RelativeThreshold(self, *args):
        """RelativeThreshold(ICT self) -> double"""
        return _IFPACK.ICT_RelativeThreshold(self, *args)


    def RelaxValue(self, *args):
        """RelaxValue(ICT self) -> double"""
        return _IFPACK.ICT_RelaxValue(self, *args)


    def DropTolerance(self, *args):
        """DropTolerance(ICT self) -> double"""
        return _IFPACK.ICT_DropTolerance(self, *args)

ICT_swigregister = _IFPACK.ICT_swigregister
ICT_swigregister(ICT)

class ILU(Preconditioner):
    """Proxy of C++ Ifpack_ILU class."""

    __swig_setmethods__ = {}
    for _s in [Preconditioner]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, ILU, name, value)
    __swig_getmethods__ = {}
    for _s in [Preconditioner]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, ILU, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """__init__(Ifpack_ILU self, RowMatrix A) -> ILU"""
        this = _IFPACK.new_ILU(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _IFPACK.delete_ILU

    def Initialize(self, *args):
        """Initialize(ILU self) -> int"""
        return _IFPACK.ILU_Initialize(self, *args)


    def IsInitialized(self, *args):
        """IsInitialized(ILU self) -> bool"""
        return _IFPACK.ILU_IsInitialized(self, *args)


    def Compute(self, *args):
        """Compute(ILU self) -> int"""
        return _IFPACK.ILU_Compute(self, *args)


    def IsComputed(self, *args):
        """IsComputed(ILU self) -> bool"""
        return _IFPACK.ILU_IsComputed(self, *args)


    def SetParameters(self, *args):
        """SetParameters(ILU self, ParameterList parameterlist) -> int"""
        return _IFPACK.ILU_SetParameters(self, *args)


    def SetUseTranspose(self, *args):
        """SetUseTranspose(ILU self, bool UseTranspose_in) -> int"""
        return _IFPACK.ILU_SetUseTranspose(self, *args)


    def Apply(self, *args):
        """
        Apply(self, MultiVector x, MultiVector y) -> int

        In C++, the Apply() method is pure virtual, thus intended to be
        overridden by derived classes.  In python, cross-language polymorphism
        is supported, and you are expected to derive classes from this base
        class and redefine the Apply() method.  C++ code (e.g., AztecOO
        solvers) can call back to your Apply() method as needed.  You must
        support two arguments, labeled here MultiVector x and MultiVector y.
        These will be converted from Epetra_MultiVector C++ objects to
        numpy-hybrid Epetra.MultiVector objects before they are passed to you.
        Thus, it is legal to use slice indexing and other numpy features to
        compute y from x.

        If application of your operator is successful, return 0; else return
        some non-zero error code.

        It is strongly suggested that you prevent Apply() from raising any
        exceptions.  Accidental errors can be prevented by wrapping your code
        in a try block:

            try:
                # Your code goes here...
            except Exception, e:
                print 'A python exception was raised by method Apply:'
                print e
                return -1

        By returning a -1, you inform the calling routine that Apply() was
        unsuccessful.

        """
        return _IFPACK.ILU_Apply(self, *args)


    def Multiply(self, *args):
        """Multiply(ILU self, bool Trans, MultiVector X, MultiVector Y) -> int"""
        return _IFPACK.ILU_Multiply(self, *args)


    def ApplyInverse(self, *args):
        """
        ApplyInverse(self, MultiVector x, MultiVector y) -> int

        In C++, the ApplyInverse() method is pure virtual, thus intended to be
        overridden by derived classes.  In python, cross-language polymorphism
        is supported, and you are expected to derive classes from this base
        class and redefine the ApplyInverse() method.  C++ code (e.g., AztecOO
        solvers) can call back to your ApplyInverse() method as needed.  You
        must support two arguments, labeled here MultiVector x and MultiVector
        y.  These will be converted from Epetra_MultiVector C++ objects to
        numpy-hybrid Epetra.MultiVector objects before they are passed to you.
        Thus, it is legal to use slice indexing and other numpy features to
        compute y from x.

        If application of your operator is successful, return 0; else return
        some non-zero error code.

        It is strongly suggested that you prevent ApplyInverse() from raising
        any exceptions.  Accidental errors can be prevented by wrapping your
        code in a try block:

            try:
                # Your code goes here...
            except Exception, e:
                print 'A python exception was raised by method ApplyInverse:'
                print e
                return -1

        By returning a -1, you inform the calling routine that ApplyInverse()
        was unsuccessful.

        """
        return _IFPACK.ILU_ApplyInverse(self, *args)


    def Condest(self, *args):
        """Condest(ILU self, Ifpack_CondestType const CT, int const MaxIters=1550, double const Tol=1e-9, RowMatrix Matrix_in=None) -> double"""
        return _IFPACK.ILU_Condest(self, *args)


    def L(self, *args):
        """L(ILU self) -> CrsMatrix"""
        return _IFPACK.ILU_L(self, *args)


    def D(self, *args):
        """D(ILU self) -> Vector"""
        return _IFPACK.ILU_D(self, *args)


    def U(self, *args):
        """U(ILU self) -> CrsMatrix"""
        return _IFPACK.ILU_U(self, *args)


    def Label(self, *args):
        """Label(ILU self) -> char const *"""
        return _IFPACK.ILU_Label(self, *args)


    def SetLabel(self, *args):
        """SetLabel(ILU self, char const * Label_in) -> int"""
        return _IFPACK.ILU_SetLabel(self, *args)


    def NormInf(self, *args):
        """NormInf(ILU self) -> double"""
        return _IFPACK.ILU_NormInf(self, *args)


    def HasNormInf(self, *args):
        """HasNormInf(ILU self) -> bool"""
        return _IFPACK.ILU_HasNormInf(self, *args)


    def UseTranspose(self, *args):
        """UseTranspose(ILU self) -> bool"""
        return _IFPACK.ILU_UseTranspose(self, *args)


    def OperatorDomainMap(self, *args):
        """OperatorDomainMap(ILU self) -> Map"""
        return _IFPACK.ILU_OperatorDomainMap(self, *args)


    def OperatorRangeMap(self, *args):
        """OperatorRangeMap(ILU self) -> Map"""
        return _IFPACK.ILU_OperatorRangeMap(self, *args)


    def Comm(self, *args):
        """Comm(ILU self) -> Comm"""
        return _IFPACK.ILU_Comm(self, *args)


    def Matrix(self, *args):
        """Matrix(ILU self) -> RowMatrix"""
        return _IFPACK.ILU_Matrix(self, *args)


    def NumInitialize(self, *args):
        """NumInitialize(ILU self) -> int"""
        return _IFPACK.ILU_NumInitialize(self, *args)


    def NumCompute(self, *args):
        """NumCompute(ILU self) -> int"""
        return _IFPACK.ILU_NumCompute(self, *args)


    def NumApplyInverse(self, *args):
        """NumApplyInverse(ILU self) -> int"""
        return _IFPACK.ILU_NumApplyInverse(self, *args)


    def InitializeTime(self, *args):
        """InitializeTime(ILU self) -> double"""
        return _IFPACK.ILU_InitializeTime(self, *args)


    def ComputeTime(self, *args):
        """ComputeTime(ILU self) -> double"""
        return _IFPACK.ILU_ComputeTime(self, *args)


    def ApplyInverseTime(self, *args):
        """ApplyInverseTime(ILU self) -> double"""
        return _IFPACK.ILU_ApplyInverseTime(self, *args)


    def InitializeFlops(self, *args):
        """InitializeFlops(ILU self) -> double"""
        return _IFPACK.ILU_InitializeFlops(self, *args)


    def ComputeFlops(self, *args):
        """ComputeFlops(ILU self) -> double"""
        return _IFPACK.ILU_ComputeFlops(self, *args)


    def ApplyInverseFlops(self, *args):
        """ApplyInverseFlops(ILU self) -> double"""
        return _IFPACK.ILU_ApplyInverseFlops(self, *args)

ILU_swigregister = _IFPACK.ILU_swigregister
ILU_swigregister(ILU)

class ILUT(Preconditioner):
    """Proxy of C++ Ifpack_ILUT class."""

    __swig_setmethods__ = {}
    for _s in [Preconditioner]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, ILUT, name, value)
    __swig_getmethods__ = {}
    for _s in [Preconditioner]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, ILUT, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """__init__(Ifpack_ILUT self, RowMatrix A) -> ILUT"""
        this = _IFPACK.new_ILUT(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _IFPACK.delete_ILUT

    def SetParameters(self, *args):
        """SetParameters(ILUT self, ParameterList parameterlis) -> int"""
        return _IFPACK.ILUT_SetParameters(self, *args)


    def Initialize(self, *args):
        """Initialize(ILUT self) -> int"""
        return _IFPACK.ILUT_Initialize(self, *args)


    def IsInitialized(self, *args):
        """IsInitialized(ILUT self) -> bool"""
        return _IFPACK.ILUT_IsInitialized(self, *args)


    def Compute(self, *args):
        """Compute(ILUT self) -> int"""
        return _IFPACK.ILUT_Compute(self, *args)


    def IsComputed(self, *args):
        """IsComputed(ILUT self) -> bool"""
        return _IFPACK.ILUT_IsComputed(self, *args)


    def ApplyInverse(self, *args):
        """
        ApplyInverse(self, MultiVector x, MultiVector y) -> int

        In C++, the ApplyInverse() method is pure virtual, thus intended to be
        overridden by derived classes.  In python, cross-language polymorphism
        is supported, and you are expected to derive classes from this base
        class and redefine the ApplyInverse() method.  C++ code (e.g., AztecOO
        solvers) can call back to your ApplyInverse() method as needed.  You
        must support two arguments, labeled here MultiVector x and MultiVector
        y.  These will be converted from Epetra_MultiVector C++ objects to
        numpy-hybrid Epetra.MultiVector objects before they are passed to you.
        Thus, it is legal to use slice indexing and other numpy features to
        compute y from x.

        If application of your operator is successful, return 0; else return
        some non-zero error code.

        It is strongly suggested that you prevent ApplyInverse() from raising
        any exceptions.  Accidental errors can be prevented by wrapping your
        code in a try block:

            try:
                # Your code goes here...
            except Exception, e:
                print 'A python exception was raised by method ApplyInverse:'
                print e
                return -1

        By returning a -1, you inform the calling routine that ApplyInverse()
        was unsuccessful.

        """
        return _IFPACK.ILUT_ApplyInverse(self, *args)


    def Apply(self, *args):
        """
        Apply(self, MultiVector x, MultiVector y) -> int

        In C++, the Apply() method is pure virtual, thus intended to be
        overridden by derived classes.  In python, cross-language polymorphism
        is supported, and you are expected to derive classes from this base
        class and redefine the Apply() method.  C++ code (e.g., AztecOO
        solvers) can call back to your Apply() method as needed.  You must
        support two arguments, labeled here MultiVector x and MultiVector y.
        These will be converted from Epetra_MultiVector C++ objects to
        numpy-hybrid Epetra.MultiVector objects before they are passed to you.
        Thus, it is legal to use slice indexing and other numpy features to
        compute y from x.

        If application of your operator is successful, return 0; else return
        some non-zero error code.

        It is strongly suggested that you prevent Apply() from raising any
        exceptions.  Accidental errors can be prevented by wrapping your code
        in a try block:

            try:
                # Your code goes here...
            except Exception, e:
                print 'A python exception was raised by method Apply:'
                print e
                return -1

        By returning a -1, you inform the calling routine that Apply() was
        unsuccessful.

        """
        return _IFPACK.ILUT_Apply(self, *args)


    def Condest(self, *args):
        """Condest(ILUT self, Ifpack_CondestType const CT, int const MaxIters=1550, double const Tol=1e-9, RowMatrix Matrix_in=None) -> double"""
        return _IFPACK.ILUT_Condest(self, *args)


    def SetUseTranspose(self, *args):
        """SetUseTranspose(ILUT self, bool UseTranspose_in) -> int"""
        return _IFPACK.ILUT_SetUseTranspose(self, *args)


    def NormInf(self, *args):
        """NormInf(ILUT self) -> double"""
        return _IFPACK.ILUT_NormInf(self, *args)


    def HasNormInf(self, *args):
        """HasNormInf(ILUT self) -> bool"""
        return _IFPACK.ILUT_HasNormInf(self, *args)


    def UseTranspose(self, *args):
        """UseTranspose(ILUT self) -> bool"""
        return _IFPACK.ILUT_UseTranspose(self, *args)


    def OperatorDomainMap(self, *args):
        """OperatorDomainMap(ILUT self) -> Map"""
        return _IFPACK.ILUT_OperatorDomainMap(self, *args)


    def OperatorRangeMap(self, *args):
        """OperatorRangeMap(ILUT self) -> Map"""
        return _IFPACK.ILUT_OperatorRangeMap(self, *args)


    def Comm(self, *args):
        """Comm(ILUT self) -> Comm"""
        return _IFPACK.ILUT_Comm(self, *args)


    def Matrix(self, *args):
        """Matrix(ILUT self) -> RowMatrix"""
        return _IFPACK.ILUT_Matrix(self, *args)


    def L(self, *args):
        """L(ILUT self) -> CrsMatrix"""
        return _IFPACK.ILUT_L(self, *args)


    def U(self, *args):
        """U(ILUT self) -> CrsMatrix"""
        return _IFPACK.ILUT_U(self, *args)


    def Label(self, *args):
        """Label(ILUT self) -> char const *"""
        return _IFPACK.ILUT_Label(self, *args)


    def SetLabel(self, *args):
        """SetLabel(ILUT self, char const * Label_in) -> int"""
        return _IFPACK.ILUT_SetLabel(self, *args)


    def NumInitialize(self, *args):
        """NumInitialize(ILUT self) -> int"""
        return _IFPACK.ILUT_NumInitialize(self, *args)


    def NumCompute(self, *args):
        """NumCompute(ILUT self) -> int"""
        return _IFPACK.ILUT_NumCompute(self, *args)


    def NumApplyInverse(self, *args):
        """NumApplyInverse(ILUT self) -> int"""
        return _IFPACK.ILUT_NumApplyInverse(self, *args)


    def InitializeTime(self, *args):
        """InitializeTime(ILUT self) -> double"""
        return _IFPACK.ILUT_InitializeTime(self, *args)


    def ComputeTime(self, *args):
        """ComputeTime(ILUT self) -> double"""
        return _IFPACK.ILUT_ComputeTime(self, *args)


    def ApplyInverseTime(self, *args):
        """ApplyInverseTime(ILUT self) -> double"""
        return _IFPACK.ILUT_ApplyInverseTime(self, *args)


    def InitializeFlops(self, *args):
        """InitializeFlops(ILUT self) -> double"""
        return _IFPACK.ILUT_InitializeFlops(self, *args)


    def ComputeFlops(self, *args):
        """ComputeFlops(ILUT self) -> double"""
        return _IFPACK.ILUT_ComputeFlops(self, *args)


    def ApplyInverseFlops(self, *args):
        """ApplyInverseFlops(ILUT self) -> double"""
        return _IFPACK.ILUT_ApplyInverseFlops(self, *args)


    def LevelOfFill(self, *args):
        """LevelOfFill(ILUT self) -> double"""
        return _IFPACK.ILUT_LevelOfFill(self, *args)


    def RelaxValue(self, *args):
        """RelaxValue(ILUT self) -> double"""
        return _IFPACK.ILUT_RelaxValue(self, *args)


    def AbsoluteThreshold(self, *args):
        """AbsoluteThreshold(ILUT self) -> double"""
        return _IFPACK.ILUT_AbsoluteThreshold(self, *args)


    def RelativeThreshold(self, *args):
        """RelativeThreshold(ILUT self) -> double"""
        return _IFPACK.ILUT_RelativeThreshold(self, *args)


    def DropTolerance(self, *args):
        """DropTolerance(ILUT self) -> double"""
        return _IFPACK.ILUT_DropTolerance(self, *args)


    def NumGlobalNonzeros(self, *args):
        """NumGlobalNonzeros(ILUT self) -> int"""
        return _IFPACK.ILUT_NumGlobalNonzeros(self, *args)


    def NumGlobalNonzeros64(self, *args):
        """NumGlobalNonzeros64(ILUT self) -> long long"""
        return _IFPACK.ILUT_NumGlobalNonzeros64(self, *args)


    def NumMyNonzeros(self, *args):
        """NumMyNonzeros(ILUT self) -> int"""
        return _IFPACK.ILUT_NumMyNonzeros(self, *args)

ILUT_swigregister = _IFPACK.ILUT_swigregister
ILUT_swigregister(ILUT)

class PointRelaxation(Preconditioner):
    """Proxy of C++ Ifpack_PointRelaxation class."""

    __swig_setmethods__ = {}
    for _s in [Preconditioner]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, PointRelaxation, name, value)
    __swig_getmethods__ = {}
    for _s in [Preconditioner]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, PointRelaxation, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """__init__(Ifpack_PointRelaxation self, RowMatrix Matrix) -> PointRelaxation"""
        this = _IFPACK.new_PointRelaxation(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _IFPACK.delete_PointRelaxation

    def SetUseTranspose(self, *args):
        """SetUseTranspose(PointRelaxation self, bool UseTranspose_in) -> int"""
        return _IFPACK.PointRelaxation_SetUseTranspose(self, *args)


    def Apply(self, *args):
        """
        Apply(self, MultiVector x, MultiVector y) -> int

        In C++, the Apply() method is pure virtual, thus intended to be
        overridden by derived classes.  In python, cross-language polymorphism
        is supported, and you are expected to derive classes from this base
        class and redefine the Apply() method.  C++ code (e.g., AztecOO
        solvers) can call back to your Apply() method as needed.  You must
        support two arguments, labeled here MultiVector x and MultiVector y.
        These will be converted from Epetra_MultiVector C++ objects to
        numpy-hybrid Epetra.MultiVector objects before they are passed to you.
        Thus, it is legal to use slice indexing and other numpy features to
        compute y from x.

        If application of your operator is successful, return 0; else return
        some non-zero error code.

        It is strongly suggested that you prevent Apply() from raising any
        exceptions.  Accidental errors can be prevented by wrapping your code
        in a try block:

            try:
                # Your code goes here...
            except Exception, e:
                print 'A python exception was raised by method Apply:'
                print e
                return -1

        By returning a -1, you inform the calling routine that Apply() was
        unsuccessful.

        """
        return _IFPACK.PointRelaxation_Apply(self, *args)


    def ApplyInverse(self, *args):
        """
        ApplyInverse(self, MultiVector x, MultiVector y) -> int

        In C++, the ApplyInverse() method is pure virtual, thus intended to be
        overridden by derived classes.  In python, cross-language polymorphism
        is supported, and you are expected to derive classes from this base
        class and redefine the ApplyInverse() method.  C++ code (e.g., AztecOO
        solvers) can call back to your ApplyInverse() method as needed.  You
        must support two arguments, labeled here MultiVector x and MultiVector
        y.  These will be converted from Epetra_MultiVector C++ objects to
        numpy-hybrid Epetra.MultiVector objects before they are passed to you.
        Thus, it is legal to use slice indexing and other numpy features to
        compute y from x.

        If application of your operator is successful, return 0; else return
        some non-zero error code.

        It is strongly suggested that you prevent ApplyInverse() from raising
        any exceptions.  Accidental errors can be prevented by wrapping your
        code in a try block:

            try:
                # Your code goes here...
            except Exception, e:
                print 'A python exception was raised by method ApplyInverse:'
                print e
                return -1

        By returning a -1, you inform the calling routine that ApplyInverse()
        was unsuccessful.

        """
        return _IFPACK.PointRelaxation_ApplyInverse(self, *args)


    def NormInf(self, *args):
        """NormInf(PointRelaxation self) -> double"""
        return _IFPACK.PointRelaxation_NormInf(self, *args)


    def Label(self, *args):
        """Label(PointRelaxation self) -> char const *"""
        return _IFPACK.PointRelaxation_Label(self, *args)


    def UseTranspose(self, *args):
        """UseTranspose(PointRelaxation self) -> bool"""
        return _IFPACK.PointRelaxation_UseTranspose(self, *args)


    def HasNormInf(self, *args):
        """HasNormInf(PointRelaxation self) -> bool"""
        return _IFPACK.PointRelaxation_HasNormInf(self, *args)


    def Comm(self, *args):
        """Comm(PointRelaxation self) -> Comm"""
        return _IFPACK.PointRelaxation_Comm(self, *args)


    def OperatorDomainMap(self, *args):
        """OperatorDomainMap(PointRelaxation self) -> Map"""
        return _IFPACK.PointRelaxation_OperatorDomainMap(self, *args)


    def OperatorRangeMap(self, *args):
        """OperatorRangeMap(PointRelaxation self) -> Map"""
        return _IFPACK.PointRelaxation_OperatorRangeMap(self, *args)


    def Initialize(self, *args):
        """Initialize(PointRelaxation self) -> int"""
        return _IFPACK.PointRelaxation_Initialize(self, *args)


    def IsInitialized(self, *args):
        """IsInitialized(PointRelaxation self) -> bool"""
        return _IFPACK.PointRelaxation_IsInitialized(self, *args)


    def IsComputed(self, *args):
        """IsComputed(PointRelaxation self) -> bool"""
        return _IFPACK.PointRelaxation_IsComputed(self, *args)


    def Compute(self, *args):
        """Compute(PointRelaxation self) -> int"""
        return _IFPACK.PointRelaxation_Compute(self, *args)


    def Matrix(self, *args):
        """Matrix(PointRelaxation self) -> RowMatrix"""
        return _IFPACK.PointRelaxation_Matrix(self, *args)


    def Condest(self, *args):
        """Condest(PointRelaxation self, Ifpack_CondestType const CT, int const MaxIters=1550, double const Tol=1e-9, RowMatrix Matrix=None) -> double"""
        return _IFPACK.PointRelaxation_Condest(self, *args)


    def SetParameters(self, *args):
        """SetParameters(PointRelaxation self, ParameterList List) -> int"""
        return _IFPACK.PointRelaxation_SetParameters(self, *args)


    def NumInitialize(self, *args):
        """NumInitialize(PointRelaxation self) -> int"""
        return _IFPACK.PointRelaxation_NumInitialize(self, *args)


    def NumCompute(self, *args):
        """NumCompute(PointRelaxation self) -> int"""
        return _IFPACK.PointRelaxation_NumCompute(self, *args)


    def NumApplyInverse(self, *args):
        """NumApplyInverse(PointRelaxation self) -> int"""
        return _IFPACK.PointRelaxation_NumApplyInverse(self, *args)


    def InitializeTime(self, *args):
        """InitializeTime(PointRelaxation self) -> double"""
        return _IFPACK.PointRelaxation_InitializeTime(self, *args)


    def ComputeTime(self, *args):
        """ComputeTime(PointRelaxation self) -> double"""
        return _IFPACK.PointRelaxation_ComputeTime(self, *args)


    def ApplyInverseTime(self, *args):
        """ApplyInverseTime(PointRelaxation self) -> double"""
        return _IFPACK.PointRelaxation_ApplyInverseTime(self, *args)


    def InitializeFlops(self, *args):
        """InitializeFlops(PointRelaxation self) -> double"""
        return _IFPACK.PointRelaxation_InitializeFlops(self, *args)


    def ComputeFlops(self, *args):
        """ComputeFlops(PointRelaxation self) -> double"""
        return _IFPACK.PointRelaxation_ComputeFlops(self, *args)


    def ApplyInverseFlops(self, *args):
        """ApplyInverseFlops(PointRelaxation self) -> double"""
        return _IFPACK.PointRelaxation_ApplyInverseFlops(self, *args)

PointRelaxation_swigregister = _IFPACK.PointRelaxation_swigregister
PointRelaxation_swigregister(PointRelaxation)

class Amesos(Preconditioner):
    """Proxy of C++ Ifpack_Amesos class."""

    __swig_setmethods__ = {}
    for _s in [Preconditioner]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, Amesos, name, value)
    __swig_getmethods__ = {}
    for _s in [Preconditioner]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, Amesos, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(Ifpack_Amesos self, RowMatrix Matrix) -> Amesos
        __init__(Ifpack_Amesos self, Amesos rhs) -> Amesos
        """
        this = _IFPACK.new_Amesos(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _IFPACK.delete_Amesos

    def SetUseTranspose(self, *args):
        """SetUseTranspose(Amesos self, bool UseTranspose_in) -> int"""
        return _IFPACK.Amesos_SetUseTranspose(self, *args)


    def Apply(self, *args):
        """
        Apply(self, MultiVector x, MultiVector y) -> int

        In C++, the Apply() method is pure virtual, thus intended to be
        overridden by derived classes.  In python, cross-language polymorphism
        is supported, and you are expected to derive classes from this base
        class and redefine the Apply() method.  C++ code (e.g., AztecOO
        solvers) can call back to your Apply() method as needed.  You must
        support two arguments, labeled here MultiVector x and MultiVector y.
        These will be converted from Epetra_MultiVector C++ objects to
        numpy-hybrid Epetra.MultiVector objects before they are passed to you.
        Thus, it is legal to use slice indexing and other numpy features to
        compute y from x.

        If application of your operator is successful, return 0; else return
        some non-zero error code.

        It is strongly suggested that you prevent Apply() from raising any
        exceptions.  Accidental errors can be prevented by wrapping your code
        in a try block:

            try:
                # Your code goes here...
            except Exception, e:
                print 'A python exception was raised by method Apply:'
                print e
                return -1

        By returning a -1, you inform the calling routine that Apply() was
        unsuccessful.

        """
        return _IFPACK.Amesos_Apply(self, *args)


    def ApplyInverse(self, *args):
        """
        ApplyInverse(self, MultiVector x, MultiVector y) -> int

        In C++, the ApplyInverse() method is pure virtual, thus intended to be
        overridden by derived classes.  In python, cross-language polymorphism
        is supported, and you are expected to derive classes from this base
        class and redefine the ApplyInverse() method.  C++ code (e.g., AztecOO
        solvers) can call back to your ApplyInverse() method as needed.  You
        must support two arguments, labeled here MultiVector x and MultiVector
        y.  These will be converted from Epetra_MultiVector C++ objects to
        numpy-hybrid Epetra.MultiVector objects before they are passed to you.
        Thus, it is legal to use slice indexing and other numpy features to
        compute y from x.

        If application of your operator is successful, return 0; else return
        some non-zero error code.

        It is strongly suggested that you prevent ApplyInverse() from raising
        any exceptions.  Accidental errors can be prevented by wrapping your
        code in a try block:

            try:
                # Your code goes here...
            except Exception, e:
                print 'A python exception was raised by method ApplyInverse:'
                print e
                return -1

        By returning a -1, you inform the calling routine that ApplyInverse()
        was unsuccessful.

        """
        return _IFPACK.Amesos_ApplyInverse(self, *args)


    def NormInf(self, *args):
        """NormInf(Amesos self) -> double"""
        return _IFPACK.Amesos_NormInf(self, *args)


    def Label(self, *args):
        """Label(Amesos self) -> char const *"""
        return _IFPACK.Amesos_Label(self, *args)


    def UseTranspose(self, *args):
        """UseTranspose(Amesos self) -> bool"""
        return _IFPACK.Amesos_UseTranspose(self, *args)


    def HasNormInf(self, *args):
        """HasNormInf(Amesos self) -> bool"""
        return _IFPACK.Amesos_HasNormInf(self, *args)


    def Comm(self, *args):
        """Comm(Amesos self) -> Comm"""
        return _IFPACK.Amesos_Comm(self, *args)


    def OperatorDomainMap(self, *args):
        """OperatorDomainMap(Amesos self) -> Map"""
        return _IFPACK.Amesos_OperatorDomainMap(self, *args)


    def OperatorRangeMap(self, *args):
        """OperatorRangeMap(Amesos self) -> Map"""
        return _IFPACK.Amesos_OperatorRangeMap(self, *args)


    def IsInitialized(self, *args):
        """IsInitialized(Amesos self) -> bool"""
        return _IFPACK.Amesos_IsInitialized(self, *args)


    def Initialize(self, *args):
        """Initialize(Amesos self) -> int"""
        return _IFPACK.Amesos_Initialize(self, *args)


    def IsComputed(self, *args):
        """IsComputed(Amesos self) -> bool"""
        return _IFPACK.Amesos_IsComputed(self, *args)


    def Compute(self, *args):
        """Compute(Amesos self) -> int"""
        return _IFPACK.Amesos_Compute(self, *args)


    def SetParameters(self, *args):
        """SetParameters(Amesos self, ParameterList List) -> int"""
        return _IFPACK.Amesos_SetParameters(self, *args)


    def Matrix(self, *args):
        """Matrix(Amesos self) -> RowMatrix"""
        return _IFPACK.Amesos_Matrix(self, *args)


    def Condest(self, *args):
        """Condest(Amesos self, Ifpack_CondestType const CT, int const MaxIters=1550, double const Tol=1e-9, RowMatrix Matrix_in=None) -> double"""
        return _IFPACK.Amesos_Condest(self, *args)


    def NumInitialize(self, *args):
        """NumInitialize(Amesos self) -> int"""
        return _IFPACK.Amesos_NumInitialize(self, *args)


    def NumCompute(self, *args):
        """NumCompute(Amesos self) -> int"""
        return _IFPACK.Amesos_NumCompute(self, *args)


    def NumApplyInverse(self, *args):
        """NumApplyInverse(Amesos self) -> int"""
        return _IFPACK.Amesos_NumApplyInverse(self, *args)


    def InitializeTime(self, *args):
        """InitializeTime(Amesos self) -> double"""
        return _IFPACK.Amesos_InitializeTime(self, *args)


    def ComputeTime(self, *args):
        """ComputeTime(Amesos self) -> double"""
        return _IFPACK.Amesos_ComputeTime(self, *args)


    def ApplyInverseTime(self, *args):
        """ApplyInverseTime(Amesos self) -> double"""
        return _IFPACK.Amesos_ApplyInverseTime(self, *args)


    def InitializeFlops(self, *args):
        """InitializeFlops(Amesos self) -> double"""
        return _IFPACK.Amesos_InitializeFlops(self, *args)


    def ComputeFlops(self, *args):
        """ComputeFlops(Amesos self) -> double"""
        return _IFPACK.Amesos_ComputeFlops(self, *args)


    def ApplyInverseFlops(self, *args):
        """ApplyInverseFlops(Amesos self) -> double"""
        return _IFPACK.Amesos_ApplyInverseFlops(self, *args)


    def List(self, *args):
        """List(Amesos self) -> ParameterList"""
        return _IFPACK.Amesos_List(self, *args)

Amesos_swigregister = _IFPACK.Amesos_swigregister
Amesos_swigregister(Amesos)

class Factory(_object):
    """Proxy of C++ Ifpack class."""

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, Factory, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, Factory, name)
    __repr__ = _swig_repr
    POINT_RELAXATION = _IFPACK.Factory_POINT_RELAXATION
    POINT_RELAXATION_STAND_ALONE = _IFPACK.Factory_POINT_RELAXATION_STAND_ALONE
    BLOCK_RELAXATION = _IFPACK.Factory_BLOCK_RELAXATION
    BLOCK_RELAXATION_STAND_ALONE = _IFPACK.Factory_BLOCK_RELAXATION_STAND_ALONE
    BLOCK_RELAXATION_STAND_ALONE_ILU = _IFPACK.Factory_BLOCK_RELAXATION_STAND_ALONE_ILU
    BLOCK_RELAXATION_STAND_ALONE_ILUT = _IFPACK.Factory_BLOCK_RELAXATION_STAND_ALONE_ILUT
    BLOCK_RELAXATION_STAND_ALONE_IC = _IFPACK.Factory_BLOCK_RELAXATION_STAND_ALONE_IC
    BLOCK_RELAXATION_STAND_ALONE_AMESOS = _IFPACK.Factory_BLOCK_RELAXATION_STAND_ALONE_AMESOS
    BLOCK_RELAXATION_AMESOS = _IFPACK.Factory_BLOCK_RELAXATION_AMESOS
    AMESOS = _IFPACK.Factory_AMESOS
    AMESOS_STAND_ALONE = _IFPACK.Factory_AMESOS_STAND_ALONE
    IC = _IFPACK.Factory_IC
    IC_STAND_ALONE = _IFPACK.Factory_IC_STAND_ALONE
    ICT = _IFPACK.Factory_ICT
    ICT_STAND_ALONE = _IFPACK.Factory_ICT_STAND_ALONE
    ILU = _IFPACK.Factory_ILU
    ILU_STAND_ALONE = _IFPACK.Factory_ILU_STAND_ALONE
    ILUT = _IFPACK.Factory_ILUT
    ILUT_STAND_ALONE = _IFPACK.Factory_ILUT_STAND_ALONE
    CHEBYSHEV = _IFPACK.Factory_CHEBYSHEV
    POLYNOMIAL = _IFPACK.Factory_POLYNOMIAL
    KRYLOV = _IFPACK.Factory_KRYLOV
    IHSS = _IFPACK.Factory_IHSS
    SORA = _IFPACK.Factory_SORA
    TRIDI_RELAXATION = _IFPACK.Factory_TRIDI_RELAXATION
    TRIDI_RELAXATION_STAND_ALONE = _IFPACK.Factory_TRIDI_RELAXATION_STAND_ALONE
    numPrecTypes = _IFPACK.Factory_numPrecTypes
    __swig_setmethods__["precTypeNames"] = _IFPACK.Factory_precTypeNames_set
    __swig_getmethods__["precTypeNames"] = _IFPACK.Factory_precTypeNames_get
    if _newclass:
        precTypeNames = _swig_property(_IFPACK.Factory_precTypeNames_get, _IFPACK.Factory_precTypeNames_set)

    def toString(*args):
        """toString(Ifpack::EPrecType const precType) -> char const *"""
        return _IFPACK.Factory_toString(*args)

    toString = staticmethod(toString)

    def Create(self, *args):
        """
        Create(Factory self, Ifpack::EPrecType PrecType, RowMatrix Matrix, int const overlap=0, bool overrideSerialDefault=False) -> Preconditioner
        Create(Factory self, std::string const PrecType, RowMatrix Matrix, int const overlap=0, bool overrideSerialDefault=False) -> Preconditioner
        """
        return _IFPACK.Factory_Create(self, *args)


    def SetParameters(self, *args):
        """SetParameters(Factory self, int argc, char *[] argv, ParameterList List, std::string & PrecType, int & Overlap) -> int"""
        return _IFPACK.Factory_SetParameters(self, *args)


    def __init__(self, *args):
        """__init__(Ifpack self) -> Factory"""
        this = _IFPACK.new_Factory(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _IFPACK.delete_Factory
Factory_swigregister = _IFPACK.Factory_swigregister
Factory_swigregister(Factory)
cvar = _IFPACK.cvar
Factory.precTypeValues = _IFPACK.cvar.Factory_precTypeValues
Factory.supportsUnsymmetric = _IFPACK.cvar.Factory_supportsUnsymmetric

def Factory_toString(*args):
    """Factory_toString(Ifpack::EPrecType const precType) -> char const *"""
    return _IFPACK.Factory_toString(*args)

# This file is compatible with both classic and new-style classes.


